package org.eclipse.swt.internal.image {
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Compatibility;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class PngEncoder {
  public static var SIGNATURE: JavaArray = new JavaArray("[B").values(int(137), int(80), int(78), int(71), int(13), int(10), int(26), int(10));
  public static var TAG_IHDR: JavaArray = new JavaArray("[B").values(int(73), int(72), int(68), int(82));
  public static var TAG_PLTE: JavaArray = new JavaArray("[B").values(int(80), int(76), int(84), int(69));
  public static var TAG_TRNS: JavaArray = new JavaArray("[B").values(int(116), int(82), int(78), int(83));
  public static var TAG_IDAT: JavaArray = new JavaArray("[B").values(int(73), int(68), int(65), int(84));
  public static var TAG_IEND: JavaArray = new JavaArray("[B").values(int(73), int(69), int(78), int(68));
  internal var bytes: ByteArrayOutputStream = new ByteArrayOutputStream(new Arguments(java.io.ByteArrayOutputStream.ByteArrayOutputStream__I, [1024]));
  internal var chunk: PngChunk;
  internal var loader: ImageLoader;
  internal var data: ImageData;
  internal var transparencyType: int;
  internal var width: int;
  internal var height: int;
  internal var bitDepth: int;
  internal var colorType: int;
  internal var compressionMethod: int = 0;
  internal var filterMethod: int = 0;
  internal var interlaceMethod: int = 0;
  public function PngEncoder(loader: ImageLoader) {
    this.loader = loader;
    this.data = loader.data[0];
    this.transparencyType = data.getTransparencyType__();
    this.width = data.width;
    this.height = data.height;
    this.bitDepth = 8;
    this.colorType = 2;
    if (data.palette.isDirect) {
      if (transparencyType == 1) {
        this.colorType = 6;
      }
    } else {
      this.colorType = 3;
    }
    if (!(colorType == 2 || colorType == 3 || colorType == 6))
      SWT.error__I(40);
    return;
  }
  public function writeShort__Ljava_io_ByteArrayOutputStream_2I(baos: ByteArrayOutputStream, theShort: int): void {
    var byte1: int = int(((theShort >> 8) & 0xff));
    var byte2: int = int((theShort & 0xff));
    var temp: JavaArray = new JavaArray("[B").values(byte1, byte2);
    baos.write___3BII(temp, 0, 2);
    return;
  }
  public function writeInt__Ljava_io_ByteArrayOutputStream_2I(baos: ByteArrayOutputStream, theInt: int): void {
    var byte1: int = int(((theInt >> 24) & 0xff));
    var byte2: int = int(((theInt >> 16) & 0xff));
    var byte3: int = int(((theInt >> 8) & 0xff));
    var byte4: int = int((theInt & 0xff));
    var temp: JavaArray = new JavaArray("[B").values(byte1, byte2, byte3, byte4);
    baos.write___3BII(temp, 0, 4);
    return;
  }
  public function writeChunk___3B_3B(tag: JavaArray, buffer: JavaArray): void {
    var bufferLength: int = (buffer !== null) ? buffer.length : 0;
    chunk = new PngChunk(new Arguments(org.eclipse.swt.internal.image.PngChunk.PngChunk__I, [bufferLength]));
    this.writeInt__Ljava_io_ByteArrayOutputStream_2I(bytes, bufferLength);
    bytes.write___3BII(tag, 0, 4);
    chunk.setType___3B(tag);
    if (bufferLength != 0) {
      bytes.write___3BII(buffer, 0, bufferLength);
      chunk.setData___3B(buffer);
    } else {
      chunk.setCRC__I(chunk.computeCRC__());
    }
    this.writeInt__Ljava_io_ByteArrayOutputStream_2I(bytes, chunk.getCRC__());
    return;
  }
  public function writeSignature__(): void {
    bytes.write___3BII(SIGNATURE, 0, 8);
    return;
  }
  public function writeHeader__(): void {
    var baos: ByteArrayOutputStream = new ByteArrayOutputStream(new Arguments(java.io.ByteArrayOutputStream.ByteArrayOutputStream__I, [13]));
    this.writeInt__Ljava_io_ByteArrayOutputStream_2I(baos, width);
    this.writeInt__Ljava_io_ByteArrayOutputStream_2I(baos, height);
    baos.write__I(bitDepth);
    baos.write__I(colorType);
    baos.write__I(compressionMethod);
    baos.write__I(filterMethod);
    baos.write__I(interlaceMethod);
    this.writeChunk___3B_3B(TAG_IHDR, baos.toByteArray__());
    return;
  }
  public function writePalette__(): void {
    var RGBs: JavaArray = data.palette.getRGBs__();
    if (RGBs.length > 256)
      SWT.error__I(40);
    var baos: ByteArrayOutputStream = new ByteArrayOutputStream(new Arguments(java.io.ByteArrayOutputStream.ByteArrayOutputStream__I, [RGBs.length]));
    for (var i: int = 0; i < RGBs.length; i++) {
      baos.write__I(int(RGBs[i].red));
      baos.write__I(int(RGBs[i].green));
      baos.write__I(int(RGBs[i].blue));
    }
    this.writeChunk___3B_3B(TAG_PLTE, baos.toByteArray__());
    return;
  }
  public function writeTransparency__(): void {
    var baos: ByteArrayOutputStream = new ByteArrayOutputStream(new Arguments(java.io.ByteArrayOutputStream.ByteArrayOutputStream__, []));
    switch (transparencyType) {
      case 1 :
        var pixelValue: int;
        var alphaValue: int;
        var alphas: JavaArray = new JavaArray("[B").lengths(data.palette.getRGBs__().length);
        for (var y: int = 0; y < height; y++) {
          for (var x: int = 0; x < width; x++) {
            pixelValue = data.getPixel__II(x, y);
            alphaValue = data.getAlpha__II(x, y);
            alphas[pixelValue] = int(alphaValue);
          }
        }
        baos.write___3BII(alphas, 0, alphas.length);
        break;
      case 4 :
        var pixel: int = data.transparentPixel;
        if (colorType == 2) {
          var redMask: int = data.palette.redMask;
          var redShift: int = data.palette.redShift;
          var greenMask: int = data.palette.greenMask;
          var greenShift: int = data.palette.greenShift;
          var blueShift: int = data.palette.blueShift;
          var blueMask: int = data.palette.blueMask;
          var r: int = pixel & redMask;
          r = (redShift < 0) ? r >>> -redShift : r << redShift;
          var g: int = pixel & greenMask;
          g = (greenShift < 0) ? g >>> -greenShift : g << greenShift;
          var b: int = pixel & blueMask;
          b = (blueShift < 0) ? b >>> -blueShift : b << blueShift;
          this.writeShort__Ljava_io_ByteArrayOutputStream_2I(baos, r);
          this.writeShort__Ljava_io_ByteArrayOutputStream_2I(baos, g);
          this.writeShort__Ljava_io_ByteArrayOutputStream_2I(baos, b);
        }
        if (colorType == 3) {
          var padding: JavaArray = new JavaArray("[B").lengths(pixel + 1);
          for (var i: int = 0; i < pixel; i++) {
            padding[i] = int(255);
          }
          padding[pixel] = int(0);
          baos.write___3BII(padding, 0, padding.length);
        }
        break;
    }
    this.writeChunk___3B_3B(TAG_TRNS, baos.toByteArray__());
    return;
  }
  public function writeImageData__(): void {
    var baos: ByteArrayOutputStream = new ByteArrayOutputStream(new Arguments(java.io.ByteArrayOutputStream.ByteArrayOutputStream__I, [1024]));
    var os: OutputStream = Compatibility.newDeflaterOutputStream__Ljava_io_OutputStream_2(baos);
    if (os === null)
      os = baos;
    if (colorType == 3) {
      var lineData: JavaArray = new JavaArray("[B").lengths(width);
      for (var y: int = 0; y < height; y++) {
        var filter: int = 0;
        os.write__I(filter);
        data.getPixels__III_3BI(0, y, width, lineData, 0);
        for (var x: int = 0; x < lineData.length; x++) {
          os.write__I(lineData[x]);
        }
      }
    } else {
      var lineData_1: JavaArray = new JavaArray("[I").lengths(width);
      var alphaData: JavaArray = null;
      if (colorType == 6) {
        alphaData = new JavaArray("[B").lengths(width);
      }
      var redMask: int = data.palette.redMask;
      var redShift: int = data.palette.redShift;
      var greenMask: int = data.palette.greenMask;
      var greenShift: int = data.palette.greenShift;
      var blueShift: int = data.palette.blueShift;
      var blueMask: int = data.palette.blueMask;
      for (var y_1: int = 0; y_1 < height; y_1++) {
        var filter_1: int = 0;
        os.write__I(filter_1);
        data.getPixels__III_3II(0, y_1, width, lineData_1, 0);
        if (colorType == 6) {
          data.getAlphas__III_3BI(0, y_1, width, alphaData, 0);
        }
        for (var x_1: int = 0; x_1 < lineData_1.length; x_1++) {
          var pixel: int = lineData_1[x_1];
          var r: int = pixel & redMask;
          r = (redShift < 0) ? r >>> -redShift : r << redShift;
          var g: int = pixel & greenMask;
          g = (greenShift < 0) ? g >>> -greenShift : g << greenShift;
          var b: int = pixel & blueMask;
          b = (blueShift < 0) ? b >>> -blueShift : b << blueShift;
          os.write__I(r);
          os.write__I(g);
          os.write__I(b);
          if (colorType == 6) {
            os.write__I(alphaData[x_1]);
          }
        }
      }
    }
    os.flush__();
    os.close__();
    var compressed: JavaArray = baos.toByteArray__();
    if (os === baos) {
      var deflater: PngDeflater = new PngDeflater();
      compressed = deflater.deflate___3B(compressed);
    }
    this.writeChunk___3B_3B(TAG_IDAT, compressed);
    return;
  }
  public function writeEnd__(): void {
    this.writeChunk___3B_3B(TAG_IEND, null);
    return;
  }
  public function encode__Lorg_eclipse_swt_internal_image_LEDataOutputStream_2(outputStream: LEDataOutputStream): void {
    try {
      this.writeSignature__();
      this.writeHeader__();
      if (colorType == 3) {
        this.writePalette__();
      }
      var transparencyAlpha: Boolean = (transparencyType == 1);
      var transparencyPixel: Boolean = (transparencyType == 4);
      var type2Transparency: Boolean = (colorType == 2 && transparencyPixel);
      var type3Transparency: Boolean = (colorType == 3 && (transparencyAlpha || transparencyPixel));
      if (type2Transparency || type3Transparency) {
        this.writeTransparency__();
      }
      this.writeImageData__();
      this.writeEnd__();
      outputStream.write___3B(bytes.toByteArray__());
    } catch (e : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
    }
    return;
  }
}
}
