package org.eclipse.swt.internal.image {
import java.io.*;
import java.io.IOException;
import java.lang.JavaArray;
dynamic public class PngHuffmanTable {
  internal var codeLengthInfo: JavaArray;
  internal var codeValues: JavaArray;
  public static const MAX_CODE_LENGTH: int = 15;
  public static const BAD_CODE: int = 0xFFFFFFF;
  public static var incs: JavaArray = new JavaArray("[I").values(1391376, 463792, 198768, 86961, 33936, 13776, 4592, 1968, 861, 336, 112, 48, 21, 7, 3, 1);
  function PngHuffmanTable(lengths: JavaArray) {
    this.initialize___3I(lengths);
    this.generateTable___3I(lengths);
    return;
  }
  private function initialize___3I(lengths: JavaArray): void {
    codeValues = new JavaArray("[I").lengths(lengths.length);
    for (var i: int = 0; i < codeValues.length; i++) {
      codeValues[i] = i;
    }
    codeLengthInfo = new JavaArray("[Lorg/eclipse/swt/internal/image/PngHuffmanTable$CodeLengthInfo;").lengths(15);
    for (var i_1: int = 0; i_1 < 15; i_1++) {
      codeLengthInfo[i_1] = new PngHuffmanTable$CodeLengthInfo();
      codeLengthInfo[i_1].length = i_1;
      codeLengthInfo[i_1].baseIndex = 0;
      codeLengthInfo[i_1].min = 268435455;
      codeLengthInfo[i_1].max = -1;
    }
    return;
  }
  private function generateTable___3I(lengths: JavaArray): void {
    var codeValuesTemp: int;
    for (var k: int = 0; k < 16; k++) {
      for (var h: int = incs[k], i: int = h; i < lengths.length; i++) {
        var v: int = lengths[i];
        codeValuesTemp = codeValues[i];
        var j: int = i;
        while (j >= h && (lengths[j - h] > v || (lengths[j - h] == v && codeValues[j - h] > codeValuesTemp))) {
          lengths[j] = lengths[j - h];
          codeValues[j] = codeValues[j - h];
          j -= h;
        }
        lengths[j] = v;
        codeValues[j] = codeValuesTemp;
      }
    }
    var codes: JavaArray = new JavaArray("[I").lengths(lengths.length);
    var lastLength: int = 0;
    var code: int = 0;
    for (var i_1: int = 0; i_1 < lengths.length; i_1++) {
      while (lastLength != lengths[i_1]) {
        lastLength++;
        code <<= 1;
      }
      if (lastLength != 0) {
        codes[i_1] = code;
        code++;
      }
    }
    var last: int = 0;
    for (var i_2: int = 0; i_2 < lengths.length; i_2++) {
      if (last != lengths[i_2]) {
        last = lengths[i_2];
        codeLengthInfo[last - 1].baseIndex = i_2;
        codeLengthInfo[last - 1].min = codes[i_2];
      }
      if (last != 0)
        codeLengthInfo[last - 1].max = codes[i_2];
    }
    return;
  }
  public function getNextValue__Lorg_eclipse_swt_internal_image_PngDecodingDataStream_2(stream: PngDecodingDataStream): int {
    var code: int = stream.getNextIdatBit__();
    var codelength: int = 0;
    while (codelength < 15 && code > codeLengthInfo[codelength].max) {
      code = ((code << 1) | stream.getNextIdatBit__());
      codelength++;
    }
    if (codelength >= 15)
      stream.error__();
    var offset: int = code - codeLengthInfo[codelength].min;
    var index: int = codeLengthInfo[codelength].baseIndex + offset;
    return codeValues[index];
  }
}
}
