package org.eclipse.swt.internal.image {
import java.io.*;
import java.io.IOException;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class PngHuffmanTables {
  internal var literalTable: PngHuffmanTable;
  internal var distanceTable: PngHuffmanTable;
  public static var FixedLiteralTable: PngHuffmanTable;
  public static var FixedDistanceTable: PngHuffmanTable;
  public static const LiteralTableSize: int = 288;
  public static var FixedLiteralLengths: JavaArray = new JavaArray("[I").values(8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8);
  public static const DistanceTableSize: int = 32;
  public static var FixedDistanceLengths: JavaArray = new JavaArray("[I").values(5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5);
  public static const LengthCodeTableSize: int = 19;
  public static var LengthCodeOrder: JavaArray = new JavaArray("[I").values(16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15);
  public static function getDynamicTables__Lorg_eclipse_swt_internal_image_PngDecodingDataStream_2(stream: PngDecodingDataStream): PngHuffmanTables {
    return new PngHuffmanTables(new Arguments(org.eclipse.swt.internal.image.PngHuffmanTables.PngHuffmanTables__Lorg_eclipse_swt_internal_image_PngDecodingDataStream_2, [stream]));
  }
  public static function getFixedTables__(): PngHuffmanTables {
    return new PngHuffmanTables(new Arguments(org.eclipse.swt.internal.image.PngHuffmanTables.PngHuffmanTables__, []));
  }
  private function getFixedLiteralTable__(): PngHuffmanTable {
    if (FixedLiteralTable === null) {
      FixedLiteralTable = new PngHuffmanTable(FixedLiteralLengths);
    }
    return FixedLiteralTable;
  }
  private function getFixedDistanceTable__(): PngHuffmanTable {
    if (FixedDistanceTable === null) {
      FixedDistanceTable = new PngHuffmanTable(FixedDistanceLengths);
    }
    return FixedDistanceTable;
  }
  private function PngHuffmanTables__(): Object {
    literalTable = this.getFixedLiteralTable__();
    distanceTable = this.getFixedDistanceTable__();
    return this;
  }
  private function PngHuffmanTables__Lorg_eclipse_swt_internal_image_PngDecodingDataStream_2(stream: PngDecodingDataStream): Object {
    var literals: int = 257 + stream.getNextIdatBits__I(5);
    var distances: int = 1 + stream.getNextIdatBits__I(5);
    var codeLengthCodes: int = 4 + stream.getNextIdatBits__I(4);
    if (codeLengthCodes > 19) {
      stream.error__();
    }
    var lengthCodes: JavaArray = new JavaArray("[I").lengths(19);
    for (var i: int = 0; i < codeLengthCodes; i++) {
      lengthCodes[LengthCodeOrder[i]] = stream.getNextIdatBits__I(3);
    }
    var codeLengthsTable: PngHuffmanTable = new PngHuffmanTable(lengthCodes);
    var literalLengths: JavaArray = this.readLengths__Lorg_eclipse_swt_internal_image_PngDecodingDataStream_2ILorg_eclipse_swt_internal_image_PngHuffmanTable_2I(stream, literals, codeLengthsTable, 288);
    var distanceLengths: JavaArray = this.readLengths__Lorg_eclipse_swt_internal_image_PngDecodingDataStream_2ILorg_eclipse_swt_internal_image_PngHuffmanTable_2I(stream, distances, codeLengthsTable, 32);
    literalTable = new PngHuffmanTable(literalLengths);
    distanceTable = new PngHuffmanTable(distanceLengths);
    return this;
  }
  private function readLengths__Lorg_eclipse_swt_internal_image_PngDecodingDataStream_2ILorg_eclipse_swt_internal_image_PngHuffmanTable_2I(stream: PngDecodingDataStream, numLengths: int, lengthsTable: PngHuffmanTable, tableSize: int): JavaArray {
    var lengths: JavaArray = new JavaArray("[I").lengths(tableSize);
    for (var index: int = 0; index < numLengths;) {
      var value: int = lengthsTable.getNextValue__Lorg_eclipse_swt_internal_image_PngDecodingDataStream_2(stream);
      if (value < 16) {
        lengths[index] = value;
        index++;
      } else if (value == 16) {
        var count: int = stream.getNextIdatBits__I(2) + 3;
        for (var i: int = 0; i < count; i++) {
          lengths[index] = lengths[index - 1];
          index++;
        }
      } else if (value == 17) {
        var count_1: int = stream.getNextIdatBits__I(3) + 3;
        for (var i_1: int = 0; i_1 < count_1; i_1++) {
          lengths[index] = 0;
          index++;
        }
      } else if (value == 18) {
        var count_2: int = stream.getNextIdatBits__I(7) + 11;
        for (var i_2: int = 0; i_2 < count_2; i_2++) {
          lengths[index] = 0;
          index++;
        }
      } else {
        stream.error__();
      }
    }
    return lengths;
  }
  public function getNextLiteralValue__Lorg_eclipse_swt_internal_image_PngDecodingDataStream_2(stream: PngDecodingDataStream): int {
    return literalTable.getNextValue__Lorg_eclipse_swt_internal_image_PngDecodingDataStream_2(stream);
  }
  public function getNextDistanceValue__Lorg_eclipse_swt_internal_image_PngDecodingDataStream_2(stream: PngDecodingDataStream): int {
    return distanceTable.getNextValue__Lorg_eclipse_swt_internal_image_PngDecodingDataStream_2(stream);
  }
  public function PngHuffmanTables(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is PngDecodingDataStream) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0]];
        break;
    }
    super();
    switch (id) {
      case 0:
        PngHuffmanTables__();
        break;
      case 1:
        PngHuffmanTables__Lorg_eclipse_swt_internal_image_PngDecodingDataStream_2(args1[0]);
        break;
    }
  }
  public static const PngHuffmanTables__ : int = 0;
  public static const PngHuffmanTables__Lorg_eclipse_swt_internal_image_PngDecodingDataStream_2 : int = 1;
}
}
