package org.eclipse.swt.internal.image {
import org.eclipse.swt.*;
import java.lang.System;
import org.eclipse.swt.SWT;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class PngIdatChunk extends PngChunk {
  public static const HEADER_BYTES_LENGTH: int = 2;
  public static const ADLER_FIELD_LENGTH: int = 4;
  public static const HEADER_BYTE1_DATA_OFFSET: int = 8 + 0;
  public static const HEADER_BYTE2_DATA_OFFSET: int = 8 + 1;
  public static const ADLER_DATA_OFFSET: int = 8 + 2;
  public function PngIdatChunk__BB_3BI(headerByte1: int, headerByte2: int, data: JavaArray, adler: int): Object {
    this.setType___3B(PngChunk.TYPE_IDAT);
    reference[8] = headerByte1;
    reference[9] = headerByte2;
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(data, 0, reference, 8, data.length);
    this.setInt32__II(10, adler);
    this.setCRC__I(this.computeCRC__());
    return this;
  }
  public function PngIdatChunk___3B(reference: JavaArray): Object {
    return this;
  }
  public override function getChunkType__(): int {
    return 2;
  }
  public override function validate__Lorg_eclipse_swt_internal_image_PngFileReadState_2Lorg_eclipse_swt_internal_image_PngIhdrChunk_2(readState: PngFileReadState, headerChunk: PngIhdrChunk): void {
    if (!readState.readIHDR || (headerChunk.getMustHavePalette__() && !readState.readPLTE) || readState.readIEND) {
      SWT.error__I(40);
    } else {
      readState.readIDAT = true;
    }
    super.validate__Lorg_eclipse_swt_internal_image_PngFileReadState_2Lorg_eclipse_swt_internal_image_PngIhdrChunk_2(readState, headerChunk);
    return;
  }
  public function getDataByteAtOffset__I(offset: int): int {
    return reference[8 + offset];
  }
  public function PngIdatChunk(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 4 && vargs[0] is int && vargs[1] is int && vargs[2] is JavaArray && vargs[3] is int) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is JavaArray) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0], args[1], args[2], args[3]];
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.swt.internal.image.PngChunk.PngChunk__I, [args0[2].length + 2 + 4]);
        break;
      case 1:
        var args1: Array = [args[0]];
        superArgs = new Arguments(org.eclipse.swt.internal.image.PngChunk.PngChunk___3B, [args1[0]]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        PngIdatChunk__BB_3BI(args0[0], args0[1], args0[2], args0[3]);
        break;
      case 1:
        PngIdatChunk___3B(args1[0]);
        break;
    }
  }
  public static const PngIdatChunk__BB_3BI : int = 0;
  public static const PngIdatChunk___3B : int = 1;
}
}
