package org.eclipse.swt.internal.image {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.SWT;
import java.lang.StringBuffer;
import java.lang.Math__;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class PngIhdrChunk extends PngChunk {
  public static const IHDR_DATA_LENGTH: int = 13;
  public static const WIDTH_DATA_OFFSET: int = 8 + 0;
  public static const HEIGHT_DATA_OFFSET: int = 8 + 4;
  public static const BIT_DEPTH_OFFSET: int = 8 + 8;
  public static const COLOR_TYPE_OFFSET: int = 8 + 9;
  public static const COMPRESSION_METHOD_OFFSET: int = 8 + 10;
  public static const FILTER_METHOD_OFFSET: int = 8 + 11;
  public static const INTERLACE_METHOD_OFFSET: int = 8 + 12;
  public static const COLOR_TYPE_GRAYSCALE: int = 0;
  public static const COLOR_TYPE_RGB: int = 2;
  public static const COLOR_TYPE_PALETTE: int = 3;
  public static const COLOR_TYPE_GRAYSCALE_WITH_ALPHA: int = 4;
  public static const COLOR_TYPE_RGB_WITH_ALPHA: int = 6;
  public static const INTERLACE_METHOD_NONE: int = 0;
  public static const INTERLACE_METHOD_ADAM7: int = 1;
  public static const FILTER_NONE: int = 0;
  public static const FILTER_SUB: int = 1;
  public static const FILTER_UP: int = 2;
  public static const FILTER_AVERAGE: int = 3;
  public static const FILTER_PAETH: int = 4;
  public static var ValidBitDepths: JavaArray = new JavaArray("[B").values(1, 2, 4, 8, 16);
  public static var ValidColorTypes: JavaArray = new JavaArray("[B").values(0, 2, 3, 4, 6);
  internal var width: int;
  internal var height: int;
  internal var bitDepth: int;
  internal var colorType: int;
  internal var compressionMethod: int;
  internal var filterMethod: int;
  internal var interlaceMethod: int;
  public function PngIhdrChunk__IIBBBBB(width: int, height: int, bitDepth: int, colorType: int, compressionMethod: int, filterMethod: int, interlaceMethod: int): Object {
    this.setType___3B(PngChunk.TYPE_IHDR);
    this.setWidth__I(width);
    this.setHeight__I(height);
    this.setBitDepth__B(bitDepth);
    this.setColorType__B(colorType);
    this.setCompressionMethod__B(compressionMethod);
    this.setFilterMethod__B(filterMethod);
    this.setInterlaceMethod__B(interlaceMethod);
    this.setCRC__I(this.computeCRC__());
    return this;
  }
  public function PngIhdrChunk___3B(reference: JavaArray): Object {
    if (reference.length <= 13)
      SWT.error__I(40);
    width = this.getInt32__I(8);
    height = this.getInt32__I(12);
    bitDepth = reference[16];
    colorType = reference[17];
    compressionMethod = reference[18];
    filterMethod = reference[19];
    interlaceMethod = reference[20];
    return this;
  }
  public override function getChunkType__(): int {
    return 0;
  }
  public function getWidth__(): int {
    return width;
  }
  public function setWidth__I(value: int): void {
    this.setInt32__II(8, value);
    width = value;
  }
  public function getHeight__(): int {
    return height;
  }
  public function setHeight__I(value: int): void {
    this.setInt32__II(12, value);
    height = value;
  }
  public function getBitDepth__(): int {
    return bitDepth;
  }
  public function setBitDepth__B(value: int): void {
    reference[16] = value;
    bitDepth = value;
  }
  public function getColorType__(): int {
    return colorType;
  }
  public function setColorType__B(value: int): void {
    reference[17] = value;
    colorType = value;
  }
  public function getCompressionMethod__(): int {
    return compressionMethod;
  }
  public function setCompressionMethod__B(value: int): void {
    reference[18] = value;
    compressionMethod = value;
  }
  public function getFilterMethod__(): int {
    return filterMethod;
  }
  public function setFilterMethod__B(value: int): void {
    reference[19] = value;
    filterMethod = value;
  }
  public function getInterlaceMethod__(): int {
    return interlaceMethod;
  }
  public function setInterlaceMethod__B(value: int): void {
    reference[20] = value;
    interlaceMethod = value;
  }
  public override function validate__Lorg_eclipse_swt_internal_image_PngFileReadState_2Lorg_eclipse_swt_internal_image_PngIhdrChunk_2(readState: PngFileReadState, headerChunk: PngIhdrChunk): void {
    if (readState.readIHDR || readState.readPLTE || readState.readIDAT || readState.readIEND) {
      SWT.error__I(40);
    } else {
      readState.readIHDR = true;
    }
    super.validate__Lorg_eclipse_swt_internal_image_PngFileReadState_2Lorg_eclipse_swt_internal_image_PngIhdrChunk_2(readState, headerChunk);
    if (length != 13)
      SWT.error__I(40);
    if (compressionMethod != 0)
      SWT.error__I(40);
    if (interlaceMethod != 0 && interlaceMethod != 1) {
      SWT.error__I(40);
    }
    var colorTypeIsValid: Boolean = false;
    for (var i: int = 0; i < ValidColorTypes.length; i++) {
      if (ValidColorTypes[i] == colorType) {
        colorTypeIsValid = true;
        break;
      }
    }
    if (!colorTypeIsValid)
      SWT.error__I(40);
    var bitDepthIsValid: Boolean = false;
    for (var i_1: int = 0; i_1 < ValidBitDepths.length; i_1++) {
      if (ValidBitDepths[i_1] == bitDepth) {
        bitDepthIsValid = true;
        break;
      }
    }
    if (!bitDepthIsValid)
      SWT.error__I(40);
    if ((colorType == 2 || colorType == 6 || colorType == 4) && bitDepth < 8) {
      SWT.error__I(40);
    }
    if (colorType == 3 && bitDepth > 8) {
      SWT.error__I(40);
    }
    return;
  }
  public function getColorTypeString__(): String {
    switch (colorType) {
      case 0 :
        return "Grayscale";
      case 2 :
        return "RGB";
      case 3 :
        return "Palette";
      case 4 :
        return "Grayscale with Alpha";
      case 6 :
        return "RGB with Alpha";
      default :
        return "Unknown - " + colorType;
    }
  }
  public function getFilterMethodString__(): String {
    switch (filterMethod) {
      case 0 :
        return "None";
      case 1 :
        return "Sub";
      case 2 :
        return "Up";
      case 3 :
        return "Average";
      case 4 :
        return "Paeth";
      default :
        return "Unknown";
    }
  }
  public function getInterlaceMethodString__(): String {
    switch (interlaceMethod) {
      case 0 :
        return "Not Interlaced";
      case 1 :
        return "Interlaced - ADAM7";
      default :
        return "Unknown";
    }
  }
  public override function contributeToString__Ljava_lang_StringBuffer_2(buffer: StringBuffer): void {
    buffer.append__Ljava_lang_String_2("\n\tWidth: ");
    buffer.append__I(width);
    buffer.append__Ljava_lang_String_2("\n\tHeight: ");
    buffer.append__I(height);
    buffer.append__Ljava_lang_String_2("\n\tBit Depth: ");
    buffer.append__I(bitDepth);
    buffer.append__Ljava_lang_String_2("\n\tColor Type: ");
    buffer.append__Ljava_lang_String_2(this.getColorTypeString__());
    buffer.append__Ljava_lang_String_2("\n\tCompression Method: ");
    buffer.append__I(compressionMethod);
    buffer.append__Ljava_lang_String_2("\n\tFilter Method: ");
    buffer.append__Ljava_lang_String_2(this.getFilterMethodString__());
    buffer.append__Ljava_lang_String_2("\n\tInterlace Method: ");
    buffer.append__Ljava_lang_String_2(this.getInterlaceMethodString__());
  }
  public function getMustHavePalette__(): Boolean {
    return colorType == 3;
  }
  public function getCanHavePalette__(): Boolean {
    return colorType != 0 && colorType != 4;
  }
  public function getBitsPerPixel__(): int {
    switch (colorType) {
      case 6 :
        return 4 * bitDepth;
      case 2 :
        return 3 * bitDepth;
      case 4 :
        return 2 * bitDepth;
      case 0 :
      case 3 :
        return bitDepth;
      default :
        SWT.error__I(40);
        return 0;
    }
  }
  public function getSwtBitsPerPixel__(): int {
    switch (colorType) {
      case 6 :
      case 2 :
      case 4 :
        return 24;
      case 0 :
      case 3 :
        return Math__.min__II(bitDepth, 8);
      default :
        SWT.error__I(40);
        return 0;
    }
  }
  public function getFilterByteOffset__(): int {
    if (bitDepth < 8)
      return 1;
    return int(this.getBitsPerPixel__() / 8);
  }
  public function usesDirectColor__(): Boolean {
    switch (colorType) {
      case 0 :
      case 4 :
      case 2 :
      case 6 :
        return true;
      default :
        return false;
    }
  }
  public function createGrayscalePalette__(): PaletteData {
    var depth: int = Math__.min__II(bitDepth, 8);
    var max: int = (1 << depth) - 1;
    var delta: int = int(255 / max);
    var gray: int = 0;
    var rgbs: JavaArray = new JavaArray("[Lorg/eclipse/swt/graphics/RGB;").lengths(max + 1);
    for (var i: int = 0; i <= max; i++) {
      rgbs[i] = new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [gray, gray, gray]));
      gray += delta;
    }
    return new PaletteData(new Arguments(org.eclipse.swt.graphics.PaletteData.PaletteData___3Lorg_eclipse_swt_graphics_RGB_2, [rgbs]));
  }
  public function getPaletteData__(): PaletteData {
    switch (colorType) {
      case 0 :
        return this.createGrayscalePalette__();
      case 4 :
      case 2 :
      case 6 :
        return new PaletteData(new Arguments(org.eclipse.swt.graphics.PaletteData.PaletteData__III, [0xFF0000, 0xFF00, 0xFF]));
      default :
        return null;
    }
  }
  public function PngIhdrChunk(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 7 && vargs[0] is int && vargs[1] is int && vargs[2] is int && vargs[3] is int && vargs[4] is int && vargs[5] is int && vargs[6] is int) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is JavaArray) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0], args[1], args[2], args[3], args[4], args[5], args[6]];
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.swt.internal.image.PngChunk.PngChunk__I, [13]);
        break;
      case 1:
        var args1: Array = [args[0]];
        superArgs = new Arguments(org.eclipse.swt.internal.image.PngChunk.PngChunk___3B, [args1[0]]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        PngIhdrChunk__IIBBBBB(args0[0], args0[1], args0[2], args0[3], args0[4], args0[5], args0[6]);
        break;
      case 1:
        PngIhdrChunk___3B(args1[0]);
        break;
    }
  }
  public static const PngIhdrChunk__IIBBBBB : int = 0;
  public static const PngIhdrChunk___3B : int = 1;
}
}
