package org.eclipse.swt.internal.image {
import java.io.*;
import java.io.InputStream;
import java.io.IOException;
import java.lang.Math__;
import java.lang.System;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class PngInputStream extends InputStream {
  internal var reader: PngChunkReader;
  internal var chunk: PngChunk;
  internal var offset: int;
  internal var length: int;
  public static const DATA_OFFSET: int = 8;
  public function PngInputStream(chunk: PngIdatChunk, reader: PngChunkReader) {
    this.chunk = chunk;
    this.reader = reader;
    length = chunk.getLength__();
    offset = 0;
    return;
  }
  private function checkChunk__(): Boolean {
    while (offset == length) {
      chunk = reader.readNextChunk__();
      if (chunk === null)
        throw new IOException(new Arguments(java.io.IOException.IOException__, []));
      if (chunk.getChunkType__() == 3)
        return false;
      if (chunk.getChunkType__() != 2)
        throw new IOException(new Arguments(java.io.IOException.IOException__, []));
      length = chunk.getLength__();
      offset = 0;
    }
    return true;
  }
  public override function close__(): void {
    chunk = null;
  }
  public override function read__(): int {
    if (chunk === null)
      throw new IOException(new Arguments(java.io.IOException.IOException__, []));
    if (offset == length && !this.checkChunk__())
      return -1;
    var b: int = chunk.reference[8 + offset] & 0xFF;
    offset++;
    return b;
  }
  public override function read___3BII(b: JavaArray, off: int, len: int): int {
    if (chunk === null)
      throw new IOException(new Arguments(java.io.IOException.IOException__, []));
    if (offset == length && !this.checkChunk__())
      return -1;
    len = Math__.min__II(len, length - offset);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(chunk.reference, 8 + offset, b, off, len);
    offset += len;
    return len;
  }
}
}
