package org.eclipse.swt.internal.image {
import java.io.*;
import java.io.IOException;
import java.lang.JavaArray;
dynamic public class PngLzBlockReader {
  internal var isLastBlock: Boolean;
  internal var compressionType: int;
  internal var uncompressedBytesRemaining: int;
  internal var stream: PngDecodingDataStream;
  internal var huffmanTables: PngHuffmanTables;
  internal var window: JavaArray;
  internal var windowIndex: int;
  internal var copyIndex: int;
  internal var copyBytesRemaining: int;
  public static const UNCOMPRESSED: int = 0;
  public static const COMPRESSED_FIXED: int = 1;
  public static const COMPRESSED_DYNAMIC: int = 2;
  public static const END_OF_COMPRESSED_BLOCK: int = 256;
  public static const FIRST_LENGTH_CODE: int = 257;
  public static const LAST_LENGTH_CODE: int = 285;
  public static const FIRST_DISTANCE_CODE: int = 1;
  public static const LAST_DISTANCE_CODE: int = 29;
  public static const FIRST_CODE_LENGTH_CODE: int = 4;
  public static const LAST_CODE_LENGTH_CODE: int = 19;
  public static var lengthBases: JavaArray = new JavaArray("[I").values(3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31, 35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258);
  public static var extraLengthBits: JavaArray = new JavaArray("[I").values(0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0);
  public static var distanceBases: JavaArray = new JavaArray("[I").values(1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193, 257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145, 8193, 12289, 16385, 24577);
  public static var extraDistanceBits: JavaArray = new JavaArray("[I").values(0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13);
  function PngLzBlockReader(stream: PngDecodingDataStream) {
    this.stream = stream;
    isLastBlock = false;
    return;
  }
  public function setWindowSize__I(windowSize: int): void {
    window = new JavaArray("[B").lengths(windowSize);
    return;
  }
  public function readNextBlockHeader__(): void {
    isLastBlock = stream.getNextIdatBit__() != 0;
    compressionType = int((stream.getNextIdatBits__I(2) & 0xFF));
    if (compressionType > 2)
      stream.error__();
    if (compressionType == 0) {
      var b1: int = stream.getNextIdatByte__();
      var b2: int = stream.getNextIdatByte__();
      var b3: int = stream.getNextIdatByte__();
      var b4: int = stream.getNextIdatByte__();
      if (b1 != ~b3 || b2 != ~b4)
        stream.error__();
      uncompressedBytesRemaining = (b1 & 0xFF) | ((b2 & 0xFF) << 8);
    } else if (compressionType == 2) {
      huffmanTables = PngHuffmanTables.getDynamicTables__Lorg_eclipse_swt_internal_image_PngDecodingDataStream_2(stream);
    } else {
      huffmanTables = PngHuffmanTables.getFixedTables__();
    }
    return;
  }
  public function getNextByte__(): int {
    if (compressionType == 0) {
      if (uncompressedBytesRemaining == 0) {
        this.readNextBlockHeader__();
        return this.getNextByte__();
      }
      uncompressedBytesRemaining--;
      return stream.getNextIdatByte__();
    } else {
      var value: int = this.getNextCompressedByte__();
      if (value == 256) {
        if (isLastBlock)
          stream.error__();
        this.readNextBlockHeader__();
        return this.getNextByte__();
      } else {
        return value;
      }
    }
    return 0;
  }
  private function assertBlockAtEnd__(): void {
    if (compressionType == 0) {
      if (uncompressedBytesRemaining > 0)
        stream.error__();
    } else if (copyBytesRemaining > 0 || (huffmanTables.getNextLiteralValue__Lorg_eclipse_swt_internal_image_PngDecodingDataStream_2(stream) != 256)) {
      stream.error__();
    }
    return;
  }
  public function assertCompressedDataAtEnd__(): void {
    this.assertBlockAtEnd__();
    while (!isLastBlock) {
      this.readNextBlockHeader__();
      this.assertBlockAtEnd__();
    }
    return;
  }
  private function getNextCompressedByte__(): int {
    if (copyBytesRemaining > 0) {
      var value: int = window[copyIndex];
      window[windowIndex] = value;
      copyBytesRemaining--;
      copyIndex++;
      windowIndex++;
      if (copyIndex == window.length)
        copyIndex = 0;
      if (windowIndex == window.length)
        windowIndex = 0;
      return value;
    }
    var value_1: int = huffmanTables.getNextLiteralValue__Lorg_eclipse_swt_internal_image_PngDecodingDataStream_2(stream);
    if (value_1 < 256) {
      window[windowIndex] = int((value_1 & 0xFF));
      windowIndex++;
      if (windowIndex >= window.length)
        windowIndex = 0;
      return int((value_1 & 0xFF));
    } else if (value_1 == 256) {
      this.readNextBlockHeader__();
      return this.getNextByte__();
    } else if (value_1 <= 285) {
      var extraBits: int = extraLengthBits[value_1 - 257];
      var length: int = lengthBases[value_1 - 257];
      if (extraBits > 0) {
        length += stream.getNextIdatBits__I(extraBits);
      }
      value_1 = huffmanTables.getNextDistanceValue__Lorg_eclipse_swt_internal_image_PngDecodingDataStream_2(stream);
      if (value_1 > 29)
        stream.error__();
      extraBits = extraDistanceBits[value_1];
      var distance: int = distanceBases[value_1];
      if (extraBits > 0) {
        distance += stream.getNextIdatBits__I(extraBits);
      }
      copyIndex = windowIndex - distance;
      if (copyIndex < 0)
        copyIndex += window.length;
      copyBytesRemaining = length;
      return this.getNextCompressedByte__();
    } else {
      stream.error__();
      return 0;
    }
    return 0;
  }
}
}
