package org.eclipse.swt.internal.image {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.SWT;
import java.lang.StringBuffer;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class PngPlteChunk extends PngChunk {
  internal var paletteSize: int;
  public function PngPlteChunk__Lorg_eclipse_swt_graphics_PaletteData_2(palette: PaletteData): Object {
    paletteSize = int(length / 3);
    this.setType___3B(PngChunk.TYPE_PLTE);
    this.setPaletteData__Lorg_eclipse_swt_graphics_PaletteData_2(palette);
    this.setCRC__I(this.computeCRC__());
    return this;
  }
  public function PngPlteChunk___3B(reference: JavaArray): Object {
    paletteSize = int(length / 3);
    return this;
  }
  public override function getChunkType__(): int {
    return 1;
  }
  public function getPaletteSize__(): int {
    return paletteSize;
  }
  public function getPaletteData__(): PaletteData {
    var rgbs: JavaArray = new JavaArray("[Lorg/eclipse/swt/graphics/RGB;").lengths(paletteSize);
    for (var i: int = 0; i < rgbs.length; i++) {
      var offset: int = 8 + (i * 3);
      var red: int = reference[offset] & 0xFF;
      var green: int = reference[offset + 1] & 0xFF;
      var blue: int = reference[offset + 2] & 0xFF;
      rgbs[i] = new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [red, green, blue]));
    }
    return new PaletteData(new Arguments(org.eclipse.swt.graphics.PaletteData.PaletteData___3Lorg_eclipse_swt_graphics_RGB_2, [rgbs]));
  }
  public function setPaletteData__Lorg_eclipse_swt_graphics_PaletteData_2(palette: PaletteData): void {
    var rgbs: JavaArray = palette.getRGBs__();
    for (var i: int = 0; i < rgbs.length; i++) {
      var offset: int = 8 + (i * 3);
      reference[offset] = int(rgbs[i].red);
      reference[offset + 1] = int(rgbs[i].green);
      reference[offset + 2] = int(rgbs[i].blue);
    }
    return;
  }
  public override function validate__Lorg_eclipse_swt_internal_image_PngFileReadState_2Lorg_eclipse_swt_internal_image_PngIhdrChunk_2(readState: PngFileReadState, headerChunk: PngIhdrChunk): void {
    if (!readState.readIHDR || readState.readPLTE || readState.readTRNS || readState.readIDAT || readState.readIEND) {
      SWT.error__I(40);
    } else {
      readState.readPLTE = true;
    }
    super.validate__Lorg_eclipse_swt_internal_image_PngFileReadState_2Lorg_eclipse_swt_internal_image_PngIhdrChunk_2(readState, headerChunk);
    if (this.getLength__() % 3 != 0)
      SWT.error__I(40);
    if (1 << headerChunk.getBitDepth__() < paletteSize) {
      SWT.error__I(40);
    }
    if (256 < paletteSize)
      SWT.error__I(40);
    return;
  }
  public override function contributeToString__Ljava_lang_StringBuffer_2(buffer: StringBuffer): void {
    buffer.append__Ljava_lang_String_2("\n\tPalette size:");
    buffer.append__I(paletteSize);
    return;
  }
  public function PngPlteChunk(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 1 && vargs[0] is PaletteData) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is JavaArray) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0]];
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.swt.internal.image.PngChunk.PngChunk__I, [args0[0].getRGBs__().length * 3]);
        break;
      case 1:
        var args1: Array = [args[0]];
        superArgs = new Arguments(org.eclipse.swt.internal.image.PngChunk.PngChunk___3B, [args1[0]]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        PngPlteChunk__Lorg_eclipse_swt_graphics_PaletteData_2(args0[0]);
        break;
      case 1:
        PngPlteChunk___3B(args1[0]);
        break;
    }
  }
  public static const PngPlteChunk__Lorg_eclipse_swt_graphics_PaletteData_2 : int = 0;
  public static const PngPlteChunk___3B : int = 1;
}
}
