package org.eclipse.swt.internal.image {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.SWT;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class PngTrnsChunk extends PngChunk {
  public static const TRANSPARENCY_TYPE_PIXEL: int = 0;
  public static const TRANSPARENCY_TYPE_ALPHAS: int = 1;
  public static const RGB_DATA_LENGTH: int = 6;
  public function PngTrnsChunk__Lorg_eclipse_swt_graphics_RGB_2(rgb: RGB): Object {
    this.setType___3B(PngChunk.TYPE_tRNS);
    this.setInt16__II(8, rgb.red);
    this.setInt16__II(8 + 2, rgb.green);
    this.setInt16__II(8 + 4, rgb.blue);
    this.setCRC__I(this.computeCRC__());
    return this;
  }
  public function PngTrnsChunk___3B(reference: JavaArray): Object {
    return this;
  }
  public override function getChunkType__(): int {
    return 5;
  }
  public function validateLength__Lorg_eclipse_swt_internal_image_PngIhdrChunk_2Lorg_eclipse_swt_internal_image_PngPlteChunk_2(header: PngIhdrChunk, paletteChunk: PngPlteChunk): void {
    var valid: Boolean;
    switch (header.getColorType__()) {
      case 2 :
        valid = this.getLength__() == 6;
        break;
      case 3 :
        valid = this.getLength__() <= paletteChunk.getLength__();
        break;
      case 0 :
        valid = this.getLength__() == 2;
        break;
      case 6 :
      case 4 :
      default :
        valid = false;
    }
    if (!valid) {
      SWT.error__I(40);
    }
    return;
  }
  public function validate__Lorg_eclipse_swt_internal_image_PngFileReadState_2Lorg_eclipse_swt_internal_image_PngIhdrChunk_2Lorg_eclipse_swt_internal_image_PngPlteChunk_2(readState: PngFileReadState, headerChunk: PngIhdrChunk, paletteChunk: PngPlteChunk): void {
    if (!readState.readIHDR || (headerChunk.getMustHavePalette__() && !readState.readPLTE) || readState.readIDAT || readState.readIEND) {
      SWT.error__I(40);
    } else {
      readState.readTRNS = true;
    }
    this.validateLength__Lorg_eclipse_swt_internal_image_PngIhdrChunk_2Lorg_eclipse_swt_internal_image_PngPlteChunk_2(headerChunk, paletteChunk);
    super.validate__Lorg_eclipse_swt_internal_image_PngFileReadState_2Lorg_eclipse_swt_internal_image_PngIhdrChunk_2(readState, headerChunk);
    return;
  }
  public function getTransparencyType__Lorg_eclipse_swt_internal_image_PngIhdrChunk_2(header: PngIhdrChunk): int {
    if (header.getColorType__() == 3) {
      return 1;
    }
    return 0;
  }
  public function getSwtTransparentPixel__Lorg_eclipse_swt_internal_image_PngIhdrChunk_2(header: PngIhdrChunk): int {
    switch (header.getColorType__()) {
      case 0 :
        var gray: int = ((reference[8] & 0xFF) << 8) + (reference[8 + 1] & 0xFF);
        if (header.getBitDepth__() > 8) {
          return PNGFileFormat.compress16BitDepthTo8BitDepth__I(gray);
        }
        return gray & 0xFF;
      case 2 :
        var red: int = ((reference[8] & 0xFF) << 8) | (reference[8 + 1] & 0xFF);
        var green: int = ((reference[8 + 2] & 0xFF) << 8) | (reference[8 + 3] & 0xFF);
        var blue: int = ((reference[8 + 4] & 0xFF) << 8) | (reference[8 + 5] & 0xFF);
        if (header.getBitDepth__() > 8) {
          red = PNGFileFormat.compress16BitDepthTo8BitDepth__I(red);
          green = PNGFileFormat.compress16BitDepthTo8BitDepth__I(green);
          blue = PNGFileFormat.compress16BitDepthTo8BitDepth__I(blue);
        }
        return (red << 16) | (green << 8) | blue;
      default :
        SWT.error__I(40);
        return -1;
    }
  }
  public function getAlphaValues__Lorg_eclipse_swt_internal_image_PngIhdrChunk_2Lorg_eclipse_swt_internal_image_PngPlteChunk_2(header: PngIhdrChunk, paletteChunk: PngPlteChunk): JavaArray {
    if (header.getColorType__() != 3) {
      SWT.error__I(40);
    }
    var alphas: JavaArray = new JavaArray("[B").lengths(paletteChunk.getPaletteSize__());
    var dataLength: int = this.getLength__();
    var i: int = 0;
    for (i = 0; i < dataLength; i++) {
      alphas[i] = reference[8 + i];
    }
    for (var j: int = i; j < alphas.length; j++) {
      alphas[j] = int(255);
    }
    return alphas;
  }
  public function PngTrnsChunk(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 1 && vargs[0] is RGB) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is JavaArray) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0]];
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.swt.internal.image.PngChunk.PngChunk__I, [6]);
        break;
      case 1:
        var args1: Array = [args[0]];
        superArgs = new Arguments(org.eclipse.swt.internal.image.PngChunk.PngChunk___3B, [args1[0]]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        PngTrnsChunk__Lorg_eclipse_swt_graphics_RGB_2(args0[0]);
        break;
      case 1:
        PngTrnsChunk___3B(args1[0]);
        break;
    }
  }
  public static const PngTrnsChunk__Lorg_eclipse_swt_graphics_RGB_2 : int = 0;
  public static const PngTrnsChunk___3B : int = 1;
}
}
