package org.eclipse.swt.internal.image {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import java.io.*;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.ImageData;
import java.lang.System;
import java.io.IOException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageLoaderEvent;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import java.lang.Integer;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class TIFFDirectory {
  internal var file: TIFFRandomFileAccess;
  internal var isLittleEndian: Boolean;
  internal var loader: ImageLoader;
  internal var depth: int;
  internal var imageWidth: int;
  internal var imageLength: int;
  internal var bitsPerSample: JavaArray;
  internal var compression: int;
  internal var photometricInterpretation: int;
  internal var stripOffsets: JavaArray;
  internal var samplesPerPixel: int;
  internal var rowsPerStrip: int;
  internal var stripByteCounts: JavaArray;
  internal var t4Options: int;
  internal var colorMapOffset: int;
  internal var image: ImageData;
  internal var out: LEDataOutputStream;
  public static const NO_VALUE: int = -1;
  public static const TAG_ImageWidth: int = 256;
  public static const TAG_ImageLength: int = 257;
  public static const TAG_BitsPerSample: int = 258;
  public static const TAG_Compression: int = 259;
  public static const TAG_PhotometricInterpretation: int = 262;
  public static const TAG_StripOffsets: int = 273;
  public static const TAG_SamplesPerPixel: int = 277;
  public static const TAG_RowsPerStrip: int = 278;
  public static const TAG_StripByteCounts: int = 279;
  public static const TAG_XResolution: int = 282;
  public static const TAG_YResolution: int = 283;
  public static const TAG_T4Options: int = 292;
  public static const TAG_ResolutionUnit: int = 296;
  public static const TAG_ColorMap: int = 320;
  public static const TYPE_BYTE: int = 1;
  public static const TYPE_ASCII: int = 2;
  public static const TYPE_SHORT: int = 3;
  public static const TYPE_LONG: int = 4;
  public static const TYPE_RATIONAL: int = 5;
  public static const COMPRESSION_NONE: int = 1;
  public static const COMPRESSION_CCITT_3_1: int = 2;
  public static const COMPRESSION_PACKBITS: int = 32773;
  public static const IFD_ENTRY_SIZE: int = 12;
  public function TIFFDirectory__Lorg_eclipse_swt_internal_image_TIFFRandomFileAccess_2ZLorg_eclipse_swt_graphics_ImageLoader_2(file: TIFFRandomFileAccess, isLittleEndian: Boolean, loader: ImageLoader): Object {
    this.file = file;
    this.isLittleEndian = isLittleEndian;
    this.loader = loader;
    return this;
  }
  public function TIFFDirectory__Lorg_eclipse_swt_graphics_ImageData_2(image: ImageData): Object {
    this.image = image;
    return this;
  }
  public function decodePackBits___3B_3BI(src: JavaArray, dest: JavaArray, offsetDest: int): int {
    var destIndex: int = offsetDest;
    var srcIndex: int = 0;
    while (srcIndex < src.length) {
      var n: int = src[srcIndex];
      if (0 <= n && n <= 127) {
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(src, ++srcIndex, dest, destIndex, n + 1);
        srcIndex += n + 1;
        destIndex += n + 1;
      } else if (-127 <= n && n <= -1) {
        var value: int = src[++srcIndex];
        for (var j: int = 0; j < -n + 1; j++) {
          dest[destIndex++] = value;
        }
        srcIndex++;
      } else {
        srcIndex++;
      }
    }
    return destIndex - offsetDest;
  }
  public function getEntryValue__I_3BI(type: int, buffer: JavaArray, index: int): int {
    return this.toInt___3BII(buffer, index + 8, type);
  }
  public function getEntryValue__I_3BI_3I(type: int, buffer: JavaArray, index: int, values: JavaArray): void {
    var start: int = index + 8;
    var size: int;
    var offset: int = this.toInt___3BII(buffer, start, 4);
    switch (type) {
      case 3 :
        size = 2;
        break;
      case 4 :
        size = 4;
        break;
      case 5 :
        size = 8;
        break;
      case 2 :
      case 1 :
        size = 1;
        break;
      default :
        SWT.error__I(42);
        return;
    }
    if (values.length * size > 4) {
      buffer = new JavaArray("[B").lengths(values.length * size);
      file.seek__I(offset);
      file.read___3B(buffer);
      start = 0;
    }
    for (var i: int = 0; i < values.length; i++) {
      values[i] = this.toInt___3BII(buffer, start + i * size, type);
    }
    return;
  }
  public function decodePixels__Lorg_eclipse_swt_graphics_ImageData_2(image_1: ImageData): void {
    var imageData: JavaArray = new JavaArray("[B").lengths(int((imageWidth * depth + 7) / 8) * imageLength);
    image_1.data = imageData;
    var destIndex: int = 0;
    var length: int = stripOffsets.length;
    for (var i: int = 0; i < length; i++) {
      var data: JavaArray = new JavaArray("[B").lengths(stripByteCounts[i]);
      file.seek__I(stripOffsets[i]);
      file.read___3B(data);
      if (compression == 1) {
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(data, 0, imageData, destIndex, data.length);
        destIndex += data.length;
      } else if (compression == 32773) {
        destIndex += this.decodePackBits___3B_3BI(data, imageData, destIndex);
      } else if (compression == 2 || compression == 3) {
        var codec: TIFFModifiedHuffmanCodec = new TIFFModifiedHuffmanCodec();
        var nRows: int = rowsPerStrip;
        if (i == length - 1) {
          var n: int = imageLength % rowsPerStrip;
          if (n != 0)
            nRows = n;
        }
        destIndex += codec.decode___3B_3BIII(data, imageData, destIndex, imageWidth, nRows);
      }
      if (loader.hasListeners__()) {
        loader.notifyListeners__Lorg_eclipse_swt_graphics_ImageLoaderEvent_2(new ImageLoaderEvent(loader, image_1, i, i == length - 1));
      }
    }
    return;
  }
  public function getColorMap__(): PaletteData {
    var numColors: int = 1 << bitsPerSample[0];
    var numBytes: int = 3 * 2 * numColors;
    var buffer: JavaArray = new JavaArray("[B").lengths(numBytes);
    file.seek__I(colorMapOffset);
    file.read___3B(buffer);
    var colors: JavaArray = new JavaArray("[Lorg/eclipse/swt/graphics/RGB;").lengths(numColors);
    var offset: int = isLittleEndian ? 1 : 0;
    var startG: int = 2 * numColors;
    var startB: int = startG + 2 * numColors;
    for (var i: int = 0; i < numColors; i++) {
      var r: int = buffer[offset] & 0xFF;
      var g: int = buffer[startG + offset] & 0xFF;
      var b: int = buffer[startB + offset] & 0xFF;
      colors[i] = new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [r, g, b]));
      offset += 2;
    }
    return new PaletteData(new Arguments(org.eclipse.swt.graphics.PaletteData.PaletteData___3Lorg_eclipse_swt_graphics_RGB_2, [colors]));
  }
  public function getGrayPalette__(): PaletteData {
    var numColors: int = 1 << bitsPerSample[0];
    var rgbs: JavaArray = new JavaArray("[Lorg/eclipse/swt/graphics/RGB;").lengths(numColors);
    for (var i: int = 0; i < numColors; i++) {
      var value: int = int(i * 0xFF / (numColors - 1));
      if (photometricInterpretation == 0)
        value = 0xFF - value;
      rgbs[i] = new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [value, value, value]));
    }
    return new PaletteData(new Arguments(org.eclipse.swt.graphics.PaletteData.PaletteData___3Lorg_eclipse_swt_graphics_RGB_2, [rgbs]));
  }
  public function getRGBPalette__III(bitsR: int, bitsG: int, bitsB: int): PaletteData {
    var blueMask: int = 0;
    for (var i: int = 0; i < bitsB; i++) {
      blueMask |= 1 << i;
    }
    var greenMask: int = 0;
    for (var i_1: int = bitsB; i_1 < bitsB + bitsG; i_1++) {
      greenMask |= 1 << i_1;
    }
    var redMask: int = 0;
    for (var i_2: int = bitsB + bitsG; i_2 < bitsB + bitsG + bitsR; i_2++) {
      redMask |= 1 << i_2;
    }
    return new PaletteData(new Arguments(org.eclipse.swt.graphics.PaletteData.PaletteData__III, [redMask, greenMask, blueMask]));
  }
  public function formatStrips__II_3BIII_3_3I(rowByteSize: int, nbrRows: int, data: JavaArray, maxStripByteSize: int, offsetPostIFD: int, extraBytes: int, strips: JavaArray): int {
    var n: int;
    var nbrRowsPerStrip: int;
    if (rowByteSize > maxStripByteSize) {
      n = int(data.length / rowByteSize);
      nbrRowsPerStrip = 1;
    } else {
      var nbr: int = int((data.length + maxStripByteSize - 1) / maxStripByteSize);
      nbrRowsPerStrip = int(nbrRows / nbr);
      n = int((nbrRows + nbrRowsPerStrip - 1) / nbrRowsPerStrip);
    }
    var stripByteSize: int = rowByteSize * nbrRowsPerStrip;
    var offsets: JavaArray = new JavaArray("[I").lengths(n);
    var counts: JavaArray = new JavaArray("[I").lengths(n);
    var postIFDData: int = n == 1 ? 0 : n * 2 * 4;
    var startOffset: int = offsetPostIFD + extraBytes + postIFDData;
    var offset: int = startOffset;
    for (var i: int = 0; i < n; i++) {
      offsets[i] = offset;
      counts[i] = stripByteSize;
      offset += stripByteSize;
    }
    var mod: int = data.length % stripByteSize;
    if (mod != 0)
      counts[counts.length - 1] = mod;
    strips[0] = offsets;
    strips[1] = counts;
    return nbrRowsPerStrip;
  }
  public function formatColorMap___3Lorg_eclipse_swt_graphics_RGB_2(rgbs: JavaArray): JavaArray {
    var colorMap: JavaArray = new JavaArray("[I").lengths(rgbs.length * 3);
    var offsetGreen: int = rgbs.length;
    var offsetBlue: int = rgbs.length * 2;
    for (var i: int = 0; i < rgbs.length; i++) {
      colorMap[i] = rgbs[i].red << 8 | rgbs[i].red;
      colorMap[i + offsetGreen] = rgbs[i].green << 8 | rgbs[i].green;
      colorMap[i + offsetBlue] = rgbs[i].blue << 8 | rgbs[i].blue;
    }
    return colorMap;
  }
  public function parseEntries___3B(buffer: JavaArray): void {
    for (var offset: int = 0; offset < buffer.length; offset += 12) {
      var tag: int = this.toInt___3BII(buffer, offset, 3);
      var type: int = this.toInt___3BII(buffer, offset + 2, 3);
      var count: int = this.toInt___3BII(buffer, offset + 4, 4);
      switch (tag) {
        case 256 :
          {
            imageWidth = this.getEntryValue__I_3BI(type, buffer, offset);
            break;
          }
        case 257 :
          {
            imageLength = this.getEntryValue__I_3BI(type, buffer, offset);
            break;
          }
        case 258 :
          {
            if (type != 3)
              SWT.error__I(40);
            bitsPerSample = new JavaArray("[I").lengths(count);
            this.getEntryValue__I_3BI_3I(type, buffer, offset, bitsPerSample);
            break;
          }
        case 259 :
          {
            compression = this.getEntryValue__I_3BI(type, buffer, offset);
            break;
          }
        case 262 :
          {
            photometricInterpretation = this.getEntryValue__I_3BI(type, buffer, offset);
            break;
          }
        case 273 :
          {
            if (type != 4 && type != 3)
              SWT.error__I(40);
            stripOffsets = new JavaArray("[I").lengths(count);
            this.getEntryValue__I_3BI_3I(type, buffer, offset, stripOffsets);
            break;
          }
        case 277 :
          {
            if (type != 3)
              SWT.error__I(40);
            samplesPerPixel = this.getEntryValue__I_3BI(type, buffer, offset);
            if (samplesPerPixel != 1 && samplesPerPixel != 3)
              SWT.error__I(38);
            break;
          }
        case 278 :
          {
            rowsPerStrip = this.getEntryValue__I_3BI(type, buffer, offset);
            break;
          }
        case 279 :
          {
            stripByteCounts = new JavaArray("[I").lengths(count);
            this.getEntryValue__I_3BI_3I(type, buffer, offset, stripByteCounts);
            break;
          }
        case 282 :
          {
            break;
          }
        case 283 :
          {
            break;
          }
        case 292 :
          {
            if (type != 4)
              SWT.error__I(40);
            t4Options = this.getEntryValue__I_3BI(type, buffer, offset);
            if ((t4Options & 0x1) == 1) {
              SWT.error__I(42);
            }
            break;
          }
        case 296 :
          {
            break;
          }
        case 320 :
          {
            if (type != 3)
              SWT.error__I(40);
            colorMapOffset = this.getEntryValue__I_3BI(4, buffer, offset);
            break;
          }
      }
    }
    return;
  }
  public function read__(): ImageData {
    bitsPerSample = new JavaArray("[I").values(1);
    colorMapOffset = -1;
    compression = 1;
    imageLength = -1;
    imageWidth = -1;
    photometricInterpretation = -1;
    rowsPerStrip = 2147483647;
    samplesPerPixel = 1;
    stripByteCounts = null;
    stripOffsets = null;
    var buffer: JavaArray = new JavaArray("[B").lengths(2);
    file.read___3B(buffer);
    var numberEntries: int = this.toInt___3BII(buffer, 0, 3);
    buffer = new JavaArray("[B").lengths(12 * numberEntries);
    file.read___3B(buffer);
    this.parseEntries___3B(buffer);
    var palette: PaletteData = null;
    depth = 0;
    switch (photometricInterpretation) {
      case 0 :
      case 1 :
        {
          palette = this.getGrayPalette__();
          depth = bitsPerSample[0];
          break;
        }
      case 2 :
        {
          if (colorMapOffset != -1)
            SWT.error__I(40);
          palette = this.getRGBPalette__III(bitsPerSample[0], bitsPerSample[1], bitsPerSample[2]);
          depth = bitsPerSample[0] + bitsPerSample[1] + bitsPerSample[2];
          break;
        }
      case 3 :
        {
          if (colorMapOffset == -1)
            SWT.error__I(40);
          palette = this.getColorMap__();
          depth = bitsPerSample[0];
          break;
        }
      default :
        {
          SWT.error__I(40);
        }
    }
    var image_1: ImageData = ImageData.internal_new__IIILorg_eclipse_swt_graphics_PaletteData_2I_3BI_3B_3BIIIIIII(imageWidth, imageLength, depth, palette, 1, null, 0, null, null, -1, -1, 6, 0, 0, 0, 0);
    this.decodePixels__Lorg_eclipse_swt_graphics_ImageData_2(image_1);
    return image_1;
  }
  public function toInt___3BII(buffer: JavaArray, i: int, type: int): int {
    if (type == 4) {
      return isLittleEndian ? (buffer[i] & 0xFF) | ((buffer[i + 1] & 0xFF) << 8) | ((buffer[i + 2] & 0xFF) << 16) | ((buffer[i + 3] & 0xFF) << 24) : (buffer[i + 3] & 0xFF) | ((buffer[i + 2] & 0xFF) << 8) | ((buffer[i + 1] & 0xFF) << 16) | ((buffer[i] & 0xFF) << 24);
    }
    if (type == 3) {
      return isLittleEndian ? (buffer[i] & 0xFF) | ((buffer[i + 1] & 0xFF) << 8) : (buffer[i + 1] & 0xFF) | ((buffer[i] & 0xFF) << 8);
    }
    SWT.error__I(40);
    return -1;
  }
  public function write__I(photometricInterpretation_1: int): void {
    var isRGB: Boolean = photometricInterpretation_1 == 2;
    var isColorMap: Boolean = photometricInterpretation_1 == 3;
    var isBiLevel: Boolean = photometricInterpretation_1 == 0 || photometricInterpretation_1 == 1;
    var imageWidth_1: int = image.width;
    var imageLength_1: int = image.height;
    var rowByteSize: int = image.bytesPerLine;
    var numberEntries: int = isBiLevel ? 9 : 11;
    var lengthDirectory: int = 2 + 12 * numberEntries + 4;
    var nextOffset: int = 8 + lengthDirectory;
    var extraBytes: int = 16;
    var colorMap: JavaArray = null;
    if (isColorMap) {
      var palette: PaletteData = image.palette;
      var rgbs: JavaArray = palette.getRGBs__();
      colorMap = this.formatColorMap___3Lorg_eclipse_swt_graphics_RGB_2(rgbs);
      if (colorMap.length != 3 * 1 << image.depth)
        SWT.error__I(42);
      extraBytes += colorMap.length * 2;
    }
    if (isRGB) {
      extraBytes += 6;
    }
    var data: JavaArray = image.data;
    var strips: JavaArray = new JavaArray("[[I").lengths(2);
    var nbrRowsPerStrip: int = this.formatStrips__II_3BIII_3_3I(rowByteSize, imageLength_1, data, 8192, nextOffset, extraBytes, strips);
    var stripOffsets_1: JavaArray = strips[0];
    var stripByteCounts_1: JavaArray = strips[1];
    var bitsPerSampleOffset: int = -1;
    if (isRGB) {
      bitsPerSampleOffset = nextOffset;
      nextOffset += 6;
    }
    var stripOffsetsOffset: int = -1;
    var stripByteCountsOffset: int = -1;
    var xResolutionOffset: int;
    var yResolutionOffset: int;
    var colorMapOffset_1: int = -1;
    var cnt: int = stripOffsets_1.length;
    if (cnt > 1) {
      stripOffsetsOffset = nextOffset;
      nextOffset += 4 * cnt;
      stripByteCountsOffset = nextOffset;
      nextOffset += 4 * cnt;
    }
    xResolutionOffset = nextOffset;
    nextOffset += 8;
    yResolutionOffset = nextOffset;
    nextOffset += 8;
    if (isColorMap) {
      colorMapOffset_1 = nextOffset;
      nextOffset += colorMap.length * 2;
    }
    this.writeHeader__();
    out.writeShort__I(numberEntries);
    this.writeEntry__SIII(256, 4, 1, imageWidth_1);
    this.writeEntry__SIII(257, 4, 1, imageLength_1);
    if (isColorMap)
      this.writeEntry__SIII(258, 3, 1, image.depth);
    if (isRGB)
      this.writeEntry__SIII(258, 3, 3, bitsPerSampleOffset);
    this.writeEntry__SIII(259, 3, 1, 1);
    this.writeEntry__SIII(262, 3, 1, photometricInterpretation_1);
    this.writeEntry__SIII(273, 4, cnt, cnt > 1 ? stripOffsetsOffset : stripOffsets_1[0]);
    if (isRGB)
      this.writeEntry__SIII(277, 3, 1, 3);
    this.writeEntry__SIII(278, 4, 1, nbrRowsPerStrip);
    this.writeEntry__SIII(279, 4, cnt, cnt > 1 ? stripByteCountsOffset : stripByteCounts_1[0]);
    this.writeEntry__SIII(282, 5, 1, xResolutionOffset);
    this.writeEntry__SIII(283, 5, 1, yResolutionOffset);
    if (isColorMap)
      this.writeEntry__SIII(320, 3, colorMap.length, colorMapOffset_1);
    out.writeInt__I(0);
    if (isRGB)
      for (var i: int = 0; i < 3; i++)
        out.writeShort__I(8);
    if (cnt > 1) {
      for (var i_1: int = 0; i_1 < cnt; i_1++)
        out.writeInt__I(stripOffsets_1[i_1]);
      for (var i_2: int = 0; i_2 < cnt; i_2++)
        out.writeInt__I(stripByteCounts_1[i_2]);
    }
    for (var i_3: int = 0; i_3 < 2; i_3++) {
      out.writeInt__I(300);
      out.writeInt__I(1);
    }
    if (isColorMap)
      for (var i_4: int = 0; i_4 < colorMap.length; i_4++)
        out.writeShort__I(colorMap[i_4]);
    out.write___3B(data);
    return;
  }
  public function writeEntry__SIII(tag: int, type: int, count: int, value: int): void {
    out.writeShort__I(tag);
    out.writeShort__I(type);
    out.writeInt__I(count);
    out.writeInt__I(value);
    return;
  }
  public function writeHeader__(): void {
    out.write__I(0x49);
    out.write__I(0x49);
    out.writeShort__I(42);
    out.writeInt__I(8);
    return;
  }
  public function writeToStream__Lorg_eclipse_swt_internal_image_LEDataOutputStream_2(byteStream: LEDataOutputStream): void {
    out = byteStream;
    var photometricInterpretation_1: int = -1;
    if (image.scanlinePad != 1)
      SWT.error__I(42);
    switch (image.depth) {
      case 1 :
        {
          var palette: PaletteData = image.palette;
          var rgbs: JavaArray = palette.colors;
          if (palette.isDirect || rgbs === null || rgbs.length != 2)
            SWT.error__I(42);
          var rgb0: RGB = rgbs[0];
          var rgb1: RGB = rgbs[1];
          if (!(rgb0.red == rgb0.green && rgb0.green == rgb0.blue && rgb1.red == rgb1.green && rgb1.green == rgb1.blue && ((rgb0.red == 0x0 && rgb1.red == 0xFF) || (rgb0.red == 0xFF && rgb1.red == 0x0)))) {
            SWT.error__I(42);
          }
          photometricInterpretation_1 = image.palette.colors[0].red == 0xFF ? 0 : 1;
          break;
        }
      case 4 :
      case 8 :
        {
          photometricInterpretation_1 = 3;
          break;
        }
      case 24 :
        {
          photometricInterpretation_1 = 2;
          break;
        }
      default :
        {
          SWT.error__I(42);
        }
    }
    this.write__I(photometricInterpretation_1);
    return;
  }
  public function TIFFDirectory(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 3 && vargs[0] is TIFFRandomFileAccess && vargs[1] is Boolean && vargs[2] is ImageLoader) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is ImageData) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0], args[1], args[2]];
        break;
      case 1:
        var args1: Array = [args[0]];
        break;
    }
    super();
    switch (id) {
      case 0:
        TIFFDirectory__Lorg_eclipse_swt_internal_image_TIFFRandomFileAccess_2ZLorg_eclipse_swt_graphics_ImageLoader_2(args0[0], args0[1], args0[2]);
        break;
      case 1:
        TIFFDirectory__Lorg_eclipse_swt_graphics_ImageData_2(args1[0]);
        break;
    }
  }
  public static const TIFFDirectory__Lorg_eclipse_swt_internal_image_TIFFRandomFileAccess_2ZLorg_eclipse_swt_graphics_ImageLoader_2 : int = 0;
  public static const TIFFDirectory__Lorg_eclipse_swt_graphics_ImageData_2 : int = 1;
}
}
