package org.eclipse.swt.internal.image {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import java.io.*;
import java.lang.Exception;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.SWT;
import java.io.IOException;
import org.eclipse.swt.graphics.ImageLoader;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class TIFFFileFormat extends FileFormat {
  public override function isFileFormat__Lorg_eclipse_swt_internal_image_LEDataInputStream_2(stream: LEDataInputStream): Boolean {
    try {
      var header: JavaArray = new JavaArray("[B").lengths(4);
      stream.read___3B(header);
      stream.unread___3B(header);
      if (header[0] != header[1])
        return false;
      if (!(header[0] == 0x49 && header[2] == 42 && header[3] == 0) && !(header[0] == 0x4d && header[2] == 0 && header[3] == 42)) {
        return false;
      }
      return true;
    } catch (e : Exception) {
      return false;
    }
    return false;
  }
  public override function loadFromByteStream__(): JavaArray {
    var header: JavaArray = new JavaArray("[B").lengths(8);
    var isLittleEndian: Boolean;
    var images: JavaArray = new JavaArray("[Lorg/eclipse/swt/graphics/ImageData;").lengths(0);
    var file: TIFFRandomFileAccess = new TIFFRandomFileAccess(inputStream);
    try {
      file.read___3B(header);
      if (header[0] != header[1])
        SWT.error__I(40);
      if (!(header[0] == 0x49 && header[2] == 42 && header[3] == 0) && !(header[0] == 0x4d && header[2] == 0 && header[3] == 42)) {
        SWT.error__I(40);
      }
      isLittleEndian = header[0] == 0x49;
      var offset: int = isLittleEndian ? (header[4] & 0xFF) | ((header[5] & 0xFF) << 8) | ((header[6] & 0xFF) << 16) | ((header[7] & 0xFF) << 24) : (header[7] & 0xFF) | ((header[6] & 0xFF) << 8) | ((header[5] & 0xFF) << 16) | ((header[4] & 0xFF) << 24);
      file.seek__I(offset);
      var directory: TIFFDirectory = new TIFFDirectory(new Arguments(org.eclipse.swt.internal.image.TIFFDirectory.TIFFDirectory__Lorg_eclipse_swt_internal_image_TIFFRandomFileAccess_2ZLorg_eclipse_swt_graphics_ImageLoader_2, [file, isLittleEndian, loader]));
      var image: ImageData = directory.read__();
      images = new JavaArray("[Lorg/eclipse/swt/graphics/ImageData;").values(image);
    } catch (e : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
    }
    return images;
  }
  public override function unloadIntoByteStream__Lorg_eclipse_swt_graphics_ImageLoader_2(loader_1: ImageLoader): void {
    var image: ImageData = loader_1.data[0];
    var directory: TIFFDirectory = new TIFFDirectory(new Arguments(org.eclipse.swt.internal.image.TIFFDirectory.TIFFDirectory__Lorg_eclipse_swt_graphics_ImageData_2, [image]));
    try {
      directory.writeToStream__Lorg_eclipse_swt_internal_image_LEDataOutputStream_2(outputStream);
    } catch (e : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
    }
    return;
  }
}
}
