package org.eclipse.swt.internal.image {
import org.eclipse.swt.*;
import org.eclipse.swt.SWT;
import java.lang.JavaArray;
dynamic public class TIFFModifiedHuffmanCodec {
  public static var BLACK_CODE: JavaArray = new JavaArray("[[[S").values(new JavaArray("[[S").values(new JavaArray("[S").values(2, 3), new JavaArray("[S").values(3, 2)), new JavaArray("[[S").values(new JavaArray("[S").values(2, 1), new JavaArray("[S").values(3, 4)), new JavaArray("[[S").values(new JavaArray("[S").values(2, 6), new JavaArray("[S").values(3, 5)), new JavaArray("[[S").values(new JavaArray("[S").values(3, 7)), new JavaArray("[[S").values(new JavaArray("[S").values(4, 9), new JavaArray("[S").values(5, 8)), new JavaArray("[[S").values(new JavaArray("[S").values(4, 10), new JavaArray("[S").values(5, 11), new JavaArray("[S").values(7, 12)), new JavaArray("[[S").values(new JavaArray("[S").values(4, 13), new JavaArray("[S").values(7, 14)), new JavaArray("[[S").values(new JavaArray("[S").values(24, 15)), new JavaArray("[[S").values(new JavaArray("[S").values(8, 18), new JavaArray("[S").values(15, 64), new JavaArray("[S").values(23, 16), new JavaArray("[S").values(24, 17), new JavaArray("[S").values(55, 0)), new JavaArray("[[S").values(new JavaArray("[S").values(0, -1), new JavaArray("[S").values(8, 1792), new JavaArray("[S").values(23, 24), new JavaArray("[S").values(24, 25), new JavaArray("[S").values(40, 23), new JavaArray("[S").values(55, 22), new JavaArray("[S").values(103, 19), new JavaArray("[S").values(104, 20), new JavaArray("[S").values(108, 21), new JavaArray("[S").values(12, 1856), new JavaArray("[S").values(13, 1920)), new JavaArray("[[S").values(new JavaArray("[S").values(18, 1984), new JavaArray("[S").values(19, 2048), new JavaArray("[S").values(20, 2112), new JavaArray("[S").values(21, 2176), new JavaArray("[S").values(22, 2240), new JavaArray("[S").values(23, 2304), new JavaArray("[S").values(28, 2368), new JavaArray("[S").values(29, 2432), new JavaArray("[S").values(30, 2496), new JavaArray("[S").values(31, 2560), new JavaArray("[S").values(36, 52), new JavaArray("[S").values(39, 55), new JavaArray("[S").values(40, 56), new JavaArray("[S").values(43, 59), new JavaArray("[S").values(44, 60), new JavaArray("[S").values(51, 320), new JavaArray("[S").values(52, 384), new JavaArray("[S").values(53, 448), new JavaArray("[S").values(55, 53), new JavaArray("[S").values(56, 54), new JavaArray("[S").values(82, 50), new JavaArray("[S").values(83, 51), new JavaArray("[S").values(84, 44), new JavaArray("[S").values(85, 45), new JavaArray("[S").values(86, 46), new JavaArray("[S").values(87, 47), new JavaArray("[S").values(88, 57), new JavaArray("[S").values(89, 58), new JavaArray("[S").values(90, 61), new JavaArray("[S").values(91, 256), new JavaArray("[S").values(100, 48), new JavaArray("[S").values(101, 49), new JavaArray("[S").values(102, 62), new JavaArray("[S").values(103, 63), new JavaArray("[S").values(104, 30), new JavaArray("[S").values(105, 31), new JavaArray("[S").values(106, 32), new JavaArray("[S").values(107, 33), new JavaArray("[S").values(108, 40), new JavaArray("[S").values(109, 41), new JavaArray("[S").values(200, 128), new JavaArray("[S").values(201, 192), new JavaArray("[S").values(202, 26), new JavaArray("[S").values(203, 27), new JavaArray("[S").values(204, 28), new JavaArray("[S").values(205, 29), new JavaArray("[S").values(210, 34), new JavaArray("[S").values(211, 35), new JavaArray("[S").values(212, 36), new JavaArray("[S").values(213, 37), new JavaArray("[S").values(214, 38), new JavaArray("[S").values(215, 39), new JavaArray("[S").values(218, 42), new JavaArray("[S").values(219, 43)), new JavaArray("[[S").values(new JavaArray("[S").values(74, 640), new JavaArray("[S").values(75, 704), new JavaArray("[S").values(76, 768), new JavaArray("[S").values(77, 832), new JavaArray("[S").values(82, 1280), new JavaArray("[S").values(83, 1344), new JavaArray("[S").values(84, 1408), new JavaArray("[S").values(85, 1472), new JavaArray("[S").values(90, 1536), new JavaArray("[S").values(91, 1600), new JavaArray("[S").values(100, 1664), new JavaArray("[S").values(101, 1728), new JavaArray("[S").values(108, 512), new JavaArray("[S").values(109, 576), new JavaArray("[S").values(114, 896), new JavaArray("[S").values(115, 960), new JavaArray("[S").values(116, 1024), new JavaArray("[S").values(117, 1088), new JavaArray("[S").values(118, 1152), new JavaArray("[S").values(119, 1216)));
  public static var WHITE_CODE: JavaArray = new JavaArray("[[[S").values(new JavaArray("[[S").values(new JavaArray("[S").values(7, 2), new JavaArray("[S").values(8, 3), new JavaArray("[S").values(11, 4), new JavaArray("[S").values(12, 5), new JavaArray("[S").values(14, 6), new JavaArray("[S").values(15, 7)), new JavaArray("[[S").values(new JavaArray("[S").values(7, 10), new JavaArray("[S").values(8, 11), new JavaArray("[S").values(18, 128), new JavaArray("[S").values(19, 8), new JavaArray("[S").values(20, 9), new JavaArray("[S").values(27, 64)), new JavaArray("[[S").values(new JavaArray("[S").values(3, 13), new JavaArray("[S").values(7, 1), new JavaArray("[S").values(8, 12), new JavaArray("[S").values(23, 192), new JavaArray("[S").values(24, 1664), new JavaArray("[S").values(42, 16), new JavaArray("[S").values(43, 17), new JavaArray("[S").values(52, 14), new JavaArray("[S").values(53, 15)), new JavaArray("[[S").values(new JavaArray("[S").values(3, 22), new JavaArray("[S").values(4, 23), new JavaArray("[S").values(8, 20), new JavaArray("[S").values(12, 19), new JavaArray("[S").values(19, 26), new JavaArray("[S").values(23, 21), new JavaArray("[S").values(24, 28), new JavaArray("[S").values(36, 27), new JavaArray("[S").values(39, 18), new JavaArray("[S").values(40, 24), new JavaArray("[S").values(43, 25), new JavaArray("[S").values(55, 256)), new JavaArray("[[S").values(new JavaArray("[S").values(2, 29), new JavaArray("[S").values(3, 30), new JavaArray("[S").values(4, 45), new JavaArray("[S").values(5, 46), new JavaArray("[S").values(10, 47), new JavaArray("[S").values(11, 48), new JavaArray("[S").values(18, 33), new JavaArray("[S").values(19, 34), new JavaArray("[S").values(20, 35), new JavaArray("[S").values(21, 36), new JavaArray("[S").values(22, 37), new JavaArray("[S").values(23, 38), new JavaArray("[S").values(26, 31), new JavaArray("[S").values(27, 32), new JavaArray("[S").values(36, 53), new JavaArray("[S").values(37, 54), new JavaArray("[S").values(40, 39), new JavaArray("[S").values(41, 40), new JavaArray("[S").values(42, 41), new JavaArray("[S").values(43, 42), new JavaArray("[S").values(44, 43), new JavaArray("[S").values(45, 44), new JavaArray("[S").values(50, 61), new JavaArray("[S").values(51, 62), new JavaArray("[S").values(52, 63), new JavaArray("[S").values(53, 0), new JavaArray("[S").values(54, 320), new JavaArray("[S").values(55, 384), new JavaArray("[S").values(74, 59), new JavaArray("[S").values(75, 60), new JavaArray("[S").values(82, 49), new JavaArray("[S").values(83, 50), new JavaArray("[S").values(84, 51), new JavaArray("[S").values(85, 52), new JavaArray("[S").values(88, 55), new JavaArray("[S").values(89, 56), new JavaArray("[S").values(90, 57), new JavaArray("[S").values(91, 58), new JavaArray("[S").values(100, 448), new JavaArray("[S").values(101, 512), new JavaArray("[S").values(103, 640), new JavaArray("[S").values(104, 576)), new JavaArray("[[S").values(new JavaArray("[S").values(152, 1472), new JavaArray("[S").values(153, 1536), new JavaArray("[S").values(154, 1600), new JavaArray("[S").values(155, 1728), new JavaArray("[S").values(204, 704), new JavaArray("[S").values(205, 768), new JavaArray("[S").values(210, 832), new JavaArray("[S").values(211, 896), new JavaArray("[S").values(212, 960), new JavaArray("[S").values(213, 1024), new JavaArray("[S").values(214, 1088), new JavaArray("[S").values(215, 1152), new JavaArray("[S").values(216, 1216), new JavaArray("[S").values(217, 1280), new JavaArray("[S").values(218, 1344), new JavaArray("[S").values(219, 1408)), new JavaArray("[[S"), new JavaArray("[[S").values(new JavaArray("[S").values(8, 1792), new JavaArray("[S").values(12, 1856), new JavaArray("[S").values(13, 1920)), new JavaArray("[[S").values(new JavaArray("[S").values(1, -1), new JavaArray("[S").values(18, 1984), new JavaArray("[S").values(19, 2048), new JavaArray("[S").values(20, 2112), new JavaArray("[S").values(21, 2176), new JavaArray("[S").values(22, 2240), new JavaArray("[S").values(23, 2304), new JavaArray("[S").values(28, 2368), new JavaArray("[S").values(29, 2432), new JavaArray("[S").values(30, 2496), new JavaArray("[S").values(31, 2560)));
  public static const BLACK_MIN_BITS: int = 2;
  public static const WHITE_MIN_BITS: int = 4;
  internal var isWhite: Boolean;
  internal var whiteValue: int = 0;
  internal var blackValue: int = 1;
  internal var src: JavaArray;
  internal var dest: JavaArray;
  internal var byteOffsetSrc: int = 0;
  internal var bitOffsetSrc: int = 0;
  internal var byteOffsetDest: int = 0;
  internal var bitOffsetDest: int = 0;
  internal var code: int = 0;
  internal var nbrBits: int = 0;
  internal var rowSize: int;
  public function decode___3B_3BIII(src_1: JavaArray, dest_1: JavaArray, offsetDest: int, rowSize_1: int, nRows: int): int {
    this.src = src_1;
    this.dest = dest_1;
    this.rowSize = rowSize_1;
    byteOffsetSrc = 0;
    bitOffsetSrc = 0;
    byteOffsetDest = offsetDest;
    bitOffsetDest = 0;
    var cnt: int = 0;
    while (cnt < nRows && this.decodeRow__()) {
      cnt++;
      if (bitOffsetDest > 0) {
        byteOffsetDest++;
        bitOffsetDest = 0;
      }
    }
    return byteOffsetDest - offsetDest;
  }
  public function decodeRow__(): Boolean {
    isWhite = true;
    var n: int = 0;
    while (n < rowSize) {
      var runLength: int = this.decodeRunLength__();
      if (runLength < 0)
        return false;
      n += runLength;
      this.setNextBits__II(isWhite ? whiteValue : blackValue, runLength);
      isWhite = !isWhite;
    }
    return true;
  }
  public function decodeRunLength__(): int {
    var runLength: int = 0;
    var partialRun: int = 0;
    var huffmanCode: JavaArray = isWhite ? WHITE_CODE : BLACK_CODE;
    while (true) {
      var found: Boolean = false;
      nbrBits = isWhite ? 4 : 2;
      code = this.getNextBits__I(nbrBits);
      for (var i: int = 0; i < huffmanCode.length; i++) {
        for (var j: int = 0; j < huffmanCode[i].length; j++) {
          if (huffmanCode[i][j][0] == code) {
            found = true;
            partialRun = huffmanCode[i][j][1];
            if (partialRun == -1) {
              if (byteOffsetSrc == src.length - 1)
                return -1;
            } else {
              runLength += partialRun;
              if (partialRun < 64)
                return runLength;
            }
            break;
          }
        }
        if (found)
          break;
        code = code << 1 | this.getNextBit__();
      }
      if (!found)
        SWT.error__I(40);
    }
    return 0;
  }
  public function getNextBit__(): int {
    var value: int = (src[byteOffsetSrc] >>> (7 - bitOffsetSrc)) & 0x1;
    bitOffsetSrc++;
    if (bitOffsetSrc > 7) {
      byteOffsetSrc++;
      bitOffsetSrc = 0;
    }
    return value;
  }
  public function getNextBits__I(cnt: int): int {
    var value: int = 0;
    for (var i: int = 0; i < cnt; i++) {
      value = value << 1 | this.getNextBit__();
    }
    return value;
  }
  public function setNextBits__II(value: int, cnt: int): void {
    var n: int = cnt;
    while (bitOffsetDest > 0 && bitOffsetDest <= 7 && n > 0) {
      dest[byteOffsetDest] = value == 1 ? int((dest[byteOffsetDest] | (1 << (7 - bitOffsetDest)))) : int((dest[byteOffsetDest] & ~(1 << (7 - bitOffsetDest))));
      n--;
      bitOffsetDest++;
    }
    if (bitOffsetDest == 8) {
      byteOffsetDest++;
      bitOffsetDest = 0;
    }
    while (n >= 8) {
      dest[byteOffsetDest++] = int((value == 1 ? 0xFF : 0));
      n -= 8;
    }
    while (n > 0) {
      dest[byteOffsetDest] = value == 1 ? int((dest[byteOffsetDest] | (1 << (7 - bitOffsetDest)))) : int((dest[byteOffsetDest] & ~(1 << (7 - bitOffsetDest))));
      n--;
      bitOffsetDest++;
    }
    return;
  }
}
}
