package org.eclipse.swt.internal.image {
import java.io.*;
import java.io.IOException;
import java.lang.Math__;
import java.lang.System;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class TIFFRandomFileAccess {
  internal var inputStream: LEDataInputStream;
  internal var start: int;
  internal var current: int;
  internal var next: int;
  internal var buffers: JavaArray;
  public static const CHUNK_SIZE: int = 8192;
  public static const LIST_SIZE: int = 128;
  public function TIFFRandomFileAccess(stream: LEDataInputStream) {
    inputStream = stream;
    start = current = next = inputStream.getPosition__();
    buffers = new JavaArray("[[B").lengths(128);
    return;
  }
  public function seek__I(pos: int): void {
    if (pos == current)
      return;
    if (pos < start)
      throw new IOException(new Arguments(java.io.IOException.IOException__, []));
    current = pos;
    if (current > next) {
      var n: int = current - next;
      var index: int = int(next / 8192);
      var offset: int = next % 8192;
      while (n > 0) {
        if (index >= buffers.length) {
          var oldBuffers: JavaArray = buffers;
          buffers = new JavaArray("[[B").lengths(Math__.max__II(index + 1, oldBuffers.length + 128));
          System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(oldBuffers, 0, buffers, 0, oldBuffers.length);
        }
        if (buffers[index] === null)
          buffers[index] = new JavaArray("[B").lengths(8192);
        var cnt: int = inputStream.read___3BII(buffers[index], offset, Math__.min__II(n, 8192 - offset));
        n -= cnt;
        next += cnt;
        index++;
        offset = 0;
      }
    }
    return;
  }
  public function read___3B(b: JavaArray): void {
    var size: int = b.length;
    var nCached: int = Math__.min__II(size, next - current);
    var nMissing: int = size - next + current;
    var destNext: int = 0;
    if (nCached > 0) {
      var index: int = int(current / 8192);
      var offset: int = current % 8192;
      while (nCached > 0) {
        var cnt: int = Math__.min__II(nCached, 8192 - offset);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(buffers[index], offset, b, destNext, cnt);
        nCached -= cnt;
        destNext += cnt;
        index++;
        offset = 0;
      }
    }
    if (nMissing > 0) {
      var index_1: int = int(next / 8192);
      var offset_1: int = next % 8192;
      while (nMissing > 0) {
        if (index_1 >= buffers.length) {
          var oldBuffers: JavaArray = buffers;
          buffers = new JavaArray("[[B").lengths(Math__.max__II(index_1, oldBuffers.length + 128));
          System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(oldBuffers, 0, buffers, 0, oldBuffers.length);
        }
        if (buffers[index_1] === null)
          buffers[index_1] = new JavaArray("[B").lengths(8192);
        var cnt_1: int = inputStream.read___3BII(buffers[index_1], offset_1, Math__.min__II(nMissing, 8192 - offset_1));
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(buffers[index_1], offset_1, b, destNext, cnt_1);
        nMissing -= cnt_1;
        next += cnt_1;
        destNext += cnt_1;
        index_1++;
        offset_1 = 0;
      }
    }
    current += size;
    return;
  }
}
}
