package org.eclipse.swt.internal.image {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import java.io.*;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.SWT;
import java.lang.Exception;
import java.io.IOException;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import java.io.OutputStream;
import java.lang.System;
import org.eclipse.swt.graphics.ImageLoader;
import java.io.ByteArrayOutputStream;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class WinBMPFileFormat extends FileFormat {
  public static const BMPFileHeaderSize: int = 14;
  public static const BMPHeaderFixedSize: int = 40;
  internal var importantColors: int;
  internal var pelsPerMeter: Point = new Point(0, 0);
  public function compress__I_3BII_3BZ(comp: int, src: JavaArray, srcOffset: int, numBytes: int, dest: JavaArray, last: Boolean): int {
    if (comp == 1) {
      return this.compressRLE8Data___3BII_3BZ(src, srcOffset, numBytes, dest, last);
    }
    if (comp == 2) {
      return this.compressRLE4Data___3BII_3BZ(src, srcOffset, numBytes, dest, last);
    }
    SWT.error__I(40);
    return 0;
  }
  public function compressRLE4Data___3BII_3BZ(src: JavaArray, srcOffset: int, numBytes: int, dest: JavaArray, last: Boolean): int {
    var sp: int = srcOffset;
    var end: int = srcOffset + numBytes;
    var dp: int = 0;
    var size: int = 0;
    var left: int;
    var i: int;
    var n: int;
    var theByte: int;
    while (sp < end) {
      left = end - sp - 1;
      if (left > 127)
        left = 127;
      for (n = 0; n < left; n++) {
        if (src[sp + n] == src[sp + n + 1])
          break;
      }
      if (n < 127 && n == left)
        n++;
      switch (n) {
        case 0 :
          break;
        case 1 :
          dest[dp] = 2;
          dp++;
          dest[dp] = src[sp];
          dp++;
          sp++;
          size += 2;
          break;
        default :
          dest[dp] = 0;
          dp++;
          dest[dp] = int((n + n));
          dp++;
          for (i = n; i > 0; i--) {
            dest[dp] = src[sp];
            dp++;
            sp++;
          }
          size += 2 + n;
          if ((n & 1) != 0) {
            dest[dp] = 0;
            dp++;
            size++;
          }
          break;
      }
      left = end - sp;
      if (left > 0) {
        if (left > 127)
          left = 127;
        theByte = src[sp];
        for (n = 1; n < left; n++) {
          if (src[sp + n] != theByte)
            break;
        }
        dest[dp] = int((n + n));
        dp++;
        dest[dp] = theByte;
        dp++;
        sp += n;
        size += 2;
      }
    }
    dest[dp] = 0;
    dp++;
    if (last) {
      dest[dp] = 1;
      dp++;
    } else {
      dest[dp] = 0;
      dp++;
    }
    size += 2;
    return size;
  }
  public function compressRLE8Data___3BII_3BZ(src: JavaArray, srcOffset: int, numBytes: int, dest: JavaArray, last: Boolean): int {
    var sp: int = srcOffset;
    var end: int = srcOffset + numBytes;
    var dp: int = 0;
    var size: int = 0;
    var left: int;
    var i: int;
    var n: int;
    var theByte: int;
    while (sp < end) {
      left = end - sp - 1;
      if (left > 254)
        left = 254;
      for (n = 0; n < left; n++) {
        if (src[sp + n] == src[sp + n + 1])
          break;
      }
      if (n == left)
        n++;
      switch (n) {
        case 0 :
          break;
        case 2 :
          dest[dp] = 1;
          dp++;
          dest[dp] = src[sp];
          dp++;
          sp++;
          size += 2;
        case 1 :
          dest[dp] = 1;
          dp++;
          dest[dp] = src[sp];
          dp++;
          sp++;
          size += 2;
          break;
        default :
          dest[dp] = 0;
          dp++;
          dest[dp] = int(n);
          dp++;
          for (i = n; i > 0; i--) {
            dest[dp] = src[sp];
            dp++;
            sp++;
          }
          size += 2 + n;
          if ((n & 1) != 0) {
            dest[dp] = 0;
            dp++;
            size++;
          }
          break;
      }
      left = end - sp;
      if (left > 0) {
        if (left > 255)
          left = 255;
        theByte = src[sp];
        for (n = 1; n < left; n++) {
          if (src[sp + n] != theByte)
            break;
        }
        dest[dp] = int(n);
        dp++;
        dest[dp] = theByte;
        dp++;
        sp += n;
        size += 2;
      }
    }
    dest[dp] = 0;
    dp++;
    if (last) {
      dest[dp] = 1;
      dp++;
    } else {
      dest[dp] = 0;
      dp++;
    }
    size += 2;
    return size;
  }
  public function decompressData___3B_3BII(src: JavaArray, dest: JavaArray, stride: int, cmp: int): void {
    if (cmp == 1) {
      if (this.decompressRLE8Data___3BII_3BI(src, src.length, stride, dest, dest.length) <= 0)
        SWT.error__I(40);
      return;
    }
    if (cmp == 2) {
      if (this.decompressRLE4Data___3BII_3BI(src, src.length, stride, dest, dest.length) <= 0)
        SWT.error__I(40);
      return;
    }
    SWT.error__I(40);
    return;
  }
  public function decompressRLE4Data___3BII_3BI(src: JavaArray, numBytes: int, stride: int, dest: JavaArray, destSize: int): int {
    var sp: int = 0;
    var se: int = numBytes;
    var dp: int = 0;
    var de: int = destSize;
    var x: int = 0;
    var y: int = 0;
    while (sp < se) {
      var len: int = src[sp] & 0xFF;
      sp++;
      if (len == 0) {
        len = src[sp] & 0xFF;
        sp++;
        switch (len) {
          case 0 :
            y++;
            x = 0;
            dp = y * stride;
            if (dp > de)
              return -1;
            break;
          case 1 :
            return 1;
          case 2 :
            x += src[sp] & 0xFF;
            sp++;
            y += src[sp] & 0xFF;
            sp++;
            dp = y * stride + int(x / 2);
            if (dp > de)
              return -1;
            break;
          default :
            if ((len & 1) != 0)
              return -1;
            x += len;
            len = int(len / 2);
            if (len > (se - sp))
              return -1;
            if (len > (de - dp))
              return -1;
            for (var i: int = 0; i < len; i++) {
              dest[dp] = src[sp];
              dp++;
              sp++;
            }
            if ((sp & 1) != 0)
              sp++;
            break;
        }
      } else {
        if ((len & 1) != 0)
          return -1;
        x += len;
        len = int(len / 2);
        var theByte: int = src[sp];
        sp++;
        if (len > (de - dp))
          return -1;
        for (var i_1: int = 0; i_1 < len; i_1++) {
          dest[dp] = theByte;
          dp++;
        }
      }
    }
    return 1;
  }
  public function decompressRLE8Data___3BII_3BI(src: JavaArray, numBytes: int, stride: int, dest: JavaArray, destSize: int): int {
    var sp: int = 0;
    var se: int = numBytes;
    var dp: int = 0;
    var de: int = destSize;
    var x: int = 0;
    var y: int = 0;
    while (sp < se) {
      var len: int = src[sp] & 0xFF;
      sp++;
      if (len == 0) {
        len = src[sp] & 0xFF;
        sp++;
        switch (len) {
          case 0 :
            y++;
            x = 0;
            dp = y * stride;
            if (dp > de)
              return -1;
            break;
          case 1 :
            return 1;
          case 2 :
            x += src[sp] & 0xFF;
            sp++;
            y += src[sp] & 0xFF;
            sp++;
            dp = y * stride + x;
            if (dp > de)
              return -1;
            break;
          default :
            if (len > (se - sp))
              return -1;
            if (len > (de - dp))
              return -1;
            for (var i: int = 0; i < len; i++) {
              dest[dp] = src[sp];
              dp++;
              sp++;
            }
            if ((sp & 1) != 0)
              sp++;
            x += len;
            break;
        }
      } else {
        var theByte: int = src[sp];
        sp++;
        if (len > (de - dp))
          return -1;
        for (var i_1: int = 0; i_1 < len; i_1++) {
          dest[dp] = theByte;
          dp++;
        }
        x += len;
      }
    }
    return 1;
  }
  public override function isFileFormat__Lorg_eclipse_swt_internal_image_LEDataInputStream_2(stream: LEDataInputStream): Boolean {
    try {
      var header: JavaArray = new JavaArray("[B").lengths(18);
      stream.read___3B(header);
      stream.unread___3B(header);
      var infoHeaderSize: int = (header[14] & 0xFF) | ((header[15] & 0xFF) << 8) | ((header[16] & 0xFF) << 16) | ((header[17] & 0xFF) << 24);
      return header[0] == 0x42 && header[1] == 0x4D && infoHeaderSize >= 40;
    } catch (e : Exception) {
      return false;
    }
    return false;
  }
  public function loadData___3B(infoHeader: JavaArray): JavaArray {
    var width: int = (infoHeader[4] & 0xFF) | ((infoHeader[5] & 0xFF) << 8) | ((infoHeader[6] & 0xFF) << 16) | ((infoHeader[7] & 0xFF) << 24);
    var height: int = (infoHeader[8] & 0xFF) | ((infoHeader[9] & 0xFF) << 8) | ((infoHeader[10] & 0xFF) << 16) | ((infoHeader[11] & 0xFF) << 24);
    var bitCount: int = (infoHeader[14] & 0xFF) | ((infoHeader[15] & 0xFF) << 8);
    var stride: int = int((width * bitCount + 7) / 8);
    stride = int((stride + 3) / 4) * 4;
    var data: JavaArray = this.loadData___3BI(infoHeader, stride);
    this.flipScanLines___3BII(data, stride, height);
    return data;
  }
  public function loadData___3BI(infoHeader: JavaArray, stride: int): JavaArray {
    var height: int = (infoHeader[8] & 0xFF) | ((infoHeader[9] & 0xFF) << 8) | ((infoHeader[10] & 0xFF) << 16) | ((infoHeader[11] & 0xFF) << 24);
    if (height < 0)
      height = -height;
    var dataSize: int = height * stride;
    var data: JavaArray = new JavaArray("[B").lengths(dataSize);
    var cmp: int = (infoHeader[16] & 0xFF) | ((infoHeader[17] & 0xFF) << 8) | ((infoHeader[18] & 0xFF) << 16) | ((infoHeader[19] & 0xFF) << 24);
    if (cmp == 0 || cmp == 3) {
      try {
        if (inputStream.read___3B(data) != dataSize)
          SWT.error__I(40);
      } catch (e : IOException) {
        SWT.error__ILjava_lang_Throwable_2(39, e);
      }
    } else {
      var compressedSize: int = (infoHeader[20] & 0xFF) | ((infoHeader[21] & 0xFF) << 8) | ((infoHeader[22] & 0xFF) << 16) | ((infoHeader[23] & 0xFF) << 24);
      var compressed: JavaArray = new JavaArray("[B").lengths(compressedSize);
      try {
        if (inputStream.read___3B(compressed) != compressedSize)
          SWT.error__I(40);
      } catch (e_1 : IOException) {
        SWT.error__ILjava_lang_Throwable_2(39, e_1);
      }
      this.decompressData___3B_3BII(compressed, data, stride, cmp);
    }
    return data;
  }
  public function loadFileHeader__(): JavaArray {
    var header: JavaArray = new JavaArray("[I").lengths(5);
    try {
      header[0] = inputStream.readShort__();
      header[1] = inputStream.readInt__();
      header[2] = inputStream.readShort__();
      header[3] = inputStream.readShort__();
      header[4] = inputStream.readInt__();
    } catch (e : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
    }
    if (header[0] != 0x4D42)
      SWT.error__I(40);
    return header;
  }
  public override function loadFromByteStream__(): JavaArray {
    var fileHeader: JavaArray = this.loadFileHeader__();
    var infoHeader: JavaArray = new JavaArray("[B").lengths(40);
    try {
      inputStream.read___3B(infoHeader);
    } catch (e : Exception) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
    }
    var width: int = (infoHeader[4] & 0xFF) | ((infoHeader[5] & 0xFF) << 8) | ((infoHeader[6] & 0xFF) << 16) | ((infoHeader[7] & 0xFF) << 24);
    var height: int = (infoHeader[8] & 0xFF) | ((infoHeader[9] & 0xFF) << 8) | ((infoHeader[10] & 0xFF) << 16) | ((infoHeader[11] & 0xFF) << 24);
    if (height < 0)
      height = -height;
    var bitCount: int = (infoHeader[14] & 0xFF) | ((infoHeader[15] & 0xFF) << 8);
    this.compression = (infoHeader[16] & 0xFF) | ((infoHeader[17] & 0xFF) << 8) | ((infoHeader[18] & 0xFF) << 16) | ((infoHeader[19] & 0xFF) << 24);
    var palette: PaletteData = this.loadPalette___3B(infoHeader);
    if (inputStream.getPosition__() < fileHeader[4]) {
      try {
        inputStream.skip__J(fileHeader[4] - inputStream.getPosition__());
      } catch (e_1 : IOException) {
        SWT.error__ILjava_lang_Throwable_2(39, e_1);
      }
    }
    var data: JavaArray = this.loadData___3B(infoHeader);
    this.importantColors = (infoHeader[36] & 0xFF) | ((infoHeader[37] & 0xFF) << 8) | ((infoHeader[38] & 0xFF) << 16) | ((infoHeader[39] & 0xFF) << 24);
    var xPelsPerMeter: int = (infoHeader[24] & 0xFF) | ((infoHeader[25] & 0xFF) << 8) | ((infoHeader[26] & 0xFF) << 16) | ((infoHeader[27] & 0xFF) << 24);
    var yPelsPerMeter: int = (infoHeader[28] & 0xFF) | ((infoHeader[29] & 0xFF) << 8) | ((infoHeader[30] & 0xFF) << 16) | ((infoHeader[31] & 0xFF) << 24);
    this.pelsPerMeter = new Point(xPelsPerMeter, yPelsPerMeter);
    var type: int = (this.compression == 1) || (this.compression == 2) ? 1 : 0;
    return new JavaArray("[Lorg/eclipse/swt/graphics/ImageData;").values(ImageData.internal_new__IIILorg_eclipse_swt_graphics_PaletteData_2I_3BI_3B_3BIIIIIII(width, height, bitCount, palette, 4, data, 0, null, null, -1, -1, type, 0, 0, 0, 0));
  }
  public function loadPalette___3B(infoHeader: JavaArray): PaletteData {
    var depth: int = (infoHeader[14] & 0xFF) | ((infoHeader[15] & 0xFF) << 8);
    if (depth <= 8) {
      var numColors: int = (infoHeader[32] & 0xFF) | ((infoHeader[33] & 0xFF) << 8) | ((infoHeader[34] & 0xFF) << 16) | ((infoHeader[35] & 0xFF) << 24);
      if (numColors == 0) {
        numColors = 1 << depth;
      } else {
        if (numColors > 256)
          numColors = 256;
      }
      var buf: JavaArray = new JavaArray("[B").lengths(numColors * 4);
      try {
        if (inputStream.read___3B(buf) != buf.length)
          SWT.error__I(40);
      } catch (e : IOException) {
        SWT.error__ILjava_lang_Throwable_2(39, e);
      }
      return this.paletteFromBytes___3BI(buf, numColors);
    }
    if (depth == 16) {
      if (this.compression == 3) {
        try {
          return new PaletteData(new Arguments(org.eclipse.swt.graphics.PaletteData.PaletteData__III, [inputStream.readInt__(), inputStream.readInt__(), inputStream.readInt__()]));
        } catch (e_1 : IOException) {
          SWT.error__ILjava_lang_Throwable_2(39, e_1);
        }
      }
      return new PaletteData(new Arguments(org.eclipse.swt.graphics.PaletteData.PaletteData__III, [0x7C00, 0x3E0, 0x1F]));
    }
    if (depth == 24)
      return new PaletteData(new Arguments(org.eclipse.swt.graphics.PaletteData.PaletteData__III, [0xFF, 0xFF00, 0xFF0000]));
    if (this.compression == 3) {
      try {
        return new PaletteData(new Arguments(org.eclipse.swt.graphics.PaletteData.PaletteData__III, [inputStream.readInt__(), inputStream.readInt__(), inputStream.readInt__()]));
      } catch (e_2 : IOException) {
        SWT.error__ILjava_lang_Throwable_2(39, e_2);
      }
    }
    return new PaletteData(new Arguments(org.eclipse.swt.graphics.PaletteData.PaletteData__III, [0xFF00, 0xFF0000, 0xFF000000]));
  }
  public function paletteFromBytes___3BI(bytes: JavaArray, numColors: int): PaletteData {
    var bytesOffset: int = 0;
    var colors: JavaArray = new JavaArray("[Lorg/eclipse/swt/graphics/RGB;").lengths(numColors);
    for (var i: int = 0; i < numColors; i++) {
      colors[i] = new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [bytes[bytesOffset + 2] & 0xFF, bytes[bytesOffset + 1] & 0xFF, bytes[bytesOffset] & 0xFF]));
      bytesOffset += 4;
    }
    return new PaletteData(new Arguments(org.eclipse.swt.graphics.PaletteData.PaletteData___3Lorg_eclipse_swt_graphics_RGB_2, [colors]));
  }
  public static function paletteToBytes__Lorg_eclipse_swt_graphics_PaletteData_2(pal: PaletteData): JavaArray {
    var n: int = pal.colors === null ? 0 : (pal.colors.length < 256 ? pal.colors.length : 256);
    var bytes: JavaArray = new JavaArray("[B").lengths(n * 4);
    var offset: int = 0;
    for (var i: int = 0; i < n; i++) {
      var col: RGB = pal.colors[i];
      bytes[offset] = int(col.blue);
      bytes[offset + 1] = int(col.green);
      bytes[offset + 2] = int(col.red);
      offset += 4;
    }
    return bytes;
  }
  public function unloadData__Lorg_eclipse_swt_graphics_ImageData_2Ljava_io_OutputStream_2I(image: ImageData, out: OutputStream, comp: int): int {
    var totalSize: int = 0;
    try {
      if (comp == 0)
        return this.unloadDataNoCompression__Lorg_eclipse_swt_graphics_ImageData_2Ljava_io_OutputStream_2(image, out);
      var bpl: int = int((image.width * image.depth + 7) / 8);
      var bmpBpl: int = int((bpl + 3) / 4) * 4;
      var imageBpl: int = image.bytesPerLine;
      var buf: JavaArray = new JavaArray("[B").lengths(bmpBpl * 2);
      var srcOffset: int = imageBpl * (image.height - 1);
      var data: JavaArray = image.data;
      totalSize = 0;
      var buf2: JavaArray = new JavaArray("[B").lengths(32768);
      var buf2Offset: int = 0;
      for (var y: int = image.height - 1; y >= 0; y--) {
        var lineSize: int = this.compress__I_3BII_3BZ(comp, data, srcOffset, bpl, buf, y == 0);
        if (buf2Offset + lineSize > buf2.length) {
          out.write___3BII(buf2, 0, buf2Offset);
          buf2Offset = 0;
        }
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(buf, 0, buf2, buf2Offset, lineSize);
        buf2Offset += lineSize;
        totalSize += lineSize;
        srcOffset -= imageBpl;
      }
      if (buf2Offset > 0)
        out.write___3BII(buf2, 0, buf2Offset);
    } catch (e : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
    }
    return totalSize;
  }
  public function unloadDataNoCompression__Lorg_eclipse_swt_graphics_ImageData_2Ljava_io_OutputStream_2(image: ImageData, out: OutputStream): int {
    var bmpBpl: int = 0;
    try {
      var bpl: int = int((image.width * image.depth + 7) / 8);
      bmpBpl = int((bpl + 3) / 4) * 4;
      var linesPerBuf: int = int(32678 / bmpBpl);
      var buf: JavaArray = new JavaArray("[B").lengths(linesPerBuf * bmpBpl);
      var data: JavaArray = image.data;
      var imageBpl: int = image.bytesPerLine;
      var dataIndex: int = imageBpl * (image.height - 1);
      if (image.depth == 16) {
        for (var y: int = 0; y < image.height; y += linesPerBuf) {
          var count: int = image.height - y;
          if (linesPerBuf < count)
            count = linesPerBuf;
          var bufOffset: int = 0;
          for (var i: int = 0; i < count; i++) {
            for (var wIndex: int = 0; wIndex < bpl; wIndex += 2) {
              buf[bufOffset + wIndex + 1] = data[dataIndex + wIndex + 1];
              buf[bufOffset + wIndex] = data[dataIndex + wIndex];
            }
            bufOffset += bmpBpl;
            dataIndex -= imageBpl;
          }
          out.write___3BII(buf, 0, bufOffset);
        }
      } else {
        for (var y_1: int = 0; y_1 < image.height; y_1 += linesPerBuf) {
          var tmp: int = image.height - y_1;
          var count_1: int = tmp < linesPerBuf ? tmp : linesPerBuf;
          var bufOffset_1: int = 0;
          for (var i_1: int = 0; i_1 < count_1; i_1++) {
            System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(data, dataIndex, buf, bufOffset_1, bpl);
            bufOffset_1 += bmpBpl;
            dataIndex -= imageBpl;
          }
          out.write___3BII(buf, 0, bufOffset_1);
        }
      }
    } catch (e : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
    }
    return bmpBpl * image.height;
  }
  public override function unloadIntoByteStream__Lorg_eclipse_swt_graphics_ImageLoader_2(loader_1: ImageLoader): void {
    var image: ImageData = loader_1.data[0];
    var rgbs: JavaArray;
    var numCols: int;
    if (!((image.depth == 1) || (image.depth == 4) || (image.depth == 8) || (image.depth == 16) || (image.depth == 24) || (image.depth == 32)))
      SWT.error__I(38);
    var comp: int = this.compression;
    if (!((comp == 0) || ((comp == 1) && (image.depth == 8)) || ((comp == 2) && (image.depth == 4))))
      SWT.error__I(40);
    var pal: PaletteData = image.palette;
    if ((image.depth == 16) || (image.depth == 24) || (image.depth == 32)) {
      if (!pal.isDirect)
        SWT.error__I(40);
      numCols = 0;
      rgbs = null;
    } else {
      if (pal.isDirect)
        SWT.error__I(40);
      numCols = pal.colors.length;
      rgbs = WinBMPFileFormat.paletteToBytes__Lorg_eclipse_swt_graphics_PaletteData_2(pal);
    }
    var headersSize: int = 14 + 40;
    var fileHeader: JavaArray = new JavaArray("[I").lengths(5);
    fileHeader[0] = 0x4D42;
    fileHeader[1] = 0;
    fileHeader[2] = 0;
    fileHeader[3] = 0;
    fileHeader[4] = headersSize;
    if (rgbs !== null) {
      fileHeader[4] += rgbs.length;
    }
    var out: ByteArrayOutputStream = new ByteArrayOutputStream(new Arguments(java.io.ByteArrayOutputStream.ByteArrayOutputStream__, []));
    this.unloadData__Lorg_eclipse_swt_graphics_ImageData_2Ljava_io_OutputStream_2I(image, out, comp);
    var data: JavaArray = out.toByteArray__();
    fileHeader[1] = fileHeader[4] + data.length;
    try {
      outputStream.writeShort__I(fileHeader[0]);
      outputStream.writeInt__I(fileHeader[1]);
      outputStream.writeShort__I(fileHeader[2]);
      outputStream.writeShort__I(fileHeader[3]);
      outputStream.writeInt__I(fileHeader[4]);
    } catch (e : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
    }
    try {
      outputStream.writeInt__I(40);
      outputStream.writeInt__I(image.width);
      outputStream.writeInt__I(image.height);
      outputStream.writeShort__I(1);
      outputStream.writeShort__I(int(image.depth));
      outputStream.writeInt__I(comp);
      outputStream.writeInt__I(data.length);
      outputStream.writeInt__I(pelsPerMeter.x);
      outputStream.writeInt__I(pelsPerMeter.y);
      outputStream.writeInt__I(numCols);
      outputStream.writeInt__I(importantColors);
    } catch (e_1 : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e_1);
    }
    if (numCols > 0) {
      try {
        outputStream.write___3B(rgbs);
      } catch (e_2 : IOException) {
        SWT.error__ILjava_lang_Throwable_2(39, e_2);
      }
    }
    try {
      outputStream.write___3B(data);
    } catch (e_3 : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e_3);
    }
    return;
  }
  public function flipScanLines___3BII(data: JavaArray, stride: int, height: int): void {
    var i1: int = 0;
    var i2: int = (height - 1) * stride;
    for (var i: int = 0; i < int(height / 2); i++) {
      for (var index: int = 0; index < stride; index++) {
        var b: int = data[index + i1];
        data[index + i1] = data[index + i2];
        data[index + i2] = b;
      }
      i1 += stride;
      i2 -= stride;
    }
    return;
  }
}
}
