package org.eclipse.swt.internal.image {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import java.io.*;
import java.lang.System;
import org.eclipse.swt.graphics.ImageData;
import java.lang.Exception;
import java.io.IOException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.ImageLoader;
import java.lang.JavaArray;
dynamic public class WinICOFileFormat extends FileFormat {
  public function bitInvertData___3BII(data: JavaArray, startIndex: int, endIndex: int): JavaArray {
    for (var i: int = startIndex; i < endIndex; i++) {
      data[i] = int((255 - data[i - startIndex]));
    }
    return data;
  }
  public static function convertPad___3BIIIII(data: JavaArray, width: int, height: int, depth: int, pad: int, newPad: int): JavaArray {
    if (pad == newPad)
      return data;
    var stride: int = int((width * depth + 7) / 8);
    var bpl: int = int((stride + (pad - 1)) / pad) * pad;
    var newBpl: int = int((stride + (newPad - 1)) / newPad) * newPad;
    var newData: JavaArray = new JavaArray("[B").lengths(height * newBpl);
    var srcIndex: int = 0;
    var destIndex: int = 0;
    for (var y: int = 0; y < height; y++) {
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(data, srcIndex, newData, destIndex, newBpl);
      srcIndex += bpl;
      destIndex += newBpl;
    }
    return newData;
  }
  public function iconSize__Lorg_eclipse_swt_graphics_ImageData_2(i: ImageData): int {
    var shapeDataStride: int = int((i.width * i.depth + 31) / 32) * 4;
    var maskDataStride: int = int((i.width + 31) / 32) * 4;
    var dataSize: int = (shapeDataStride + maskDataStride) * i.height;
    var paletteSize: int = i.palette.colors !== null ? i.palette.colors.length * 4 : 0;
    return 40 + paletteSize + dataSize;
  }
  public override function isFileFormat__Lorg_eclipse_swt_internal_image_LEDataInputStream_2(stream: LEDataInputStream): Boolean {
    try {
      var header: JavaArray = new JavaArray("[B").lengths(4);
      stream.read___3B(header);
      stream.unread___3B(header);
      return header[0] == 0 && header[1] == 0 && header[2] == 1 && header[3] == 0;
    } catch (e : Exception) {
      return false;
    }
    return false;
  }
  public function isValidIcon__Lorg_eclipse_swt_graphics_ImageData_2(i: ImageData): Boolean {
    switch (i.depth) {
      case 1 :
      case 4 :
      case 8 :
        if (i.palette.isDirect)
          return false;
        var size: int = i.palette.colors.length;
        return size == 2 || size == 16 || size == 32 || size == 256;
      case 24 :
      case 32 :
        return i.palette.isDirect;
    }
    return false;
  }
  public function loadFileHeader__Lorg_eclipse_swt_internal_image_LEDataInputStream_2(byteStream: LEDataInputStream): int {
    var fileHeader: JavaArray = new JavaArray("[I").lengths(3);
    try {
      fileHeader[0] = byteStream.readShort__();
      fileHeader[1] = byteStream.readShort__();
      fileHeader[2] = byteStream.readShort__();
    } catch (e : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
    }
    if ((fileHeader[0] != 0) || (fileHeader[1] != 1))
      SWT.error__I(40);
    var numIcons: int = fileHeader[2];
    if (numIcons <= 0)
      SWT.error__I(40);
    return numIcons;
  }
  public function loadFileHeader__Lorg_eclipse_swt_internal_image_LEDataInputStream_2Z(byteStream: LEDataInputStream, hasHeader: Boolean): int {
    var fileHeader: JavaArray = new JavaArray("[I").lengths(3);
    try {
      if (hasHeader) {
        fileHeader[0] = byteStream.readShort__();
        fileHeader[1] = byteStream.readShort__();
      } else {
        fileHeader[0] = 0;
        fileHeader[1] = 1;
      }
      fileHeader[2] = byteStream.readShort__();
    } catch (e : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
    }
    if ((fileHeader[0] != 0) || (fileHeader[1] != 1))
      SWT.error__I(40);
    var numIcons: int = fileHeader[2];
    if (numIcons <= 0)
      SWT.error__I(40);
    return numIcons;
  }
  public override function loadFromByteStream__(): JavaArray {
    var numIcons: int = this.loadFileHeader__Lorg_eclipse_swt_internal_image_LEDataInputStream_2(inputStream);
    var headers: JavaArray = this.loadIconHeaders__I(numIcons);
    var icons: JavaArray = new JavaArray("[Lorg/eclipse/swt/graphics/ImageData;").lengths(headers.length);
    for (var i: int = 0; i < icons.length; i++) {
      icons[i] = this.loadIcon___3I(headers[i]);
    }
    return icons;
  }
  public function loadIcon___3I(iconHeader: JavaArray): ImageData {
    var infoHeader: JavaArray = this.loadInfoHeader___3I(iconHeader);
    var bmpFormat: WinBMPFileFormat = new WinBMPFileFormat();
    bmpFormat.inputStream = inputStream;
    var palette: PaletteData = bmpFormat.loadPalette___3B(infoHeader);
    var shapeData: JavaArray = bmpFormat.loadData___3B(infoHeader);
    var width: int = (infoHeader[4] & 0xFF) | ((infoHeader[5] & 0xFF) << 8) | ((infoHeader[6] & 0xFF) << 16) | ((infoHeader[7] & 0xFF) << 24);
    var height: int = (infoHeader[8] & 0xFF) | ((infoHeader[9] & 0xFF) << 8) | ((infoHeader[10] & 0xFF) << 16) | ((infoHeader[11] & 0xFF) << 24);
    if (height < 0)
      height = -height;
    var depth: int = (infoHeader[14] & 0xFF) | ((infoHeader[15] & 0xFF) << 8);
    infoHeader[14] = 1;
    infoHeader[15] = 0;
    var maskData: JavaArray = bmpFormat.loadData___3B(infoHeader);
    maskData = WinICOFileFormat.convertPad___3BIIIII(maskData, width, height, 1, 4, 2);
    this.bitInvertData___3BII(maskData, 0, maskData.length);
    return ImageData.internal_new__IIILorg_eclipse_swt_graphics_PaletteData_2I_3BI_3B_3BIIIIIII(width, height, depth, palette, 4, shapeData, 2, maskData, null, -1, -1, 3, 0, 0, 0, 0);
  }
  public function loadIconHeaders__I(numIcons: int): JavaArray {
    var headers: JavaArray = new JavaArray("[[I").lengths(numIcons, 7);
    try {
      for (var i: int = 0; i < numIcons; i++) {
        headers[i][0] = inputStream.read__();
        headers[i][1] = inputStream.read__();
        headers[i][2] = inputStream.readShort__();
        headers[i][3] = inputStream.readShort__();
        headers[i][4] = inputStream.readShort__();
        headers[i][5] = inputStream.readInt__();
        headers[i][6] = inputStream.readInt__();
      }
    } catch (e : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
    }
    return headers;
  }
  public function loadInfoHeader___3I(iconHeader: JavaArray): JavaArray {
    var width: int = iconHeader[0];
    var height: int = iconHeader[1];
    var numColors: int = iconHeader[2];
    if (numColors == 0)
      numColors = 256;
    if ((numColors != 2) && (numColors != 8) && (numColors != 16) && (numColors != 32) && (numColors != 256))
      SWT.error__I(40);
    if (inputStream.getPosition__() < iconHeader[6]) {
      try {
        inputStream.skip__J(iconHeader[6] - inputStream.getPosition__());
      } catch (e : IOException) {
        SWT.error__ILjava_lang_Throwable_2(39, e);
        return null;
      }
    }
    var infoHeader: JavaArray = new JavaArray("[B").lengths(40);
    try {
      inputStream.read___3B(infoHeader);
    } catch (e_1 : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e_1);
    }
    if (((infoHeader[12] & 0xFF) | ((infoHeader[13] & 0xFF) << 8)) != 1)
      SWT.error__I(40);
    var infoWidth: int = (infoHeader[4] & 0xFF) | ((infoHeader[5] & 0xFF) << 8) | ((infoHeader[6] & 0xFF) << 16) | ((infoHeader[7] & 0xFF) << 24);
    var infoHeight: int = (infoHeader[8] & 0xFF) | ((infoHeader[9] & 0xFF) << 8) | ((infoHeader[10] & 0xFF) << 16) | ((infoHeader[11] & 0xFF) << 24);
    var bitCount: int = (infoHeader[14] & 0xFF) | ((infoHeader[15] & 0xFF) << 8);
    if (height == infoHeight && bitCount == 1)
      height /= 2;
    if (!((width == infoWidth) && (height * 2 == infoHeight) && (bitCount == 1 || bitCount == 4 || bitCount == 8 || bitCount == 24 || bitCount == 32)))
      SWT.error__I(40);
    infoHeader[8] = int((height & 0xFF));
    infoHeader[9] = int(((height >> 8) & 0xFF));
    infoHeader[10] = int(((height >> 16) & 0xFF));
    infoHeader[11] = int(((height >> 24) & 0xFF));
    return infoHeader;
  }
  public function unloadIcon__Lorg_eclipse_swt_graphics_ImageData_2(icon: ImageData): void {
    var sizeImage: int = ((int((icon.width * icon.depth + 31) / 32) * 4) + (int((icon.width + 31) / 32) * 4)) * icon.height;
    try {
      outputStream.writeInt__I(40);
      outputStream.writeInt__I(icon.width);
      outputStream.writeInt__I(icon.height * 2);
      outputStream.writeShort__I(1);
      outputStream.writeShort__I(int(icon.depth));
      outputStream.writeInt__I(0);
      outputStream.writeInt__I(sizeImage);
      outputStream.writeInt__I(0);
      outputStream.writeInt__I(0);
      outputStream.writeInt__I(icon.palette.colors !== null ? icon.palette.colors.length : 0);
      outputStream.writeInt__I(0);
    } catch (e : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
    }
    var rgbs: JavaArray = WinBMPFileFormat.paletteToBytes__Lorg_eclipse_swt_graphics_PaletteData_2(icon.palette);
    try {
      outputStream.write___3B(rgbs);
    } catch (e_1 : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e_1);
    }
    this.unloadShapeData__Lorg_eclipse_swt_graphics_ImageData_2(icon);
    this.unloadMaskData__Lorg_eclipse_swt_graphics_ImageData_2(icon);
    return;
  }
  public function unloadIconHeader__Lorg_eclipse_swt_graphics_ImageData_2(i: ImageData): void {
    var headerSize: int = 16;
    var offset: int = headerSize + 6;
    var iconSize: int = this.iconSize__Lorg_eclipse_swt_graphics_ImageData_2(i);
    try {
      outputStream.write__I(i.width);
      outputStream.write__I(i.height);
      outputStream.writeShort__I(i.palette.colors !== null ? i.palette.colors.length : 0);
      outputStream.writeShort__I(0);
      outputStream.writeShort__I(0);
      outputStream.writeInt__I(iconSize);
      outputStream.writeInt__I(offset);
    } catch (e : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
    }
    return;
  }
  public override function unloadIntoByteStream__Lorg_eclipse_swt_graphics_ImageLoader_2(loader_1: ImageLoader): void {
    var image: ImageData = loader_1.data[0];
    if (!this.isValidIcon__Lorg_eclipse_swt_graphics_ImageData_2(image))
      SWT.error__I(40);
    try {
      outputStream.writeShort__I(0);
      outputStream.writeShort__I(1);
      outputStream.writeShort__I(1);
    } catch (e : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
    }
    this.unloadIconHeader__Lorg_eclipse_swt_graphics_ImageData_2(image);
    this.unloadIcon__Lorg_eclipse_swt_graphics_ImageData_2(image);
    return;
  }
  public function unloadMaskData__Lorg_eclipse_swt_graphics_ImageData_2(icon: ImageData): void {
    var mask: ImageData = icon.getTransparencyMask__();
    var bpl: int = int((icon.width + 7) / 8);
    var pad: int = mask.scanlinePad;
    var srcBpl: int = int((bpl + pad - 1) / pad) * pad;
    var destBpl: int = int((bpl + 3) / 4) * 4;
    var buf: JavaArray = new JavaArray("[B").lengths(destBpl);
    var offset: int = (icon.height - 1) * srcBpl;
    var data: JavaArray = mask.data;
    try {
      for (var i: int = 0; i < icon.height; i++) {
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(data, offset, buf, 0, bpl);
        this.bitInvertData___3BII(buf, 0, bpl);
        outputStream.write___3BII(buf, 0, destBpl);
        offset -= srcBpl;
      }
    } catch (e : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
    }
    return;
  }
  public function unloadShapeData__Lorg_eclipse_swt_graphics_ImageData_2(icon: ImageData): void {
    var bpl: int = int((icon.width * icon.depth + 7) / 8);
    var pad: int = icon.scanlinePad;
    var srcBpl: int = int((bpl + pad - 1) / pad) * pad;
    var destBpl: int = int((bpl + 3) / 4) * 4;
    var buf: JavaArray = new JavaArray("[B").lengths(destBpl);
    var offset: int = (icon.height - 1) * srcBpl;
    var data: JavaArray = icon.data;
    try {
      for (var i: int = 0; i < icon.height; i++) {
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(data, offset, buf, 0, bpl);
        outputStream.write___3BII(buf, 0, destBpl);
        offset -= srcBpl;
      }
    } catch (e : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
    }
    return;
  }
}
}
