package org.eclipse.swt.layout {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import java.lang.Math__;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.graphics.Rectangle;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class FillLayout extends Layout {
  public var type: int = 256;
  public var marginWidth: int = 0;
  public var marginHeight: int = 0;
  public var spacing: int = 0;
  public function FillLayout__(): Object {
    return this;
  }
  public function FillLayout__I(type: int): Object {
    this.type = type;
    return this;
  }
  public override function computeSize__Lorg_eclipse_swt_widgets_Composite_2IIZ(composite: Composite, wHint: int, hHint: int, flushCache: Boolean): Point {
    var children: JavaArray = composite.getChildren__();
    var count: int = children.length;
    var maxWidth: int = 0;
    var maxHeight: int = 0;
    for (var i: int = 0; i < count; i++) {
      var child: Control = children[i];
      var w: int = wHint;
      var h: int = hHint;
      if (count > 0) {
        if (type == 256 && wHint != -1) {
          w = Math__.max__II(0, int((wHint - (count - 1) * spacing) / count));
        }
        if (type == 512 && hHint != -1) {
          h = Math__.max__II(0, int((hHint - (count - 1) * spacing) / count));
        }
      }
      var size: Point = this.computeChildSize__Lorg_eclipse_swt_widgets_Control_2IIZ(child, w, h, flushCache);
      maxWidth = Math__.max__II(maxWidth, size.x);
      maxHeight = Math__.max__II(maxHeight, size.y);
    }
    var width: int = 0;
    var height: int = 0;
    if (type == 256) {
      width = count * maxWidth;
      if (count != 0)
        width += (count - 1) * spacing;
      height = maxHeight;
    } else {
      width = maxWidth;
      height = count * maxHeight;
      if (count != 0)
        height += (count - 1) * spacing;
    }
    width += marginWidth * 2;
    height += marginHeight * 2;
    if (wHint != -1)
      width = wHint;
    if (hHint != -1)
      height = hHint;
    return new Point(width, height);
  }
  public function computeChildSize__Lorg_eclipse_swt_widgets_Control_2IIZ(control: Control, wHint: int, hHint: int, flushCache: Boolean): Point {
    var data: FillData = FillData(control.getLayoutData__());
    if (data === null) {
      data = new FillData();
      control.setLayoutData__Ljava_lang_Object_2(data);
    }
    var size: Point = null;
    if (wHint == -1 && hHint == -1) {
      size = data.computeSize__Lorg_eclipse_swt_widgets_Control_2IIZ(control, wHint, hHint, flushCache);
    } else {
      var trimX: int;
      var trimY: int;
      if (control is Scrollable) {
        var rect: Rectangle = (Scrollable(control)).computeTrim__IIII(0, 0, 0, 0);
        trimX = rect.width;
        trimY = rect.height;
      } else {
        trimX = trimY = control.getBorderWidth__() * 2;
      }
      var w: int = wHint == -1 ? wHint : Math__.max__II(0, wHint - trimX);
      var h: int = hHint == -1 ? hHint : Math__.max__II(0, hHint - trimY);
      size = data.computeSize__Lorg_eclipse_swt_widgets_Control_2IIZ(control, w, h, flushCache);
    }
    return size;
  }
  public override function flushCache__Lorg_eclipse_swt_widgets_Control_2(control: Control): Boolean {
    var data: Object = control.getLayoutData__();
    if (data !== null)
      (FillData(data)).flushCache__();
    return true;
  }
  public function getName__(): String {
    var string: String = Object(this).getClass__().getName__();
    var index: int = Object(string).lastIndexOf__I(46);
    if (index == -1)
      return string;
    return Object(string).substring__II(index + 1, Object(string).length__());
  }
  public override function layout__Lorg_eclipse_swt_widgets_Composite_2Z(composite: Composite, flushCache: Boolean): void {
    var rect: Rectangle = composite.getClientArea__();
    var children: JavaArray = composite.getChildren__();
    var count: int = children.length;
    if (count == 0)
      return;
    var width: int = rect.width - marginWidth * 2;
    var height: int = rect.height - marginHeight * 2;
    if (type == 256) {
      width -= (count - 1) * spacing;
      var x: int = rect.x + marginWidth;
      var extra: int = width % count;
      var y: int = rect.y + marginHeight;
      var cellWidth: int = int(width / count);
      for (var i: int = 0; i < count; i++) {
        var child: Control = children[i];
        var childWidth: int = cellWidth;
        if (i == 0) {
          childWidth += int(extra / 2);
        } else {
          if (i == count - 1)
            childWidth += int((extra + 1) / 2);
        }
        child.setBounds__IIII(x, y, childWidth, height);
        x += childWidth + spacing;
      }
    } else {
      height -= (count - 1) * spacing;
      var x_1: int = rect.x + marginWidth;
      var cellHeight: int = int(height / count);
      var y_1: int = rect.y + marginHeight;
      var extra_1: int = height % count;
      for (var i_1: int = 0; i_1 < count; i_1++) {
        var child_1: Control = children[i_1];
        var childHeight: int = cellHeight;
        if (i_1 == 0) {
          childHeight += int(extra_1 / 2);
        } else {
          if (i_1 == count - 1)
            childHeight += int((extra_1 + 1) / 2);
        }
        child_1.setBounds__IIII(x_1, y_1, width, childHeight);
        y_1 += childHeight + spacing;
      }
    }
    return;
  }
  public function toString__(): String {
    var string: String = this.getName__() + " {";
    string += "type=" + ((type == 512) ? "SWT.VERTICAL" : "SWT.HORIZONTAL") + " ";
    if (marginWidth != 0)
      string += "marginWidth=" + marginWidth + " ";
    if (marginHeight != 0)
      string += "marginHeight=" + marginHeight + " ";
    if (spacing != 0)
      string += "spacing=" + spacing + " ";
    string = Object(string).trim__();
    string += "}";
    return string;
  }
  public function FillLayout(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is int) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0]];
        break;
    }
    super();
    switch (id) {
      case 0:
        FillLayout__();
        break;
      case 1:
        FillLayout__I(args1[0]);
        break;
    }
  }
  public static const FillLayout__ : int = 0;
  public static const FillLayout__I : int = 1;
}
}
