package org.eclipse.swt.layout {
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.SWT;
import java.lang.Math__;
import java.lang.Arguments;
dynamic public class FormAttachment {
  public var numerator: int;
  public var denominator: int = 100;
  public var offset: int;
  public var control: Control;
  public var alignment: int;
  public function FormAttachment__(): Object {
    return this;
  }
  public function FormAttachment__I(numerator: int): Object {
    return this;
  }
  public function FormAttachment__II(numerator: int, offset: int): Object {
    return this;
  }
  public function FormAttachment__III(numerator: int, denominator: int, offset: int): Object {
    if (denominator == 0)
      SWT.error__I(7);
    this.numerator = numerator;
    this.denominator = denominator;
    this.offset = offset;
    return this;
  }
  public function FormAttachment__Lorg_eclipse_swt_widgets_Control_2(control: Control): Object {
    return this;
  }
  public function FormAttachment__Lorg_eclipse_swt_widgets_Control_2I(control: Control, offset: int): Object {
    return this;
  }
  public function FormAttachment__Lorg_eclipse_swt_widgets_Control_2II(control: Control, offset: int, alignment: int): Object {
    this.control = control;
    this.offset = offset;
    this.alignment = alignment;
    return this;
  }
  public function divide__I(value: int): FormAttachment {
    return new FormAttachment(new Arguments(org.eclipse.swt.layout.FormAttachment.FormAttachment__III, [numerator, denominator * value, int(offset / value)]));
  }
  public function gcd__II(m: int, n: int): int {
    var temp: int;
    m = Math__.abs__I(m);
    n = Math__.abs__I(n);
    if (m < n) {
      temp = m;
      m = n;
      n = temp;
    }
    while (n != 0) {
      temp = m;
      m = n;
      n = temp % n;
    }
    return m;
  }
  public function minus__Lorg_eclipse_swt_layout_FormAttachment_2(attachment: FormAttachment): FormAttachment {
    var solution: FormAttachment = new FormAttachment(new Arguments(org.eclipse.swt.layout.FormAttachment.FormAttachment__, []));
    solution.numerator = numerator * attachment.denominator - denominator * attachment.numerator;
    solution.denominator = denominator * attachment.denominator;
    var gcd: int = this.gcd__II(solution.denominator, solution.numerator);
    solution.numerator = int(solution.numerator / gcd);
    solution.denominator = int(solution.denominator / gcd);
    solution.offset = offset - attachment.offset;
    return solution;
  }
  public function minus__I(value: int): FormAttachment {
    return new FormAttachment(new Arguments(org.eclipse.swt.layout.FormAttachment.FormAttachment__III, [numerator, denominator, offset - value]));
  }
  public function plus__Lorg_eclipse_swt_layout_FormAttachment_2(attachment: FormAttachment): FormAttachment {
    var solution: FormAttachment = new FormAttachment(new Arguments(org.eclipse.swt.layout.FormAttachment.FormAttachment__, []));
    solution.numerator = numerator * attachment.denominator + denominator * attachment.numerator;
    solution.denominator = denominator * attachment.denominator;
    var gcd: int = this.gcd__II(solution.denominator, solution.numerator);
    solution.numerator = int(solution.numerator / gcd);
    solution.denominator = int(solution.denominator / gcd);
    solution.offset = offset + attachment.offset;
    return solution;
  }
  public function plus__I(value: int): FormAttachment {
    return new FormAttachment(new Arguments(org.eclipse.swt.layout.FormAttachment.FormAttachment__III, [numerator, denominator, offset + value]));
  }
  public function solveX__I(value: int): int {
    if (denominator == 0)
      SWT.error__I(7);
    return (int((numerator * value) / denominator)) + offset;
  }
  public function solveY__I(value: int): int {
    if (numerator == 0)
      SWT.error__I(7);
    return int((value - offset) * denominator / numerator);
  }
  public function toString__(): String {
    var string: String = control !== null ? control.toString__() : numerator + "/" + denominator;
    return "{y = (" + string + (offset >= 0 ? ")x + " + offset : ")x - " + (-offset)) + "}";
  }
  public function FormAttachment(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is int) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 2 && vargs[0] is int && vargs[1] is int) {
        args = vargs;
        id = 2;
      } else if (vargs.length == 3 && vargs[0] is int && vargs[1] is int && vargs[2] is int) {
        args = vargs;
        id = 3;
      } else if (vargs.length == 1 && vargs[0] is Control) {
        args = vargs;
        id = 4;
      } else if (vargs.length == 2 && vargs[0] is Control && vargs[1] is int) {
        args = vargs;
        id = 5;
      } else if (vargs.length == 3 && vargs[0] is Control && vargs[1] is int && vargs[2] is int) {
        args = vargs;
        id = 6;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0]];
        args3 = [args1[0], 100, 0];
        break;
      case 2:
        var args2: Array = [args[0], args[1]];
        args3 = [args2[0], 100, args2[1]];
        break;
      case 3:
        var args3: Array = [args[0], args[1], args[2]];
        break;
      case 4:
        var args4: Array = [args[0]];
        args6 = [args4[0], 0, -1];
        break;
      case 5:
        var args5: Array = [args[0], args[1]];
        args6 = [args5[0], args5[1], -1];
        break;
      case 6:
        var args6: Array = [args[0], args[1], args[2]];
        break;
    }
    super();
    switch (id) {
      case 0:
        FormAttachment__();
        break;
      case 1:
        FormAttachment__III(args3[0], args3[1], args3[2]);
        FormAttachment__I(args1[0]);
        break;
      case 2:
        FormAttachment__III(args3[0], args3[1], args3[2]);
        FormAttachment__II(args2[0], args2[1]);
        break;
      case 3:
        FormAttachment__III(args3[0], args3[1], args3[2]);
        break;
      case 4:
        FormAttachment__Lorg_eclipse_swt_widgets_Control_2II(args6[0], args6[1], args6[2]);
        FormAttachment__Lorg_eclipse_swt_widgets_Control_2(args4[0]);
        break;
      case 5:
        FormAttachment__Lorg_eclipse_swt_widgets_Control_2II(args6[0], args6[1], args6[2]);
        FormAttachment__Lorg_eclipse_swt_widgets_Control_2I(args5[0], args5[1]);
        break;
      case 6:
        FormAttachment__Lorg_eclipse_swt_widgets_Control_2II(args6[0], args6[1], args6[2]);
        break;
    }
  }
  public static const FormAttachment__ : int = 0;
  public static const FormAttachment__I : int = 1;
  public static const FormAttachment__II : int = 2;
  public static const FormAttachment__III : int = 3;
  public static const FormAttachment__Lorg_eclipse_swt_widgets_Control_2 : int = 4;
  public static const FormAttachment__Lorg_eclipse_swt_widgets_Control_2I : int = 5;
  public static const FormAttachment__Lorg_eclipse_swt_widgets_Control_2II : int = 6;
}
}
