package org.eclipse.swt.layout {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.graphics.Point;
import java.lang.Arguments;
import java.lang.System;
dynamic public class FormData {
  public var width: int = -1;
  public var height: int = -1;
  public var left: FormAttachment;
  public var right: FormAttachment;
  public var top: FormAttachment;
  public var bottom: FormAttachment;
  internal var cacheWidth: int = -1;
  internal var cacheHeight: int = -1;
  internal var defaultWhint: int;
  internal var defaultHhint: int;
  internal var defaultWidth: int = -1;
  internal var defaultHeight: int = -1;
  internal var currentWhint: int;
  internal var currentHhint: int;
  internal var currentWidth: int = -1;
  internal var currentHeight: int = -1;
  internal var cacheLeft: FormAttachment;
  internal var cacheRight: FormAttachment;
  internal var cacheTop: FormAttachment;
  internal var cacheBottom: FormAttachment;
  internal var isVisited: Boolean;
  internal var needed: Boolean;
  public function FormData__(): Object {
    return this;
  }
  public function FormData__II(width: int, height: int): Object {
    this.width = width;
    this.height = height;
    return this;
  }
  public function computeSize__Lorg_eclipse_swt_widgets_Control_2IIZ(control: Control, wHint: int, hHint: int, flushCache: Boolean): void {
    if (cacheWidth != -1 && cacheHeight != -1)
      return;
    if (wHint == this.width && hHint == this.height) {
      if (defaultWidth == -1 || defaultHeight == -1 || wHint != defaultWhint || hHint != defaultHhint) {
        var size: Point = control.computeSize__IIZ(wHint, hHint, flushCache);
        defaultWhint = wHint;
        defaultHhint = hHint;
        defaultWidth = size.x;
        defaultHeight = size.y;
      }
      cacheWidth = defaultWidth;
      cacheHeight = defaultHeight;
      return;
    }
    if (currentWidth == -1 || currentHeight == -1 || wHint != currentWhint || hHint != currentHhint) {
      var size_1: Point = control.computeSize__IIZ(wHint, hHint, flushCache);
      currentWhint = wHint;
      currentHhint = hHint;
      currentWidth = size_1.x;
      currentHeight = size_1.y;
    }
    cacheWidth = currentWidth;
    cacheHeight = currentHeight;
    return;
  }
  public function flushCache__(): void {
    cacheWidth = cacheHeight = -1;
    defaultHeight = defaultWidth = -1;
    currentHeight = currentWidth = -1;
    return;
  }
  public function getWidth__Lorg_eclipse_swt_widgets_Control_2Z(control: Control, flushCache: Boolean): int {
    needed = true;
    this.computeSize__Lorg_eclipse_swt_widgets_Control_2IIZ(control, width, height, flushCache);
    return cacheWidth;
  }
  public function getHeight__Lorg_eclipse_swt_widgets_Control_2Z(control: Control, flushCache: Boolean): int {
    this.computeSize__Lorg_eclipse_swt_widgets_Control_2IIZ(control, width, height, flushCache);
    return cacheHeight;
  }
  public function getBottomAttachment__Lorg_eclipse_swt_widgets_Control_2IZ(control: Control, spacing: int, flushCache: Boolean): FormAttachment {
    if (cacheBottom !== null)
      return cacheBottom;
    if (isVisited)
      return cacheBottom = new FormAttachment(new Arguments(org.eclipse.swt.layout.FormAttachment.FormAttachment__II, [0, this.getHeight__Lorg_eclipse_swt_widgets_Control_2Z(control, flushCache)]));
    if (bottom === null) {
      if (top === null)
        return cacheBottom = new FormAttachment(new Arguments(org.eclipse.swt.layout.FormAttachment.FormAttachment__II, [0, this.getHeight__Lorg_eclipse_swt_widgets_Control_2Z(control, flushCache)]));
      return cacheBottom = this.getTopAttachment__Lorg_eclipse_swt_widgets_Control_2IZ(control, spacing, flushCache).plus__I(this.getHeight__Lorg_eclipse_swt_widgets_Control_2Z(control, flushCache));
    }
    var bottomControl: Control = bottom.control;
    if (bottomControl !== null) {
      if (bottomControl.isDisposed__()) {
        bottom.control = bottomControl = null;
      } else {
        if (bottomControl.getParent__() !== control.getParent__()) {
          bottomControl = null;
        }
      }
    }
    if (bottomControl === null)
      return cacheBottom = bottom;
    isVisited = true;
    var bottomData: FormData = FormData(bottomControl.getLayoutData__());
    var bottomAttachment: FormAttachment = bottomData.getBottomAttachment__Lorg_eclipse_swt_widgets_Control_2IZ(bottomControl, spacing, flushCache);
    switch (bottom.alignment) {
      case 1024 :
        cacheBottom = bottomAttachment.plus__I(bottom.offset);
        break;
      case 16777216 :
        {
          var topAttachment: FormAttachment = bottomData.getTopAttachment__Lorg_eclipse_swt_widgets_Control_2IZ(bottomControl, spacing, flushCache);
          var bottomHeight: FormAttachment = bottomAttachment.minus__Lorg_eclipse_swt_layout_FormAttachment_2(topAttachment);
          cacheBottom = bottomAttachment.minus__Lorg_eclipse_swt_layout_FormAttachment_2(bottomHeight.minus__I(this.getHeight__Lorg_eclipse_swt_widgets_Control_2Z(control, flushCache)).divide__I(2));
          break;
        }
      default :
        {
          var topAttachment_1: FormAttachment = bottomData.getTopAttachment__Lorg_eclipse_swt_widgets_Control_2IZ(bottomControl, spacing, flushCache);
          cacheBottom = topAttachment_1.plus__I(bottom.offset - spacing);
          break;
        }
    }
    isVisited = false;
    return cacheBottom;
  }
  public function getLeftAttachment__Lorg_eclipse_swt_widgets_Control_2IZ(control: Control, spacing: int, flushCache: Boolean): FormAttachment {
    if (cacheLeft !== null)
      return cacheLeft;
    if (isVisited)
      return cacheLeft = new FormAttachment(new Arguments(org.eclipse.swt.layout.FormAttachment.FormAttachment__II, [0, 0]));
    if (left === null) {
      if (right === null)
        return cacheLeft = new FormAttachment(new Arguments(org.eclipse.swt.layout.FormAttachment.FormAttachment__II, [0, 0]));
      return cacheLeft = this.getRightAttachment__Lorg_eclipse_swt_widgets_Control_2IZ(control, spacing, flushCache).minus__I(this.getWidth__Lorg_eclipse_swt_widgets_Control_2Z(control, flushCache));
    }
    var leftControl: Control = left.control;
    if (leftControl !== null) {
      if (leftControl.isDisposed__()) {
        left.control = leftControl = null;
      } else {
        if (leftControl.getParent__() !== control.getParent__()) {
          leftControl = null;
        }
      }
    }
    if (leftControl === null)
      return cacheLeft = left;
    isVisited = true;
    var leftData: FormData = FormData(leftControl.getLayoutData__());
    var leftAttachment: FormAttachment = leftData.getLeftAttachment__Lorg_eclipse_swt_widgets_Control_2IZ(leftControl, spacing, flushCache);
    switch (left.alignment) {
      case 16384 :
        cacheLeft = leftAttachment.plus__I(left.offset);
        break;
      case 16777216 :
        {
          var rightAttachment: FormAttachment = leftData.getRightAttachment__Lorg_eclipse_swt_widgets_Control_2IZ(leftControl, spacing, flushCache);
          var leftWidth: FormAttachment = rightAttachment.minus__Lorg_eclipse_swt_layout_FormAttachment_2(leftAttachment);
          cacheLeft = leftAttachment.plus__Lorg_eclipse_swt_layout_FormAttachment_2(leftWidth.minus__I(this.getWidth__Lorg_eclipse_swt_widgets_Control_2Z(control, flushCache)).divide__I(2));
          break;
        }
      default :
        {
          var rightAttachment_1: FormAttachment = leftData.getRightAttachment__Lorg_eclipse_swt_widgets_Control_2IZ(leftControl, spacing, flushCache);
          cacheLeft = rightAttachment_1.plus__I(left.offset + spacing);
        }
    }
    isVisited = false;
    return cacheLeft;
  }
  public function getName__(): String {
    var string: String = Object(this).getClass__().getName__();
    var index: int = Object(string).lastIndexOf__I(46);
    if (index == -1)
      return string;
    return Object(string).substring__II(index + 1, Object(string).length__());
  }
  public function getRightAttachment__Lorg_eclipse_swt_widgets_Control_2IZ(control: Control, spacing: int, flushCache: Boolean): FormAttachment {
    if (cacheRight !== null)
      return cacheRight;
    if (isVisited)
      return cacheRight = new FormAttachment(new Arguments(org.eclipse.swt.layout.FormAttachment.FormAttachment__II, [0, this.getWidth__Lorg_eclipse_swt_widgets_Control_2Z(control, flushCache)]));
    if (right === null) {
      if (left === null)
        return cacheRight = new FormAttachment(new Arguments(org.eclipse.swt.layout.FormAttachment.FormAttachment__II, [0, this.getWidth__Lorg_eclipse_swt_widgets_Control_2Z(control, flushCache)]));
      return cacheRight = this.getLeftAttachment__Lorg_eclipse_swt_widgets_Control_2IZ(control, spacing, flushCache).plus__I(this.getWidth__Lorg_eclipse_swt_widgets_Control_2Z(control, flushCache));
    }
    var rightControl: Control = right.control;
    if (rightControl !== null) {
      if (rightControl.isDisposed__()) {
        right.control = rightControl = null;
      } else {
        if (rightControl.getParent__() !== control.getParent__()) {
          rightControl = null;
        }
      }
    }
    if (rightControl === null)
      return cacheRight = right;
    isVisited = true;
    var rightData: FormData = FormData(rightControl.getLayoutData__());
    var rightAttachment: FormAttachment = rightData.getRightAttachment__Lorg_eclipse_swt_widgets_Control_2IZ(rightControl, spacing, flushCache);
    switch (right.alignment) {
      case 131072 :
        cacheRight = rightAttachment.plus__I(right.offset);
        break;
      case 16777216 :
        {
          var leftAttachment: FormAttachment = rightData.getLeftAttachment__Lorg_eclipse_swt_widgets_Control_2IZ(rightControl, spacing, flushCache);
          var rightWidth: FormAttachment = rightAttachment.minus__Lorg_eclipse_swt_layout_FormAttachment_2(leftAttachment);
          cacheRight = rightAttachment.minus__Lorg_eclipse_swt_layout_FormAttachment_2(rightWidth.minus__I(this.getWidth__Lorg_eclipse_swt_widgets_Control_2Z(control, flushCache)).divide__I(2));
          break;
        }
      default :
        {
          var leftAttachment_1: FormAttachment = rightData.getLeftAttachment__Lorg_eclipse_swt_widgets_Control_2IZ(rightControl, spacing, flushCache);
          cacheRight = leftAttachment_1.plus__I(right.offset - spacing);
          break;
        }
    }
    isVisited = false;
    return cacheRight;
  }
  public function getTopAttachment__Lorg_eclipse_swt_widgets_Control_2IZ(control: Control, spacing: int, flushCache: Boolean): FormAttachment {
    if (cacheTop !== null)
      return cacheTop;
    if (isVisited)
      return cacheTop = new FormAttachment(new Arguments(org.eclipse.swt.layout.FormAttachment.FormAttachment__II, [0, 0]));
    if (top === null) {
      if (bottom === null)
        return cacheTop = new FormAttachment(new Arguments(org.eclipse.swt.layout.FormAttachment.FormAttachment__II, [0, 0]));
      return cacheTop = this.getBottomAttachment__Lorg_eclipse_swt_widgets_Control_2IZ(control, spacing, flushCache).minus__I(this.getHeight__Lorg_eclipse_swt_widgets_Control_2Z(control, flushCache));
    }
    var topControl: Control = top.control;
    if (topControl !== null) {
      if (topControl.isDisposed__()) {
        top.control = topControl = null;
      } else {
        if (topControl.getParent__() !== control.getParent__()) {
          topControl = null;
        }
      }
    }
    if (topControl === null)
      return cacheTop = top;
    isVisited = true;
    var topData: FormData = FormData(topControl.getLayoutData__());
    var topAttachment: FormAttachment = topData.getTopAttachment__Lorg_eclipse_swt_widgets_Control_2IZ(topControl, spacing, flushCache);
    switch (top.alignment) {
      case 128 :
        cacheTop = topAttachment.plus__I(top.offset);
        break;
      case 16777216 :
        {
          var bottomAttachment: FormAttachment = topData.getBottomAttachment__Lorg_eclipse_swt_widgets_Control_2IZ(topControl, spacing, flushCache);
          var topHeight: FormAttachment = bottomAttachment.minus__Lorg_eclipse_swt_layout_FormAttachment_2(topAttachment);
          cacheTop = topAttachment.plus__Lorg_eclipse_swt_layout_FormAttachment_2(topHeight.minus__I(this.getHeight__Lorg_eclipse_swt_widgets_Control_2Z(control, flushCache)).divide__I(2));
          break;
        }
      default :
        {
          var bottomAttachment_1: FormAttachment = topData.getBottomAttachment__Lorg_eclipse_swt_widgets_Control_2IZ(topControl, spacing, flushCache);
          cacheTop = bottomAttachment_1.plus__I(top.offset + spacing);
          break;
        }
    }
    isVisited = false;
    return cacheTop;
  }
  public function toString__(): String {
    var string: String = this.getName__() + " {";
    if (width != -1)
      string += "width=" + width + " ";
    if (height != -1)
      string += "height=" + height + " ";
    if (left !== null)
      string += "left=" + java.lang.System.stringValueOf(left) + " ";
    if (right !== null)
      string += "right=" + java.lang.System.stringValueOf(right) + " ";
    if (top !== null)
      string += "top=" + java.lang.System.stringValueOf(top) + " ";
    if (bottom !== null)
      string += "bottom=" + java.lang.System.stringValueOf(bottom) + " ";
    string = Object(string).trim__();
    string += "}";
    return string;
  }
  public function FormData(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 2 && vargs[0] is int && vargs[1] is int) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0], args[1]];
        break;
    }
    super();
    switch (id) {
      case 0:
        FormData__();
        break;
      case 1:
        FormData__II(args1[0], args1[1]);
        break;
    }
  }
  public static const FormData__ : int = 0;
  public static const FormData__II : int = 1;
}
}
