package org.eclipse.swt.layout {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Rectangle;
import java.lang.Math__;
import org.eclipse.swt.widgets.Scrollable;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class FormLayout extends Layout {
  public var marginWidth: int = 0;
  public var marginHeight: int = 0;
  public var marginLeft: int = 0;
  public var marginTop: int = 0;
  public var marginRight: int = 0;
  public var marginBottom: int = 0;
  public var spacing: int = 0;
  public function FormLayout() {
    return;
  }
  public function computeHeight__Lorg_eclipse_swt_widgets_Control_2Lorg_eclipse_swt_layout_FormData_2Z(control: Control, data: FormData, flushCache: Boolean): int {
    var top: FormAttachment = data.getTopAttachment__Lorg_eclipse_swt_widgets_Control_2IZ(control, spacing, flushCache);
    var bottom: FormAttachment = data.getBottomAttachment__Lorg_eclipse_swt_widgets_Control_2IZ(control, spacing, flushCache);
    var height: FormAttachment = bottom.minus__Lorg_eclipse_swt_layout_FormAttachment_2(top);
    if (height.numerator == 0) {
      if (bottom.numerator == 0)
        return bottom.offset;
      if (bottom.numerator == bottom.denominator)
        return -top.offset;
      if (bottom.offset <= 0) {
        return int(-top.offset * top.denominator / bottom.numerator);
      }
      var divider: int = bottom.denominator - bottom.numerator;
      return int(bottom.denominator * bottom.offset / divider);
    }
    return height.solveY__I(data.getHeight__Lorg_eclipse_swt_widgets_Control_2Z(control, flushCache));
  }
  public override function computeSize__Lorg_eclipse_swt_widgets_Composite_2IIZ(composite: Composite, wHint: int, hHint: int, flushCache: Boolean): Point {
    var size: Point = this.layout__Lorg_eclipse_swt_widgets_Composite_2ZIIIIZ(composite, false, 0, 0, wHint, hHint, flushCache);
    if (wHint != -1)
      size.x = wHint;
    if (hHint != -1)
      size.y = hHint;
    return size;
  }
  public override function flushCache__Lorg_eclipse_swt_widgets_Control_2(control: Control): Boolean {
    var data: Object = control.getLayoutData__();
    if (data !== null)
      (FormData(data)).flushCache__();
    return true;
  }
  public function getName__(): String {
    var string: String = Object(this).getClass__().getName__();
    var index: int = Object(string).lastIndexOf__I(46);
    if (index == -1)
      return string;
    return Object(string).substring__II(index + 1, Object(string).length__());
  }
  public function computeWidth__Lorg_eclipse_swt_widgets_Control_2Lorg_eclipse_swt_layout_FormData_2Z(control: Control, data: FormData, flushCache: Boolean): int {
    var left: FormAttachment = data.getLeftAttachment__Lorg_eclipse_swt_widgets_Control_2IZ(control, spacing, flushCache);
    var right: FormAttachment = data.getRightAttachment__Lorg_eclipse_swt_widgets_Control_2IZ(control, spacing, flushCache);
    var width: FormAttachment = right.minus__Lorg_eclipse_swt_layout_FormAttachment_2(left);
    if (width.numerator == 0) {
      if (right.numerator == 0)
        return right.offset;
      if (right.numerator == right.denominator)
        return -left.offset;
      if (right.offset <= 0) {
        return int(-left.offset * left.denominator / left.numerator);
      }
      var divider: int = right.denominator - right.numerator;
      return int(right.denominator * right.offset / divider);
    }
    return width.solveY__I(data.getWidth__Lorg_eclipse_swt_widgets_Control_2Z(control, flushCache));
  }
  public override function layout__Lorg_eclipse_swt_widgets_Composite_2Z(composite: Composite, flushCache: Boolean): void {
    var rect: Rectangle = composite.getClientArea__();
    var x: int = rect.x + marginLeft + marginWidth;
    var y: int = rect.y + marginTop + marginHeight;
    var width: int = Math__.max__II(0, rect.width - marginLeft - 2 * marginWidth - marginRight);
    var height: int = Math__.max__II(0, rect.height - marginTop - 2 * marginHeight - marginBottom);
    this.layout__Lorg_eclipse_swt_widgets_Composite_2ZIIIIZ(composite, true, x, y, width, height, flushCache);
  }
  public function layout__Lorg_eclipse_swt_widgets_Composite_2ZIIIIZ(composite: Composite, move: Boolean, x: int, y: int, width: int, height: int, flushCache: Boolean): Point {
    var children: JavaArray = composite.getChildren__();
    for (var i: int = 0; i < children.length; i++) {
      var child: Control = children[i];
      var data: FormData = FormData(child.getLayoutData__());
      if (data === null)
        child.setLayoutData__Ljava_lang_Object_2(data = new FormData(new Arguments(org.eclipse.swt.layout.FormData.FormData__, [])));
      if (flushCache)
        data.flushCache__();
      data.cacheLeft = data.cacheRight = data.cacheTop = data.cacheBottom = null;
    }
    var flush: JavaArray = null;
    var bounds: JavaArray = null;
    var w: int = 0;
    var h: int = 0;
    for (var i_1: int = 0; i_1 < children.length; i_1++) {
      var child_1: Control = children[i_1];
      var data_1: FormData = FormData(child_1.getLayoutData__());
      if (width != -1) {
        data_1.needed = false;
        var left: FormAttachment = data_1.getLeftAttachment__Lorg_eclipse_swt_widgets_Control_2IZ(child_1, spacing, flushCache);
        var right: FormAttachment = data_1.getRightAttachment__Lorg_eclipse_swt_widgets_Control_2IZ(child_1, spacing, flushCache);
        var x1: int = left.solveX__I(width);
        var x2: int = right.solveX__I(width);
        if (data_1.height == -1 && !data_1.needed) {
          var trim: int = 0;
          if (child_1 is Scrollable) {
            var rect: Rectangle = (Scrollable(child_1)).computeTrim__IIII(0, 0, 0, 0);
            trim = rect.width;
          } else {
            trim = child_1.getBorderWidth__() * 2;
          }
          data_1.cacheWidth = data_1.cacheHeight = -1;
          var currentWidth: int = Math__.max__II(0, x2 - x1 - trim);
          data_1.computeSize__Lorg_eclipse_swt_widgets_Control_2IIZ(child_1, currentWidth, data_1.height, flushCache);
          if (flush === null)
            flush = new JavaArray("[Z").lengths(children.length);
          flush[i_1] = true;
        }
        w = Math__.max__II(x2, w);
        if (move) {
          if (bounds === null)
            bounds = new JavaArray("[Lorg/eclipse/swt/graphics/Rectangle;").lengths(children.length);
          bounds[i_1] = new Rectangle(0, 0, 0, 0);
          bounds[i_1].x = x + x1;
          bounds[i_1].width = x2 - x1;
        }
      } else {
        w = Math__.max__II(this.computeWidth__Lorg_eclipse_swt_widgets_Control_2Lorg_eclipse_swt_layout_FormData_2Z(child_1, data_1, flushCache), w);
      }
    }
    for (var i_2: int = 0; i_2 < children.length; i_2++) {
      var child_2: Control = children[i_2];
      var data_2: FormData = FormData(child_2.getLayoutData__());
      if (height != -1) {
        var y1: int = data_2.getTopAttachment__Lorg_eclipse_swt_widgets_Control_2IZ(child_2, spacing, flushCache).solveX__I(height);
        var y2: int = data_2.getBottomAttachment__Lorg_eclipse_swt_widgets_Control_2IZ(child_2, spacing, flushCache).solveX__I(height);
        h = Math__.max__II(y2, h);
        if (move) {
          bounds[i_2].y = y + y1;
          bounds[i_2].height = y2 - y1;
        }
      } else {
        h = Math__.max__II(this.computeHeight__Lorg_eclipse_swt_widgets_Control_2Lorg_eclipse_swt_layout_FormData_2Z(child_2, data_2, flushCache), h);
      }
    }
    for (var i_3: int = 0; i_3 < children.length; i_3++) {
      var child_3: Control = children[i_3];
      var data_3: FormData = FormData(child_3.getLayoutData__());
      if (flush !== null && flush[i_3])
        data_3.cacheWidth = data_3.cacheHeight = -1;
      data_3.cacheLeft = data_3.cacheRight = data_3.cacheTop = data_3.cacheBottom = null;
    }
    if (move) {
      for (var i_4: int = 0; i_4 < children.length; i_4++) {
        children[i_4].setBounds__Lorg_eclipse_swt_graphics_Rectangle_2(bounds[i_4]);
      }
    }
    w += marginLeft + marginWidth * 2 + marginRight;
    h += marginTop + marginHeight * 2 + marginBottom;
    return new Point(w, h);
  }
  public function toString__(): String {
    var string: String = this.getName__() + " {";
    if (marginWidth != 0)
      string += "marginWidth=" + marginWidth + " ";
    if (marginHeight != 0)
      string += "marginHeight=" + marginHeight + " ";
    if (marginLeft != 0)
      string += "marginLeft=" + marginLeft + " ";
    if (marginRight != 0)
      string += "marginRight=" + marginRight + " ";
    if (marginTop != 0)
      string += "marginTop=" + marginTop + " ";
    if (marginBottom != 0)
      string += "marginBottom=" + marginBottom + " ";
    if (spacing != 0)
      string += "spacing=" + spacing + " ";
    string = Object(string).trim__();
    string += "}";
    return string;
  }
}
}
