package org.eclipse.swt.layout {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.graphics.Point;
import java.lang.Arguments;
dynamic public class GridData {
  public var verticalAlignment: int = 2;
  public var horizontalAlignment: int = 1;
  public var widthHint: int = -1;
  public var heightHint: int = -1;
  public var horizontalIndent: int = 0;
  public var verticalIndent: int = 0;
  public var horizontalSpan: int = 1;
  public var verticalSpan: int = 1;
  public var grabExcessHorizontalSpace: Boolean = false;
  public var grabExcessVerticalSpace: Boolean = false;
  public var minimumWidth: int = 0;
  public var minimumHeight: int = 0;
  public var exclude: Boolean = false;
  public static const BEGINNING: int = 1;
  public static const CENTER: int = 2;
  public static const END: int = 3;
  public static const FILL: int = 4;
  public static const VERTICAL_ALIGN_BEGINNING: int = 1 << 1;
  public static const VERTICAL_ALIGN_CENTER: int = 1 << 2;
  public static const VERTICAL_ALIGN_END: int = 1 << 3;
  public static const VERTICAL_ALIGN_FILL: int = 1 << 4;
  public static const HORIZONTAL_ALIGN_BEGINNING: int = 1 << 5;
  public static const HORIZONTAL_ALIGN_CENTER: int = 1 << 6;
  public static const HORIZONTAL_ALIGN_END: int = 1 << 7;
  public static const HORIZONTAL_ALIGN_FILL: int = 1 << 8;
  public static const GRAB_HORIZONTAL: int = 1 << 9;
  public static const GRAB_VERTICAL: int = 1 << 10;
  public static const FILL_VERTICAL: int = 16 | 1024;
  public static const FILL_HORIZONTAL: int = 256 | 512;
  public static const FILL_BOTH: int = 1040 | 768;
  internal var cacheWidth: int = -1;
  internal var cacheHeight: int = -1;
  internal var defaultWhint: int;
  internal var defaultHhint: int;
  internal var defaultWidth: int = -1;
  internal var defaultHeight: int = -1;
  internal var currentWhint: int;
  internal var currentHhint: int;
  internal var currentWidth: int = -1;
  internal var currentHeight: int = -1;
  public function GridData__(): Object {
    return this;
  }
  public function GridData__I(style: int): Object {
    if ((style & 2) != 0)
      verticalAlignment = 1;
    if ((style & 4) != 0)
      verticalAlignment = 2;
    if ((style & 16) != 0)
      verticalAlignment = 4;
    if ((style & 8) != 0)
      verticalAlignment = 3;
    if ((style & 32) != 0)
      horizontalAlignment = 1;
    if ((style & 64) != 0)
      horizontalAlignment = 2;
    if ((style & 256) != 0)
      horizontalAlignment = 4;
    if ((style & 128) != 0)
      horizontalAlignment = 3;
    grabExcessHorizontalSpace = (style & 512) != 0;
    grabExcessVerticalSpace = (style & 1024) != 0;
    return this;
  }
  public function GridData__IIZZ(horizontalAlignment: int, verticalAlignment: int, grabExcessHorizontalSpace: Boolean, grabExcessVerticalSpace: Boolean): Object {
    return this;
  }
  public function GridData__IIZZII(horizontalAlignment: int, verticalAlignment: int, grabExcessHorizontalSpace: Boolean, grabExcessVerticalSpace: Boolean, horizontalSpan: int, verticalSpan: int): Object {
    this.horizontalAlignment = horizontalAlignment;
    this.verticalAlignment = verticalAlignment;
    this.grabExcessHorizontalSpace = grabExcessHorizontalSpace;
    this.grabExcessVerticalSpace = grabExcessVerticalSpace;
    this.horizontalSpan = horizontalSpan;
    this.verticalSpan = verticalSpan;
    return this;
  }
  public function GridData__II(width: int, height: int): Object {
    this.widthHint = width;
    this.heightHint = height;
    return this;
  }
  public function computeSize__Lorg_eclipse_swt_widgets_Control_2IIZ(control: Control, wHint: int, hHint: int, flushCache: Boolean): void {
    if (cacheWidth != -1 && cacheHeight != -1)
      return;
    if (wHint == this.widthHint && hHint == this.heightHint) {
      if (defaultWidth == -1 || defaultHeight == -1 || wHint != defaultWhint || hHint != defaultHhint) {
        var size: Point = control.computeSize__IIZ(wHint, hHint, flushCache);
        defaultWhint = wHint;
        defaultHhint = hHint;
        defaultWidth = size.x;
        defaultHeight = size.y;
      }
      cacheWidth = defaultWidth;
      cacheHeight = defaultHeight;
      return;
    }
    if (currentWidth == -1 || currentHeight == -1 || wHint != currentWhint || hHint != currentHhint) {
      var size_1: Point = control.computeSize__IIZ(wHint, hHint, flushCache);
      currentWhint = wHint;
      currentHhint = hHint;
      currentWidth = size_1.x;
      currentHeight = size_1.y;
    }
    cacheWidth = currentWidth;
    cacheHeight = currentHeight;
    return;
  }
  public function flushCache__(): void {
    cacheWidth = cacheHeight = -1;
    defaultWidth = defaultHeight = -1;
    currentWidth = currentHeight = -1;
    return;
  }
  public function getName__(): String {
    var string: String = Object(this).getClass__().getName__();
    var index: int = Object(string).lastIndexOf__I(46);
    if (index == -1)
      return string;
    return Object(string).substring__II(index + 1, Object(string).length__());
  }
  public function toString__(): String {
    var hAlign: String = "";
    switch (horizontalAlignment) {
      case 4 :
        hAlign = "SWT.FILL";
        break;
      case 1 :
        hAlign = "SWT.BEGINNING";
        break;
      case 16384 :
        hAlign = "SWT.LEFT";
        break;
      case 16777224 :
        hAlign = "SWT.END";
        break;
      case 3 :
        hAlign = "GridData.END";
        break;
      case 131072 :
        hAlign = "SWT.RIGHT";
        break;
      case 16777216 :
        hAlign = "SWT.CENTER";
        break;
      case 2 :
        hAlign = "GridData.CENTER";
        break;
      default :
        hAlign = "Undefined " + horizontalAlignment;
        break;
    }
    var vAlign: String = "";
    switch (verticalAlignment) {
      case 4 :
        vAlign = "SWT.FILL";
        break;
      case 1 :
        vAlign = "SWT.BEGINNING";
        break;
      case 128 :
        vAlign = "SWT.TOP";
        break;
      case 16777224 :
        vAlign = "SWT.END";
        break;
      case 3 :
        vAlign = "GridData.END";
        break;
      case 1024 :
        vAlign = "SWT.BOTTOM";
        break;
      case 16777216 :
        vAlign = "SWT.CENTER";
        break;
      case 2 :
        vAlign = "GridData.CENTER";
        break;
      default :
        vAlign = "Undefined " + verticalAlignment;
        break;
    }
    var string: String = this.getName__() + " {";
    string += "horizontalAlignment=" + hAlign + " ";
    if (horizontalIndent != 0)
      string += "horizontalIndent=" + horizontalIndent + " ";
    if (horizontalSpan != 1)
      string += "horizontalSpan=" + horizontalSpan + " ";
    if (grabExcessHorizontalSpace)
      string += "grabExcessHorizontalSpace=" + grabExcessHorizontalSpace + " ";
    if (widthHint != -1)
      string += "widthHint=" + widthHint + " ";
    if (minimumWidth != 0)
      string += "minimumWidth=" + minimumWidth + " ";
    string += "verticalAlignment=" + vAlign + " ";
    if (verticalIndent != 0)
      string += "verticalIndent=" + verticalIndent + " ";
    if (verticalSpan != 1)
      string += "verticalSpan=" + verticalSpan + " ";
    if (grabExcessVerticalSpace)
      string += "grabExcessVerticalSpace=" + grabExcessVerticalSpace + " ";
    if (heightHint != -1)
      string += "heightHint=" + heightHint + " ";
    if (minimumHeight != 0)
      string += "minimumHeight=" + minimumHeight + " ";
    if (exclude)
      string += "exclude=" + exclude + " ";
    string = Object(string).trim__();
    string += "}";
    return string;
  }
  public function GridData(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is int) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 4 && vargs[0] is int && vargs[1] is int && vargs[2] is Boolean && vargs[3] is Boolean) {
        args = vargs;
        id = 2;
      } else if (vargs.length == 6 && vargs[0] is int && vargs[1] is int && vargs[2] is Boolean && vargs[3] is Boolean && vargs[4] is int && vargs[5] is int) {
        args = vargs;
        id = 3;
      } else if (vargs.length == 2 && vargs[0] is int && vargs[1] is int) {
        args = vargs;
        id = 4;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0]];
        break;
      case 2:
        var args2: Array = [args[0], args[1], args[2], args[3]];
        args3 = [args2[0], args2[1], args2[2], args2[3], 1, 1];
        break;
      case 3:
        var args3: Array = [args[0], args[1], args[2], args[3], args[4], args[5]];
        break;
      case 4:
        var args4: Array = [args[0], args[1]];
        break;
    }
    super();
    switch (id) {
      case 0:
        GridData__();
        break;
      case 1:
        GridData__I(args1[0]);
        break;
      case 2:
        GridData__IIZZII(args3[0], args3[1], args3[2], args3[3], args3[4], args3[5]);
        GridData__IIZZ(args2[0], args2[1], args2[2], args2[3]);
        break;
      case 3:
        GridData__IIZZII(args3[0], args3[1], args3[2], args3[3], args3[4], args3[5]);
        break;
      case 4:
        GridData__II(args4[0], args4[1]);
        break;
    }
  }
  public static const GridData__ : int = 0;
  public static const GridData__I : int = 1;
  public static const GridData__IIZZ : int = 2;
  public static const GridData__IIZZII : int = 3;
  public static const GridData__II : int = 4;
}
}
