package org.eclipse.swt.layout {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Control;
import java.lang.Math__;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Scrollable;
import java.lang.System;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class GridLayout extends Layout {
  public var numColumns: int = 1;
  public var makeColumnsEqualWidth: Boolean = false;
  public var marginWidth: int = 5;
  public var marginHeight: int = 5;
  public var marginLeft: int = 0;
  public var marginTop: int = 0;
  public var marginRight: int = 0;
  public var marginBottom: int = 0;
  public var horizontalSpacing: int = 5;
  public var verticalSpacing: int = 5;
  public function GridLayout__(): Object {
    return this;
  }
  public function GridLayout__IZ(numColumns: int, makeColumnsEqualWidth: Boolean): Object {
    this.numColumns = numColumns;
    this.makeColumnsEqualWidth = makeColumnsEqualWidth;
    return this;
  }
  public override function computeSize__Lorg_eclipse_swt_widgets_Composite_2IIZ(composite: Composite, wHint: int, hHint: int, flushCache: Boolean): Point {
    var size: Point = this.layout__Lorg_eclipse_swt_widgets_Composite_2ZIIIIZ(composite, false, 0, 0, wHint, hHint, flushCache);
    if (wHint != -1)
      size.x = wHint;
    if (hHint != -1)
      size.y = hHint;
    return size;
  }
  public override function flushCache__Lorg_eclipse_swt_widgets_Control_2(control: Control): Boolean {
    var data: Object = control.getLayoutData__();
    if (data !== null)
      (GridData(data)).flushCache__();
    return true;
  }
  public function getData___3_3Lorg_eclipse_swt_widgets_Control_2IIIIZ(grid: JavaArray, row: int, column: int, rowCount: int, columnCount: int, first: Boolean): GridData {
    var control: Control = grid[row][column];
    if (control !== null) {
      var data: GridData = GridData(control.getLayoutData__());
      var hSpan: int = Math__.max__II(1, Math__.min__II(data.horizontalSpan, columnCount));
      var vSpan: int = Math__.max__II(1, data.verticalSpan);
      var i: int = first ? row + vSpan - 1 : row - vSpan + 1;
      var j: int = first ? column + hSpan - 1 : column - hSpan + 1;
      if (0 <= i && i < rowCount) {
        if (0 <= j && j < columnCount) {
          if (control === grid[i][j])
            return data;
        }
      }
    }
    return null;
  }
  public override function layout__Lorg_eclipse_swt_widgets_Composite_2Z(composite: Composite, flushCache: Boolean): void {
    var rect: Rectangle = composite.getClientArea__();
    this.layout__Lorg_eclipse_swt_widgets_Composite_2ZIIIIZ(composite, true, rect.x, rect.y, rect.width, rect.height, flushCache);
  }
  public function layout__Lorg_eclipse_swt_widgets_Composite_2ZIIIIZ(composite: Composite, move: Boolean, x: int, y: int, width: int, height: int, flushCache: Boolean): Point {
    if (numColumns < 1) {
      return new Point(marginLeft + marginWidth * 2 + marginRight, marginTop + marginHeight * 2 + marginBottom);
    }
    var children: JavaArray = composite.getChildren__();
    var count: int = 0;
    for (var i: int = 0; i < children.length; i++) {
      var control: Control = children[i];
      var data: GridData = GridData(control.getLayoutData__());
      if (data === null || !data.exclude) {
        children[count++] = children[i];
      }
    }
    if (count == 0) {
      return new Point(marginLeft + marginWidth * 2 + marginRight, marginTop + marginHeight * 2 + marginBottom);
    }
    for (var i_1: int = 0; i_1 < count; i_1++) {
      var child: Control = children[i_1];
      var data_1: GridData = GridData(child.getLayoutData__());
      if (data_1 === null)
        child.setLayoutData__Ljava_lang_Object_2(data_1 = new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__, [])));
      if (flushCache)
        data_1.flushCache__();
      data_1.computeSize__Lorg_eclipse_swt_widgets_Control_2IIZ(child, data_1.widthHint, data_1.heightHint, flushCache);
      if (data_1.grabExcessHorizontalSpace && data_1.minimumWidth > 0) {
        if (data_1.cacheWidth < data_1.minimumWidth) {
          var trim: int = 0;
          if (child is Scrollable) {
            var rect: Rectangle = (Scrollable(child)).computeTrim__IIII(0, 0, 0, 0);
            trim = rect.width;
          } else {
            trim = child.getBorderWidth__() * 2;
          }
          data_1.cacheWidth = data_1.cacheHeight = -1;
          data_1.computeSize__Lorg_eclipse_swt_widgets_Control_2IIZ(child, Math__.max__II(0, data_1.minimumWidth - trim), data_1.heightHint, false);
        }
      }
      if (data_1.grabExcessVerticalSpace && data_1.minimumHeight > 0) {
        data_1.cacheHeight = Math__.max__II(data_1.cacheHeight, data_1.minimumHeight);
      }
    }
    var row: int = 0;
    var column: int = 0;
    var rowCount: int = 0;
    var columnCount: int = numColumns;
    var grid: JavaArray = new JavaArray("[[Lorg/eclipse/swt/widgets/Control;").lengths(4, columnCount);
    for (var i_2: int = 0; i_2 < count; i_2++) {
      var child_1: Control = children[i_2];
      var data_2: GridData = GridData(child_1.getLayoutData__());
      var hSpan: int = Math__.max__II(1, Math__.min__II(data_2.horizontalSpan, columnCount));
      var vSpan: int = Math__.max__II(1, data_2.verticalSpan);
      while (true) {
        var lastRow: int = row + vSpan;
        if (lastRow >= grid.length) {
          var newGrid: JavaArray = new JavaArray("[[Lorg/eclipse/swt/widgets/Control;").lengths(lastRow + 4, columnCount);
          System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(grid, 0, newGrid, 0, grid.length);
          grid = newGrid;
        }
        if (grid[row] === null) {
          grid[row] = new JavaArray("[Lorg/eclipse/swt/widgets/Control;").lengths(columnCount);
        }
        while (column < columnCount && grid[row][column] !== null) {
          column++;
        }
        var endCount: int = column + hSpan;
        if (endCount <= columnCount) {
          var index: int = column;
          while (index < endCount && grid[row][index] === null) {
            index++;
          }
          if (index == endCount)
            break;
          column = index;
        }
        if (column + hSpan >= columnCount) {
          column = 0;
          row++;
        }
      }
      for (var j: int = 0; j < vSpan; j++) {
        if (grid[row + j] === null) {
          grid[row + j] = new JavaArray("[Lorg/eclipse/swt/widgets/Control;").lengths(columnCount);
        }
        for (var k: int = 0; k < hSpan; k++) {
          grid[row + j][column + k] = child_1;
        }
      }
      rowCount = Math__.max__II(rowCount, row + vSpan);
      column += hSpan;
    }
    var availableWidth: int = width - horizontalSpacing * (columnCount - 1) - (marginLeft + marginWidth * 2 + marginRight);
    var expandCount: int = 0;
    var widths: JavaArray = new JavaArray("[I").lengths(columnCount);
    var minWidths: JavaArray = new JavaArray("[I").lengths(columnCount);
    var expandColumn: JavaArray = new JavaArray("[Z").lengths(columnCount);
    for (var j_1: int = 0; j_1 < columnCount; j_1++) {
      for (var i_3: int = 0; i_3 < rowCount; i_3++) {
        var data_3: GridData = this.getData___3_3Lorg_eclipse_swt_widgets_Control_2IIIIZ(grid, i_3, j_1, rowCount, columnCount, true);
        if (data_3 !== null) {
          var hSpan_1: int = Math__.max__II(1, Math__.min__II(data_3.horizontalSpan, columnCount));
          if (hSpan_1 == 1) {
            var w: int = data_3.cacheWidth + data_3.horizontalIndent;
            widths[j_1] = Math__.max__II(widths[j_1], w);
            if (data_3.grabExcessHorizontalSpace) {
              if (!expandColumn[j_1])
                expandCount++;
              expandColumn[j_1] = true;
            }
            if (!data_3.grabExcessHorizontalSpace || data_3.minimumWidth != 0) {
              w = !data_3.grabExcessHorizontalSpace || data_3.minimumWidth == -1 ? data_3.cacheWidth : data_3.minimumWidth;
              w += data_3.horizontalIndent;
              minWidths[j_1] = Math__.max__II(minWidths[j_1], w);
            }
          }
        }
      }
      for (var i_4: int = 0; i_4 < rowCount; i_4++) {
        var data_4: GridData = this.getData___3_3Lorg_eclipse_swt_widgets_Control_2IIIIZ(grid, i_4, j_1, rowCount, columnCount, false);
        if (data_4 !== null) {
          var hSpan_2: int = Math__.max__II(1, Math__.min__II(data_4.horizontalSpan, columnCount));
          if (hSpan_2 > 1) {
            var spanWidth: int = 0;
            var spanMinWidth: int = 0;
            var spanExpandCount: int = 0;
            for (var k_1: int = 0; k_1 < hSpan_2; k_1++) {
              spanWidth += widths[j_1 - k_1];
              spanMinWidth += minWidths[j_1 - k_1];
              if (expandColumn[j_1 - k_1])
                spanExpandCount++;
            }
            if (data_4.grabExcessHorizontalSpace && spanExpandCount == 0) {
              expandCount++;
              expandColumn[j_1] = true;
            }
            var w_1: int = data_4.cacheWidth + data_4.horizontalIndent - spanWidth - (hSpan_2 - 1) * horizontalSpacing;
            if (w_1 > 0) {
              if (makeColumnsEqualWidth) {
                var equalWidth: int = int((w_1 + spanWidth) / hSpan_2);
                var remainder: int = (w_1 + spanWidth) % hSpan_2;
                var last: int = -1;
                for (var k_2: int = 0; k_2 < hSpan_2; k_2++) {
                  widths[last = j_1 - k_2] = Math__.max__II(equalWidth, widths[j_1 - k_2]);
                }
                if (last > -1)
                  widths[last] += remainder;
              } else {
                if (spanExpandCount == 0) {
                  widths[j_1] += w_1;
                } else {
                  var delta: int = int(w_1 / spanExpandCount);
                  var remainder_1: int = w_1 % spanExpandCount;
                  var last_1: int = -1;
                  for (var k_3: int = 0; k_3 < hSpan_2; k_3++) {
                    if (expandColumn[j_1 - k_3]) {
                      widths[last_1 = j_1 - k_3] += delta;
                    }
                  }
                  if (last_1 > -1)
                    widths[last_1] += remainder_1;
                }
              }
            }
            if (!data_4.grabExcessHorizontalSpace || data_4.minimumWidth != 0) {
              w_1 = !data_4.grabExcessHorizontalSpace || data_4.minimumWidth == -1 ? data_4.cacheWidth : data_4.minimumWidth;
              w_1 += data_4.horizontalIndent - spanMinWidth - (hSpan_2 - 1) * horizontalSpacing;
              if (w_1 > 0) {
                if (spanExpandCount == 0) {
                  minWidths[j_1] += w_1;
                } else {
                  var delta_1: int = int(w_1 / spanExpandCount);
                  var remainder_2: int = w_1 % spanExpandCount;
                  var last_2: int = -1;
                  for (var k_4: int = 0; k_4 < hSpan_2; k_4++) {
                    if (expandColumn[j_1 - k_4]) {
                      minWidths[last_2 = j_1 - k_4] += delta_1;
                    }
                  }
                  if (last_2 > -1)
                    minWidths[last_2] += remainder_2;
                }
              }
            }
          }
        }
      }
    }
    if (makeColumnsEqualWidth) {
      var minColumnWidth: int = 0;
      var columnWidth: int = 0;
      for (var i_5: int = 0; i_5 < columnCount; i_5++) {
        minColumnWidth = Math__.max__II(minColumnWidth, minWidths[i_5]);
        columnWidth = Math__.max__II(columnWidth, widths[i_5]);
      }
      columnWidth = width == -1 || expandCount == 0 ? columnWidth : Math__.max__II(minColumnWidth, int(availableWidth / columnCount));
      for (var i_6: int = 0; i_6 < columnCount; i_6++) {
        expandColumn[i_6] = expandCount > 0;
        widths[i_6] = columnWidth;
      }
    } else {
      if (width != -1 && expandCount > 0) {
        var totalWidth: int = 0;
        for (var i_7: int = 0; i_7 < columnCount; i_7++) {
          totalWidth += widths[i_7];
        }
        var c: int = expandCount;
        var delta_2: int = int((availableWidth - totalWidth) / c);
        var remainder_3: int = (availableWidth - totalWidth) % c;
        var last_3: int = -1;
        while (totalWidth != availableWidth) {
          for (var j_2: int = 0; j_2 < columnCount; j_2++) {
            if (expandColumn[j_2]) {
              if (widths[j_2] + delta_2 > minWidths[j_2]) {
                widths[last_3 = j_2] = widths[j_2] + delta_2;
              } else {
                widths[j_2] = minWidths[j_2];
                expandColumn[j_2] = false;
                c--;
              }
            }
          }
          if (last_3 > -1)
            widths[last_3] += remainder_3;
          for (var j_3: int = 0; j_3 < columnCount; j_3++) {
            for (var i_8: int = 0; i_8 < rowCount; i_8++) {
              var data_5: GridData = this.getData___3_3Lorg_eclipse_swt_widgets_Control_2IIIIZ(grid, i_8, j_3, rowCount, columnCount, false);
              if (data_5 !== null) {
                var hSpan_3: int = Math__.max__II(1, Math__.min__II(data_5.horizontalSpan, columnCount));
                if (hSpan_3 > 1) {
                  if (!data_5.grabExcessHorizontalSpace || data_5.minimumWidth != 0) {
                    var spanWidth_1: int = 0;
                    var spanExpandCount_1: int = 0;
                    for (var k_5: int = 0; k_5 < hSpan_3; k_5++) {
                      spanWidth_1 += widths[j_3 - k_5];
                      if (expandColumn[j_3 - k_5])
                        spanExpandCount_1++;
                    }
                    var w_2: int = !data_5.grabExcessHorizontalSpace || data_5.minimumWidth == -1 ? data_5.cacheWidth : data_5.minimumWidth;
                    w_2 += data_5.horizontalIndent - spanWidth_1 - (hSpan_3 - 1) * horizontalSpacing;
                    if (w_2 > 0) {
                      if (spanExpandCount_1 == 0) {
                        widths[j_3] += w_2;
                      } else {
                        var delta2: int = int(w_2 / spanExpandCount_1);
                        var remainder2: int = w_2 % spanExpandCount_1;
                        var last2: int = -1;
                        for (var k_6: int = 0; k_6 < hSpan_3; k_6++) {
                          if (expandColumn[j_3 - k_6]) {
                            widths[last2 = j_3 - k_6] += delta2;
                          }
                        }
                        if (last2 > -1)
                          widths[last2] += remainder2;
                      }
                    }
                  }
                }
              }
            }
          }
          if (c == 0)
            break;
          totalWidth = 0;
          for (var i_9: int = 0; i_9 < columnCount; i_9++) {
            totalWidth += widths[i_9];
          }
          delta_2 = int((availableWidth - totalWidth) / c);
          remainder_3 = (availableWidth - totalWidth) % c;
          last_3 = -1;
        }
      }
    }
    var flush: JavaArray = null;
    var flushLength: int = 0;
    if (width != -1) {
      for (var j_4: int = 0; j_4 < columnCount; j_4++) {
        for (var i_10: int = 0; i_10 < rowCount; i_10++) {
          var data_6: GridData = this.getData___3_3Lorg_eclipse_swt_widgets_Control_2IIIIZ(grid, i_10, j_4, rowCount, columnCount, false);
          if (data_6 !== null) {
            if (data_6.heightHint == -1) {
              var child_2: Control = grid[i_10][j_4];
              var hSpan_4: int = Math__.max__II(1, Math__.min__II(data_6.horizontalSpan, columnCount));
              var currentWidth: int = 0;
              for (var k_7: int = 0; k_7 < hSpan_4; k_7++) {
                currentWidth += widths[j_4 - k_7];
              }
              currentWidth += (hSpan_4 - 1) * horizontalSpacing - data_6.horizontalIndent;
              if ((currentWidth != data_6.cacheWidth && data_6.horizontalAlignment == 4) || (data_6.cacheWidth > currentWidth)) {
                var trim_1: int = 0;
                if (child_2 is Scrollable) {
                  var rect_1: Rectangle = (Scrollable(child_2)).computeTrim__IIII(0, 0, 0, 0);
                  trim_1 = rect_1.width;
                } else {
                  trim_1 = child_2.getBorderWidth__() * 2;
                }
                data_6.cacheWidth = data_6.cacheHeight = -1;
                data_6.computeSize__Lorg_eclipse_swt_widgets_Control_2IIZ(child_2, Math__.max__II(0, currentWidth - trim_1), data_6.heightHint, false);
                if (data_6.grabExcessVerticalSpace && data_6.minimumHeight > 0) {
                  data_6.cacheHeight = Math__.max__II(data_6.cacheHeight, data_6.minimumHeight);
                }
                if (flush === null)
                  flush = new JavaArray("[Lorg/eclipse/swt/layout/GridData;").lengths(count);
                flush[flushLength++] = data_6;
              }
            }
          }
        }
      }
    }
    var availableHeight: int = height - verticalSpacing * (rowCount - 1) - (marginTop + marginHeight * 2 + marginBottom);
    expandCount = 0;
    var heights: JavaArray = new JavaArray("[I").lengths(rowCount);
    var minHeights: JavaArray = new JavaArray("[I").lengths(rowCount);
    var expandRow: JavaArray = new JavaArray("[Z").lengths(rowCount);
    for (var i_11: int = 0; i_11 < rowCount; i_11++) {
      for (var j_5: int = 0; j_5 < columnCount; j_5++) {
        var data_7: GridData = this.getData___3_3Lorg_eclipse_swt_widgets_Control_2IIIIZ(grid, i_11, j_5, rowCount, columnCount, true);
        if (data_7 !== null) {
          var vSpan_1: int = Math__.max__II(1, Math__.min__II(data_7.verticalSpan, rowCount));
          if (vSpan_1 == 1) {
            var h: int = data_7.cacheHeight + data_7.verticalIndent;
            heights[i_11] = Math__.max__II(heights[i_11], h);
            if (data_7.grabExcessVerticalSpace) {
              if (!expandRow[i_11])
                expandCount++;
              expandRow[i_11] = true;
            }
            if (!data_7.grabExcessVerticalSpace || data_7.minimumHeight != 0) {
              h = !data_7.grabExcessVerticalSpace || data_7.minimumHeight == -1 ? data_7.cacheHeight : data_7.minimumHeight;
              h += data_7.verticalIndent;
              minHeights[i_11] = Math__.max__II(minHeights[i_11], h);
            }
          }
        }
      }
      for (var j_6: int = 0; j_6 < columnCount; j_6++) {
        var data_8: GridData = this.getData___3_3Lorg_eclipse_swt_widgets_Control_2IIIIZ(grid, i_11, j_6, rowCount, columnCount, false);
        if (data_8 !== null) {
          var vSpan_2: int = Math__.max__II(1, Math__.min__II(data_8.verticalSpan, rowCount));
          if (vSpan_2 > 1) {
            var spanHeight: int = 0;
            var spanMinHeight: int = 0;
            var spanExpandCount_2: int = 0;
            for (var k_8: int = 0; k_8 < vSpan_2; k_8++) {
              spanHeight += heights[i_11 - k_8];
              spanMinHeight += minHeights[i_11 - k_8];
              if (expandRow[i_11 - k_8])
                spanExpandCount_2++;
            }
            if (data_8.grabExcessVerticalSpace && spanExpandCount_2 == 0) {
              expandCount++;
              expandRow[i_11] = true;
            }
            var h_1: int = data_8.cacheHeight + data_8.verticalIndent - spanHeight - (vSpan_2 - 1) * verticalSpacing;
            if (h_1 > 0) {
              if (spanExpandCount_2 == 0) {
                heights[i_11] += h_1;
              } else {
                var delta_3: int = int(h_1 / spanExpandCount_2);
                var remainder_4: int = h_1 % spanExpandCount_2;
                var last_4: int = -1;
                for (var k_9: int = 0; k_9 < vSpan_2; k_9++) {
                  if (expandRow[i_11 - k_9]) {
                    heights[last_4 = i_11 - k_9] += delta_3;
                  }
                }
                if (last_4 > -1)
                  heights[last_4] += remainder_4;
              }
            }
            if (!data_8.grabExcessVerticalSpace || data_8.minimumHeight != 0) {
              h_1 = !data_8.grabExcessVerticalSpace || data_8.minimumHeight == -1 ? data_8.cacheHeight : data_8.minimumHeight;
              h_1 += data_8.verticalIndent - spanMinHeight - (vSpan_2 - 1) * verticalSpacing;
              if (h_1 > 0) {
                if (spanExpandCount_2 == 0) {
                  minHeights[i_11] += h_1;
                } else {
                  var delta_4: int = int(h_1 / spanExpandCount_2);
                  var remainder_5: int = h_1 % spanExpandCount_2;
                  var last_5: int = -1;
                  for (var k_10: int = 0; k_10 < vSpan_2; k_10++) {
                    if (expandRow[i_11 - k_10]) {
                      minHeights[last_5 = i_11 - k_10] += delta_4;
                    }
                  }
                  if (last_5 > -1)
                    minHeights[last_5] += remainder_5;
                }
              }
            }
          }
        }
      }
    }
    if (height != -1 && expandCount > 0) {
      var totalHeight: int = 0;
      for (var i_12: int = 0; i_12 < rowCount; i_12++) {
        totalHeight += heights[i_12];
      }
      var c_1: int = expandCount;
      var delta_5: int = int((availableHeight - totalHeight) / c_1);
      var remainder_6: int = (availableHeight - totalHeight) % c_1;
      var last_6: int = -1;
      while (totalHeight != availableHeight) {
        for (var i_13: int = 0; i_13 < rowCount; i_13++) {
          if (expandRow[i_13]) {
            if (heights[i_13] + delta_5 > minHeights[i_13]) {
              heights[last_6 = i_13] = heights[i_13] + delta_5;
            } else {
              heights[i_13] = minHeights[i_13];
              expandRow[i_13] = false;
              c_1--;
            }
          }
        }
        if (last_6 > -1)
          heights[last_6] += remainder_6;
        for (var i_14: int = 0; i_14 < rowCount; i_14++) {
          for (var j_7: int = 0; j_7 < columnCount; j_7++) {
            var data_9: GridData = this.getData___3_3Lorg_eclipse_swt_widgets_Control_2IIIIZ(grid, i_14, j_7, rowCount, columnCount, false);
            if (data_9 !== null) {
              var vSpan_3: int = Math__.max__II(1, Math__.min__II(data_9.verticalSpan, rowCount));
              if (vSpan_3 > 1) {
                if (!data_9.grabExcessVerticalSpace || data_9.minimumHeight != 0) {
                  var spanHeight_1: int = 0;
                  var spanExpandCount_3: int = 0;
                  for (var k_11: int = 0; k_11 < vSpan_3; k_11++) {
                    spanHeight_1 += heights[i_14 - k_11];
                    if (expandRow[i_14 - k_11])
                      spanExpandCount_3++;
                  }
                  var h_2: int = !data_9.grabExcessVerticalSpace || data_9.minimumHeight == -1 ? data_9.cacheHeight : data_9.minimumHeight;
                  h_2 += data_9.verticalIndent - spanHeight_1 - (vSpan_3 - 1) * verticalSpacing;
                  if (h_2 > 0) {
                    if (spanExpandCount_3 == 0) {
                      heights[i_14] += h_2;
                    } else {
                      var delta2_1: int = int(h_2 / spanExpandCount_3);
                      var remainder2_1: int = h_2 % spanExpandCount_3;
                      var last2_1: int = -1;
                      for (var k_12: int = 0; k_12 < vSpan_3; k_12++) {
                        if (expandRow[i_14 - k_12]) {
                          heights[last2_1 = i_14 - k_12] += delta2_1;
                        }
                      }
                      if (last2_1 > -1)
                        heights[last2_1] += remainder2_1;
                    }
                  }
                }
              }
            }
          }
        }
        if (c_1 == 0)
          break;
        totalHeight = 0;
        for (var i_15: int = 0; i_15 < rowCount; i_15++) {
          totalHeight += heights[i_15];
        }
        delta_5 = int((availableHeight - totalHeight) / c_1);
        remainder_6 = (availableHeight - totalHeight) % c_1;
        last_6 = -1;
      }
    }
    if (move) {
      var gridY: int = y + marginTop + marginHeight;
      for (var i_16: int = 0; i_16 < rowCount; i_16++) {
        var gridX: int = x + marginLeft + marginWidth;
        for (var j_8: int = 0; j_8 < columnCount; j_8++) {
          var data_10: GridData = this.getData___3_3Lorg_eclipse_swt_widgets_Control_2IIIIZ(grid, i_16, j_8, rowCount, columnCount, true);
          if (data_10 !== null) {
            var hSpan_5: int = Math__.max__II(1, Math__.min__II(data_10.horizontalSpan, columnCount));
            var vSpan_4: int = Math__.max__II(1, data_10.verticalSpan);
            var cellWidth: int = 0;
            var cellHeight: int = 0;
            for (var k_13: int = 0; k_13 < hSpan_5; k_13++) {
              cellWidth += widths[j_8 + k_13];
            }
            for (var k_14: int = 0; k_14 < vSpan_4; k_14++) {
              cellHeight += heights[i_16 + k_14];
            }
            cellWidth += horizontalSpacing * (hSpan_5 - 1);
            var childX: int = gridX + data_10.horizontalIndent;
            var childWidth: int = Math__.min__II(data_10.cacheWidth, cellWidth);
            switch (data_10.horizontalAlignment) {
              case 16777216 :
              case 2 :
                childX += Math__.max__II(0, int((cellWidth - data_10.horizontalIndent - childWidth) / 2));
                break;
              case 131072 :
              case 16777224 :
              case 3 :
                childX += Math__.max__II(0, cellWidth - data_10.horizontalIndent - childWidth);
                break;
              case 4 :
                childWidth = cellWidth - data_10.horizontalIndent;
                break;
            }
            cellHeight += verticalSpacing * (vSpan_4 - 1);
            var childY: int = gridY + data_10.verticalIndent;
            var childHeight: int = Math__.min__II(data_10.cacheHeight, cellHeight);
            switch (data_10.verticalAlignment) {
              case 16777216 :
              case 2 :
                childY += Math__.max__II(0, int((cellHeight - data_10.verticalIndent - childHeight) / 2));
                break;
              case 1024 :
              case 16777224 :
              case 3 :
                childY += Math__.max__II(0, cellHeight - data_10.verticalIndent - childHeight);
                break;
              case 4 :
                childHeight = cellHeight - data_10.verticalIndent;
                break;
            }
            var child_3: Control = grid[i_16][j_8];
            if (child_3 !== null) {
              child_3.setBounds__IIII(childX, childY, childWidth, childHeight);
            }
          }
          gridX += widths[j_8] + horizontalSpacing;
        }
        gridY += heights[i_16] + verticalSpacing;
      }
    }
    for (var i_17: int = 0; i_17 < flushLength; i_17++) {
      flush[i_17].cacheWidth = flush[i_17].cacheHeight = -1;
    }
    var totalDefaultWidth: int = 0;
    var totalDefaultHeight: int = 0;
    for (var i_18: int = 0; i_18 < columnCount; i_18++) {
      totalDefaultWidth += widths[i_18];
    }
    for (var i_19: int = 0; i_19 < rowCount; i_19++) {
      totalDefaultHeight += heights[i_19];
    }
    totalDefaultWidth += horizontalSpacing * (columnCount - 1) + marginLeft + marginWidth * 2 + marginRight;
    totalDefaultHeight += verticalSpacing * (rowCount - 1) + marginTop + marginHeight * 2 + marginBottom;
    return new Point(totalDefaultWidth, totalDefaultHeight);
  }
  public function getName__(): String {
    var string: String = Object(this).getClass__().getName__();
    var index: int = Object(string).lastIndexOf__I(46);
    if (index == -1)
      return string;
    return Object(string).substring__II(index + 1, Object(string).length__());
  }
  public function toString__(): String {
    var string: String = this.getName__() + " {";
    if (numColumns != 1)
      string += "numColumns=" + numColumns + " ";
    if (makeColumnsEqualWidth)
      string += "makeColumnsEqualWidth=" + makeColumnsEqualWidth + " ";
    if (marginWidth != 0)
      string += "marginWidth=" + marginWidth + " ";
    if (marginHeight != 0)
      string += "marginHeight=" + marginHeight + " ";
    if (marginLeft != 0)
      string += "marginLeft=" + marginLeft + " ";
    if (marginRight != 0)
      string += "marginRight=" + marginRight + " ";
    if (marginTop != 0)
      string += "marginTop=" + marginTop + " ";
    if (marginBottom != 0)
      string += "marginBottom=" + marginBottom + " ";
    if (horizontalSpacing != 0)
      string += "horizontalSpacing=" + horizontalSpacing + " ";
    if (verticalSpacing != 0)
      string += "verticalSpacing=" + verticalSpacing + " ";
    string = Object(string).trim__();
    string += "}";
    return string;
  }
  public function GridLayout(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 2 && vargs[0] is int && vargs[1] is Boolean) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0], args[1]];
        break;
    }
    super();
    switch (id) {
      case 0:
        GridLayout__();
        break;
      case 1:
        GridLayout__IZ(args1[0], args1[1]);
        break;
    }
  }
  public static const GridLayout__ : int = 0;
  public static const GridLayout__IZ : int = 1;
}
}
