package org.eclipse.swt.layout {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.graphics.Rectangle;
import java.lang.Math__;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class RowLayout extends Layout {
  public var type: int = 256;
  public var marginWidth: int = 0;
  public var marginHeight: int = 0;
  public var spacing: int = 3;
  public var wrap: Boolean = true;
  public var pack: Boolean = true;
  public var fill: Boolean = false;
  public var center: Boolean = false;
  public var justify: Boolean = false;
  public var marginLeft: int = 3;
  public var marginTop: int = 3;
  public var marginRight: int = 3;
  public var marginBottom: int = 3;
  public function RowLayout__(): Object {
    return this;
  }
  public function RowLayout__I(type: int): Object {
    this.type = type;
    return this;
  }
  public override function computeSize__Lorg_eclipse_swt_widgets_Composite_2IIZ(composite: Composite, wHint: int, hHint: int, flushCache: Boolean): Point {
    var extent: Point;
    if (type == 256) {
      extent = this.layoutHorizontal__Lorg_eclipse_swt_widgets_Composite_2ZZIZ(composite, false, (wHint != -1) && wrap, wHint, flushCache);
    } else {
      extent = this.layoutVertical__Lorg_eclipse_swt_widgets_Composite_2ZZIZ(composite, false, (hHint != -1) && wrap, hHint, flushCache);
    }
    if (wHint != -1)
      extent.x = wHint;
    if (hHint != -1)
      extent.y = hHint;
    return extent;
  }
  public function computeSize__Lorg_eclipse_swt_widgets_Control_2Z(control: Control, flushCache: Boolean): Point {
    var wHint: int = -1;
    var hHint: int = -1;
    var data: RowData = RowData(control.getLayoutData__());
    if (data !== null) {
      wHint = data.width;
      hHint = data.height;
    }
    return control.computeSize__IIZ(wHint, hHint, flushCache);
  }
  public override function flushCache__Lorg_eclipse_swt_widgets_Control_2(control: Control): Boolean {
    return true;
  }
  public function getName__(): String {
    var string: String = Object(this).getClass__().getName__();
    var index: int = Object(string).lastIndexOf__I(46);
    if (index == -1)
      return string;
    return Object(string).substring__II(index + 1, Object(string).length__());
  }
  public override function layout__Lorg_eclipse_swt_widgets_Composite_2Z(composite: Composite, flushCache: Boolean): void {
    var clientArea: Rectangle = composite.getClientArea__();
    if (type == 256) {
      this.layoutHorizontal__Lorg_eclipse_swt_widgets_Composite_2ZZIZ(composite, true, wrap, clientArea.width, flushCache);
    } else {
      this.layoutVertical__Lorg_eclipse_swt_widgets_Composite_2ZZIZ(composite, true, wrap, clientArea.height, flushCache);
    }
    return;
  }
  public function layoutHorizontal__Lorg_eclipse_swt_widgets_Composite_2ZZIZ(composite: Composite, move: Boolean, wrap_1: Boolean, width: int, flushCache: Boolean): Point {
    var children: JavaArray = composite.getChildren__();
    var count: int = 0;
    for (var i: int = 0; i < children.length; i++) {
      var control: Control = children[i];
      var data: RowData = RowData(control.getLayoutData__());
      if (data === null || !data.exclude) {
        children[count++] = children[i];
      }
    }
    if (count == 0) {
      return new Point(marginLeft + marginWidth * 2 + marginRight, marginTop + marginHeight * 2 + marginBottom);
    }
    var childWidth: int = 0;
    var childHeight: int = 0;
    var maxHeight: int = 0;
    if (!pack) {
      for (var i_1: int = 0; i_1 < count; i_1++) {
        var child: Control = children[i_1];
        var size: Point = this.computeSize__Lorg_eclipse_swt_widgets_Control_2Z(child, flushCache);
        childWidth = Math__.max__II(childWidth, size.x);
        childHeight = Math__.max__II(childHeight, size.y);
      }
      maxHeight = childHeight;
    }
    var clientX: int = 0;
    var clientY: int = 0;
    if (move) {
      var rect: Rectangle = composite.getClientArea__();
      clientX = rect.x;
      clientY = rect.y;
    }
    var wraps: JavaArray = null;
    var wrapped: Boolean = false;
    var bounds: JavaArray = null;
    if (move && (justify || fill || center)) {
      bounds = new JavaArray("[Lorg/eclipse/swt/graphics/Rectangle;").lengths(count);
      wraps = new JavaArray("[I").lengths(count);
    }
    var maxX: int = 0;
    var x: int = marginLeft + marginWidth;
    var y: int = marginTop + marginHeight;
    for (var i_2: int = 0; i_2 < count; i_2++) {
      var child_1: Control = children[i_2];
      if (pack) {
        var size_1: Point = this.computeSize__Lorg_eclipse_swt_widgets_Control_2Z(child_1, flushCache);
        childWidth = size_1.x;
        childHeight = size_1.y;
      }
      if (wrap_1 && (i_2 != 0) && (x + childWidth > width)) {
        wrapped = true;
        if (move && (justify || fill || center))
          wraps[i_2 - 1] = maxHeight;
        x = marginLeft + marginWidth;
        y += spacing + maxHeight;
        if (pack)
          maxHeight = 0;
      }
      if (pack || fill || center) {
        maxHeight = Math__.max__II(maxHeight, childHeight);
      }
      if (move) {
        var childX: int = x + clientX;
        var childY: int = y + clientY;
        if (justify || fill || center) {
          bounds[i_2] = new Rectangle(childX, childY, childWidth, childHeight);
        } else {
          child_1.setBounds__IIII(childX, childY, childWidth, childHeight);
        }
      }
      x += spacing + childWidth;
      maxX = Math__.max__II(maxX, x);
    }
    maxX = Math__.max__II(clientX + marginLeft + marginWidth, maxX - spacing);
    if (!wrapped)
      maxX += marginRight + marginWidth;
    if (move && (justify || fill || center)) {
      var space: int = 0;
      var margin: int = 0;
      if (!wrapped) {
        space = Math__.max__II(0, int((width - maxX) / (count + 1)));
        margin = Math__.max__II(0, int(((width - maxX) % (count + 1)) / 2));
      } else {
        if (fill || justify || center) {
          var last: int = 0;
          if (count > 0)
            wraps[count - 1] = maxHeight;
          for (var i_3: int = 0; i_3 < count; i_3++) {
            if (wraps[i_3] != 0) {
              var wrapCount: int = i_3 - last + 1;
              if (justify) {
                var wrapX: int = 0;
                for (var j: int = last; j <= i_3; j++) {
                  wrapX += bounds[j].width + spacing;
                }
                space = Math__.max__II(0, int((width - wrapX) / (wrapCount + 1)));
                margin = Math__.max__II(0, int(((width - wrapX) % (wrapCount + 1)) / 2));
              }
              for (var j_1: int = last; j_1 <= i_3; j_1++) {
                if (justify)
                  bounds[j_1].x += (space * (j_1 - last + 1)) + margin;
                if (fill) {
                  bounds[j_1].height = wraps[i_3];
                } else {
                  if (center) {
                    bounds[j_1].y += Math__.max__II(0, int((wraps[i_3] - bounds[j_1].height) / 2));
                  }
                }
              }
              last = i_3 + 1;
            }
          }
        }
      }
      for (var i_4: int = 0; i_4 < count; i_4++) {
        if (!wrapped) {
          if (justify)
            bounds[i_4].x += (space * (i_4 + 1)) + margin;
          if (fill) {
            bounds[i_4].height = maxHeight;
          } else {
            if (center) {
              bounds[i_4].y += Math__.max__II(0, int((maxHeight - bounds[i_4].height) / 2));
            }
          }
        }
        children[i_4].setBounds__Lorg_eclipse_swt_graphics_Rectangle_2(bounds[i_4]);
      }
    }
    return new Point(maxX, y + maxHeight + marginBottom + marginHeight);
  }
  public function layoutVertical__Lorg_eclipse_swt_widgets_Composite_2ZZIZ(composite: Composite, move: Boolean, wrap_1: Boolean, height: int, flushCache: Boolean): Point {
    var children: JavaArray = composite.getChildren__();
    var count: int = 0;
    for (var i: int = 0; i < children.length; i++) {
      var control: Control = children[i];
      var data: RowData = RowData(control.getLayoutData__());
      if (data === null || !data.exclude) {
        children[count++] = children[i];
      }
    }
    if (count == 0) {
      return new Point(marginLeft + marginWidth * 2 + marginRight, marginTop + marginHeight * 2 + marginBottom);
    }
    var childWidth: int = 0;
    var childHeight: int = 0;
    var maxWidth: int = 0;
    if (!pack) {
      for (var i_1: int = 0; i_1 < count; i_1++) {
        var child: Control = children[i_1];
        var size: Point = this.computeSize__Lorg_eclipse_swt_widgets_Control_2Z(child, flushCache);
        childWidth = Math__.max__II(childWidth, size.x);
        childHeight = Math__.max__II(childHeight, size.y);
      }
      maxWidth = childWidth;
    }
    var clientX: int = 0;
    var clientY: int = 0;
    if (move) {
      var rect: Rectangle = composite.getClientArea__();
      clientX = rect.x;
      clientY = rect.y;
    }
    var wraps: JavaArray = null;
    var wrapped: Boolean = false;
    var bounds: JavaArray = null;
    if (move && (justify || fill || center)) {
      bounds = new JavaArray("[Lorg/eclipse/swt/graphics/Rectangle;").lengths(count);
      wraps = new JavaArray("[I").lengths(count);
    }
    var maxY: int = 0;
    var x: int = marginLeft + marginWidth;
    var y: int = marginTop + marginHeight;
    for (var i_2: int = 0; i_2 < count; i_2++) {
      var child_1: Control = children[i_2];
      if (pack) {
        var size_1: Point = this.computeSize__Lorg_eclipse_swt_widgets_Control_2Z(child_1, flushCache);
        childWidth = size_1.x;
        childHeight = size_1.y;
      }
      if (wrap_1 && (i_2 != 0) && (y + childHeight > height)) {
        wrapped = true;
        if (move && (justify || fill || center))
          wraps[i_2 - 1] = maxWidth;
        x += spacing + maxWidth;
        y = marginTop + marginHeight;
        if (pack)
          maxWidth = 0;
      }
      if (pack || fill || center) {
        maxWidth = Math__.max__II(maxWidth, childWidth);
      }
      if (move) {
        var childX: int = x + clientX;
        var childY: int = y + clientY;
        if (justify || fill || center) {
          bounds[i_2] = new Rectangle(childX, childY, childWidth, childHeight);
        } else {
          child_1.setBounds__IIII(childX, childY, childWidth, childHeight);
        }
      }
      y += spacing + childHeight;
      maxY = Math__.max__II(maxY, y);
    }
    maxY = Math__.max__II(clientY + marginTop + marginHeight, maxY - spacing);
    if (!wrapped)
      maxY += marginBottom + marginHeight;
    if (move && (justify || fill || center)) {
      var space: int = 0;
      var margin: int = 0;
      if (!wrapped) {
        space = Math__.max__II(0, int((height - maxY) / (count + 1)));
        margin = Math__.max__II(0, int(((height - maxY) % (count + 1)) / 2));
      } else {
        if (fill || justify || center) {
          var last: int = 0;
          if (count > 0)
            wraps[count - 1] = maxWidth;
          for (var i_3: int = 0; i_3 < count; i_3++) {
            if (wraps[i_3] != 0) {
              var wrapCount: int = i_3 - last + 1;
              if (justify) {
                var wrapY: int = 0;
                for (var j: int = last; j <= i_3; j++) {
                  wrapY += bounds[j].height + spacing;
                }
                space = Math__.max__II(0, int((height - wrapY) / (wrapCount + 1)));
                margin = Math__.max__II(0, int(((height - wrapY) % (wrapCount + 1)) / 2));
              }
              for (var j_1: int = last; j_1 <= i_3; j_1++) {
                if (justify)
                  bounds[j_1].y += (space * (j_1 - last + 1)) + margin;
                if (fill) {
                  bounds[j_1].width = wraps[i_3];
                } else {
                  if (center) {
                    bounds[j_1].x += Math__.max__II(0, int((wraps[i_3] - bounds[j_1].width) / 2));
                  }
                }
              }
              last = i_3 + 1;
            }
          }
        }
      }
      for (var i_4: int = 0; i_4 < count; i_4++) {
        if (!wrapped) {
          if (justify)
            bounds[i_4].y += (space * (i_4 + 1)) + margin;
          if (fill) {
            bounds[i_4].width = maxWidth;
          } else {
            if (center) {
              bounds[i_4].x += Math__.max__II(0, int((maxWidth - bounds[i_4].width) / 2));
            }
          }
        }
        children[i_4].setBounds__Lorg_eclipse_swt_graphics_Rectangle_2(bounds[i_4]);
      }
    }
    return new Point(x + maxWidth + marginRight + marginWidth, maxY);
  }
  public function toString__(): String {
    var string: String = this.getName__() + " {";
    string += "type=" + ((type != 256) ? "SWT.VERTICAL" : "SWT.HORIZONTAL") + " ";
    if (marginWidth != 0)
      string += "marginWidth=" + marginWidth + " ";
    if (marginHeight != 0)
      string += "marginHeight=" + marginHeight + " ";
    if (marginLeft != 0)
      string += "marginLeft=" + marginLeft + " ";
    if (marginTop != 0)
      string += "marginTop=" + marginTop + " ";
    if (marginRight != 0)
      string += "marginRight=" + marginRight + " ";
    if (marginBottom != 0)
      string += "marginBottom=" + marginBottom + " ";
    if (spacing != 0)
      string += "spacing=" + spacing + " ";
    string += "wrap=" + wrap + " ";
    string += "pack=" + pack + " ";
    string += "fill=" + fill + " ";
    string += "justify=" + justify + " ";
    string = Object(string).trim__();
    string += "}";
    return string;
  }
  public function RowLayout(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is int) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0]];
        break;
    }
    super();
    switch (id) {
      case 0:
        RowLayout__();
        break;
      case 1:
        RowLayout__I(args1[0]);
        break;
    }
  }
  public static const RowLayout__ : int = 0;
  public static const RowLayout__I : int = 1;
}
}
