package org.eclipse.swt.printing {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class Printer extends Device {
  internal var data: PrinterData;
  public static function getPrinterList__(): JavaArray {
    var printerList: JavaArray = new JavaArray("[Lorg/eclipse/swt/printing/PrinterData;").lengths(0);
    return printerList;
  }
  public static function getDefaultPrinterData__(): PrinterData {
    return null;
  }
  public static function checkNull__Lorg_eclipse_swt_printing_PrinterData_2(data: PrinterData): DeviceData {
    if (data === null)
      data = new PrinterData(new Arguments(org.eclipse.swt.printing.PrinterData.PrinterData__, []));
    if (data.driver === null || data.name === null) {
      var defaultPrinter: PrinterData = getDefaultPrinterData__();
      if (defaultPrinter === null)
        SWT.error__I(2);
      data.driver = defaultPrinter.driver;
      data.name = defaultPrinter.name;
    }
    return data;
  }
  public function Printer__(): Object {
    return this;
  }
  public function Printer__Lorg_eclipse_swt_printing_PrinterData_2(data: PrinterData): Object {
    SWT.error__I(2);
    return this;
  }
  public override function internal_new_GC__Lorg_eclipse_swt_graphics_GCData_2(data_1: GCData): int {
    return 0;
  }
  public override function internal_dispose_GC__ILorg_eclipse_swt_graphics_GCData_2(xGC: int, data_1: GCData): void {
  }
  public function startJob__Ljava_lang_String_2(jobName: String): Boolean {
    this.checkDevice__();
    return true;
  }
  public function endJob__(): void {
    this.checkDevice__();
  }
  public function cancelJob__(): void {
    this.checkDevice__();
  }
  public function startPage__(): Boolean {
    this.checkDevice__();
    return true;
  }
  public function endPage__(): void {
    this.checkDevice__();
  }
  public override function getDPI__(): Point {
    this.checkDevice__();
    return new Point(0, 0);
  }
  public override function getBounds__(): Rectangle {
    this.checkDevice__();
    return new Rectangle(0, 0, 0, 0);
  }
  public override function getClientArea__(): Rectangle {
    this.checkDevice__();
    return new Rectangle(0, 0, 0, 0);
  }
  public function computeTrim__IIII(x: int, y: int, width: int, height: int): Rectangle {
    return new Rectangle(0, 0, 0, 0);
  }
  public function getPrinterData__(): PrinterData {
    return data;
  }
  public function Printer(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is PrinterData) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        args1 = [null];
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.swt.graphics.Device.Device__Lorg_eclipse_swt_graphics_DeviceData_2, [Printer.checkNull__Lorg_eclipse_swt_printing_PrinterData_2(args1[0])]);
        break;
      case 1:
        var args1: Array = [args[0]];
        superArgs = new Arguments(org.eclipse.swt.graphics.Device.Device__Lorg_eclipse_swt_graphics_DeviceData_2, [Printer.checkNull__Lorg_eclipse_swt_printing_PrinterData_2(args1[0])]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        Printer__Lorg_eclipse_swt_printing_PrinterData_2(args1[0]);
        Printer__();
        break;
      case 1:
        Printer__Lorg_eclipse_swt_printing_PrinterData_2(args1[0]);
        break;
    }
  }
  public static const Printer__ : int = 0;
  public static const Printer__Lorg_eclipse_swt_printing_PrinterData_2 : int = 1;
}
}
