package org.eclipse.swt.widgets {
import org.eclipse.swt.*;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import flash.events.*;
import flash.display.*;
import mx.controls.RadioButton;
import mx.controls.RadioButtonGroup;
import mx.core.UIComponent;
import org.eclipse.swt.SWT;
import flash.events.MouseEvent;
import java.lang.Double;
import mx.controls.Button;
import mx.controls.CheckBox;
import flash.display.DisplayObjectContainer;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class Button extends Control {
  internal var text: String = "";
  internal var image: Image;
  public function Button(parent: Composite, style: int) {
    super(new Arguments(org.eclipse.swt.widgets.Control.Control__Lorg_eclipse_swt_widgets_Composite_2I, [parent, org.eclipse.swt.widgets.Button.checkStyle__I(style)]));
    return;
  }
  public function addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener: SelectionListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(14, typedListener);
    return;
  }
  public static function checkStyle__I(style: int): int {
    style = Widget.checkBits__IIIIIII(style, 8, 4, 32, 16, 2, 0);
    if ((style & (8 | 2)) != 0) {
      return Widget.checkBits__IIIIIII(style, 16777216, 16384, 131072, 0, 0, 0);
    }
    if ((style & (32 | 16)) != 0) {
      return Widget.checkBits__IIIIIII(style, 16384, 131072, 16777216, 0, 0, 0);
    }
    if ((style & 4) != 0) {
      style |= 524288;
      return Widget.checkBits__IIIIIII(style, 128, 1024, 16384, 131072, 0, 0);
    }
    return style;
  }
  public function clickHandler__Lflash_events_MouseEvent_2(event: MouseEvent): void {
    this.sendSelection__();
  }
  public function clickHandlerFunction__(): Function {
    return clickHandler__Lflash_events_MouseEvent_2;
  }
  public override function computeNativeSize__Lmx_core_UIComponent_2IIZ(widget: UIComponent, wHint: int, hHint: int, changed: Boolean): Point {
    var oldWidth: Number = widget.width;
    var oldHeight: Number = widget.height;
    widget.width = NaN;
    widget.height = NaN;
    widget.validateSize();
    var width_1: int = wHint == -1 ? int(widget.measuredWidth) : wHint;
    var height_1: int = hHint == -1 ? int(widget.measuredHeight) : hHint;
    widget.width = oldWidth;
    widget.height = oldHeight;
    return new Point(width_1, height_1);
  }
  public override function createHandle__(): void {
    var widget: mx.controls.Button;
    if ((style & 16) != 0) {
      var button: RadioButton = new RadioButton();
      widget = button;
      if (parent.group === null)
        parent.group = new RadioButtonGroup();
      button.group = parent.group;
      widget.setStyle("paddingTop", 0);
      widget.setStyle("paddingBottom", 0);
    } else if ((style & 32) != 0) {
      widget = new CheckBox();
      widget.setStyle("paddingTop", 0);
      widget.setStyle("paddingBottom", 0);
    } else {
      widget = new mx.controls.Button();
      if ((style & 2) != 0)
        widget.toggle = true;
    }
    object = widget;
    return;
  }
  public function getAlignment__(): int {
    this.checkWidget__();
    if ((style & 4) != 0) {
      if ((style & 128) != 0)
        return 128;
      if ((style & 1024) != 0)
        return 1024;
      if ((style & 16384) != 0)
        return 16384;
      if ((style & 131072) != 0)
        return 131072;
      return 128;
    }
    if ((style & 16384) != 0)
      return 16384;
    if ((style & 16777216) != 0)
      return 16777216;
    if ((style & 131072) != 0)
      return 131072;
    return 16384;
  }
  public override function getNameText__(): String {
    return this.getText__();
  }
  public override function _getImage__Lflash_display_DisplayObjectContainer_2(item: DisplayObjectContainer): Image {
    return image;
  }
  public function getImage__(): Image {
    this.checkWidget__();
    return image;
  }
  public function getSelection__(): Boolean {
    this.checkWidget__();
    if ((style & (32 | 16 | 2)) == 0)
      return false;
    return (mx.controls.Button(object)).selected;
  }
  public function getText__(): String {
    this.checkWidget__();
    if ((style & 4) != 0)
      return "";
    return text;
  }
  public override function hookEvents__(): void {
    super.hookEvents__();
    object.addEventListener(MouseEvent.CLICK, this.clickHandlerFunction__());
  }
  public override function releaseWidget__(): void {
    super.releaseWidget__();
    text = null;
    image = null;
  }
  public function removeSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener: SelectionListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(13, listener);
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(14, listener);
  }
  public function selectRadio__(): void {
    var children: JavaArray = parent._getChildren__();
    for (var i: int = 0; i < children.length; i++) {
      var child: Control = children[i];
      if (this !== child)
        child.setRadioSelection__Z(false);
    }
    this.setSelection__Z(true);
    return;
  }
  public function sendSelection__(): void {
    this.postEvent__I(13);
    return;
  }
  public function setAlignment__I(alignment: int): void {
    this.checkWidget__();
    if ((style & 4) != 0) {
      if ((style & (128 | 1024 | 16384 | 131072)) == 0)
        return;
      style &= ~(128 | 1024 | 16384 | 131072);
      style |= alignment & (128 | 1024 | 16384 | 131072);
    } else {
      if ((alignment & (16384 | 131072 | 16777216)) == 0)
        return;
      style &= ~(16384 | 131072 | 16777216);
      style |= alignment & (16384 | 131072 | 16777216);
    }
    return;
  }
  public function setImage__Lorg_eclipse_swt_graphics_Image_2(image_1: Image): void {
    this.checkWidget__();
    if (image_1 !== null && image_1.isDisposed__())
      this.error__I(5);
    if ((style & 4) != 0)
      return;
    this.image = image_1;
    if (image_1 === null) {
      object.clearStyle("icon");
    } else {
      object.setStyle("icon", SWTBitmapAsset.getClazz__());
    }
    return;
  }
  public override function setRadioSelection__Z(value: Boolean): Boolean {
    if ((style & 16) == 0)
      return false;
    if (this.getSelection__() != value) {
      this.setSelection__Z(value);
      this.postEvent__I(13);
    }
    return true;
  }
  public function setSelection__Z(selected: Boolean): void {
    this.checkWidget__();
    if ((style & (32 | 16 | 2)) == 0)
      return;
    (mx.controls.Button(object)).selected = selected;
  }
  public function setText__Ljava_lang_String_2(string: String): void {
    this.checkWidget__();
    if (string === null)
      this.error__I(4);
    if ((style & 4) != 0)
      return;
    text = string;
    (mx.controls.Button(object)).label = this.fixMnemonic__Ljava_lang_String_2(string);
  }
}
}
