package org.eclipse.swt.widgets {
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import java.lang.Math__;
import org.eclipse.swt.graphics.Font;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class Canvas extends Composite {
  internal var caret: Caret;
  internal var ime: IME;
  public function Canvas__(): Object {
    return this;
  }
  public function Canvas__Lorg_eclipse_swt_widgets_Composite_2I(parent: Composite, style: int): Object {
    return this;
  }
  public function getCaret__(): Caret {
    this.checkWidget__();
    return caret;
  }
  public function getIME__(): IME {
    this.checkWidget__();
    return ime;
  }
  public function drawBackground__Lorg_eclipse_swt_graphics_GC_2IIII(gc: GC, x_1: int, y_1: int, width_1: int, height_1: int): void {
    this.checkWidget__();
    if (gc === null)
      this.error__I(4);
    if (gc.isDisposed__())
      this.error__I(5);
    var control: Control = this.findBackgroundControl__();
    if (control !== null) {
    } else {
      gc.fillRectangle__IIII(x_1, y_1, width_1, height_1);
    }
    return;
  }
  public function scroll__IIIIIIZ(destX: int, destY: int, x_1: int, y_1: int, width_1: int, height_1: int, all: Boolean): void {
    this.checkWidget__();
    if (width_1 <= 0 || height_1 <= 0)
      return;
    var deltaX: int = destX - x_1;
    var deltaY: int = destY - y_1;
    if (deltaX == 0 && deltaY == 0)
      return;
    this.redrawWidget__IIIIZ(0, 0, int(object.width), int(object.height), false);
    if (all) {
      var children_1: JavaArray = this._getChildren__();
      for (var i: int = 0; i < children_1.length; i++) {
        var child: Control = children_1[i];
        var rect: Rectangle = child.getBounds__();
        if (Math__.min__II(x_1 + width_1, rect.x + rect.width) >= Math__.max__II(x_1, rect.x) && Math__.min__II(y_1 + height_1, rect.y + rect.height) >= Math__.max__II(y_1, rect.y)) {
          child.setLocation__II(rect.x + deltaX, rect.y + deltaY);
        }
      }
    }
    return;
  }
  public override function releaseChildren__Z(destroy: Boolean): void {
    if (caret !== null) {
      caret.release__Z(false);
      caret = null;
    }
    if (ime !== null) {
      ime.release__Z(false);
      ime = null;
    }
    super.releaseChildren__Z(destroy);
    return;
  }
  public override function sendFocusEvent__I(type: int): Boolean {
    if (caret !== null) {
      if (type == 15) {
        caret.setFocus__();
      } else {
        caret.killFocus__();
      }
    }
    return super.sendFocusEvent__I(type);
  }
  public function setCaret__Lorg_eclipse_swt_widgets_Caret_2(caret_1: Caret): void {
    this.checkWidget__();
    var newCaret: Caret = caret_1;
    var oldCaret: Caret = this.caret;
    this.caret = newCaret;
    if (oldCaret !== null) {
      this.removeChild__Lorg_eclipse_swt_widgets_Widget_2(oldCaret);
      if (this.hasFocus__())
        oldCaret.killFocus__();
    }
    if (newCaret !== null) {
      if (newCaret.isDisposed__())
        this.error__I(5);
      this.addChild__Lorg_eclipse_swt_widgets_Widget_2I(newCaret, this.parentingComponent__().numChildren);
      if (this.hasFocus__())
        newCaret.setFocus__();
    }
    return;
  }
  public override function setFont__Lorg_eclipse_swt_graphics_Font_2(font_1: Font): void {
    this.checkWidget__();
    if (caret !== null)
      caret.setFont__Lorg_eclipse_swt_graphics_Font_2(font_1);
    super.setFont__Lorg_eclipse_swt_graphics_Font_2(font_1);
    return;
  }
  public function setIME__Lorg_eclipse_swt_widgets_IME_2(ime_1: IME): void {
    this.checkWidget__();
    if (ime_1 !== null && ime_1.isDisposed__())
      this.error__I(5);
    this.ime = ime_1;
    return;
  }
  public function Canvas(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 2 && vargs[0] is Composite && vargs[1] is int) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.swt.widgets.Composite.Composite__, []);
        break;
      case 1:
        var args1: Array = [args[0], args[1]];
        superArgs = new Arguments(org.eclipse.swt.widgets.Composite.Composite__Lorg_eclipse_swt_widgets_Composite_2I, [args1[0], args1[1]]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        Canvas__();
        break;
      case 1:
        Canvas__Lorg_eclipse_swt_widgets_Composite_2I(args1[0], args1[1]);
        break;
    }
  }
  public static const Canvas__ : int = 0;
  public static const Canvas__Lorg_eclipse_swt_widgets_Composite_2I : int = 1;
}
}
