package org.eclipse.swt.widgets {
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Font;
import mx.containers.Canvas;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Point;
import java.lang.Arguments;
dynamic public class Caret extends Widget {
  internal var parent: org.eclipse.swt.widgets.Canvas;
  internal var x: int;
  internal var y: int;
  internal var width: int;
  internal var height: int;
  internal var blinkRate: int;
  internal var isVisible: Boolean;
  internal var image: Image;
  internal var font: Font;
  public function Caret(parent: org.eclipse.swt.widgets.Canvas, style: int) {
    super(new Arguments(org.eclipse.swt.widgets.Widget.Widget__Lorg_eclipse_swt_widgets_Widget_2I, [parent, style]));
    this.parent = parent;
    this.createWidget__();
    return;
  }
  public function blinkCaret__(): Boolean {
    if (!isVisible)
      return true;
    if (!object.visible) {
      object.visible = true;
      return true;
    }
    if (blinkRate == 0)
      return true;
    object.visible = false;
    return true;
  }
  public override function createHandle__(): void {
    blinkRate = display.getCaretBlinkTime__();
    var widget: mx.containers.Canvas = new mx.containers.Canvas();
    widget.setStyle("backgroundColor", 0);
    widget.visible = false;
    object = widget;
  }
  public override function createWidget__(): void {
    super.createWidget__();
    isVisible = true;
    if (parent.getCaret__() === null) {
      parent.setCaret__Lorg_eclipse_swt_widgets_Caret_2(this);
    }
    return;
  }
  public function getBounds__(): Rectangle {
    this.checkWidget__();
    if (image !== null) {
      var rect: Rectangle = image.getBounds__();
      return new Rectangle(x, y, rect.width, rect.height);
    }
    return new Rectangle(x, y, width, height);
  }
  public function getFont__(): Font {
    this.checkWidget__();
    if (font === null) {
      return parent.getFont__();
    }
    return font;
  }
  public function getImage__(): Image {
    this.checkWidget__();
    return image;
  }
  public function getLocation__(): Point {
    this.checkWidget__();
    return new Point(x, y);
  }
  public function getParent__(): org.eclipse.swt.widgets.Canvas {
    this.checkWidget__();
    return parent;
  }
  public function getSize__(): Point {
    this.checkWidget__();
    if (image !== null) {
      var rect: Rectangle = image.getBounds__();
      return new Point(rect.width, rect.height);
    }
    return new Point(width, height);
  }
  public function getVisible__(): Boolean {
    this.checkWidget__();
    return isVisible;
  }
  public function isVisible__(): Boolean {
    this.checkWidget__();
    return object.visible && parent.isVisible__() && parent.hasFocus__();
  }
  public function killFocus__(): void {
    if (display.currentCaret !== this)
      return;
    display.setCurrentCaret__Lorg_eclipse_swt_widgets_Caret_2(null);
    if (isVisible)
      object.visible = false;
  }
  public function move__II(x_1: int, y_1: int): void {
    object.x = x_1;
    object.y = y_1;
  }
  public function resize__II(width_1: int, height_1: int): void {
    if (image !== null) {
      var rect: Rectangle = image.getBounds__();
      width_1 = rect.width;
      height_1 = rect.height;
    }
    if (width_1 == 0)
      width_1 = 1;
    object.width = width_1;
    object.height = height_1;
    return;
  }
  public override function releaseHandle__(): void {
    super.releaseHandle__();
    object = null;
    parent = null;
    return;
  }
  public override function releaseParent__(): void {
    super.releaseParent__();
    if (this === parent.getCaret__())
      parent.setCaret__Lorg_eclipse_swt_widgets_Caret_2(null);
    return;
  }
  public override function releaseWidget__(): void {
    super.releaseWidget__();
    image = null;
    font = null;
    return;
  }
  public function setBounds__IIII(x_1: int, y_1: int, width_1: int, height_1: int): void {
    this.checkWidget__();
    var samePosition: Boolean = this.x == x_1 && this.y == y_1;
    var sameExtent: Boolean = this.width == width_1 && this.height == height_1;
    if (samePosition && sameExtent)
      return;
    this.x = x_1;
    this.y = y_1;
    this.width = width_1;
    this.height = height_1;
    if (!sameExtent)
      this.resize__II(width_1, height_1);
    if (!samePosition)
      this.move__II(x_1, y_1);
  }
  public function setBounds__Lorg_eclipse_swt_graphics_Rectangle_2(rect: Rectangle): void {
    if (rect === null)
      this.error__I(4);
    this.setBounds__IIII(rect.x, rect.y, rect.width, rect.height);
  }
  public function setFont__Lorg_eclipse_swt_graphics_Font_2(font_1: Font): void {
    this.checkWidget__();
    if (font_1 !== null && font_1.isDisposed__()) {
      this.error__I(5);
    }
    this.font = font_1;
    return;
  }
  public function setFocus__(): void {
    if (display.currentCaret === this)
      return;
    display.setCurrentCaret__Lorg_eclipse_swt_widgets_Caret_2(this);
    if (isVisible)
      object.visible = true;
  }
  public function setImage__Lorg_eclipse_swt_graphics_Image_2(image_1: Image): void {
    this.checkWidget__();
    if (image_1 !== null && image_1.isDisposed__()) {
      this.error__I(5);
    }
    this.image = image_1;
    this.resize__II(width, height);
    return;
  }
  public function setLocation__II(x_1: int, y_1: int): void {
    this.checkWidget__();
    if (this.x == x_1 && this.y == y_1)
      return;
    this.x = x_1;
    this.y = y_1;
    this.move__II(x_1, y_1);
  }
  public function setLocation__Lorg_eclipse_swt_graphics_Point_2(location: Point): void {
    this.checkWidget__();
    if (location === null)
      this.error__I(4);
    this.setLocation__II(location.x, location.y);
  }
  public function setSize__II(width_1: int, height_1: int): void {
    this.checkWidget__();
    if (this.width == width_1 && this.height == height_1)
      return;
    this.width = width_1;
    this.height = height_1;
    this.resize__II(width_1, height_1);
  }
  public function setSize__Lorg_eclipse_swt_graphics_Point_2(size: Point): void {
    this.checkWidget__();
    if (size === null)
      this.error__I(4);
    this.setSize__II(size.x, size.y);
  }
  public function setVisible__Z(visible: Boolean): void {
    this.checkWidget__();
    if (visible == isVisible)
      return;
    isVisible = visible;
    if (!parent.hasFocus__())
      return;
    object.visible = visible;
  }
}
}
