package org.eclipse.swt.widgets {
import flash.display.DisplayObjectContainer;
import flash.events.MouseEvent;
import mx.containers.HBox;
import mx.containers.TitleWindow;
import mx.containers.VBox;
import mx.controls.ColorPicker;
import mx.events.CloseEvent;
import mx.managers.PopUpManager;
import mx.managers.PopUpManagerChildList;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.graphics.RGB;
import java.lang.System;
import mx.controls.Label;
import mx.controls.Button;
import java.lang.Math__;
import java.lang.Arguments;
dynamic public class ColorDialog extends Dialog {
  internal var rgb: RGB;
  internal var window: TitleWindow;
  internal var picker: ColorPicker;
  public function ColorDialog__Lorg_eclipse_swt_widgets_Shell_2(parent: Shell): Object {
    return this;
  }
  public function ColorDialog__Lorg_eclipse_swt_widgets_Shell_2I(parent: Shell, style: int): Object {
    this.checkSubclass__();
    return this;
  }
  public function close__(): void {
    PopUpManager.removePopUp(window);
    window = null;
    picker = null;
    System.out.println__Ljava_lang_Object_2(rgb);
    return;
  }
  public function getRGB__(): RGB {
    return rgb;
  }
  public function handleOk__Lflash_events_MouseEvent_2(event: MouseEvent): void {
    if (picker !== null) {
      var color: int = picker.selectedColor;
      rgb = new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [(color >> 16) & 0xFF, (color >> 8) & 0xFF, color & 0xFF]));
    }
    this.close__();
    return;
  }
  public function handleOkFunction__(): Function {
    return handleOk__Lflash_events_MouseEvent_2;
  }
  public function handleCancel__Lflash_events_MouseEvent_2(event: MouseEvent): void {
    this.close__();
    return;
  }
  public function handleCancelFunction__(): Function {
    return handleCancel__Lflash_events_MouseEvent_2;
  }
  public function handleClose__Lmx_events_CloseEvent_2(event: CloseEvent): void {
    this.close__();
    return;
  }
  public function handleCloseFunction__(): Function {
    return handleClose__Lmx_events_CloseEvent_2;
  }
  public function open__(): RGB {
    window = new TitleWindow();
    window.showCloseButton = true;
    window.addEventListener(CloseEvent.CLOSE, this.handleCloseFunction__());
    if (title !== null)
      window.title = title;
    var vbox: VBox = new VBox();
    vbox.setStyle("verticalGap", 10);
    vbox.setStyle("horizontalAlign", "center");
    window.addChild(vbox);
    var hbox1: HBox = new HBox();
    hbox1.setStyle("paddingLeft", 20);
    hbox1.setStyle("paddingTop", 20);
    hbox1.setStyle("paddingBottom", 20);
    hbox1.setStyle("paddingRight", 20);
    vbox.addChild(hbox1);
    var label: mx.controls.Label = new mx.controls.Label();
    label.text = SWT.getMessage__Ljava_lang_String_2("SWT_Color");
    hbox1.addChild(label);
    picker = new ColorPicker();
    picker.width = 150;
    if (rgb !== null) {
      picker.selectedColor = ((rgb.red & 0xFF) << 16) | ((rgb.green & 0xFF) << 8) | (rgb.blue & 0xFF);
    }
    rgb = null;
    hbox1.addChild(picker);
    var hbox2: HBox = new HBox();
    hbox2.setStyle("horizontalAlign", "center");
    vbox.addChild(hbox2);
    var ok: mx.controls.Button = new mx.controls.Button();
    ok.label = SWT.getMessage__Ljava_lang_String_2("SWT_OK");
    ok.addEventListener(MouseEvent.CLICK, this.handleOkFunction__());
    hbox2.addChild(ok);
    var cancel: mx.controls.Button = new mx.controls.Button();
    cancel.label = SWT.getMessage__Ljava_lang_String_2("SWT_Cancel");
    cancel.addEventListener(MouseEvent.CLICK, this.handleCancelFunction__());
    hbox2.addChild(cancel);
    ok.validateProperties();
    ok.validateSize();
    cancel.validateProperties();
    cancel.validateSize();
    ok.width = cancel.width = Math__.max__DD(ok.measuredWidth, cancel.measuredWidth);
    window.defaultButton = ok;
    var sprite: DisplayObjectContainer = parent !== null ? parent.parentingComponent__() : null;
    PopUpManager.addPopUp(window, sprite, true, PopUpManagerChildList.APPLICATION);
    PopUpManager.centerPopUp(window);
    return rgb;
  }
  public function setRGB__Lorg_eclipse_swt_graphics_RGB_2(rgb_1: RGB): void {
    this.rgb = rgb_1;
  }
  public function ColorDialog(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 1 && vargs[0] is Shell) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 2 && vargs[0] is Shell && vargs[1] is int) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0]];
        args1 = [args0[0], 32768];
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.swt.widgets.Dialog.Dialog__Lorg_eclipse_swt_widgets_Shell_2I, [args1[0], args1[1]]);
        break;
      case 1:
        var args1: Array = [args[0], args[1]];
        superArgs = new Arguments(org.eclipse.swt.widgets.Dialog.Dialog__Lorg_eclipse_swt_widgets_Shell_2I, [args1[0], args1[1]]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        ColorDialog__Lorg_eclipse_swt_widgets_Shell_2I(args1[0], args1[1]);
        ColorDialog__Lorg_eclipse_swt_widgets_Shell_2(args0[0]);
        break;
      case 1:
        ColorDialog__Lorg_eclipse_swt_widgets_Shell_2I(args1[0], args1[1]);
        break;
    }
  }
  public static const ColorDialog__Lorg_eclipse_swt_widgets_Shell_2 : int = 0;
  public static const ColorDialog__Lorg_eclipse_swt_widgets_Shell_2I : int = 1;
}
}
