package org.eclipse.swt.widgets {
import mx.collections.ArrayCollection;
import mx.controls.ComboBox;
import mx.controls.TextInput;
import mx.controls.listClasses.ListBase;
import mx.events.FlexEvent;
import mx.events.ListEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.internal.flex.SWTComboBox;
import org.eclipse.swt.events.*;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class Combo extends Composite {
  internal var dataProvider: ArrayCollection;
  public static const LIMIT: int = 0x7fffffff;
  public function Combo(parent: Composite, style: int) {
    super(new Arguments(org.eclipse.swt.widgets.Composite.Composite__Lorg_eclipse_swt_widgets_Composite_2I, [parent, Combo.checkStyle__I(style)]));
    return;
  }
  public function add__Ljava_lang_String_2(string: String): void {
    this.checkWidget__();
    if (string === null)
      this.error__I(4);
    dataProvider.addItem(string);
    return;
  }
  public function add__Ljava_lang_String_2I(string: String, index: int): void {
    this.checkWidget__();
    if (string === null)
      this.error__I(4);
    dataProvider.addItemAt(string, index);
    return;
  }
  public function addModifyListener__Lorg_eclipse_swt_events_ModifyListener_2(listener: ModifyListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(24, typedListener);
    return;
  }
  public function addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener: SelectionListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(14, typedListener);
    return;
  }
  public function addVerifyListener__Lorg_eclipse_swt_events_VerifyListener_2(listener: VerifyListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(25, typedListener);
    return;
  }
  public static function checkStyle__I(style: int): int {
    style &= ~2048;
    style &= ~(256 | 512);
    style = Widget.checkBits__IIIIIII(style, 4, 64, 0, 0, 0, 0);
    if ((style & 64) != 0)
      return style & ~8;
    return style;
  }
  public override function checkSubclass__(): void {
    if (!this.isValidSubclass__())
      this.error__I(43);
  }
  public function clearSelection__(): void {
    this.checkWidget__();
    this.setSelection__Lorg_eclipse_swt_graphics_Point_2(this.getSelection__());
  }
  public override function createHandle__(): void {
    var widget: SWTComboBox = new SWTComboBox();
    widget.dataProvider = dataProvider = new ArrayCollection();
    widget.editable = (style & 8) == 0;
    object = widget;
  }
  public override function computeSize__IIZ(wHint: int, hHint: int, changed: Boolean): Point {
    this.checkWidget__();
    return this.computeNativeSize__Lmx_core_UIComponent_2IIZ(object, wHint, hHint, changed);
  }
  public function copy__(): void {
  }
  public function cut__(): void {
  }
  public function deselect__I(index: int): void {
    this.checkWidget__();
    var selection: int = this.getSelectionIndex__();
    if (index != selection)
      return;
    (ComboBox(object)).selectedIndex = -1;
  }
  public function deselectAll__(): void {
    this.checkWidget__();
    var selection: int = this.getSelectionIndex__();
    if (selection == -1)
      return;
    (ComboBox(object)).selectedIndex = -1;
  }
  public function getItem__I(index: int): String {
    this.checkWidget__();
    var count: int = dataProvider.length;
    if (!(0 <= index && index < count))
      this.error__I(6);
    return String(dataProvider.getItemAt(index));
  }
  public function getItemCount__(): int {
    this.checkWidget__();
    return dataProvider.length;
  }
  public function getItemHeight__(): int {
    return 0;
  }
  public function getItems__(): JavaArray {
    this.checkWidget__();
    var result: JavaArray = new JavaArray("[Ljava/lang/String;").lengths(dataProvider.length);
    for (var i: int = 0; i < result.length; i++) {
      result[i] = String(dataProvider.getItemAt(i));
    }
    return result;
  }
  public function getOrientation__(): int {
    this.checkWidget__();
    return 0;
  }
  public function getSelection__(): Point {
    this.checkWidget__();
    var widget: TextInput = this.getTextInput__();
    return new Point(widget.selectionBeginIndex, widget.selectionEndIndex);
  }
  public function getSelectionIndex__(): int {
    this.checkWidget__();
    var list: ListBase = (ComboBox(object)).dropdown;
    if (list === null)
      return -1;
    return list.selectedIndex;
  }
  public function getText__(): String {
    this.checkWidget__();
    return (ComboBox(object)).text;
  }
  public function getTextHeight__(): int {
    return 0;
  }
  public function getTextInput__(): TextInput {
    return (SWTComboBox(object)).getTextInput__();
  }
  public function getTextLimit__(): int {
    this.checkWidget__();
    var limit: int = this.getTextInput__().maxChars;
    return limit != 0 ? limit : 2147483647;
  }
  public function getVisibleItemCount__(): int {
    this.checkWidget__();
    return (ComboBox(object)).rowCount;
  }
  public function handleChange__Lmx_events_ListEvent_2(event: ListEvent): void {
    var widget: ComboBox = ComboBox(object);
    if (widget.selectedIndex != -1)
      this.sendSelection__();
  }
  public function handleChangeFunction__(): Function {
    return handleChange__Lmx_events_ListEvent_2;
  }
  public function handleEnter__Lmx_events_FlexEvent_2(event: FlexEvent): void {
    this.postEvent__I(14);
  }
  public function handleEnterFunction__(): Function {
    return handleEnter__Lmx_events_FlexEvent_2;
  }
  public override function hookEvents__(): void {
    super.hookEvents__();
    object.addEventListener(FlexEvent.ENTER, this.handleEnterFunction__());
    object.addEventListener(ListEvent.CHANGE, this.handleChangeFunction__());
  }
  public function indexOf__Ljava_lang_String_2(string: String): int {
    this.checkWidget__();
    if (string === null)
      this.error__I(4);
    return dataProvider.getItemIndex(string);
  }
  public function indexOf__Ljava_lang_String_2I(string: String, start: int): int {
    this.checkWidget__();
    if (string === null)
      this.error__I(4);
    return dataProvider.toArray().indexOf(string, start);
  }
  public function paste__(): void {
  }
  public override function releaseWidget__(): void {
    super.releaseWidget__();
    dataProvider = null;
  }
  public function remove__I(index: int): void {
    this.checkWidget__();
    var count: int = dataProvider.length;
    if (!(0 <= index && index < count)) {
      this.error__I(6);
    }
    dataProvider.removeItemAt(index);
    return;
  }
  public function remove__II(start: int, end: int): void {
    this.checkWidget__();
    if (start > end)
      return;
    var count: int = dataProvider.length;
    if (!(0 <= start && start <= end && end < count)) {
      this.error__I(6);
    }
    dataProvider.disableAutoUpdate();
    for (var index: int = end; index >= start; index--) {
      dataProvider.removeItemAt(index);
    }
    dataProvider.enableAutoUpdate();
    return;
  }
  public function remove__Ljava_lang_String_2(string: String): void {
    this.checkWidget__();
    if (string === null)
      this.error__I(4);
    var index: int = this.indexOf__Ljava_lang_String_2I(string, 0);
    if (index == -1)
      this.error__I(5);
    this.remove__I(index);
    return;
  }
  public function removeAll__(): void {
    this.checkWidget__();
    dataProvider.removeAll();
    return;
  }
  public function removeModifyListener__Lorg_eclipse_swt_events_ModifyListener_2(listener: ModifyListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(24, listener);
  }
  public function removeSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener: SelectionListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(13, listener);
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(14, listener);
  }
  public function removeVerifyListener__Lorg_eclipse_swt_events_VerifyListener_2(listener: VerifyListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(25, listener);
  }
  public function select__I(index: int): void {
    this.checkWidget__();
    var count: int = dataProvider.length;
    if (0 <= index && index < count) {
      (ComboBox(object)).selectedIndex = index;
    }
    return;
  }
  public function sendSelection__(): void {
    this.postEvent__I(13);
    return;
  }
  public function setItem__ILjava_lang_String_2(index: int, string: String): void {
    this.checkWidget__();
    if (string === null)
      this.error__I(4);
    var count: int = dataProvider.length;
    if (!(0 <= index && index < count))
      this.error__I(6);
    dataProvider.setItemAt(string, index);
    return;
  }
  public function setItems___3Ljava_lang_String_2(items: JavaArray): void {
    this.checkWidget__();
    if (items === null)
      this.error__I(4);
    for (var i: int = 0; i < items.length; i++) {
      if (items[i] === null)
        this.error__I(5);
    }
    dataProvider.disableAutoUpdate();
    dataProvider.removeAll();
    for (var i_1: int = 0; i_1 < items.length; i_1++) {
      dataProvider.addItem(items[i_1]);
    }
    dataProvider.enableAutoUpdate();
    return;
  }
  public function setListVisible__Z(visible: Boolean): void {
    this.checkWidget__();
    if (visible) {
      (ComboBox(object)).open();
    } else {
      (ComboBox(object)).close();
    }
    return;
  }
  public function setOrientation__I(orientation: int): void {
    this.checkWidget__();
    return;
  }
  public function setSelection__Lorg_eclipse_swt_graphics_Point_2(selection: Point): void {
    this.checkWidget__();
    if (selection === null)
      this.error__I(4);
    this.getTextInput__().setSelection(selection.x, selection.y);
    return;
  }
  public function setText__Ljava_lang_String_2(string: String): void {
    this.checkWidget__();
    if (string === null)
      this.error__I(4);
    if ((style & 8) != 0) {
      var index: int = this.indexOf__Ljava_lang_String_2(string);
      if (index != -1)
        this.select__I(index);
      return;
    }
    (ComboBox(object)).text = string;
    return;
  }
  public function setTextLimit__I(limit: int): void {
    this.checkWidget__();
    if (limit == 0)
      this.error__I(7);
    if (limit == 2147483647)
      limit = 0;
    this.getTextInput__().maxChars = limit;
    return;
  }
  public function setVisibleItemCount__I(count: int): void {
    this.checkWidget__();
    if (count < 0)
      return;
    (ComboBox(object)).rowCount = count;
  }
}
}
