package org.eclipse.swt.widgets {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.internal.flex.*;
import flash.display.*;
import mx.controls.RadioButtonGroup;
import mx.core.*;
import org.eclipse.swt.internal.flex.SWTCanvas;
import mx.core.UIComponent;
import org.eclipse.swt.internal.flex.SWTScrollControlBase;
import java.lang.System;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import mx.containers.Canvas;
import mx.core.ScrollPolicy;
import mx.core.EdgeMetrics;
import flash.display.DisplayObject;
import java.lang.Math__;
import mx.events.ResizeEvent;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class Composite extends Scrollable {
  internal var layout: Layout;
  internal var tabList: JavaArray;
  internal var children: JavaArray;
  internal var layoutCount: int;
  internal var backgroundMode: int;
  internal var sprite: SWTCanvas;
  internal var group: RadioButtonGroup;
  public function Composite__(): Object {
    return this;
  }
  public function Composite__Lorg_eclipse_swt_widgets_Composite_2I(parent: Composite, style: int): Object {
    return this;
  }
  public function parentingComponent__(): UIComponent {
    if ((state & 16) != 0) {
      return (SWTScrollControlBase(object)).getContent__();
    }
    return object;
  }
  public function addChild__Lorg_eclipse_swt_widgets_Widget_2I(child: Widget, index: int): void {
    var widget: UIComponent = child.topComponent__();
    if (index == -1) {
      this.parentingComponent__().addChildAt(widget, 0);
    } else {
      this.parentingComponent__().addChildAt(widget, index);
    }
    return;
  }
  public function addControl__Lorg_eclipse_swt_widgets_Control_2(control: Control): void {
    if (children === null)
      children = new JavaArray("[Lorg/eclipse/swt/widgets/Control;").lengths(4);
    var length: int = children.length;
    for (var i: int = 0; i < length; i++) {
      if (children[i] === control)
        return;
    }
    var index: int = 0;
    while (index < length) {
      if (children[index] === null)
        break;
      index++;
    }
    if (index == length) {
      var temp: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/Control;").lengths(length + 4);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(children, 0, temp, 0, length);
      children = temp;
    }
    children[index] = control;
    return;
  }
  public function _getChildren__(): JavaArray {
    if (children === null)
      return new JavaArray("[Lorg/eclipse/swt/widgets/Control;").lengths(0);
    var count: int = 0;
    var length: int = children.length;
    while (count < length) {
      if (children[count] === null)
        break;
      count++;
    }
    var result: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/Control;").lengths(count);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(children, 0, result, 0, count);
    return result;
  }
  public function _getTabList__(): JavaArray {
    if (tabList === null)
      return tabList;
    var count: int = 0;
    for (var i: int = 0; i < tabList.length; i++) {
      if (!tabList[i].isDisposed__())
        count++;
    }
    if (count == tabList.length)
      return tabList;
    var newList: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/Control;").lengths(count);
    var index: int = 0;
    for (var i_1: int = 0; i_1 < tabList.length; i_1++) {
      if (!tabList[i_1].isDisposed__()) {
        newList[index++] = tabList[i_1];
      }
    }
    tabList = newList;
    return tabList;
  }
  public override function backgroundControl__(): UIComponent {
    if ((state & 16) != 0)
      return (SWTScrollControlBase(object)).getContent__();
    return super.backgroundControl__();
  }
  public function changed___3Lorg_eclipse_swt_widgets_Control_2(changed: JavaArray): void {
    this.checkWidget__();
    if (changed === null)
      this.error__I(5);
    for (var i: int = 0; i < changed.length; i++) {
      var control: Control = changed[i];
      if (control === null)
        this.error__I(5);
      if (control.isDisposed__())
        this.error__I(5);
      var ancestor: Boolean = false;
      var composite: Composite = control.parent;
      while (composite !== null) {
        ancestor = composite === this;
        if (ancestor)
          break;
        composite = composite.parent;
      }
      if (!ancestor)
        this.error__I(32);
    }
    for (var i_1: int = 0; i_1 < changed.length; i_1++) {
      var child: Control = changed[i_1];
      var composite_1: Composite = child.parent;
      while (child !== this) {
        if (composite_1.layout === null || !composite_1.layout.flushCache__Lorg_eclipse_swt_widgets_Control_2(child)) {
          composite_1.state |= 256;
        }
        child = composite_1;
        composite_1 = child.parent;
      }
    }
    return;
  }
  public override function checkSubclass__(): void {
  }
  public override function computeSize__IIZ(wHint: int, hHint: int, changed: Boolean): Point {
    this.checkWidget__();
    var size: Point;
    if (layout !== null) {
      if (wHint == -1 || hHint == -1) {
        changed = (changed) ? ((state & 256) != 0, true) : ((state & 256) != 0);
        state &= ~256;
        size = layout.computeSize__Lorg_eclipse_swt_widgets_Composite_2IIZ(this, wHint, hHint, changed);
      } else {
        size = new Point(wHint, hHint);
      }
    } else {
      size = this.minimumSize__IIZ(wHint, hHint, changed);
    }
    if (size.x == 0)
      size.x = 64;
    if (size.y == 0)
      size.y = 64;
    if (wHint != -1)
      size.x = wHint;
    if (hHint != -1)
      size.y = hHint;
    var trim: Rectangle = this.computeTrim__IIII(0, 0, size.x, size.y);
    return new Point(trim.width, trim.height);
  }
  public override function computeTabList__(): JavaArray {
    var result: JavaArray = super.computeTabList__();
    if (result.length == 0)
      return result;
    var list: JavaArray = tabList !== null ? this._getTabList__() : this._getChildren__();
    for (var i: int = 0; i < list.length; i++) {
      var child: Control = list[i];
      var childList: JavaArray = child.computeTabList__();
      if (childList.length != 0) {
        var newResult: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/Control;").lengths(result.length + childList.length);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(result, 0, newResult, 0, result.length);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(childList, 0, newResult, result.length, childList.length);
        result = newResult;
      }
    }
    return result;
  }
  public override function createHandle__(): void {
    state |= 16;
    sprite = new SWTCanvas();
    sprite.mouseEnabled = false;
    var content: mx.containers.Canvas = new mx.containers.Canvas();
    content.setStyle("backgroundColor", 0xFFFFFF);
    content.horizontalScrollPolicy = ScrollPolicy.OFF;
    content.verticalScrollPolicy = ScrollPolicy.OFF;
    var widget: SWTScrollControlBase = new SWTScrollControlBase(content);
    widget.setStyle("borderStyle", this.hasBorder__() ? "inset" : "none");
    widget.horizontalScrollPolicy = (style & 256) != 0 ? ScrollPolicy.ON : ScrollPolicy.OFF;
    widget.verticalScrollPolicy = (style & 512) != 0 ? ScrollPolicy.ON : ScrollPolicy.OFF;
    this.dummy__Lmx_core_EdgeMetrics_2(widget.viewMetrics);
    widget.addChild(content);
    content.addChild(sprite);
    object = widget;
  }
  public override function deregister__(): void {
    super.deregister__();
    if ((state & 16) != 0) {
      display.removeWidget__Lmx_core_UIComponent_2(this.parentingComponent__());
    }
    return;
  }
  public function dummy__Lmx_core_EdgeMetrics_2(vm: EdgeMetrics): void {
  }
  public override function eventComponent__(): DisplayObject {
    if ((state & 16) != 0)
      return this.parentingComponent__();
    return object;
  }
  public function findDeferredControl__(): Composite {
    return layoutCount > 0 ? this : parent.findDeferredControl__();
  }
  public function fixTabList__Lorg_eclipse_swt_widgets_Control_2(control: Control): void {
    if (tabList === null)
      return;
    var count: int = 0;
    for (var i: int = 0; i < tabList.length; i++) {
      if (tabList[i] === control)
        count++;
    }
    if (count == 0)
      return;
    var newList: JavaArray = null;
    var length: int = tabList.length - count;
    if (length != 0) {
      newList = new JavaArray("[Lorg/eclipse/swt/widgets/Control;").lengths(length);
      var index: int = 0;
      for (var i_1: int = 0; i_1 < tabList.length; i_1++) {
        if (tabList[i_1] !== control) {
          newList[index++] = tabList[i_1];
        }
      }
    }
    tabList = newList;
    return;
  }
  public function getBackgroundMode__(): int {
    this.checkWidget__();
    return backgroundMode;
  }
  public function getChildren__(): JavaArray {
    this.checkWidget__();
    return this._getChildren__();
  }
  public function getLayout__(): Layout {
    this.checkWidget__();
    return layout;
  }
  public override function getSprite__(): UIComponent {
    return sprite;
  }
  public function getTabList__(): JavaArray {
    this.checkWidget__();
    var tabList_1: JavaArray = this._getTabList__();
    if (tabList_1 === null) {
      var count: int = 0;
      var list: JavaArray = this._getChildren__();
      for (var i: int = 0; i < list.length; i++) {
        if (list[i].isTabGroup__())
          count++;
      }
      tabList_1 = new JavaArray("[Lorg/eclipse/swt/widgets/Control;").lengths(count);
      var index: int = 0;
      for (var i_1: int = 0; i_1 < list.length; i_1++) {
        if (list[i_1].isTabGroup__()) {
          tabList_1[index++] = list[i_1];
        }
      }
    }
    return tabList_1;
  }
  public function getLayoutDeferred__(): Boolean {
    this.checkWidget__();
    return layoutCount > 0;
  }
  public function hooksKeys__(): Boolean {
    return this.hooks__I(1) || this.hooks__I(2);
  }
  public override function hookEvents__(): void {
    super.hookEvents__();
    if (sprite !== null) {
      sprite.addEventListener("swtpaint", this.paintHandlerFunction__());
    }
    return;
  }
  public function isLayoutDeferred__(): Boolean {
    this.checkWidget__();
    return this.findDeferredControl__() !== null;
  }
  public function layout__(): void {
    this.checkWidget__();
    this.layout__Z(true);
  }
  public function layout__Z(changed: Boolean): void {
    this.checkWidget__();
    if (layout === null)
      return;
    this.layout__ZZ(changed, false);
  }
  public function layout__ZZ(changed: Boolean, all: Boolean): void {
    this.checkWidget__();
    if (layout === null && !all)
      return;
    this.markLayout__ZZ(changed, all);
    this.updateLayout__ZZ(true, all);
  }
  public function layout___3Lorg_eclipse_swt_widgets_Control_2(changed: JavaArray): void {
    this.checkWidget__();
    if (changed === null)
      this.error__I(5);
    for (var i: int = 0; i < changed.length; i++) {
      var control: Control = changed[i];
      if (control === null)
        this.error__I(5);
      if (control.isDisposed__())
        this.error__I(5);
      var ancestor: Boolean = false;
      var composite: Composite = control.parent;
      while (composite !== null) {
        ancestor = composite === this;
        if (ancestor)
          break;
        composite = composite.parent;
      }
      if (!ancestor)
        this.error__I(32);
    }
    var updateCount: int = 0;
    var update: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/Composite;").lengths(16);
    for (var i_1: int = 0; i_1 < changed.length; i_1++) {
      var child: Control = changed[i_1];
      var composite_1: Composite = child.parent;
      while (child !== this) {
        if (composite_1.layout !== null) {
          composite_1.state |= 128;
          if (!composite_1.layout.flushCache__Lorg_eclipse_swt_widgets_Control_2(child)) {
            composite_1.state |= 256;
          }
        }
        if (updateCount == update.length) {
          var newUpdate: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/Composite;").lengths(update.length + 16);
          System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(update, 0, newUpdate, 0, update.length);
          update = newUpdate;
        }
        child = update[updateCount++] = composite_1;
        composite_1 = child.parent;
      }
    }
    for (var i_2: int = updateCount - 1; i_2 >= 0; i_2--) {
      update[i_2].updateLayout__ZZ(true, false);
    }
    return;
  }
  public override function markLayout__ZZ(changed: Boolean, all: Boolean): void {
    if (layout !== null) {
      state |= 128;
      if (changed)
        state |= 256;
    }
    if (all) {
      var children_1: JavaArray = this._getChildren__();
      for (var i: int = 0; i < children_1.length; i++) {
        children_1[i].markLayout__ZZ(changed, all);
      }
    }
    return;
  }
  public function minimumSize__IIZ(wHint: int, hHint: int, changed: Boolean): Point {
    var children_1: JavaArray = this._getChildren__();
    var width_1: int = 0;
    var height_1: int = 0;
    for (var i: int = 0; i < children_1.length; i++) {
      var rect: Rectangle = children_1[i].getBounds__();
      width_1 = Math__.max__II(width_1, rect.x + rect.width);
      height_1 = Math__.max__II(height_1, rect.y + rect.height);
    }
    return new Point(width_1, height_1);
  }
  public override function register__(): void {
    super.register__();
    if ((state & 16) != 0) {
      display.addWidget__Lmx_core_UIComponent_2Lorg_eclipse_swt_widgets_Widget_2(this.parentingComponent__(), this);
    }
    return;
  }
  public override function releaseChildren__Z(destroy: Boolean): void {
    var children_1: JavaArray = this._getChildren__();
    for (var i: int = 0; i < children_1.length; i++) {
      var child: Control = children_1[i];
      if (child !== null && !child.isDisposed__()) {
        child.release__Z(false);
      }
    }
    super.releaseChildren__Z(destroy);
    return;
  }
  public override function releaseWidget__(): void {
    super.releaseWidget__();
    layout = null;
    tabList = null;
    return;
  }
  public function removeControl__Lorg_eclipse_swt_widgets_Control_2(control: Control): void {
    this.fixTabList__Lorg_eclipse_swt_widgets_Control_2(control);
    var index: int = 0;
    while (index < children.length) {
      if (children[index] === control)
        break;
      index++;
    }
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(children, index + 1, children, index, children.length - index - 1);
    children[children.length - 1] = null;
    return;
  }
  public override function resizeComponent__(): UIComponent {
    if ((state & 16) != 0) {
      return (SWTScrollControlBase(object)).getContent__();
    }
    return super.resizeComponent__();
  }
  public override function resized__(): void {
    super.resized__();
    if (layout !== null) {
      this.markLayout__ZZ(false, false);
      this.updateLayout__ZZ(false, false);
    }
    return;
  }
  public function removeChild__Lorg_eclipse_swt_widgets_Widget_2(child: Widget): void {
    var widget: UIComponent = child.topComponent__();
    this.parentingComponent__().removeChild(widget);
    return;
  }
  public override function handleResize__Lmx_events_ResizeEvent_2(event: ResizeEvent): void {
    super.handleResize__Lmx_events_ResizeEvent_2(event);
    if (this.isDisposed__())
      return;
    if (sprite !== null) {
      this.redrawWidget__IIIIZ(0, 0, int(object.width), int(object.height), false);
    }
    return;
  }
  public function setBackgroundMode__I(mode: int): void {
  }
  public override function setBounds__IIIII(x_1: int, y_1: int, width_1: int, height_1: int, flags: int): int {
    var result: int = super.setBounds__IIIII(x_1, y_1, width_1, height_1, flags);
    if ((result & 8192) != 0 && layout !== null) {
      this.markLayout__ZZ(false, false);
      this.updateLayout__ZZ((result & 8192) != 0, false);
    }
    return result;
  }
  public override function setFocus__(): Boolean {
    this.checkWidget__();
    var children_1: JavaArray = this._getChildren__();
    for (var i: int = 0; i < children_1.length; i++) {
      if (children_1[i].setFocus__())
        return true;
    }
    return super.setFocus__();
  }
  public function setLayout__Lorg_eclipse_swt_widgets_Layout_2(layout_1: Layout): void {
    this.checkWidget__();
    this.layout = layout_1;
  }
  public function setLayoutDeferred__Z(defer: Boolean): void {
    if (!defer) {
      if (--layoutCount == 0) {
        if ((state & 512) != 0 || (state & 128) != 0) {
          this.updateLayout__ZZ(true, true);
        }
      }
    } else {
      layoutCount++;
    }
    return;
  }
  public override function setTabGroupFocus__(): Boolean {
    if (this.isTabItem__())
      return this.setTabItemFocus__();
    var takeFocus: Boolean = (style & 524288) == 0;
    if ((state & 16) != 0) {
      takeFocus = this.hooksKeys__();
      if ((style & 16777216) != 0)
        takeFocus = true;
    }
    if (takeFocus && this.setTabItemFocus__())
      return true;
    var children_1: JavaArray = this._getChildren__();
    for (var i: int = 0; i < children_1.length; i++) {
      var child: Control = children_1[i];
      if (child.isTabItem__() && child.setTabItemFocus__())
        return true;
    }
    return false;
  }
  public function setTabList___3Lorg_eclipse_swt_widgets_Control_2(tabList_1: JavaArray): void {
    this.checkWidget__();
    if (tabList_1 !== null) {
      for (var i: int = 0; i < tabList_1.length; i++) {
        var control: Control = tabList_1[i];
        if (control === null)
          this.error__I(5);
        if (control.isDisposed__())
          this.error__I(5);
        if (control.parent !== this)
          this.error__I(32);
      }
      var newList: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/Control;").lengths(tabList_1.length);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(tabList_1, 0, newList, 0, tabList_1.length);
      tabList_1 = newList;
    }
    this.tabList = tabList_1;
    return;
  }
  public override function updateLayout__ZZ(resize: Boolean, all: Boolean): void {
    var parent_1: Composite = this.findDeferredControl__();
    if (parent_1 !== null) {
      parent_1.state |= 512;
      return;
    }
    if ((state & 128) != 0) {
      var changed: Boolean = (state & 256) != 0;
      state &= ~(128 | 256);
      layout.layout__Lorg_eclipse_swt_widgets_Composite_2Z(this, changed);
    }
    if (all) {
      state &= ~512;
      var children_1: JavaArray = this._getChildren__();
      for (var i: int = 0; i < children_1.length; i++) {
        children_1[i].updateLayout__ZZ(resize, all);
      }
    }
    return;
  }
  public function Composite(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 2 && vargs[0] is Composite && vargs[1] is int) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.swt.widgets.Scrollable.Scrollable__, []);
        break;
      case 1:
        var args1: Array = [args[0], args[1]];
        superArgs = new Arguments(org.eclipse.swt.widgets.Scrollable.Scrollable__Lorg_eclipse_swt_widgets_Composite_2I, [args1[0], args1[1]]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        Composite__();
        break;
      case 1:
        Composite__Lorg_eclipse_swt_widgets_Composite_2I(args1[0], args1[1]);
        break;
    }
  }
  public static const Composite__ : int = 0;
  public static const Composite__Lorg_eclipse_swt_widgets_Composite_2I : int = 1;
}
}
