package org.eclipse.swt.widgets {
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.*;
import org.eclipse.swt.effects.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.accessibility.*;
import flash.display.DisplayObject;
import flash.events.KeyboardEvent;
import mx.core.*;
import mx.events.MoveEvent;
import mx.events.ResizeEvent;
import mx.managers.IFocusManager;
import mx.managers.IFocusManagerComponent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseListener;
import mx.core.UIComponent;
import org.eclipse.swt.graphics.Point;
import java.lang.Double;
import org.eclipse.swt.events.MouseEvent;
import mx.core.Application;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.GCData;
import java.lang.Math__;
import flash.events.Event;
import flash.geom.Rectangle;
import org.eclipse.swt.graphics.GC;
import flash.events.MouseEvent;
import flash.geom.Point;
import java.lang.System;
import org.eclipse.swt.effects.Effect;
import org.eclipse.swt.effects.CompositeEffect;
import org.eclipse.swt.graphics.Transform;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class Control extends Widget implements Drawable {
  internal var drawCount: int;
  internal var x: int;
  internal var y: int;
  internal var width: int;
  internal var height: int;
  internal var toolTipText: String;
  internal var layoutData: Object;
  internal var parent: Composite;
  internal var cursor: Cursor;
  internal var foreground: Color;
  internal var background: Color;
  internal var backgroundImage: Image;
  internal var font: Font;
  internal var menu: Menu;
  internal var accessible: Accessible;
  internal var region: Region;
  public function Control__(): Object {
    return this;
  }
  public function Control__Lorg_eclipse_swt_widgets_Composite_2I(parent: Composite, style: int): Object {
    this.parent = parent;
    this.createWidget__();
    return this;
  }
  public function addControlListener__Lorg_eclipse_swt_events_ControlListener_2(listener: ControlListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(11, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(10, typedListener);
    return;
  }
  public function addDragDetectListener__Lorg_eclipse_swt_events_DragDetectListener_2(listener: DragDetectListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(29, typedListener);
    return;
  }
  public function addFocusListener__Lorg_eclipse_swt_events_FocusListener_2(listener: FocusListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(15, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(16, typedListener);
    return;
  }
  public function addHelpListener__Lorg_eclipse_swt_events_HelpListener_2(listener: HelpListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(28, typedListener);
    return;
  }
  public function addKeyListener__Lorg_eclipse_swt_events_KeyListener_2(listener: KeyListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(2, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(1, typedListener);
    return;
  }
  public function addMenuDetectListener__Lorg_eclipse_swt_events_MenuDetectListener_2(listener: MenuDetectListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(35, typedListener);
    return;
  }
  public function addMouseListener__Lorg_eclipse_swt_events_MouseListener_2(listener: MouseListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(3, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(4, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(8, typedListener);
    return;
  }
  public function addMouseMoveListener__Lorg_eclipse_swt_events_MouseMoveListener_2(listener: MouseMoveListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(5, typedListener);
    return;
  }
  public function addMouseTrackListener__Lorg_eclipse_swt_events_MouseTrackListener_2(listener: MouseTrackListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(6, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(7, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(32, typedListener);
    return;
  }
  public function addMouseWheelListener__Lorg_eclipse_swt_events_MouseWheelListener_2(listener: MouseWheelListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(37, typedListener);
    return;
  }
  public function addPaintListener__Lorg_eclipse_swt_events_PaintListener_2(listener: PaintListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(9, typedListener);
    return;
  }
  public function addParent__I(index: int): void {
    parent.addControl__Lorg_eclipse_swt_widgets_Control_2(this);
    parent.addChild__Lorg_eclipse_swt_widgets_Widget_2I(this, index);
    return;
  }
  public function addTraverseListener__Lorg_eclipse_swt_events_TraverseListener_2(listener: TraverseListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(31, typedListener);
    return;
  }
  public function backgroundControl__(): UIComponent {
    return object;
  }
  public function cast__Ljava_lang_Object_2(obj: Object): int {
    return int(obj);
  }
  public function computeSize__II(wHint: int, hHint: int): org.eclipse.swt.graphics.Point {
    return this.computeSize__IIZ(wHint, hHint, true);
  }
  public function computeSize__IIZ(wHint: int, hHint: int, changed: Boolean): org.eclipse.swt.graphics.Point {
    this.checkWidget__();
    return this.computeNativeSize__Lmx_core_UIComponent_2IIZ(object, wHint, hHint, changed);
  }
  public function computeNativeSize__Lmx_core_UIComponent_2IIZ(widget: UIComponent, wHint: int, hHint: int, changed: Boolean): org.eclipse.swt.graphics.Point {
    var oldWidth: Number = widget.width;
    var oldHeight: Number = widget.height;
    widget.width = NaN;
    widget.height = NaN;
    widget.validateProperties();
    widget.validateSize();
    var width_1: int = wHint == -1 ? int(widget.measuredWidth) : wHint;
    var height_1: int = hHint == -1 ? int(widget.measuredHeight) : hHint;
    widget.width = oldWidth;
    widget.height = oldHeight;
    return new org.eclipse.swt.graphics.Point(width_1, height_1);
  }
  public function computeTabGroup__(): Control {
    if (this.isTabGroup__())
      return this;
    return parent.computeTabGroup__();
  }
  public function computeTabRoot__(): Control {
    var tabList: JavaArray = parent._getTabList__();
    if (tabList !== null) {
      var index: int = 0;
      while (index < tabList.length) {
        if (tabList[index] === this)
          break;
        index++;
      }
      if (index == tabList.length) {
        if (this.isTabGroup__())
          return this;
      }
    }
    return parent.computeTabRoot__();
  }
  public function computeTabList__(): JavaArray {
    if (this.isTabGroup__()) {
      if (this.getVisible__() && this.getEnabled__()) {
        return new JavaArray("[Lorg/eclipse/swt/widgets/Control;").values(this);
      }
    }
    return new JavaArray("[Lorg/eclipse/swt/widgets/Control;").lengths(0);
  }
  public override function createWidget__(): void {
    super.createWidget__();
    state |= 1024;
    this.setInitialBounds__();
    this.addParent__I(-1);
  }
  public function defaultBackground__(): Color {
    var widget: UIComponent = this.backgroundControl__();
    return Color.flex_new__Lorg_eclipse_swt_graphics_Device_2I(display, this.cast__Ljava_lang_Object_2(widget.getStyle("backgroundColor")));
  }
  public function defaultFont__(): Font {
    var fontFamily: String = String(object.getStyle("fontFamily"));
    var fontStyle: String = String(object.getStyle("fontStyle"));
    var fontWeight: String = String(object.getStyle("fontWeight"));
    var fontSize: int = this.cast__Ljava_lang_Object_2(object.getStyle("fontSize"));
    return Font.flex_new__Lorg_eclipse_swt_graphics_Device_2Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2F(display, fontFamily, fontStyle, fontWeight, fontSize);
  }
  public function defaultForeground__(): Color {
    return Color.flex_new__Lorg_eclipse_swt_graphics_Device_2I(display, this.cast__Ljava_lang_Object_2(object.getStyle("color")));
  }
  public override function destroyWidget__(): void {
    parent.removeChild__Lorg_eclipse_swt_widgets_Widget_2(this);
    this.releaseHandle__();
  }
  public function dragDetect__Lorg_eclipse_swt_widgets_Event_2(event: org.eclipse.swt.widgets.Event): Boolean {
    this.checkWidget__();
    if (event === null)
      this.error__I(4);
    return this._dragDetect__IIIII(event.button, event.count, event.stateMask, event.x, event.y);
  }
  public function drawGripper__IIIIZ(x_1: int, y_1: int, width_1: int, height_1: int, vertical: Boolean): Boolean {
    return false;
  }
  public function dragDetect__Lorg_eclipse_swt_events_MouseEvent_2(event: org.eclipse.swt.events.MouseEvent): Boolean {
    this.checkWidget__();
    if (event === null)
      this.error__I(4);
    return this._dragDetect__IIIII(event.button, event.count, event.stateMask, event.x, event.y);
  }
  public function eventComponent__(): DisplayObject {
    return object;
  }
  public function findBackgroundControl__(): Control {
    if (background !== null || backgroundImage !== null)
      return this;
    return (state & 16384) != 0 ? parent.findBackgroundControl__() : null;
  }
  public function findCursor__(): Cursor {
    if (cursor !== null)
      return cursor;
    return parent.findCursor__();
  }
  public function fixFocus__Lorg_eclipse_swt_widgets_Control_2(focusControl: Control): void {
  }
  public function forceFocus__(): Boolean {
    this.checkWidget__();
    if (!this.isEnabled__() || !this.isVisible__())
      return false;
    if (this.isFocusControl__())
      return true;
    var app: Application = Application(Application.application);
    var focusManager: IFocusManager = app.focusManager;
    if (object is IFocusManagerComponent) {
      focusManager.setFocus(IFocusManagerComponent(object));
    }
    if (this.isDisposed__())
      return false;
    return this.isFocusControl__();
  }
  public function getAccessible__(): Accessible {
    this.checkWidget__();
    if (accessible === null) {
      accessible = Accessible.internal_new_Accessible__Lorg_eclipse_swt_widgets_Control_2(this);
    }
    return accessible;
  }
  public function getAlpha__(): int {
    this.checkWidget__();
    return int(((DisplayObject(object)).alpha * 0xFF));
  }
  public function getBackground__(): Color {
    this.checkWidget__();
    var control: Control = this.findBackgroundControl__();
    if (control === null)
      control = this;
    return control.background !== null ? control.background : control.defaultBackground__();
  }
  public function getBackgroundImage__(): Image {
    this.checkWidget__();
    var control: Control = this.findBackgroundControl__();
    if (control === null)
      control = this;
    return control.backgroundImage;
  }
  public function getBorderWidth__(): int {
    return 0;
  }
  public function getBounds__(): org.eclipse.swt.graphics.Rectangle {
    this.checkWidget__();
    var widget: UIComponent = this.topComponent__();
    return new org.eclipse.swt.graphics.Rectangle(int(widget.x), int(widget.y), int(widget.width), int(widget.height));
  }
  public function getCursor__(): Cursor {
    this.checkWidget__();
    return cursor;
  }
  public function getDragDetect__(): Boolean {
    this.checkWidget__();
    return (state & 1024) != 0;
  }
  public function getEnabled__(): Boolean {
    this.checkWidget__();
    return (state & 32) == 0;
  }
  public function getFont__(): Font {
    this.checkWidget__();
    return font !== null ? font : this.defaultFont__();
  }
  public function getForeground__(): Color {
    this.checkWidget__();
    return foreground !== null ? foreground : this.defaultForeground__();
  }
  public function getLayoutData__(): Object {
    this.checkWidget__();
    return layoutData;
  }
  public function getLocation__(): org.eclipse.swt.graphics.Point {
    this.checkWidget__();
    var widget: UIComponent = this.topComponent__();
    return new org.eclipse.swt.graphics.Point(int(widget.x), int(widget.y));
  }
  public function getMenu__(): Menu {
    this.checkWidget__();
    return menu;
  }
  public function getMonitor__(): Monitor {
    this.checkWidget__();
    return this._getMonitor__();
  }
  public function getParent__(): Composite {
    this.checkWidget__();
    return parent;
  }
  public function getPath__(): JavaArray {
    var count: int = 0;
    var shell: Shell = this.getShell__();
    var control: Control = this;
    while (control !== shell) {
      count++;
      control = control.parent;
    }
    control = this;
    var result: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/Control;").lengths(count);
    while (control !== shell) {
      result[--count] = control;
      control = control.parent;
    }
    return result;
  }
  public function getShell__(): Shell {
    this.checkWidget__();
    return parent.getShell__();
  }
  public function getSize__(): org.eclipse.swt.graphics.Point {
    this.checkWidget__();
    var widget: UIComponent = this.topComponent__();
    return new org.eclipse.swt.graphics.Point(int(widget.width), int(widget.height));
  }
  public function getSprite__(): UIComponent {
    return null;
  }
  public function getToolTipText__(): String {
    this.checkWidget__();
    return toolTipText;
  }
  public function getVisible__(): Boolean {
    this.checkWidget__();
    return (state & 64) == 0;
  }
  public function handleMove__Lmx_events_MoveEvent_2(event: MoveEvent): void {
    var widget: UIComponent = this.topComponent__();
    var newX: int = int(widget.x);
    var newY: int = int(widget.y);
    if (x != newX || y != newY) {
      x = newX;
      y = newY;
      this.moved__();
    }
    return;
  }
  public function handleMoveFunction__(): Function {
    return handleMove__Lmx_events_MoveEvent_2;
  }
  public function handleResize__Lmx_events_ResizeEvent_2(event: ResizeEvent): void {
    if (this.isDisposed__())
      return;
    var widget: UIComponent = this.topComponent__();
    var newWidth: int = int(widget.width);
    var newHeight: int = int(widget.height);
    if (width != newWidth || height != newHeight) {
      width = newWidth;
      height = newHeight;
      this.resized__();
    }
    return;
  }
  public function handleResizeFunction__(): Function {
    return handleResize__Lmx_events_ResizeEvent_2;
  }
  public function hasFocus__(): Boolean {
    if (object.stage !== null) {
      return object.stage.focus === object;
    }
    return false;
  }
  public override function hookEvents__(): void {
    super.hookEvents__();
    this.topComponent__().addEventListener(MoveEvent.MOVE, this.handleMoveFunction__());
    this.resizeComponent__().addEventListener(ResizeEvent.RESIZE, this.handleResizeFunction__());
  }
  public function hooksMouse__I(type: int): Boolean {
    return this.hooks__I(type) || this.filters__I(type);
  }
  public function internal_new_GC__Lorg_eclipse_swt_graphics_GCData_2(data_1: GCData): int {
    this.checkWidget__();
    if (data_1 !== null) {
      data_1.sprite = this.getSprite__();
      var mask: int = 33554432 | 67108864;
      if ((data_1.style & mask) == 0) {
        data_1.style |= style & (mask | 134217728);
      } else {
        if ((data_1.style & 67108864) != 0) {
          data_1.style |= 134217728;
        }
      }
      data_1.device = display;
      data_1.background = this.getBackground__();
      data_1.foreground = this.getForeground__();
      data_1.font = this.getFont__();
      return 1;
    }
    return 0;
  }
  public function internal_dispose_GC__ILorg_eclipse_swt_graphics_GCData_2(hDC: int, data_1: GCData): void {
    if (data_1 !== null) {
      data_1.sprite = null;
    }
    return;
  }
  public function isEnabled__(): Boolean {
    this.checkWidget__();
    return this.getEnabled__() && parent.isEnabled__();
  }
  public function isFocusAncestor__Lorg_eclipse_swt_widgets_Control_2(control: Control): Boolean {
    while (control !== null && control !== this && !(control is Shell)) {
      control = control.parent;
    }
    return control === this;
  }
  public function isFocusControl__(): Boolean {
    this.checkWidget__();
    return this === display.getFocusControl__();
  }
  public function isReparentable__(): Boolean {
    this.checkWidget__();
    return this._isReparentable__();
  }
  public function isShowing__(): Boolean {
    if (!this.isVisible__())
      return false;
    var control: Control = this;
    while (control !== null) {
      var size: org.eclipse.swt.graphics.Point = control.getSize__();
      if (size.x == 0 || size.y == 0) {
        return false;
      }
      control = control.parent;
    }
    return true;
  }
  public function isTabGroup__(): Boolean {
    var tabList: JavaArray = parent._getTabList__();
    if (tabList !== null) {
      for (var i: int = 0; i < tabList.length; i++) {
        if (tabList[i] === this)
          return true;
      }
    }
    return this._isTabGroup__();
  }
  public function isTabItem__(): Boolean {
    var tabList: JavaArray = parent._getTabList__();
    if (tabList !== null) {
      for (var i: int = 0; i < tabList.length; i++) {
        if (tabList[i] === this)
          return false;
      }
    }
    return this._isTabItem__();
  }
  public function isVisible__(): Boolean {
    this.checkWidget__();
    return this.getVisible__() && parent.isVisible__();
  }
  public function markLayout__ZZ(changed: Boolean, all: Boolean): void {
  }
  public function menuShell__(): Decorations {
    return parent.menuShell__();
  }
  public function moveAbove__Lorg_eclipse_swt_widgets_Control_2(control: Control): void {
    this.checkWidget__();
    if (control !== null) {
      if (control.isDisposed__())
        this.error__I(5);
      if (parent !== control.parent)
        return;
    }
    var index: int;
    var parentComponent: UIComponent = parent.parentingComponent__();
    if (control !== null) {
      index = parentComponent.getChildIndex(control.topComponent__());
    } else {
      index = parentComponent.numChildren - 1;
    }
    var topComponent: UIComponent = this.topComponent__();
    if (parentComponent.getChildIndex(topComponent) < index) {
      parentComponent.setChildIndex(topComponent, index);
    }
    return;
  }
  public function moveBelow__Lorg_eclipse_swt_widgets_Control_2(control: Control): void {
    this.checkWidget__();
    if (control !== null) {
      if (control.isDisposed__())
        this.error__I(5);
      if (parent !== control.parent)
        return;
    }
    var index: int;
    var parentComponent: UIComponent = parent.parentingComponent__();
    if (control !== null) {
      index = Math__.max__II(0, parentComponent.getChildIndex(control.topComponent__()) - 1);
    } else {
      index = 0;
    }
    var topComponent: UIComponent = this.topComponent__();
    if (parentComponent.getChildIndex(topComponent) > index) {
      parentComponent.setChildIndex(topComponent, index);
    }
    return;
  }
  public function moved__(): void {
    this.sendEvent__I(10);
    return;
  }
  public function pack__(): void {
    this.checkWidget__();
    this.pack__Z(true);
    return;
  }
  public function pack__Z(changed: Boolean): void {
    this.checkWidget__();
    this.setSize__Lorg_eclipse_swt_graphics_Point_2(this.computeSize__IIZ(-1, -1, changed));
    return;
  }
  public function paintHandler__Lflash_events_Event_2(e: flash.events.Event): void {
    var sprite: UIComponent = this.getSprite__();
    if (e.target !== sprite)
      return;
    sprite.graphics.clear();
    while (sprite.numChildren > 0) {
      sprite.removeChildAt(0);
    }
    var area: flash.geom.Rectangle = new flash.geom.Rectangle(0, 0, object.width, object.height);
    var event: org.eclipse.swt.widgets.Event = new org.eclipse.swt.widgets.Event();
    event.x = Math__.max__II(0, int(area.x));
    event.y = Math__.max__II(0, int(area.y));
    event.width = int(area.width);
    event.height = int(area.height);
    var data_1: GCData = new GCData();
    data_1.paintRect = area;
    var gc: GC = event.gc = GC.flex_new__Lorg_eclipse_swt_graphics_Drawable_2Lorg_eclipse_swt_graphics_GCData_2(this, data_1);
    this.sendEvent__ILorg_eclipse_swt_widgets_Event_2(9, event);
    gc.dispose__();
    event.gc = null;
    return;
  }
  public function paintHandlerFunction__(): Function {
    return paintHandler__Lflash_events_Event_2;
  }
  public function redraw__(): void {
    this.checkWidget__();
    this.redrawWidget__IIIIZ(0, 0, int(object.width), int(object.height), false);
    return;
  }
  public function redraw__IIIIZ(x_1: int, y_1: int, width_1: int, height_1: int, all: Boolean): void {
    this.checkWidget__();
    this.redrawWidget__IIIIZ(x_1, y_1, width_1, height_1, all);
    return;
  }
  public function redrawWidget__IIIIZ(x_1: int, y_1: int, width_1: int, height_1: int, all: Boolean): void {
    if (width_1 == 0 || height_1 == 0)
      return;
    var sprite: UIComponent = this.getSprite__();
    if (sprite !== null) {
      sprite.invalidateDisplayList();
    } else {
      object.invalidateDisplayList();
    }
    return;
  }
  public override function releaseHandle__(): void {
    super.releaseHandle__();
    object = null;
    parent = null;
    return;
  }
  public override function releaseParent__(): void {
    parent.removeControl__Lorg_eclipse_swt_widgets_Control_2(this);
    return;
  }
  public override function releaseWidget__(): void {
    super.releaseWidget__();
    if (menu !== null && !menu.isDisposed__()) {
      menu.dispose__();
    }
    if (display.grabControl === this) {
      display.grabControl = null;
    }
    background = null;
    backgroundImage = null;
    cursor = null;
    font = null;
    foreground = null;
    layoutData = null;
    menu = null;
    toolTipText = null;
    return;
  }
  public function removeControlListener__Lorg_eclipse_swt_events_ControlListener_2(listener: ControlListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(10, listener);
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(11, listener);
  }
  public function removeDragDetectListener__Lorg_eclipse_swt_events_DragDetectListener_2(listener: DragDetectListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(29, listener);
  }
  public function removeFocusListener__Lorg_eclipse_swt_events_FocusListener_2(listener: FocusListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(15, listener);
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(16, listener);
  }
  public function removeHelpListener__Lorg_eclipse_swt_events_HelpListener_2(listener: HelpListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(28, listener);
  }
  public function removeKeyListener__Lorg_eclipse_swt_events_KeyListener_2(listener: KeyListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(2, listener);
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(1, listener);
  }
  public function removeMenuDetectListener__Lorg_eclipse_swt_events_MenuDetectListener_2(listener: MenuDetectListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(35, listener);
  }
  public function removeMouseListener__Lorg_eclipse_swt_events_MouseListener_2(listener: MouseListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(3, listener);
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(4, listener);
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(8, listener);
  }
  public function removeMouseMoveListener__Lorg_eclipse_swt_events_MouseMoveListener_2(listener: MouseMoveListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(5, listener);
  }
  public function removeMouseTrackListener__Lorg_eclipse_swt_events_MouseTrackListener_2(listener: MouseTrackListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(6, listener);
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(7, listener);
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(32, listener);
  }
  public function removeMouseWheelListener__Lorg_eclipse_swt_events_MouseWheelListener_2(listener: MouseWheelListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(37, listener);
  }
  public function removePaintListener__Lorg_eclipse_swt_events_PaintListener_2(listener: PaintListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(9, listener);
  }
  public function removeTraverseListener__Lorg_eclipse_swt_events_TraverseListener_2(listener: TraverseListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(31, listener);
  }
  public function resizeComponent__(): UIComponent {
    return object;
  }
  public function resized__(): void {
    this.sendEvent__I(11);
  }
  public function sendFocusEvent__I(type: int): Boolean {
    var shell: Shell = this.getShell__();
    this.sendEvent__I(type);
    if (!shell.isDisposed__()) {
      switch (type) {
        case 15 :
          shell.setActiveControl__Lorg_eclipse_swt_widgets_Control_2(this);
          break;
        case 16 :
          if (shell !== display.getActiveShell__()) {
            shell.setActiveControl__Lorg_eclipse_swt_widgets_Control_2(null);
          }
          break;
      }
    }
    return true;
  }
  public function sendKeyEvent__ILflash_events_KeyboardEvent_2(type: int, keyEvent: KeyboardEvent): Boolean {
    var event: org.eclipse.swt.widgets.Event = new org.eclipse.swt.widgets.Event();
    if (!this.setKeyState__Lorg_eclipse_swt_widgets_Event_2ILflash_events_KeyboardEvent_2(event, type, keyEvent))
      return true;
    return this.sendKeyEvent__ILorg_eclipse_swt_widgets_Event_2(type, event);
  }
  public function sendKeyEvent__ILorg_eclipse_swt_widgets_Event_2(type: int, keyEvent: org.eclipse.swt.widgets.Event): Boolean {
    this.sendEvent__ILorg_eclipse_swt_widgets_Event_2(type, keyEvent);
    if (this.isDisposed__())
      return false;
    return keyEvent.doit;
  }
  public function sendMouseEvent__ILflash_events_MouseEvent_2Z(type: int, mouseEvent: flash.events.MouseEvent, send: Boolean): Boolean {
    if (!this.hooksMouse__I(type))
      return true;
    var event: org.eclipse.swt.widgets.Event = new org.eclipse.swt.widgets.Event();
    switch (type) {
      case 3 :
      case 4 :
        event.button = 1;
    }
    var eventComponent: DisplayObject = this.eventComponent__();
    if (mouseEvent.target === eventComponent) {
      event.x = int(mouseEvent.localX);
      event.y = int(mouseEvent.localY);
    } else {
      var pt: flash.geom.Point = new flash.geom.Point(mouseEvent.stageX, mouseEvent.stageY);
      pt = eventComponent.globalToLocal(pt);
      event.x = int(pt.x);
      event.y = int(pt.y);
    }
    event.time = int(System.currentTimeMillis__());
    event.count = display.getClickCount__ILorg_eclipse_swt_widgets_Control_2III(type, this, event.x, event.y, event.time);
    this.setInputState__Lorg_eclipse_swt_widgets_Event_2IZZZZ(event, type, mouseEvent.altKey, mouseEvent.ctrlKey, mouseEvent.shiftKey, mouseEvent.buttonDown);
    return this.sendMouseEvent__ILorg_eclipse_swt_widgets_Event_2Z(type, event, send);
  }
  public function sendMouseEvent__ILorg_eclipse_swt_widgets_Event_2Z(type: int, mouseEvent: org.eclipse.swt.widgets.Event, send: Boolean): Boolean {
    if (send) {
      this.sendEvent__ILorg_eclipse_swt_widgets_Event_2(type, mouseEvent);
      if (this.isDisposed__())
        return false;
    } else {
      this.postEvent__ILorg_eclipse_swt_widgets_Event_2(type, mouseEvent);
    }
    return mouseEvent.doit;
  }
  public function setInputState__Lorg_eclipse_swt_widgets_Event_2IZZZZ(event: org.eclipse.swt.widgets.Event, type: int, altKey: Boolean, controlKey: Boolean, shiftKey: Boolean, buttonDown: Boolean): Boolean {
    if (altKey)
      event.stateMask |= 65536;
    if (shiftKey)
      event.stateMask |= 131072;
    if (controlKey)
      event.stateMask |= 262144;
    if (buttonDown)
      event.stateMask |= 524288;
    switch (type) {
      case 3 :
      case 8 :
        if (event.button == 1)
          event.stateMask &= ~524288;
        if (event.button == 2)
          event.stateMask &= ~1048576;
        if (event.button == 3)
          event.stateMask &= ~2097152;
        if (event.button == 4)
          event.stateMask &= ~8388608;
        if (event.button == 5)
          event.stateMask &= ~33554432;
        break;
      case 4 :
        if (event.button == 1)
          event.stateMask |= 524288;
        if (event.button == 2)
          event.stateMask |= 1048576;
        if (event.button == 3)
          event.stateMask |= 2097152;
        if (event.button == 4)
          event.stateMask |= 8388608;
        if (event.button == 5)
          event.stateMask |= 33554432;
        break;
      case 1 :
      case 31 :
        if (event.keyCode == 65536)
          event.stateMask &= ~65536;
        if (event.keyCode == 131072)
          event.stateMask &= ~131072;
        if (event.keyCode == 262144)
          event.stateMask &= ~262144;
        break;
      case 2 :
        if (event.keyCode == 65536)
          event.stateMask |= 65536;
        if (event.keyCode == 131072)
          event.stateMask |= 131072;
        if (event.keyCode == 262144)
          event.stateMask |= 262144;
        break;
    }
    return true;
  }
  public function setInitialBounds__(): void {
    var topComponent: UIComponent = this.topComponent__();
    topComponent.x = topComponent.y = 0;
    topComponent.width = topComponent.height = 0;
  }
  public function setAlpha__I(alpha: int): void {
    this.checkWidget__();
    (DisplayObject(object)).alpha = (alpha & 0xFF) / Number(0xFF);
  }
  public function setBackground__Lorg_eclipse_swt_graphics_Color_2(color: Color): void {
    this.checkWidget__();
    if (color !== null && color.isDisposed__())
      SWT.error__I(5);
    var oldColor: Color = this.background;
    if (oldColor === color)
      return;
    this.background = color;
    if (oldColor !== null && oldColor.equals__Ljava_lang_Object_2(color)) {
      return;
    }
    var widget: UIComponent = this.backgroundControl__();
    if (color !== null) {
      widget.setStyle("backgroundColor", color.handle);
    } else {
      widget.clearStyle("backgroundColor");
    }
    return;
  }
  public function setBackgroundImage__Lorg_eclipse_swt_graphics_Image_2(image: Image): void {
    this.checkWidget__();
    if (image !== null && image.isDisposed__())
      SWT.error__I(5);
    var oldImage: Image = this.backgroundImage;
    if (oldImage === image)
      return;
    this.backgroundImage = image;
    if (oldImage !== null && oldImage.equals__Ljava_lang_Object_2(font)) {
      return;
    }
    this._setBackgroundImage__Lorg_eclipse_swt_graphics_Image_2(image);
    return;
  }
  public function setBounds__IIII(x_1: int, y_1: int, width_1: int, height_1: int): void {
    this.checkWidget__();
    this.setBounds__IIIII(x_1, y_1, Math__.max__II(0, width_1), Math__.max__II(0, height_1), 4096 | 8192);
    return;
  }
  public function setBounds__IIIII(x_1: int, y_1: int, width_1: int, height_1: int, flags: int): int {
    var sameOrigin: Boolean = true;
    var sameExtent: Boolean = true;
    var widget: UIComponent = this.topComponent__();
    var oldX: int = int(widget.x);
    var oldY: int = int(widget.y);
    if ((flags & 4096) != 0) {
      sameOrigin = x_1 == oldX && y_1 == oldY;
    } else {
      x_1 = oldX;
      y_1 = oldY;
    }
    var oldWidth: int = int(widget.width);
    var oldHeight: int = int(widget.height);
    if ((flags & 8192) != 0) {
      sameExtent = width_1 == oldWidth && height_1 == oldHeight;
    } else {
      width_1 = oldWidth;
      height_1 = oldHeight;
    }
    if (!sameOrigin) {
      this.x = x_1;
      this.y = y_1;
      widget.x = x_1;
      widget.y = y_1;
    }
    if (!sameExtent) {
      this.width = width_1;
      this.height = height_1;
      widget.width = width_1;
      widget.height = height_1;
    }
    var result: int = 0;
    if (!sameOrigin) {
      this.sendEvent__I(10);
      result |= 4096;
    }
    if (!sameExtent) {
      this.sendEvent__I(11);
      result |= 8192;
    }
    return result;
  }
  public function setBounds__Lorg_eclipse_swt_graphics_Rectangle_2(rect: org.eclipse.swt.graphics.Rectangle): void {
    this.checkWidget__();
    if (rect === null)
      this.error__I(4);
    this.setBounds__IIII(rect.x, rect.y, rect.width, rect.height);
  }
  public function setCapture__Z(capture: Boolean): void {
    this.checkWidget__();
    this._setCapture__Z(capture);
  }
  public function setCursor__Lorg_eclipse_swt_graphics_Cursor_2(cursor_1: Cursor): void {
    this.checkWidget__();
    if (cursor_1 !== null && cursor_1.isDisposed__())
      SWT.error__I(5);
    this.cursor = cursor_1;
  }
  public function setDragDetect__Z(dragDetect: Boolean): void {
    this.checkWidget__();
    state = dragDetect ? state & ~1024 : state | 1024;
  }
  public function setEffect__Lorg_eclipse_swt_effects_Effect_2(effect: Effect): void {
    this.checkWidget__();
    if (effect !== null && effect.isDisposed__())
      SWT.error__I(5);
    var array: Array = new Array();
    if (effect !== null) {
      if (effect is CompositeEffect) {
        var effects: JavaArray = JavaArray(effect.object);
        for (var i: int = 0; i < effects.length; i++) {
          array.push(effects[i].object);
        }
      } else {
        array.push(effect.object);
      }
    }
    var widget: UIComponent = this.topComponent__();
    widget.filters = array;
    return;
  }
  public function setEnabled__Z(enabled: Boolean): void {
    this.checkWidget__();
    if (((state & 32) == 0) == enabled)
      return;
    var control: Control = null;
    var fixFocus: Boolean = false;
    if (!enabled) {
      control = display.getFocusControl__();
      fixFocus = this.isFocusAncestor__Lorg_eclipse_swt_widgets_Control_2(control);
    }
    state = enabled ? state & ~32 : state | 32;
    var widget: UIComponent = this.topComponent__();
    widget.enabled = enabled;
    widget.mouseChildren = enabled;
    if (this.isDisposed__())
      return;
    if (fixFocus)
      this.fixFocus__Lorg_eclipse_swt_widgets_Control_2(control);
  }
  public function setFocus__(): Boolean {
    this.checkWidget__();
    if ((style & 524288) != 0)
      return false;
    return this.forceFocus__();
  }
  public function setFont__Lorg_eclipse_swt_graphics_Font_2(font_1: Font): void {
    this.checkWidget__();
    if (font_1 !== null && font_1.isDisposed__())
      SWT.error__I(5);
    var oldFont: Font = this.font;
    if (oldFont === font_1)
      return;
    this.font = font_1;
    if (oldFont !== null && oldFont.equals__Ljava_lang_Object_2(font_1)) {
      return;
    }
    if (font_1 !== null) {
      object.setStyle("fontFamily", font_1.fontFamily);
      object.setStyle("fontStyle", font_1.fontStyle);
      object.setStyle("fontWeight", font_1.fontWeight);
      object.setStyle("fontSize", font_1.fontSize);
    } else {
      object.clearStyle("fontFamily");
      object.clearStyle("fontStyle");
      object.clearStyle("fontWeight");
      object.clearStyle("fontSize");
    }
    return;
  }
  public function setForeground__Lorg_eclipse_swt_graphics_Color_2(color: Color): void {
    this.checkWidget__();
    if (color !== null && color.isDisposed__())
      SWT.error__I(5);
    var oldColor: Color = this.foreground;
    if (oldColor === color)
      return;
    this.foreground = color;
    if (oldColor !== null && oldColor.equals__Ljava_lang_Object_2(color)) {
      return;
    }
    if (color !== null) {
      object.setStyle("color", color.handle);
    } else {
      object.clearStyle("backgroundColor");
    }
    return;
  }
  public function setKeyState__Lorg_eclipse_swt_widgets_Event_2ILflash_events_KeyboardEvent_2(event: org.eclipse.swt.widgets.Event, type: int, keyEvent: KeyboardEvent): Boolean {
    event.keyCode = Display.translateKey__I(keyEvent.keyCode);
    if (event.keyCode == 0) {
      var key: int = event.keyCode = keyEvent.keyCode;
      if (65 <= key && key <= 90)
        event.keyCode += 97 - 65;
    }
    var isNull: Boolean = false;
    var key_1: int = event.character;
    if (keyEvent.ctrlKey && (0 <= key_1 && key_1 <= 0x7F)) {
      if (97 <= key_1 && key_1 <= 122)
        key_1 -= 97 - 65;
      if (64 <= key_1 && key_1 <= 95)
        key_1 -= 64;
      event.character = uint(key_1);
      isNull = keyEvent.keyCode == 64 && key_1 == 0;
    } else {
      event.character = uint(keyEvent.charCode);
    }
    if (event.keyCode == 0 && event.character == 0) {
      if (!isNull)
        return false;
    }
    return this.setInputState__Lorg_eclipse_swt_widgets_Event_2IZZZZ(event, type, keyEvent.altKey, keyEvent.ctrlKey, keyEvent.shiftKey, false);
  }
  public function setLayoutData__Ljava_lang_Object_2(layoutData_1: Object): void {
    this.checkWidget__();
    this.layoutData = layoutData_1;
  }
  public function setLocation__II(x_1: int, y_1: int): void {
    this.checkWidget__();
    this.setBounds__IIIII(x_1, y_1, 0, 0, 4096);
  }
  public function setLocation__Lorg_eclipse_swt_graphics_Point_2(location: org.eclipse.swt.graphics.Point): void {
    this.checkWidget__();
    if (location === null)
      this.error__I(4);
    this.setLocation__II(location.x, location.y);
  }
  public function setMenu__Lorg_eclipse_swt_widgets_Menu_2(menu_1: Menu): void {
    this.checkWidget__();
    if (menu_1 !== null) {
      if (menu_1.isDisposed__())
        SWT.error__I(5);
      if ((menu_1.style & 8) == 0) {
        this.error__I(37);
      }
      if (menu_1.parent !== this.menuShell__()) {
        this.error__I(32);
      }
    }
    this.menu = menu_1;
    return;
  }
  public function setParent__Lorg_eclipse_swt_widgets_Composite_2(parent_1: Composite): Boolean {
    this.checkWidget__();
    if (parent_1 === null)
      this.error__I(4);
    if (parent_1.isDisposed__())
      SWT.error__I(5);
    if (this.parent === parent_1)
      return true;
    if (!this.isReparentable__())
      return false;
    return this._setParent__Lorg_eclipse_swt_widgets_Composite_2(parent_1);
  }
  public function setRadioSelection__Z(value: Boolean): Boolean {
    return false;
  }
  public function setRedraw__Z(redraw: Boolean): void {
    this.checkWidget__();
    if (redraw) {
      if (--drawCount == 0) {
        this._setRedraw__Z(redraw);
      }
    } else {
      if (drawCount++ == 0) {
        this._setRedraw__Z(redraw);
      }
    }
    return;
  }
  public function setRegion__Lorg_eclipse_swt_graphics_Region_2(region_1: Region): void {
    this.checkWidget__();
    if (region_1 !== null && region_1.isDisposed__())
      this.error__I(5);
    this.region = region_1;
    return;
  }
  public function setSize__II(width_1: int, height_1: int): void {
    this.checkWidget__();
    this.setBounds__IIIII(0, 0, Math__.max__II(0, width_1), Math__.max__II(0, height_1), 8192);
    return;
  }
  public function setSize__Lorg_eclipse_swt_graphics_Point_2(size: org.eclipse.swt.graphics.Point): void {
    this.checkWidget__();
    if (size === null)
      this.error__I(4);
    this.setSize__II(size.x, size.y);
    return;
  }
  public function setTabGroupFocus__(): Boolean {
    return this.setTabItemFocus__();
  }
  public function setTabItemFocus__(): Boolean {
    if (!this.isShowing__())
      return false;
    return this.forceFocus__();
  }
  public function setToolTipText__Ljava_lang_String_2(string: String): void {
    this.checkWidget__();
    toolTipText = string;
    object.toolTip = string;
  }
  public function setTransform__Lorg_eclipse_swt_graphics_Transform_2(transform: Transform): void {
    this.checkWidget__();
    var widget: UIComponent = this.topComponent__();
    widget.transform.matrix = transform.object;
  }
  public function setVisible__Z(visible: Boolean): void {
    this.checkWidget__();
    if (((state & 64) == 0) == visible)
      return;
    if (visible) {
      this.sendEvent__I(22);
      if (this.isDisposed__())
        return;
    }
    var control: Control = null;
    var fixFocus: Boolean = false;
    if (!visible) {
      control = display.getFocusControl__();
      fixFocus = this.isFocusAncestor__Lorg_eclipse_swt_widgets_Control_2(control);
    }
    state = visible ? state & ~64 : state | 64;
    var widget: UIComponent = this.topComponent__();
    widget.visible = visible;
    if (!visible) {
      this.sendEvent__I(23);
      if (this.isDisposed__())
        return;
    }
    if (fixFocus)
      this.fixFocus__Lorg_eclipse_swt_widgets_Control_2(control);
    return;
  }
  public function sort___3I(items: JavaArray): void {
    var length: int = items.length;
    for (var gap: int = int(length / 2); gap > 0; gap /= 2) {
      for (var i: int = gap; i < length; i++) {
        for (var j: int = i - gap; j >= 0; j -= gap) {
          if (items[j] <= items[j + gap]) {
            var swap: int = items[j];
            items[j] = items[j + gap];
            items[j + gap] = swap;
          }
        }
      }
    }
    return;
  }
  public function toControl__II(x_1: int, y_1: int): org.eclipse.swt.graphics.Point {
    this.checkWidget__();
    return display.map__Lorg_eclipse_swt_widgets_Control_2Lorg_eclipse_swt_widgets_Control_2II(null, this, x_1, y_1);
  }
  public function toControl__Lorg_eclipse_swt_graphics_Point_2(point: org.eclipse.swt.graphics.Point): org.eclipse.swt.graphics.Point {
    this.checkWidget__();
    if (point === null)
      this.error__I(4);
    return this.toControl__II(point.x, point.y);
  }
  public function toDisplay__II(x_1: int, y_1: int): org.eclipse.swt.graphics.Point {
    this.checkWidget__();
    return display.map__Lorg_eclipse_swt_widgets_Control_2Lorg_eclipse_swt_widgets_Control_2II(this, null, x_1, y_1);
  }
  public function toDisplay__Lorg_eclipse_swt_graphics_Point_2(point: org.eclipse.swt.graphics.Point): org.eclipse.swt.graphics.Point {
    this.checkWidget__();
    if (point === null)
      this.error__I(4);
    return this.toDisplay__II(point.x, point.y);
  }
  public function traverse__I(traversal: int): Boolean {
    this.checkWidget__();
    var event: org.eclipse.swt.widgets.Event = new org.eclipse.swt.widgets.Event();
    event.doit = true;
    event.detail = traversal;
    return this.traverse__Lorg_eclipse_swt_widgets_Event_2(event);
  }
  public function traverseEscape__(): Boolean {
    return false;
  }
  public function traverseGroup__Z(next: Boolean): Boolean {
    var root: Control = this.computeTabRoot__();
    var group: Control = this.computeTabGroup__();
    var list: JavaArray = root.computeTabList__();
    var length: int = list.length;
    var index: int = 0;
    while (index < length) {
      if (list[index] === group)
        break;
      index++;
    }
    if (index == length)
      return false;
    var start: int = index;
    var offset: int = (next) ? 1 : -1;
    while ((index = ((index + offset + length) % length)) != start) {
      var control: Control = list[index];
      if (!control.isDisposed__() && control.setTabGroupFocus__()) {
        return true;
      }
    }
    if (group.isDisposed__())
      return false;
    return group.setTabGroupFocus__();
  }
  public function traverseItem__Z(next: Boolean): Boolean {
    var children: JavaArray = parent._getChildren__();
    var length: int = children.length;
    var index: int = 0;
    while (index < length) {
      if (children[index] === this)
        break;
      index++;
    }
    if (index == length)
      return false;
    var start: int = index;
    var offset: int = (next) ? 1 : -1;
    while ((index = (index + offset + length) % length) != start) {
      var child: Control = children[index];
      if (!child.isDisposed__() && child.isTabItem__()) {
        if (child.setTabItemFocus__())
          return true;
      }
    }
    return false;
  }
  public function traverseMnemonic__C(key: uint): Boolean {
    return false;
  }
  public function traversePage__Z(next: Boolean): Boolean {
    return false;
  }
  public function traverseReturn__(): Boolean {
    return false;
  }
  public function traverse__Lorg_eclipse_swt_widgets_Event_2(event: org.eclipse.swt.widgets.Event): Boolean {
    this.sendEvent__ILorg_eclipse_swt_widgets_Event_2(31, event);
    if (this.isDisposed__())
      return true;
    if (!event.doit)
      return false;
    switch (event.detail) {
      case 0 :
        return true;
      case 2 :
        return this.traverseEscape__();
      case 4 :
        return this.traverseReturn__();
      case 16 :
        return this.traverseGroup__Z(true);
      case 8 :
        return this.traverseGroup__Z(false);
      case 64 :
        return this.traverseItem__Z(true);
      case 32 :
        return this.traverseItem__Z(false);
      case 128 :
        return this.traverseMnemonic__C(event.character);
      case 512 :
        return this.traversePage__Z(true);
      case 256 :
        return this.traversePage__Z(false);
    }
    return false;
  }
  public function update__(): void {
    this.checkWidget__();
    object.validateDisplayList();
  }
  public function updateLayout__ZZ(resize: Boolean, all: Boolean): void {
  }
  public function _dragDetect__IIIII(button: int, count: int, stateMask: int, x_1: int, y_1: int): Boolean {
    return false;
  }
  public function _getMonitor__(): Monitor {
    return null;
  }
  public function _isReparentable__(): Boolean {
    return false;
  }
  public function _isTabGroup__(): Boolean {
    return false;
  }
  public function _isTabItem__(): Boolean {
    return false;
  }
  public function _setBackgroundImage__Lorg_eclipse_swt_graphics_Image_2(image: Image): void {
  }
  public function _setCapture__Z(capture: Boolean): void {
  }
  public function _setParent__Lorg_eclipse_swt_widgets_Composite_2(parent_1: Composite): Boolean {
    return false;
  }
  public function _setRedraw__Z(redraw: Boolean): void {
  }
  public function Control(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 2 && vargs[0] is Composite && vargs[1] is int) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.swt.widgets.Widget.Widget__, []);
        break;
      case 1:
        var args1: Array = [args[0], args[1]];
        superArgs = new Arguments(org.eclipse.swt.widgets.Widget.Widget__Lorg_eclipse_swt_widgets_Widget_2I, [args1[0], args1[1]]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        Control__();
        break;
      case 1:
        Control__Lorg_eclipse_swt_widgets_Composite_2I(args1[0], args1[1]);
        break;
    }
  }
  public static const Control__ : int = 0;
  public static const Control__Lorg_eclipse_swt_widgets_Composite_2I : int = 1;
}
}
