package org.eclipse.swt.widgets {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import java.lang.Math__;
import org.eclipse.swt.graphics.Rectangle;
import java.lang.System;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Color;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class CoolBar extends Composite {
  internal var items: JavaArray = new JavaArray("[[Lorg/eclipse/swt/widgets/CoolItem;").lengths(0, 0);
  internal var originalItems: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/CoolItem;").lengths(0);
  internal var hoverCursor: Cursor;
  internal var dragCursor: Cursor;
  internal var cursor_org_eclipse_swt_widgets_CoolBar: Cursor;
  internal var dragging: CoolItem = null;
  internal var mouseXOffset: int;
  internal var itemXOffset: int;
  internal var isLocked: Boolean = false;
  internal var inDispose: Boolean = false;
  public static const ROW_SPACING: int = 2;
  public static const CLICK_DISTANCE: int = 3;
  public static const DEFAULT_COOLBAR_WIDTH: int = 0;
  public static const DEFAULT_COOLBAR_HEIGHT: int = 0;
  public function CoolBar(parent: Composite, style: int) {
    super(new Arguments(org.eclipse.swt.widgets.Composite.Composite__Lorg_eclipse_swt_widgets_Composite_2I, [parent, CoolBar.checkStyle__I(style)]));
    if ((style & 512) != 0) {
      this.style |= 512;
      hoverCursor = new Cursor(new Arguments(org.eclipse.swt.graphics.Cursor.Cursor__Lorg_eclipse_swt_graphics_Device_2I, [display, 7]));
    } else {
      this.style |= 256;
      hoverCursor = new Cursor(new Arguments(org.eclipse.swt.graphics.Cursor.Cursor__Lorg_eclipse_swt_graphics_Device_2I, [display, 9]));
    }
    dragCursor = new Cursor(new Arguments(org.eclipse.swt.graphics.Cursor.Cursor__Lorg_eclipse_swt_graphics_Device_2I, [display, 5]));
    var listener: Listener = new org.eclipse.swt.widgets.CoolBar$1(this);
    var events: JavaArray = new JavaArray("[I").values(12, 3, 7, 5, 4, 8, 9, 11);
    for (var i: int = 0; i < events.length; i++) {
      this.addListener__ILorg_eclipse_swt_widgets_Listener_2(events[i], listener);
    }
    return;
  }
  public static function checkStyle__I(style: int): int {
    style |= 524288;
    return (style | 1048576) & ~(512 | 256);
  }
  public function _setCursor__Lorg_eclipse_swt_graphics_Cursor_2(cursor_1: Cursor): void {
    if (this.cursor_org_eclipse_swt_widgets_CoolBar !== null)
      return;
    super.setCursor__Lorg_eclipse_swt_graphics_Cursor_2(cursor_1);
  }
  public override function checkSubclass__(): void {
    if (!this.isValidSubclass__())
      this.error__I(43);
  }
  public override function computeSize__IIZ(wHint: int, hHint: int, changed: Boolean): Point {
    this.checkWidget__();
    var width_1: int = 0;
    var height_1: int = 0;
    this.wrapItems__I((style & 512) != 0 ? hHint : wHint);
    var flat: Boolean = (style & 8388608) != 0;
    for (var row: int = 0; row < items.length; row++) {
      var rowWidth: int = 0;
      var rowHeight: int = 0;
      for (var i: int = 0; i < items[row].length; i++) {
        var item: CoolItem = items[row][i];
        rowWidth += item.preferredWidth;
        rowHeight = Math__.max__II(rowHeight, item.preferredHeight);
      }
      height_1 += rowHeight;
      if (!flat && row > 0)
        height_1 += 2;
      width_1 = Math__.max__II(width_1, rowWidth);
    }
    this.wrapItems__I(this.getWidth__());
    if (width_1 == 0)
      width_1 = 0;
    if (height_1 == 0)
      height_1 = 0;
    var size: Point = this.fixPoint__II(width_1, height_1);
    if (wHint != -1)
      size.x = wHint;
    if (hHint != -1)
      size.y = hHint;
    var trim: Rectangle = this.computeTrim__IIII(0, 0, size.x, size.y);
    return new Point(trim.width, trim.height);
  }
  public function getGrabbedItem__II(x_1: int, y_1: int): CoolItem {
    for (var row: int = 0; row < items.length; row++) {
      for (var i: int = 0; i < items[row].length; i++) {
        var item: CoolItem = items[row][i];
        var bounds: Rectangle = item.internalGetBounds__();
        bounds.width = 10;
        if (bounds.x > x_1)
          break;
        if (bounds.y > y_1)
          return null;
        if (bounds.contains__II(x_1, y_1)) {
          return item;
        }
      }
    }
    return null;
  }
  public function getItem__I(index: int): CoolItem {
    this.checkWidget__();
    if (index < 0)
      this.error__I(6);
    for (var row: int = 0; row < items.length; row++) {
      if (items[row].length > index) {
        return items[row][index];
      } else {
        index -= items[row].length;
      }
    }
    this.error__I(6);
    return null;
  }
  public function getItemCount__(): int {
    this.checkWidget__();
    return originalItems.length;
  }
  public function getItems__(): JavaArray {
    this.checkWidget__();
    var result: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/CoolItem;").lengths(this.getItemCount__());
    var offset: int = 0;
    for (var row: int = 0; row < items.length; row++) {
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(items[row], 0, result, offset, items[row].length);
      offset += items[row].length;
    }
    return result;
  }
  public function findItem__Lorg_eclipse_swt_widgets_CoolItem_2(item: CoolItem): Point {
    for (var row: int = 0; row < items.length; row++) {
      for (var i: int = 0; i < items[row].length; i++) {
        if (Object(items[row][i]).equals__Ljava_lang_Object_2(item))
          return new Point(i, row);
      }
    }
    return new Point(-1, -1);
  }
  public function fixEvent__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    if ((style & 512) != 0) {
      var tmp: int = event.x;
      event.x = event.y;
      event.y = tmp;
    }
    return;
  }
  public function fixRectangle__IIII(x_1: int, y_1: int, width_1: int, height_1: int): Rectangle {
    if ((style & 512) != 0) {
      return new Rectangle(y_1, x_1, height_1, width_1);
    }
    return new Rectangle(x_1, y_1, width_1, height_1);
  }
  public function fixPoint__II(x_1: int, y_1: int): Point {
    if ((style & 512) != 0) {
      return new Point(y_1, x_1);
    }
    return new Point(x_1, y_1);
  }
  public function indexOf__Lorg_eclipse_swt_widgets_CoolItem_2(item: CoolItem): int {
    this.checkWidget__();
    if (item === null)
      this.error__I(4);
    if (item.isDisposed__())
      this.error__I(5);
    var answer: int = 0;
    for (var row: int = 0; row < items.length; row++) {
      for (var i: int = 0; i < items[row].length; i++) {
        if (Object(items[row][i]).equals__Ljava_lang_Object_2(item)) {
          return answer;
        } else {
          answer++;
        }
      }
    }
    return -1;
  }
  public function insertItemIntoRow__Lorg_eclipse_swt_widgets_CoolItem_2II(item: CoolItem, rowIndex: int, x_root: int): Boolean {
    if (rowIndex < 0 || rowIndex >= items.length) {
      var bottom: Boolean = rowIndex >= items.length;
      var newRows: JavaArray = new JavaArray("[[Lorg/eclipse/swt/widgets/CoolItem;").lengths(items.length + 1);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(items, 0, newRows, bottom ? 0 : 1, items.length);
      var row: int = bottom ? items.length : 0;
      newRows[row] = new JavaArray("[Lorg/eclipse/swt/widgets/CoolItem;").lengths(1);
      newRows[row][0] = item;
      items = newRows;
      item.wrap = true;
      return true;
    }
    var barWidth: int = this.getWidth__();
    var bounds: Rectangle = items[rowIndex][0].internalGetBounds__();
    var rowY: int = bounds.y;
    var oldRowHeight: int = bounds.height;
    var x_1: int = Math__.max__II(0, Math__.abs__I(x_root - this.toDisplay__Lorg_eclipse_swt_graphics_Point_2(new Point(0, 0)).x));
    var index: int;
    for (index = 0; index < items[rowIndex].length; index++) {
      if (x_1 < items[rowIndex][index].internalGetBounds__().x)
        break;
    }
    if (index == 0) {
      item.wrap = true;
      items[rowIndex][0].wrap = false;
    }
    var oldLength: int = items[rowIndex].length;
    var newRow: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/CoolItem;").lengths(oldLength + 1);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(items[rowIndex], 0, newRow, 0, index);
    newRow[index] = item;
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(items[rowIndex], index, newRow, index + 1, oldLength - index);
    items[rowIndex] = newRow;
    if (index > 0) {
      var left: CoolItem = items[rowIndex][index - 1];
      var leftBounds: Rectangle = left.internalGetBounds__();
      var newWidth: int = x_1 - leftBounds.x;
      if (newWidth < left.internalGetMinimumWidth__()) {
        x_1 += left.internalGetMinimumWidth__() - newWidth;
        newWidth = left.internalGetMinimumWidth__();
      }
      left.setBounds__IIII(leftBounds.x, leftBounds.y, newWidth, leftBounds.height);
      left.requestedWidth = newWidth;
    }
    var width_1: int = 0;
    var height_1: int = item.preferredHeight;
    if (index < items[rowIndex].length - 1) {
      var right: CoolItem = items[rowIndex][index + 1];
      width_1 = right.internalGetBounds__().x - x_1;
      if (width_1 < right.internalGetMinimumWidth__()) {
        this.moveRight__Lorg_eclipse_swt_widgets_CoolItem_2I(right, right.internalGetMinimumWidth__() - width_1);
        width_1 = right.internalGetBounds__().x - x_1;
      }
      item.setBounds__IIII(x_1, rowY, width_1, height_1);
      if (width_1 < item.internalGetMinimumWidth__())
        this.moveLeft__Lorg_eclipse_swt_widgets_CoolItem_2I(item, item.internalGetMinimumWidth__() - width_1);
    } else {
      width_1 = Math__.max__II(item.internalGetMinimumWidth__(), barWidth - x_1);
      item.setBounds__IIII(x_1, rowY, width_1, height_1);
      if (x_1 + width_1 > barWidth)
        this.moveLeft__Lorg_eclipse_swt_widgets_CoolItem_2I(item, x_1 + width_1 - barWidth);
    }
    bounds = item.internalGetBounds__();
    item.requestedWidth = bounds.width;
    this.internalRedraw__IIII(bounds.x, bounds.y, item.internalGetMinimumWidth__(), bounds.height);
    return height_1 > oldRowHeight;
  }
  public function internalRedraw__IIII(x_1: int, y_1: int, width_1: int, height_1: int): void {
    if ((style & 512) != 0) {
      this.redraw__IIIIZ(y_1, x_1, height_1, width_1, false);
    } else {
      this.redraw__IIIIZ(x_1, y_1, width_1, height_1, false);
    }
    return;
  }
  public function createItem__Lorg_eclipse_swt_widgets_CoolItem_2I(item: CoolItem, index: int): void {
    var itemCount: int = this.getItemCount__();
    var row: int = 0;
    if (!(0 <= index && index <= itemCount))
      this.error__I(6);
    if (items.length == 0) {
      items = new JavaArray("[[Lorg/eclipse/swt/widgets/CoolItem;").lengths(1, 1);
      items[0][0] = item;
    } else {
      var i: int = index;
      if (index < itemCount) {
        while (i > items[row].length) {
          i -= items[row].length;
          row++;
        }
      } else {
        row = items.length - 1;
        i = items[row].length;
      }
      var lastIndex: int = items[row].length - 1;
      var lastItem: CoolItem = items[row][lastIndex];
      if (lastItem.ideal) {
        var bounds: Rectangle = lastItem.internalGetBounds__();
        bounds.width = lastItem.preferredWidth;
        bounds.height = lastItem.preferredHeight;
        lastItem.requestedWidth = lastItem.preferredWidth;
        lastItem.setBounds__IIII(bounds.x, bounds.y, bounds.width, bounds.height);
      }
      if (i == 0) {
        item.wrap = true;
        items[row][0].wrap = false;
      }
      var oldLength: int = items[row].length;
      var newRow: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/CoolItem;").lengths(oldLength + 1);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(items[row], 0, newRow, 0, i);
      newRow[i] = item;
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(items[row], i, newRow, i + 1, oldLength - i);
      items[row] = newRow;
    }
    item.requestedWidth = 10;
    var length: int = originalItems.length;
    var newOriginals: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/CoolItem;").lengths(length + 1);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(originalItems, 0, newOriginals, 0, index);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(originalItems, index, newOriginals, index + 1, length - index);
    newOriginals[index] = item;
    originalItems = newOriginals;
    this.layoutItems__();
    return;
  }
  public function destroyItem__Lorg_eclipse_swt_widgets_CoolItem_2(item: CoolItem): void {
    if (inDispose)
      return;
    var row: int = this.findItem__Lorg_eclipse_swt_widgets_CoolItem_2(item).y;
    if (row == -1)
      return;
    var bounds: Rectangle = item.internalGetBounds__();
    this.removeItemFromRow__Lorg_eclipse_swt_widgets_CoolItem_2IZ(item, row, true);
    var index: int = 0;
    while (index < originalItems.length) {
      if (originalItems[index] === item)
        break;
      index++;
    }
    var length: int = originalItems.length - 1;
    var newOriginals: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/CoolItem;").lengths(length);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(originalItems, 0, newOriginals, 0, index);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(originalItems, index + 1, newOriginals, index, length - index);
    originalItems = newOriginals;
    this.internalRedraw__IIII(bounds.x, bounds.y, 10, bounds.height);
    this.relayout__();
    return;
  }
  public function moveDown__Lorg_eclipse_swt_widgets_CoolItem_2I(item: CoolItem, x_root: int): void {
    var oldRowIndex: int = this.findItem__Lorg_eclipse_swt_widgets_CoolItem_2(item).y;
    if (items[oldRowIndex].length == 1) {
      if (oldRowIndex == items.length - 1)
        return;
    }
    var newRowIndex: int = (items[oldRowIndex].length == 1) ? oldRowIndex : oldRowIndex + 1;
    var resize: Boolean = this.removeItemFromRow__Lorg_eclipse_swt_widgets_CoolItem_2IZ(item, oldRowIndex, false);
    var old: Rectangle = item.internalGetBounds__();
    this.internalRedraw__IIII(old.x, old.y, 10, old.height);
    resize = (resize) ? (this.insertItemIntoRow__Lorg_eclipse_swt_widgets_CoolItem_2II(item, newRowIndex, x_root), true) : (this.insertItemIntoRow__Lorg_eclipse_swt_widgets_CoolItem_2II(item, newRowIndex, x_root));
    if (resize) {
      this.relayout__();
    } else {
      this.layoutItems__();
    }
    return;
  }
  public function moveLeft__Lorg_eclipse_swt_widgets_CoolItem_2I(item: CoolItem, pixels: int): void {
    var point: Point = this.findItem__Lorg_eclipse_swt_widgets_CoolItem_2(item);
    var row: int = point.y;
    var index: int = point.x;
    if (index == 0)
      return;
    var bounds: Rectangle = item.internalGetBounds__();
    var minSpaceOnLeft: int = 0;
    for (var i: int = 0; i < index; i++) {
      minSpaceOnLeft += items[row][i].internalGetMinimumWidth__();
    }
    var x_1: int = Math__.max__II(minSpaceOnLeft, bounds.x - pixels);
    var left: CoolItem = items[row][index - 1];
    var leftBounds: Rectangle = left.internalGetBounds__();
    if (leftBounds.x + left.internalGetMinimumWidth__() > x_1) {
      var shift: int = leftBounds.x + left.internalGetMinimumWidth__() - x_1;
      this.moveLeft__Lorg_eclipse_swt_widgets_CoolItem_2I(left, shift);
      leftBounds = left.internalGetBounds__();
    }
    var leftWidth: int = Math__.max__II(left.internalGetMinimumWidth__(), leftBounds.width - pixels);
    left.setBounds__IIII(leftBounds.x, leftBounds.y, leftWidth, leftBounds.height);
    left.requestedWidth = leftWidth;
    var width_1: int = bounds.width + (bounds.x - x_1);
    item.setBounds__IIII(x_1, bounds.y, width_1, bounds.height);
    item.requestedWidth = width_1;
    var damagedWidth: int = bounds.x - x_1 + 10;
    if (damagedWidth > 10) {
      this.internalRedraw__IIII(x_1, bounds.y, damagedWidth, bounds.height);
    }
    return;
  }
  public function moveRight__Lorg_eclipse_swt_widgets_CoolItem_2I(item: CoolItem, pixels: int): void {
    var point: Point = this.findItem__Lorg_eclipse_swt_widgets_CoolItem_2(item);
    var row: int = point.y;
    var index: int = point.x;
    if (index == 0)
      return;
    var bounds: Rectangle = item.internalGetBounds__();
    var minSpaceOnRight: int = 0;
    for (var i: int = index; i < items[row].length; i++) {
      minSpaceOnRight += items[row][i].internalGetMinimumWidth__();
    }
    var max: int = this.getWidth__() - minSpaceOnRight;
    var x_1: int = Math__.min__II(max, bounds.x + pixels);
    var width_1: int = 0;
    if (index + 1 == items[row].length) {
      width_1 = this.getWidth__() - x_1;
    } else {
      var right: CoolItem = items[row][index + 1];
      var rightBounds: Rectangle = right.internalGetBounds__();
      if (x_1 + item.internalGetMinimumWidth__() > rightBounds.x) {
        var shift: int = x_1 + item.internalGetMinimumWidth__() - rightBounds.x;
        this.moveRight__Lorg_eclipse_swt_widgets_CoolItem_2I(right, shift);
        rightBounds = right.internalGetBounds__();
      }
      width_1 = rightBounds.x - x_1;
    }
    item.setBounds__IIII(x_1, bounds.y, width_1, bounds.height);
    item.requestedWidth = width_1;
    var left: CoolItem = items[row][index - 1];
    var leftBounds: Rectangle = left.internalGetBounds__();
    var leftWidth: int = x_1 - leftBounds.x;
    left.setBounds__IIII(leftBounds.x, leftBounds.y, leftWidth, leftBounds.height);
    left.requestedWidth = leftWidth;
    var damagedWidth: int = x_1 - bounds.x + 10 + 4;
    if (x_1 - bounds.x > 0) {
      this.internalRedraw__IIII(bounds.x - 4, bounds.y, damagedWidth, bounds.height);
    }
    return;
  }
  public function moveUp__Lorg_eclipse_swt_widgets_CoolItem_2I(item: CoolItem, x_root: int): void {
    var point: Point = this.findItem__Lorg_eclipse_swt_widgets_CoolItem_2(item);
    var oldRowIndex: int = point.y;
    if (items[oldRowIndex].length == 1) {
      if (oldRowIndex == 0)
        return;
    }
    var resize: Boolean = this.removeItemFromRow__Lorg_eclipse_swt_widgets_CoolItem_2IZ(item, oldRowIndex, false);
    var old: Rectangle = item.internalGetBounds__();
    this.internalRedraw__IIII(old.x, old.y, 10, old.height);
    var newRowIndex: int = oldRowIndex - 1;
    resize = (resize) ? (this.insertItemIntoRow__Lorg_eclipse_swt_widgets_CoolItem_2II(item, newRowIndex, x_root), true) : (this.insertItemIntoRow__Lorg_eclipse_swt_widgets_CoolItem_2II(item, newRowIndex, x_root));
    if (resize) {
      this.relayout__();
    } else {
      this.layoutItems__();
    }
    return;
  }
  public function onDispose__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    if (inDispose)
      return;
    inDispose = true;
    this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(12, event);
    event.type = 0;
    for (var i: int = 0; i < items.length; i++) {
      for (var j: int = 0; j < items[i].length; j++) {
        items[i][j].dispose__();
      }
    }
    hoverCursor.dispose__();
    dragCursor.dispose__();
    cursor_org_eclipse_swt_widgets_CoolBar = null;
    return;
  }
  public function onMouseDown__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    if (isLocked || event.button != 1)
      return;
    this.fixEvent__Lorg_eclipse_swt_widgets_Event_2(event);
    dragging = this.getGrabbedItem__II(event.x, event.y);
    if (dragging !== null) {
      mouseXOffset = event.x;
      itemXOffset = mouseXOffset - dragging.internalGetBounds__().x;
      this._setCursor__Lorg_eclipse_swt_graphics_Cursor_2(dragCursor);
    }
    this.fixEvent__Lorg_eclipse_swt_widgets_Event_2(event);
    return;
  }
  public function onMouseExit__(): void {
    if (dragging === null)
      this._setCursor__Lorg_eclipse_swt_graphics_Cursor_2(null);
    return;
  }
  public function onMouseMove__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    if (isLocked)
      return;
    this.fixEvent__Lorg_eclipse_swt_widgets_Event_2(event);
    var grabbed: CoolItem = this.getGrabbedItem__II(event.x, event.y);
    if (dragging !== null) {
      var left_root: int = this.toDisplay__Lorg_eclipse_swt_graphics_Point_2(new Point(event.x - itemXOffset, event.y)).x;
      var bounds: Rectangle = dragging.internalGetBounds__();
      if (event.y < bounds.y) {
        this.moveUp__Lorg_eclipse_swt_widgets_CoolItem_2I(dragging, left_root);
      } else if (event.y > bounds.y + bounds.height) {
        this.moveDown__Lorg_eclipse_swt_widgets_CoolItem_2I(dragging, left_root);
      } else if (event.x < mouseXOffset) {
        var distance: int = Math__.min__II(mouseXOffset, bounds.x + itemXOffset) - event.x;
        if (distance > 0)
          this.moveLeft__Lorg_eclipse_swt_widgets_CoolItem_2I(dragging, distance);
      } else if (event.x > mouseXOffset) {
        var distance_1: int = event.x - Math__.max__II(mouseXOffset, bounds.x + itemXOffset);
        if (distance_1 > 0)
          this.moveRight__Lorg_eclipse_swt_widgets_CoolItem_2I(dragging, distance_1);
      }
      mouseXOffset = event.x;
    } else {
      if (grabbed !== null) {
        this._setCursor__Lorg_eclipse_swt_graphics_Cursor_2(hoverCursor);
      } else {
        this._setCursor__Lorg_eclipse_swt_graphics_Cursor_2(null);
      }
    }
    this.fixEvent__Lorg_eclipse_swt_widgets_Event_2(event);
    return;
  }
  public function onMouseUp__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    this._setCursor__Lorg_eclipse_swt_graphics_Cursor_2(null);
    dragging = null;
    return;
  }
  public function onMouseDoubleClick__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    if (isLocked)
      return;
    dragging = null;
    this.fixEvent__Lorg_eclipse_swt_widgets_Event_2(event);
    var target: CoolItem = this.getGrabbedItem__II(event.x, event.y);
    if (target === null) {
      this._setCursor__Lorg_eclipse_swt_graphics_Cursor_2(null);
    } else {
      var location: Point = this.findItem__Lorg_eclipse_swt_widgets_CoolItem_2(target);
      var row: int = location.y;
      var index: int = location.x;
      if (items[row].length > 1) {
        var bounds: Rectangle = target.internalGetBounds__();
        var maxSize: int = this.getWidth__();
        for (var i: int = 0; i < items[row].length; i++) {
          if (i != index) {
            maxSize -= items[row][i].internalGetMinimumWidth__();
          }
        }
        if (bounds.width == maxSize) {
          var distance: int = bounds.width - target.internalGetMinimumWidth__();
          if (index + 1 < items[row].length) {
            var right: CoolItem = items[row][index + 1];
            this.moveLeft__Lorg_eclipse_swt_widgets_CoolItem_2I(right, distance);
          } else {
            this.moveRight__Lorg_eclipse_swt_widgets_CoolItem_2I(target, distance);
          }
        } else if (bounds.width < target.preferredWidth) {
          var distance_1: int = target.preferredWidth - bounds.width;
          if (index + 1 < items[row].length) {
            var right_1: CoolItem = items[row][index + 1];
            this.moveRight__Lorg_eclipse_swt_widgets_CoolItem_2I(right_1, distance_1);
            distance_1 = target.preferredWidth - target.internalGetBounds__().width;
          }
          if (distance_1 > 0) {
            this.moveLeft__Lorg_eclipse_swt_widgets_CoolItem_2I(target, distance_1);
          }
        } else {
          for (var i_1: int = 0; i_1 < items[row].length; i_1++) {
            if (i_1 != index) {
              var item: CoolItem = items[row][i_1];
              item.requestedWidth = Math__.max__II(item.internalGetMinimumWidth__(), 10);
            }
          }
          target.requestedWidth = maxSize;
          this.layoutItems__();
        }
        this._setCursor__Lorg_eclipse_swt_graphics_Cursor_2(hoverCursor);
      }
    }
    this.fixEvent__Lorg_eclipse_swt_widgets_Event_2(event);
    return;
  }
  public function onPaint__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    var gc: GC = event.gc;
    if (items.length == 0)
      return;
    var shadowColor: Color = display.getSystemColor__I(18);
    var highlightColor: Color = display.getSystemColor__I(20);
    var vertical: Boolean = (style & 512) != 0;
    var flat: Boolean = (style & 8388608) != 0;
    var stopX: int = this.getWidth__();
    var rect: Rectangle;
    var clipping: Rectangle = gc.getClipping__();
    for (var row: int = 0; row < items.length; row++) {
      var bounds: Rectangle = new Rectangle(0, 0, 0, 0);
      for (var i: int = 0; i < items[row].length; i++) {
        bounds = items[row][i].internalGetBounds__();
        rect = this.fixRectangle__IIII(bounds.x, bounds.y, bounds.width, bounds.height);
        if (!clipping.intersects__Lorg_eclipse_swt_graphics_Rectangle_2(rect))
          continue;
        var nativeGripper: Boolean = false;
        if (!isLocked) {
          rect = this.fixRectangle__IIII(bounds.x, bounds.y, 10, bounds.height);
          if (!flat)
            nativeGripper = this.drawGripper__IIIIZ(rect.x, rect.y, rect.width, rect.height, vertical);
          if (!nativeGripper) {
            var grabberTrim: int = 2;
            var grabberHeight: int = bounds.height - (2 * grabberTrim) - 1;
            gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(shadowColor);
            rect = this.fixRectangle__IIII(bounds.x + 4, bounds.y + grabberTrim, 2, grabberHeight);
            gc.drawRectangle__Lorg_eclipse_swt_graphics_Rectangle_2(rect);
            gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(highlightColor);
            rect = this.fixRectangle__IIII(bounds.x + 4, bounds.y + grabberTrim + 1, bounds.x + 4, bounds.y + grabberTrim + grabberHeight - 1);
            gc.drawLine__IIII(rect.x, rect.y, rect.width, rect.height);
            rect = this.fixRectangle__IIII(bounds.x + 4, bounds.y + grabberTrim, bounds.x + 4 + 1, bounds.y + grabberTrim);
            gc.drawLine__IIII(rect.x, rect.y, rect.width, rect.height);
          }
        }
        if (!flat && !nativeGripper && i != 0) {
          gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(shadowColor);
          rect = this.fixRectangle__IIII(bounds.x, bounds.y, bounds.x, bounds.y + bounds.height - 1);
          gc.drawLine__IIII(rect.x, rect.y, rect.width, rect.height);
          gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(highlightColor);
          rect = this.fixRectangle__IIII(bounds.x + 1, bounds.y, bounds.x + 1, bounds.y + bounds.height - 1);
          gc.drawLine__IIII(rect.x, rect.y, rect.width, rect.height);
        }
      }
      if (!flat && row + 1 < items.length) {
        var separatorY: int = bounds.y + bounds.height;
        gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(shadowColor);
        rect = this.fixRectangle__IIII(0, separatorY, stopX, separatorY);
        gc.drawLine__IIII(rect.x, rect.y, rect.width, rect.height);
        gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(highlightColor);
        rect = this.fixRectangle__IIII(0, separatorY + 1, stopX, separatorY + 1);
        gc.drawLine__IIII(rect.x, rect.y, rect.width, rect.height);
      }
    }
    return;
  }
  public function onResize__(): void {
    this.layoutItems__();
    return;
  }
  public override function removeControl__Lorg_eclipse_swt_widgets_Control_2(control: Control): void {
    super.removeControl__Lorg_eclipse_swt_widgets_Control_2(control);
    var items_1: JavaArray = this.getItems__();
    for (var i: int = 0; i < items_1.length; i++) {
      var item: CoolItem = items_1[i];
      if (item.control === control)
        item.setControl__Lorg_eclipse_swt_widgets_Control_2(null);
    }
    return;
  }
  public function removeItemFromRow__Lorg_eclipse_swt_widgets_CoolItem_2IZ(item: CoolItem, rowIndex: int, disposed: Boolean): Boolean {
    var index: int = this.findItem__Lorg_eclipse_swt_widgets_CoolItem_2(item).x;
    var newLength: int = items[rowIndex].length - 1;
    var itemBounds: Rectangle = item.internalGetBounds__();
    var oldRowHeight: int = itemBounds.height;
    item.wrap = false;
    if (newLength > 0) {
      var newRow: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/CoolItem;").lengths(newLength);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(items[rowIndex], 0, newRow, 0, index);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(items[rowIndex], index + 1, newRow, index, newRow.length - index);
      items[rowIndex] = newRow;
      items[rowIndex][0].wrap = true;
    } else {
      var newRows: JavaArray = new JavaArray("[[Lorg/eclipse/swt/widgets/CoolItem;").lengths(items.length - 1);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(items, 0, newRows, 0, rowIndex);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(items, rowIndex + 1, newRows, rowIndex, newRows.length - rowIndex);
      items = newRows;
      return true;
    }
    if (!disposed) {
      if (index == 0) {
        var first: CoolItem = items[rowIndex][0];
        var bounds: Rectangle = first.internalGetBounds__();
        var width_1: int = bounds.x + bounds.width;
        first.setBounds__IIII(0, bounds.y, width_1, bounds.height);
        first.requestedWidth = width_1;
        this.internalRedraw__IIII(bounds.x, bounds.y, 10, bounds.height);
      } else {
        var previous: CoolItem = items[rowIndex][index - 1];
        var bounds_1: Rectangle = previous.internalGetBounds__();
        var width_2: int = bounds_1.width + itemBounds.width;
        previous.setBounds__IIII(bounds_1.x, bounds_1.y, width_2, bounds_1.height);
        previous.requestedWidth = width_2;
      }
    }
    var newRowHeight: int = 0;
    for (var i: int = 0; i < newLength; i++) {
      newRowHeight = Math__.max__II(newRowHeight, items[rowIndex][i].preferredHeight);
    }
    return newRowHeight != oldRowHeight;
  }
  public function layoutItems__(): int {
    var y_1: int = 0;
    var width_1: int;
    if ((style & 512) != 0) {
      width_1 = this.getClientArea__().height;
    } else {
      width_1 = this.getClientArea__().width;
    }
    this.wrapItems__I(width_1);
    var rowSpacing: int = (style & 8388608) != 0 ? 0 : 2;
    for (var row: int = 0; row < items.length; row++) {
      var count: int = items[row].length;
      var x_1: int = 0;
      var rowHeight: int = 0;
      var available: int = width_1;
      for (var i: int = 0; i < count; i++) {
        var item: CoolItem = items[row][i];
        rowHeight = Math__.max__II(rowHeight, item.preferredHeight);
        available -= item.internalGetMinimumWidth__();
      }
      if (row > 0)
        y_1 += rowSpacing;
      for (var i_1: int = 0; i_1 < count; i_1++) {
        var child: CoolItem = items[row][i_1];
        var newWidth: int = available + child.internalGetMinimumWidth__();
        if (i_1 + 1 < count) {
          newWidth = Math__.min__II(newWidth, child.requestedWidth);
          available -= (newWidth - child.internalGetMinimumWidth__());
        }
        var oldBounds: Rectangle = child.internalGetBounds__();
        var newBounds: Rectangle = new Rectangle(x_1, y_1, newWidth, rowHeight);
        if (!oldBounds.equals__Ljava_lang_Object_2(newBounds)) {
          child.setBounds__IIII(newBounds.x, newBounds.y, newBounds.width, newBounds.height);
          var damage: Rectangle = new Rectangle(0, 0, 0, 0);
          if (oldBounds.y != newBounds.y) {
            damage = newBounds;
            damage.add__Lorg_eclipse_swt_graphics_Rectangle_2(oldBounds);
            damage.y -= rowSpacing;
            damage.height += 2 * rowSpacing;
          } else if (oldBounds.height != newBounds.height) {
            damage.y = newBounds.y + Math__.min__II(oldBounds.height, newBounds.height) - 3;
            damage.height = newBounds.y + newBounds.height + rowSpacing;
            damage.x = oldBounds.x - 4;
            damage.width = oldBounds.width + 4;
          } else if (oldBounds.x != newBounds.x) {
            damage.x = Math__.min__II(oldBounds.x, newBounds.x);
            damage.width = Math__.abs__I(oldBounds.x - newBounds.x) + 10;
            damage.y = oldBounds.y;
            damage.height = oldBounds.height;
          }
          this.internalRedraw__IIII(damage.x, damage.y, damage.width, damage.height);
        }
        x_1 += newWidth;
      }
      y_1 += rowHeight;
    }
    return y_1;
  }
  public function relayout__(): void {
    var size: Point = this.getSize__();
    var height_1: int = this.layoutItems__();
    if ((style & 512) != 0) {
      var trim: Rectangle = this.computeTrim__IIII(0, 0, height_1, 0);
      if (height_1 != size.x)
        super.setSize__II(trim.width, size.y);
    } else {
      var trim_1: Rectangle = this.computeTrim__IIII(0, 0, 0, height_1);
      if (height_1 != size.y)
        super.setSize__II(size.x, trim_1.height);
    }
    return;
  }
  public function getItemOrder__(): JavaArray {
    this.checkWidget__();
    var count: int = this.getItemCount__();
    var indices: JavaArray = new JavaArray("[I").lengths(count);
    count = 0;
    for (var i: int = 0; i < items.length; i++) {
      for (var j: int = 0; j < items[i].length; j++) {
        var item: CoolItem = items[i][j];
        var index: int = 0;
        while (index < originalItems.length) {
          if (originalItems[index] === item)
            break;
          index++;
        }
        if (index == originalItems.length)
          this.error__I(8);
        indices[count++] = index;
      }
    }
    return indices;
  }
  public function setItemOrder___3I(itemOrder: JavaArray): void {
    if (itemOrder === null)
      this.error__I(4);
    var count: int = originalItems.length;
    if (itemOrder.length != count)
      this.error__I(5);
    var set_1: JavaArray = new JavaArray("[Z").lengths(count);
    for (var i: int = 0; i < set_1.length; i++)
      set_1[i] = false;
    for (var i_1: int = 0; i_1 < itemOrder.length; i_1++) {
      if (itemOrder[i_1] < 0 || itemOrder[i_1] >= count)
        this.error__I(5);
      if (set_1[itemOrder[i_1]])
        this.error__I(5);
      set_1[itemOrder[i_1]] = true;
    }
    var row: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/CoolItem;").lengths(count);
    for (var i_2: int = 0; i_2 < count; i_2++) {
      row[i_2] = originalItems[itemOrder[i_2]];
    }
    items = new JavaArray("[[Lorg/eclipse/swt/widgets/CoolItem;").lengths(1, count);
    items[0] = row;
    return;
  }
  public function getItemSizes__(): JavaArray {
    this.checkWidget__();
    var items_1: JavaArray = this.getItems__();
    var sizes: JavaArray = new JavaArray("[Lorg/eclipse/swt/graphics/Point;").lengths(items_1.length);
    for (var i: int = 0; i < items_1.length; i++) {
      sizes[i] = items_1[i].getSize__();
    }
    return sizes;
  }
  public function setItemSizes___3Lorg_eclipse_swt_graphics_Point_2(sizes: JavaArray): void {
    if (sizes === null)
      this.error__I(4);
    var items_1: JavaArray = this.getItems__();
    if (sizes.length != items_1.length)
      this.error__I(5);
    for (var i: int = 0; i < items_1.length; i++) {
      items_1[i].setSize__Lorg_eclipse_swt_graphics_Point_2(sizes[i]);
    }
    return;
  }
  public function getLocked__(): Boolean {
    this.checkWidget__();
    return isLocked;
  }
  public function getWidth__(): int {
    if ((style & 512) != 0)
      return this.getSize__().y;
    return this.getSize__().x;
  }
  public function getWrapIndices__(): JavaArray {
    this.checkWidget__();
    if (items.length <= 1)
      return new JavaArray("[I").lengths();
    var wrapIndices: JavaArray = new JavaArray("[I").lengths(items.length - 1);
    var i: int = 0;
    var nextWrap: int = items[0].length;
    for (var row: int = 1; row < items.length; row++) {
      if (items[row][0].wrap)
        wrapIndices[i++] = nextWrap;
      nextWrap += items[row].length;
    }
    if (i != wrapIndices.length) {
      var tmp: JavaArray = new JavaArray("[I").lengths(i);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(wrapIndices, 0, tmp, 0, i);
      return tmp;
    }
    return wrapIndices;
  }
  public function setLocked__Z(locked: Boolean): void {
    this.checkWidget__();
    if (isLocked != locked) {
      this.redraw__();
    }
    isLocked = locked;
    return;
  }
  public function setWrapIndices___3I(indices: JavaArray): void {
    this.checkWidget__();
    if (indices === null)
      indices = new JavaArray("[I").lengths(0);
    var count: int = originalItems.length;
    for (var i: int = 0; i < indices.length; i++) {
      if (indices[i] < 0 || indices[i] >= count) {
        this.error__I(5);
      }
    }
    for (var i_1: int = 0; i_1 < originalItems.length; i_1++) {
      originalItems[i_1].wrap = false;
    }
    for (var i_2: int = 0; i_2 < indices.length; i_2++) {
      var index: int = indices[i_2];
      for (var row: int = 0; row < items.length; row++) {
        if (items[row].length > index) {
          items[row][index].wrap = true;
          break;
        } else {
          index -= items[row].length;
        }
      }
    }
    this.relayout__();
    return;
  }
  public override function setCursor__Lorg_eclipse_swt_graphics_Cursor_2(cursor_1: Cursor): void {
    this.checkWidget__();
    super.setCursor__Lorg_eclipse_swt_graphics_Cursor_2(this.cursor_org_eclipse_swt_widgets_CoolBar = cursor_1);
    return;
  }
  public function setItemLayout___3I_3I_3Lorg_eclipse_swt_graphics_Point_2(itemOrder: JavaArray, wrapIndices: JavaArray, sizes: JavaArray): void {
    this.checkWidget__();
    this.setItemOrder___3I(itemOrder);
    this.setWrapIndices___3I(wrapIndices);
    this.setItemSizes___3Lorg_eclipse_swt_graphics_Point_2(sizes);
    this.relayout__();
    return;
  }
  public function wrapItems__I(maxWidth: int): void {
    var itemCount: int = originalItems.length;
    if (itemCount < 2)
      return;
    var itemsVisual: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/CoolItem;").lengths(itemCount);
    var start: int = 0;
    for (var row: int = 0; row < items.length; row++) {
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(items[row], 0, itemsVisual, start, items[row].length);
      start += items[row].length;
    }
    var newItems: JavaArray = new JavaArray("[[Lorg/eclipse/swt/widgets/CoolItem;").lengths(itemCount);
    var rowCount: int = 0;
    var rowWidth: int = 0;
    start = 0;
    for (var i: int = 0; i < itemCount; i++) {
      var item: CoolItem = itemsVisual[i];
      var itemWidth: int = item.internalGetMinimumWidth__();
      if ((i > 0 && item.wrap) || (maxWidth != -1 && rowWidth + itemWidth > maxWidth)) {
        if (i == start) {
          newItems[rowCount] = new JavaArray("[Lorg/eclipse/swt/widgets/CoolItem;").lengths(1);
          newItems[rowCount][0] = item;
          start = i + 1;
          rowWidth = 0;
        } else {
          var count: int = i - start;
          newItems[rowCount] = new JavaArray("[Lorg/eclipse/swt/widgets/CoolItem;").lengths(count);
          System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(itemsVisual, start, newItems[rowCount], 0, count);
          start = i;
          rowWidth = itemWidth;
        }
        rowCount++;
      } else {
        rowWidth += itemWidth;
      }
    }
    if (start < itemCount) {
      var count_1: int = itemCount - start;
      newItems[rowCount] = new JavaArray("[Lorg/eclipse/swt/widgets/CoolItem;").lengths(count_1);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(itemsVisual, start, newItems[rowCount], 0, count_1);
      rowCount++;
    }
    if (newItems.length != rowCount) {
      var tmp: JavaArray = new JavaArray("[[Lorg/eclipse/swt/widgets/CoolItem;").lengths(rowCount);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(newItems, 0, tmp, 0, rowCount);
      items = tmp;
    } else {
      items = newItems;
    }
    return;
  }
}
}
