package org.eclipse.swt.widgets {
import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.GC;
import java.lang.Math__;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class CoolItem extends Item {
  internal var control: Control;
  internal var parent: CoolBar;
  internal var ideal: Boolean;
  internal var preferredWidth: int;
  internal var preferredHeight: int;
  internal var minimumWidth: int;
  internal var minimumHeight: int;
  internal var requestedWidth: int;
  internal var itemBounds: Rectangle = new Rectangle(0, 0, 0, 0);
  public static const MARGIN_WIDTH: int = 4;
  public static const GRABBER_WIDTH: int = 2;
  public static const MINIMUM_WIDTH: int = (2 * 4) + 2;
  private var CHEVRON_HORIZONTAL_TRIM: int = -1;
  private var CHEVRON_VERTICAL_TRIM: int = -1;
  public static const CHEVRON_LEFT_MARGIN: int = 2;
  public static const CHEVRON_IMAGE_WIDTH: int = 8;
  internal var chevron: ToolBar;
  internal var wrap: Boolean;
  internal var arrowImage: Image = null;
  public function CoolItem__Lorg_eclipse_swt_widgets_CoolBar_2I(parent: CoolBar, style: int): Object {
    this.parent = parent;
    parent.createItem__Lorg_eclipse_swt_widgets_CoolItem_2I(this, parent.getItemCount__());
    this.calculateChevronTrim__();
    return this;
  }
  public function CoolItem__Lorg_eclipse_swt_widgets_CoolBar_2II(parent: CoolBar, style: int, index: int): Object {
    this.parent = parent;
    parent.createItem__Lorg_eclipse_swt_widgets_CoolItem_2I(this, index);
    this.calculateChevronTrim__();
    return this;
  }
  public function addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener: SelectionListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(14, typedListener);
    return;
  }
  public override function checkSubclass__(): void {
    if (!this.isValidSubclass__())
      this.error__I(43);
    return;
  }
  public function calculateChevronTrim__(): void {
    var tb: ToolBar = new ToolBar(parent, 8388608);
    var ti: ToolItem = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [tb, 8]));
    var image_1: Image = new Image(new Arguments(org.eclipse.swt.graphics.Image.Image__Lorg_eclipse_swt_graphics_Device_2II, [display, 1, 1]));
    ti.setImage__Lorg_eclipse_swt_graphics_Image_2(image_1);
    var size: Point = tb.computeSize__II(-1, -1);
    size = parent.fixPoint__II(size.x, size.y);
    CHEVRON_HORIZONTAL_TRIM = size.x - 1;
    CHEVRON_VERTICAL_TRIM = size.y - 1;
    tb.dispose__();
    ti.dispose__();
    image_1.dispose__();
    return;
  }
  public function computeSize__II(wHint: int, hHint: int): Point {
    this.checkWidget__();
    var width: int = wHint;
    var height: int = hHint;
    if (wHint == -1)
      width = 32;
    if (hHint == -1)
      height = 32;
    if ((parent.style & 512) != 0) {
      height += 10;
    } else {
      width += 10;
    }
    return new Point(width, height);
  }
  public override function dispose__(): void {
    if (this.isDisposed__())
      return;
    parent.destroyItem__Lorg_eclipse_swt_widgets_CoolItem_2(this);
    super.dispose__();
    parent = null;
    control = null;
    if (chevron !== null && !chevron.isDisposed__())
      chevron.dispose__();
    chevron = null;
    if (arrowImage !== null && !arrowImage.isDisposed__())
      arrowImage.dispose__();
    arrowImage = null;
  }
  public function createArrowImage__II(width: int, height: int): Image {
    var point: Point = parent.fixPoint__II(width, height);
    width = point.x;
    height = point.y;
    var foreground: Color = parent.getForeground__();
    var black: Color = display.getSystemColor__I(2);
    var background: Color = parent.getBackground__();
    var palette: PaletteData = new PaletteData(new Arguments(org.eclipse.swt.graphics.PaletteData.PaletteData___3Lorg_eclipse_swt_graphics_RGB_2, [new JavaArray("[Lorg/eclipse/swt/graphics/RGB;").values(foreground.getRGB__(), background.getRGB__(), black.getRGB__())]));
    var imageData: ImageData = new ImageData(new Arguments(org.eclipse.swt.graphics.ImageData.ImageData__IIILorg_eclipse_swt_graphics_PaletteData_2, [width, height, 4, palette]));
    imageData.transparentPixel = 1;
    var image_1: Image = new Image(new Arguments(org.eclipse.swt.graphics.Image.Image__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_ImageData_2, [display, imageData]));
    var gc: GC = new GC(new Arguments(org.eclipse.swt.graphics.GC.GC__Lorg_eclipse_swt_graphics_Drawable_2I, [image_1, parent.getStyle__() & 67108864]));
    gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(background);
    gc.fillRectangle__IIII(0, 0, width, height);
    gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(black);
    var startX: int = 0;
    if ((parent.style & 512) != 0) {
      startX = width - 8;
    }
    var startY: int = int(height / 6);
    var step: int = 2;
    gc.drawLine__IIII(startX, startY, startX + step, startY + step);
    gc.drawLine__IIII(startX, startY + (2 * step), startX + step, startY + step);
    startX++;
    gc.drawLine__IIII(startX, startY, startX + step, startY + step);
    gc.drawLine__IIII(startX, startY + (2 * step), startX + step, startY + step);
    startX += 3;
    gc.drawLine__IIII(startX, startY, startX + step, startY + step);
    gc.drawLine__IIII(startX, startY + (2 * step), startX + step, startY + step);
    startX++;
    gc.drawLine__IIII(startX, startY, startX + step, startY + step);
    gc.drawLine__IIII(startX, startY + (2 * step), startX + step, startY + step);
    gc.dispose__();
    return image_1;
  }
  public function getBounds__(): Rectangle {
    this.checkWidget__();
    return parent.fixRectangle__IIII(itemBounds.x, itemBounds.y, itemBounds.width, itemBounds.height);
  }
  public function internalGetBounds__(): Rectangle {
    return new Rectangle(itemBounds.x, itemBounds.y, itemBounds.width, itemBounds.height);
  }
  public function getControl__(): Control {
    this.checkWidget__();
    return control;
  }
  public function getMinimumSize__(): Point {
    this.checkWidget__();
    return parent.fixPoint__II(minimumWidth, minimumHeight);
  }
  public function getParent__(): CoolBar {
    this.checkWidget__();
    return parent;
  }
  public function getPreferredSize__(): Point {
    this.checkWidget__();
    return parent.fixPoint__II(preferredWidth, preferredHeight);
  }
  public function getSize__(): Point {
    this.checkWidget__();
    return parent.fixPoint__II(itemBounds.width, itemBounds.height);
  }
  public function internalGetMinimumWidth__(): int {
    var width: int = minimumWidth + 10;
    if ((style & 4) != 0 && width < preferredWidth) {
      width += 8 + CHEVRON_HORIZONTAL_TRIM + 2;
    }
    return width;
  }
  public function onSelection__Lorg_eclipse_swt_widgets_Event_2(ev: Event): void {
    var bounds: Rectangle = chevron.getBounds__();
    var event: Event = new Event();
    event.detail = 4;
    if ((parent.style & 512) != 0) {
      event.x = bounds.x + bounds.width;
      event.y = bounds.y;
    } else {
      event.x = bounds.x;
      event.y = bounds.y + bounds.height;
    }
    this.postEvent__ILorg_eclipse_swt_widgets_Event_2(13, event);
    return;
  }
  public function removeSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener: SelectionListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(13, listener);
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(14, listener);
  }
  public function setBounds__IIII(x: int, y: int, width: int, height: int): void {
    itemBounds.x = x;
    itemBounds.y = y;
    itemBounds.width = width;
    itemBounds.height = height;
    if (control !== null) {
      var controlWidth: int = width - 10;
      if ((style & 4) != 0 && width < preferredWidth) {
        controlWidth -= 8 + CHEVRON_HORIZONTAL_TRIM + 2;
      }
      if (height > preferredHeight) {
        y += int((height - preferredHeight) / 2);
        height = preferredHeight;
      }
      control.setBounds__Lorg_eclipse_swt_graphics_Rectangle_2(parent.fixRectangle__IIII(x + 10, y, controlWidth, height));
    }
    this.updateChevron__();
    return;
  }
  public function setControl__Lorg_eclipse_swt_widgets_Control_2(control_1: Control): void {
    this.checkWidget__();
    if (control_1 !== null) {
      if (control_1.isDisposed__())
        this.error__I(5);
      if (control_1.parent !== parent)
        this.error__I(32);
    }
    this.control = control_1;
    if (control_1 !== null) {
      var controlWidth: int = itemBounds.width - 10;
      if ((style & 4) != 0 && itemBounds.width < preferredWidth) {
        controlWidth -= 8 + CHEVRON_HORIZONTAL_TRIM + 2;
      }
      control_1.setBounds__Lorg_eclipse_swt_graphics_Rectangle_2(parent.fixRectangle__IIII(itemBounds.x + 10, itemBounds.y, controlWidth, itemBounds.height));
    }
    return;
  }
  public function setMinimumSize__II(width: int, height: int): void {
    this.checkWidget__();
    var point: Point = parent.fixPoint__II(width, height);
    minimumWidth = point.x;
    minimumHeight = point.y;
    return;
  }
  public function setMinimumSize__Lorg_eclipse_swt_graphics_Point_2(size: Point): void {
    this.checkWidget__();
    if (size === null)
      this.error__I(4);
    this.setMinimumSize__II(size.x, size.y);
    return;
  }
  public function setPreferredSize__II(width: int, height: int): void {
    this.checkWidget__();
    ideal = true;
    var point: Point = parent.fixPoint__II(width, height);
    preferredWidth = Math__.max__II(point.x, 10);
    preferredHeight = point.y;
    return;
  }
  public function setPreferredSize__Lorg_eclipse_swt_graphics_Point_2(size: Point): void {
    this.checkWidget__();
    if (size === null)
      this.error__I(4);
    this.setPreferredSize__II(size.x, size.y);
    return;
  }
  public function setSize__II(width: int, height: int): void {
    this.checkWidget__();
    var point: Point = parent.fixPoint__II(width, height);
    width = Math__.max__II(point.x, minimumWidth + 10);
    height = point.y;
    if (!ideal) {
      preferredWidth = width;
      preferredHeight = height;
    }
    itemBounds.width = requestedWidth = width;
    itemBounds.height = height;
    if (control !== null) {
      var controlWidth: int = width - 10;
      if ((style & 4) != 0 && width < preferredWidth) {
        controlWidth -= 8 + CHEVRON_HORIZONTAL_TRIM + 2;
      }
      control.setSize__Lorg_eclipse_swt_graphics_Point_2(parent.fixPoint__II(controlWidth, height));
    }
    parent.relayout__();
    this.updateChevron__();
    return;
  }
  public function setSize__Lorg_eclipse_swt_graphics_Point_2(size: Point): void {
    this.checkWidget__();
    if (size === null)
      this.error__I(4);
    this.setSize__II(size.x, size.y);
    return;
  }
  public function updateChevron__(): void {
    if (control !== null) {
      var width: int = itemBounds.width;
      if ((style & 4) != 0 && width < preferredWidth) {
        if (chevron === null) {
          chevron = new ToolBar(parent, 8388608 | 524288);
          var toolItem: ToolItem = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [chevron, 8]));
          toolItem.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, new org.eclipse.swt.widgets.CoolItem$1(this));
        }
        var controlHeight: int;
        var currentImageHeight: int = 0;
        if ((parent.style & 512) != 0) {
          controlHeight = control.getSize__().x;
          if (arrowImage !== null)
            currentImageHeight = arrowImage.getBounds__().width;
        } else {
          controlHeight = control.getSize__().y;
          if (arrowImage !== null)
            currentImageHeight = arrowImage.getBounds__().height;
        }
        var height: int = Math__.min__II(controlHeight, itemBounds.height);
        var imageHeight: int = Math__.max__II(1, height - CHEVRON_VERTICAL_TRIM);
        if (currentImageHeight != imageHeight) {
          var image_1: Image = this.createArrowImage__II(8, imageHeight);
          chevron.getItem__I(0).setImage__Lorg_eclipse_swt_graphics_Image_2(image_1);
          if (arrowImage !== null)
            arrowImage.dispose__();
          arrowImage = image_1;
        }
        chevron.setBackground__Lorg_eclipse_swt_graphics_Color_2(parent.getBackground__());
        chevron.setBounds__Lorg_eclipse_swt_graphics_Rectangle_2(parent.fixRectangle__IIII(itemBounds.x + width - 2 - 8 - CHEVRON_HORIZONTAL_TRIM, itemBounds.y, 8 + CHEVRON_HORIZONTAL_TRIM, height));
        chevron.setVisible__Z(true);
      } else {
        if (chevron !== null) {
          chevron.setVisible__Z(false);
        }
      }
    }
    return;
  }
  public function CoolItem(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 2 && vargs[0] is CoolBar && vargs[1] is int) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 3 && vargs[0] is CoolBar && vargs[1] is int && vargs[2] is int) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0], args[1]];
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.swt.widgets.Item.Item__Lorg_eclipse_swt_widgets_Widget_2I, [args0[0], args0[1]]);
        break;
      case 1:
        var args1: Array = [args[0], args[1], args[2]];
        superArgs = new Arguments(org.eclipse.swt.widgets.Item.Item__Lorg_eclipse_swt_widgets_Widget_2I, [args1[0], args1[1]]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        CoolItem__Lorg_eclipse_swt_widgets_CoolBar_2I(args0[0], args0[1]);
        break;
      case 1:
        CoolItem__Lorg_eclipse_swt_widgets_CoolBar_2II(args1[0], args1[1], args1[2]);
        break;
    }
  }
  public static const CoolItem__Lorg_eclipse_swt_widgets_CoolBar_2I : int = 0;
  public static const CoolItem__Lorg_eclipse_swt_widgets_CoolBar_2II : int = 1;
}
}
