package org.eclipse.swt.widgets {
import mx.controls.DateChooser;
import mx.controls.DateField;
import mx.events.CalendarLayoutChangeEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.events.SelectionListener;
import java.lang.Arguments;
dynamic public class DateTime extends Composite {
  public function DateTime(parent: Composite, style: int) {
    super(new Arguments(org.eclipse.swt.widgets.Composite.Composite__Lorg_eclipse_swt_widgets_Composite_2I, [parent, DateTime.checkStyle__I(style)]));
    return;
  }
  public function addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener: SelectionListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(14, typedListener);
    return;
  }
  public static function checkStyle__I(style: int): int {
    style &= ~(256 | 512);
    style = Widget.checkBits__IIIIIII(style, 32, 128, 1024, 0, 0, 0);
    return Widget.checkBits__IIIIIII(style, 65536, 32768, 268435456, 0, 0, 0);
  }
  public override function checkSubclass__(): void {
  }
  public override function computeSize__IIZ(wHint: int, hHint: int, changed: Boolean): Point {
    this.checkWidget__();
    return this.computeNativeSize__Lmx_core_UIComponent_2IIZ(object, wHint, hHint, changed);
  }
  public override function createHandle__(): void {
    if ((style & 1024) != 0) {
      var widget: DateChooser = new DateChooser();
      widget.selectedDate = new Date();
      object = widget;
    } else {
      if ((style & 128) != 0) {
        var widget_1: DateField = new DateField();
        widget_1.selectedDate = new Date();
        object = widget_1;
      }
      if ((style & 32) != 0) {
        var widget_2: DateField = new DateField();
        widget_2.selectedDate = new Date();
        object = widget_2;
      }
    }
    return;
  }
  public function getDate__(): Date {
    if ((style & 1024) != 0) {
      return (DateChooser(object)).selectedDate;
    } else {
      return (DateField(object)).selectedDate;
    }
    return null;
  }
  public function getDay__(): int {
    this.checkWidget__();
    return int(this.getDate__().date);
  }
  public function getHours__(): int {
    this.checkWidget__();
    return int(this.getDate__().hours);
  }
  public function getMinutes__(): int {
    this.checkWidget__();
    return int(this.getDate__().minutes);
  }
  public function getMonth__(): int {
    this.checkWidget__();
    return int(this.getDate__().month);
  }
  public function getSeconds__(): int {
    this.checkWidget__();
    return int(this.getDate__().seconds);
  }
  public function getYear__(): int {
    this.checkWidget__();
    return int(this.getDate__().fullYear);
  }
  public function handleChange__Lmx_events_CalendarLayoutChangeEvent_2(event: CalendarLayoutChangeEvent): void {
    this.postEvent__I(13);
  }
  public function handleChangeFunction__(): Function {
    return handleChange__Lmx_events_CalendarLayoutChangeEvent_2;
  }
  public override function hookEvents__(): void {
    super.hookEvents__();
    object.addEventListener(CalendarLayoutChangeEvent.CHANGE, this.handleChangeFunction__());
  }
  public function removeSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener: SelectionListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(13, listener);
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(14, listener);
  }
  public function setDate__LDate_2(date: Date): void {
    if ((style & 1024) != 0) {
      (DateChooser(object)).selectedDate = date;
    } else {
      (DateField(object)).selectedDate = date;
    }
    return;
  }
  public function setDay__I(day: int): void {
    this.checkWidget__();
    var date: Date = this.getDate__();
    date.date = day;
    this.setDate__LDate_2(date);
    return;
  }
  public function setHours__I(hours: int): void {
    this.checkWidget__();
    var date: Date = this.getDate__();
    date.hours = hours;
    this.setDate__LDate_2(date);
    return;
  }
  public function setMinutes__I(minutes: int): void {
    this.checkWidget__();
    var date: Date = this.getDate__();
    date.minutes = minutes;
    this.setDate__LDate_2(date);
    return;
  }
  public function setMonth__I(month: int): void {
    this.checkWidget__();
    var date: Date = this.getDate__();
    date.month = month;
    this.setDate__LDate_2(date);
    return;
  }
  public function setSeconds__I(seconds: int): void {
    this.checkWidget__();
    var date: Date = this.getDate__();
    date.seconds = seconds;
    this.setDate__LDate_2(date);
    return;
  }
  public function setYear__I(year: int): void {
    this.checkWidget__();
    var date: Date = this.getDate__();
    date.fullYear = year;
    this.setDate__LDate_2(date);
    return;
  }
}
}
