package org.eclipse.swt.widgets {
import mx.containers.VBox;
import mx.core.EdgeMetrics;
import mx.core.ScrollControlBase;
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Rectangle;
import mx.controls.MenuBar;
import org.eclipse.swt.graphics.Image;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class Decorations extends Canvas {
  internal var boxComponent: VBox;
  internal var text: String = "";
  internal var menuBar: Menu;
  internal var menus: JavaArray;
  public function Decorations__(): Object {
    return this;
  }
  public function Decorations__Lorg_eclipse_swt_widgets_Composite_2I(parent: Composite, style: int): Object {
    return this;
  }
  public override function checkSubclass__(): void {
  }
  public static function checkStyle__I(style: int): int {
    if ((style & 8) != 0) {
      style &= ~(64 | 32 | 128 | 1024 | 16 | 2048);
    }
    if ((style & (64 | 128 | 1024 | 64)) != 0) {
      style |= 32;
    }
    if ((style & (128 | 1024)) != 0)
      style |= 64;
    if ((style & 64) != 0)
      style |= 32;
    return style;
  }
  public override function computeTabGroup__(): Control {
    return this;
  }
  public override function computeTabRoot__(): Control {
    return this;
  }
  public override function computeTrim__IIII(x_1: int, y_1: int, width_1: int, height_1: int): Rectangle {
    this.checkWidget__();
    var trim: Rectangle = super.computeTrim__IIII(x_1, y_1, width_1, height_1);
    if (menuBar !== null) {
      var mb: MenuBar = MenuBar(menuBar.object);
      mb.validateSize();
      var menuHeight: Number = mb.getExplicitOrMeasuredHeight();
      trim.y -= menuHeight;
      trim.height += menuHeight;
    }
    return trim;
  }
  public override function getClientArea__(): Rectangle {
    this.checkWidget__();
    var rect: Rectangle = super.getClientArea__();
    if (menuBar !== null) {
      var mb: MenuBar = MenuBar(menuBar.object);
      mb.validateSize();
      rect.height -= mb.getExplicitOrMeasuredHeight();
    }
    return rect;
  }
  public function getDefaultButton__(): Button {
    return null;
  }
  public function getImage__(): Image {
    return null;
  }
  public function getImages__(): JavaArray {
    return null;
  }
  public function getMaximized__(): Boolean {
    return false;
  }
  public function getMenuBar__(): Menu {
    return null;
  }
  public function getMinimized__(): Boolean {
    return false;
  }
  public function getText__(): String {
    this.checkWidget__();
    return text;
  }
  public override function menuShell__(): Decorations {
    return this;
  }
  public override function releaseChildren__Z(destroy: Boolean): void {
    if (menuBar !== null) {
      menuBar.release__Z(false);
      menuBar = null;
    }
    super.releaseChildren__Z(destroy);
    if (menus !== null) {
      for (var i: int = 0; i < menus.length; i++) {
        var menu_1: Menu = menus[i];
        if (menu_1 !== null && !menu_1.isDisposed__()) {
          menu_1.dispose__();
        }
      }
      menus = null;
    }
    return;
  }
  public function setDefaultButton__Lorg_eclipse_swt_widgets_Button_2(button: Button): void {
  }
  public function setImage__Lorg_eclipse_swt_graphics_Image_2(image: Image): void {
  }
  public function setImages___3Lorg_eclipse_swt_graphics_Image_2(images: JavaArray): void {
  }
  public function setMaximized__Z(maximized: Boolean): void {
  }
  public function setMenuBar__Lorg_eclipse_swt_widgets_Menu_2(menu_1: Menu): void {
    this.checkWidget__();
    if (menuBar === menu_1)
      return;
    if (menu_1 !== null) {
      if (menu_1.isDisposed__())
        this.error__I(5);
      if ((menu_1.style & 2) == 0)
        this.error__I(33);
      if (menu_1.parent !== this)
        this.error__I(32);
    }
    var oldMenu: Menu = menuBar;
    menuBar = menu_1;
    if (oldMenu !== null) {
      boxComponent.removeChild(oldMenu.object);
    }
    if (menu_1 !== null) {
      boxComponent.addChildAt(menu_1.object, 0);
    }
    return;
  }
  public function setMinimized__Z(minimized: Boolean): void {
  }
  public function setText__Ljava_lang_String_2(string: String): void {
    this.checkWidget__();
    if (string === null)
      this.error__I(4);
    text = string;
    return;
  }
  public function Decorations(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 2 && vargs[0] is Composite && vargs[1] is int) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.swt.widgets.Canvas.Canvas__, []);
        break;
      case 1:
        var args1: Array = [args[0], args[1]];
        superArgs = new Arguments(org.eclipse.swt.widgets.Canvas.Canvas__Lorg_eclipse_swt_widgets_Composite_2I, [args1[0], Decorations.checkStyle__I(args1[1])]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        Decorations__();
        break;
      case 1:
        Decorations__Lorg_eclipse_swt_widgets_Composite_2I(args1[0], args1[1]);
        break;
    }
  }
  public static const Decorations__ : int = 0;
  public static const Decorations__Lorg_eclipse_swt_widgets_Composite_2I : int = 1;
}
}
