package org.eclipse.swt.widgets {
import org.eclipse.swt.*;
import org.eclipse.swt.SWT;
import java.lang.Arguments;
dynamic public class Dialog {
  internal var style: int;
  internal var parent: Shell;
  internal var title: String;
  public function Dialog__Lorg_eclipse_swt_widgets_Shell_2(parent: Shell): Object {
    return this;
  }
  public function Dialog__Lorg_eclipse_swt_widgets_Shell_2I(parent: Shell, style: int): Object {
    this.checkParent__Lorg_eclipse_swt_widgets_Shell_2(parent);
    this.parent = parent;
    this.style = style;
    title = "";
    return this;
  }
  public function checkSubclass__(): void {
    if (!Display.isValidClass__Ljava_lang_Class_2(Object(this).getClass__())) {
      this.error__I(43);
    }
    return;
  }
  public function checkParent__Lorg_eclipse_swt_widgets_Shell_2(parent_1: Shell): void {
    if (parent_1 === null)
      this.error__I(4);
    parent_1.checkWidget__();
    return;
  }
  public static function checkStyle__Lorg_eclipse_swt_widgets_Shell_2I(parent: Shell, style: int): int {
    if ((style & (32768 | 65536 | 131072)) == 0) {
      style |= 65536;
    }
    style &= ~134217728;
    if ((style & (33554432 | 67108864)) == 0) {
      if (parent !== null) {
        if ((parent.style & 33554432) != 0)
          style |= 33554432;
        if ((parent.style & 67108864) != 0)
          style |= 67108864;
      }
    }
    return Widget.checkBits__IIIIIII(style, 33554432, 67108864, 0, 0, 0, 0);
  }
  public function error__I(code: int): void {
    SWT.error__I(code);
  }
  public function getParent__(): Shell {
    return parent;
  }
  public function getStyle__(): int {
    return style;
  }
  public function getText__(): String {
    return title;
  }
  public function setText__Ljava_lang_String_2(string: String): void {
    if (string === null)
      this.error__I(4);
    title = string;
  }
  public function Dialog(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 1 && vargs[0] is Shell) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 2 && vargs[0] is Shell && vargs[1] is int) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0]];
        args1 = [args0[0], 32768];
        break;
      case 1:
        var args1: Array = [args[0], args[1]];
        break;
    }
    super();
    switch (id) {
      case 0:
        Dialog__Lorg_eclipse_swt_widgets_Shell_2I(args1[0], args1[1]);
        Dialog__Lorg_eclipse_swt_widgets_Shell_2(args0[0]);
        break;
      case 1:
        Dialog__Lorg_eclipse_swt_widgets_Shell_2I(args1[0], args1[1]);
        break;
    }
  }
  public static const Dialog__Lorg_eclipse_swt_widgets_Shell_2 : int = 0;
  public static const Dialog__Lorg_eclipse_swt_widgets_Shell_2I : int = 1;
}
}
