package org.eclipse.swt.widgets {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import flash.display.BitmapData;
import flash.display.DisplayObject;
import flash.display.DisplayObjectContainer;
import flash.display.InteractiveObject;
import flash.events.TimerEvent;
import flash.ui.Keyboard;
import flash.utils.Timer;
import mx.core.Container;
import mx.core.Application;
import mx.core.UIComponent;
import mx.managers.CursorManager;
import mx.managers.CursorManagerPriority;
import mx.managers.IFocusManager;
import mx.managers.IFocusManagerComponent;
import org.eclipse.swt.graphics.Device;
import java.lang.Thread;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.SWT;
import java.lang.Runnable;
import org.eclipse.swt.graphics.DeviceData;
import java.lang.Class__;
import mx.containers.Canvas;
import flash.events.Event;
import java.lang.System;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import flash.events.MouseEvent;
import flash.events.KeyboardEvent;
import flash.events.FocusEvent;
import org.eclipse.swt.graphics.GCData;
import flash.geom.Point;
import java.lang.Arguments;
import java.lang.Class__;
import java.lang.JavaArray;
dynamic public class Display extends Device {
  internal var root: Container;
  internal var thread: Thread;
  internal var eventQueue: JavaArray;
  internal var eventTable: EventTable;
  internal var filterTable: EventTable;
  internal var synchronizer: Synchronizer;
  internal var disposeList: JavaArray;
  internal var data: Object;
  internal var keys: JavaArray;
  internal var values: JavaArray;
  internal var tray: Tray;
  internal var currentCaret: Caret;
  internal var caretTimer: Timer;
  internal var timerIds: JavaArray;
  internal var timerList: JavaArray;
  internal var grabControl: Control = null;
  internal var lastMouseDownControl: Control;
  internal var lastMouseDownX: int;
  internal var lastMouseDownY: int;
  internal var lastMouseDownTime: int;
  internal var clickCount: int;
  internal var currentCursor: Cursor;
  internal var cursors: JavaArray = new JavaArray("[Lorg/eclipse/swt/graphics/Cursor;").lengths(21 + 1);
  public static const SWT_OBJECT_STYLE: String = "SWT_OBJECT_STYLE";
  public static var KeyTable: JavaArray = new JavaArray("[[I").values(new JavaArray("[I").values(Keyboard.SHIFT, 131072), new JavaArray("[I").values(Keyboard.CONTROL, 262144), new JavaArray("[I").values(Keyboard.UP, 16777217), new JavaArray("[I").values(Keyboard.DOWN, 16777218), new JavaArray("[I").values(Keyboard.LEFT, 16777219), new JavaArray("[I").values(Keyboard.RIGHT, 16777220), new JavaArray("[I").values(Keyboard.PAGE_UP, 16777221), new JavaArray("[I").values(Keyboard.PAGE_DOWN, 16777222), new JavaArray("[I").values(Keyboard.HOME, 16777223), new JavaArray("[I").values(Keyboard.END, 16777224), new JavaArray("[I").values(Keyboard.INSERT, 16777225), new JavaArray("[I").values(Keyboard.BACKSPACE, 8), new JavaArray("[I").values(Keyboard.ENTER, 13), new JavaArray("[I").values(Keyboard.DELETE, 127), new JavaArray("[I").values(Keyboard.ESCAPE, 27), new JavaArray("[I").values(Keyboard.TAB, 9), new JavaArray("[I").values(Keyboard.F1, 16777226), new JavaArray("[I").values(Keyboard.F2, 16777227), new JavaArray("[I").values(Keyboard.F3, 16777228), new JavaArray("[I").values(Keyboard.F4, 16777229), new JavaArray("[I").values(Keyboard.F5, 16777230), new JavaArray("[I").values(Keyboard.F6, 16777231), new JavaArray("[I").values(Keyboard.F7, 16777232), new JavaArray("[I").values(Keyboard.F8, 16777233), new JavaArray("[I").values(Keyboard.F9, 16777234), new JavaArray("[I").values(Keyboard.F10, 16777235), new JavaArray("[I").values(Keyboard.F11, 16777236), new JavaArray("[I").values(Keyboard.F12, 16777237), new JavaArray("[I").values(Keyboard.F13, 16777238), new JavaArray("[I").values(Keyboard.F14, 16777239), new JavaArray("[I").values(Keyboard.F15, 16777240), new JavaArray("[I").values(Keyboard.NUMPAD_MULTIPLY, 16777258), new JavaArray("[I").values(Keyboard.NUMPAD_ADD, 16777259), new JavaArray("[I").values(Keyboard.NUMPAD_ENTER, 16777296), new JavaArray("[I").values(Keyboard.NUMPAD_SUBTRACT, 16777261), new JavaArray("[I").values(Keyboard.NUMPAD_DECIMAL, 16777262), new JavaArray("[I").values(Keyboard.NUMPAD_DIVIDE, 16777263), new JavaArray("[I").values(Keyboard.NUMPAD_0, 16777264), new JavaArray("[I").values(Keyboard.NUMPAD_1, 16777265), new JavaArray("[I").values(Keyboard.NUMPAD_2, 16777266), new JavaArray("[I").values(Keyboard.NUMPAD_3, 16777267), new JavaArray("[I").values(Keyboard.NUMPAD_4, 16777268), new JavaArray("[I").values(Keyboard.NUMPAD_5, 16777269), new JavaArray("[I").values(Keyboard.NUMPAD_6, 16777270), new JavaArray("[I").values(Keyboard.NUMPAD_7, 16777271), new JavaArray("[I").values(Keyboard.NUMPAD_8, 16777272), new JavaArray("[I").values(Keyboard.NUMPAD_9, 16777273), new JavaArray("[I").values(Keyboard.CAPS_LOCK, 16777298));
  public static var Default: Display;
  public static var Displays: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/Display;").lengths(4);
  public static const PACKAGE_PREFIX: String = "org.eclipse.swt.widgets.";

  __clinit();

  static private function __clinit(): void {
    {
      Device.DeviceFinder = new org.eclipse.swt.widgets.Display$1();
    }
  }
  public static function setDevice__Lorg_eclipse_swt_graphics_Device_2(device: Device): void {
    Device.CurrentDevice = device;
    return;
  }
  public function Display__(): Object {
    return this;
  }
  public function Display__Lorg_eclipse_swt_graphics_DeviceData_2(data: DeviceData): Object {
    synchronizer = new Synchronizer(this);
    return this;
  }
  public static function isValidClass__Ljava_lang_Class_2(clazz: Class__): Boolean {
    var name: String = clazz.getName__();
    var index: int = Object(name).lastIndexOf__I(46);
    return Object(Object(name).substring__II(0, index + 1)).equals__Ljava_lang_Object_2("org.eclipse.swt.widgets.");
  }
  public static function translateKey__I(key: int): int {
    for (var i: int = 0; i < KeyTable.length; i++) {
      if (KeyTable[i][0] == key)
        return KeyTable[i][1];
    }
    return 0;
  }
  public static function untranslateKey__I(key: int): int {
    for (var i: int = 0; i < KeyTable.length; i++) {
      if (KeyTable[i][1] == key)
        return KeyTable[i][0];
    }
    return 0;
  }
  public function addFilter__ILorg_eclipse_swt_widgets_Listener_2(eventType: int, listener: Listener): void {
    this.checkDevice__();
    if (listener === null)
      this.error__I(4);
    if (filterTable === null)
      filterTable = new EventTable();
    filterTable.hook__ILorg_eclipse_swt_widgets_Listener_2(eventType, listener);
  }
  public function addListener__ILorg_eclipse_swt_widgets_Listener_2(eventType: int, listener: Listener): void {
    this.checkDevice__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      eventTable = new EventTable();
    eventTable.hook__ILorg_eclipse_swt_widgets_Listener_2(eventType, listener);
  }
  public function addWidget__Lmx_core_UIComponent_2Lorg_eclipse_swt_widgets_Widget_2(component: UIComponent, widget: Widget): void {
    if (component === null)
      return;
    component.setStyle("SWT_OBJECT_STYLE", widget);
  }
  public function asyncExec__Ljava_lang_Runnable_2(runnable: Runnable): void {
    {
      if (this.isDisposed__())
        this.error__I(45);
      synchronizer.asyncExec__Ljava_lang_Runnable_2(runnable);
      if (this.getMessageCount__() == 1)
        this.callLater__();
    }
    return;
  }
  public function beep__(): void {
    this.checkDevice__();
    return;
  }
  public function callLater__(): void {
    root.callLater(this.dispathEventsFunction__(), null);
    return;
  }
  public function caretTimerHandler__Lflash_events_TimerEvent_2(event: TimerEvent): void {
    if (currentCaret === null || currentCaret.isDisposed__())
      return;
    if (!(currentCaret.blinkCaret__() && currentCaret.blinkRate != 0)) {
      currentCaret = null;
      caretTimer.stop();
      caretTimer = null;
    }
    return;
  }
  public function caretTimerHandlerFunction__(): Function {
    return caretTimerHandler__Lflash_events_TimerEvent_2;
  }
  public function changeCursor__Lorg_eclipse_swt_graphics_Cursor_2(cursor: Cursor): void {
    if (currentCursor !== cursor) {
      currentCursor = cursor;
      CursorManager.removeCursor(CursorManager.currentCursorID);
      if (cursor !== null) {
        if (cursor.wait) {
          CursorManager.setBusyCursor();
        } else {
          if (cursor.object !== null) {
            CursorManager.setCursor(cursor.object, CursorManagerPriority.MEDIUM, -cursor.hotspotX, -cursor.hotspotY);
          } else {
            CursorManager.setCursor(SWTBitmapAsset.getClazz__(), CursorManagerPriority.MEDIUM, -cursor.hotspotX, -cursor.hotspotY);
          }
        }
      }
    }
    return;
  }
  public override function checkDevice__(): void {
    if (thread === null)
      this.error__I(24);
    if (thread !== Thread.currentThread__())
      this.error__I(22);
    if (this.isDisposed__())
      this.error__I(45);
    return;
  }
  public static function checkDisplay__Ljava_lang_Thread_2Z(thread: Thread, multiple: Boolean): void {
    {
      for (var i: int = 0; i < Displays.length; i++) {
        if (Displays[i] !== null) {
          if (!multiple)
            SWT.error__ILjava_lang_Throwable_2Ljava_lang_String_2(20, null, " [multiple displays]");
          if (Displays[i].thread === thread)
            SWT.error__I(22);
        }
      }
    }
    return;
  }
  public function checkSubclass__(): void {
    if (!Display.isValidClass__Ljava_lang_Class_2(Object(this).getClass__()))
      this.error__I(43);
    return;
  }
  public function close__(): void {
    this.checkDevice__();
    var event: org.eclipse.swt.widgets.Event = new org.eclipse.swt.widgets.Event();
    this.sendEvent__ILorg_eclipse_swt_widgets_Event_2(21, event);
    if (event.doit)
      this.dispose__();
    return;
  }
  public override function create__Lorg_eclipse_swt_graphics_DeviceData_2(data_1: DeviceData): void {
    this.checkSubclass__();
    Display.checkDisplay__Ljava_lang_Thread_2Z(thread = Thread.currentThread__(), false);
    this.createDisplay__Lorg_eclipse_swt_graphics_DeviceData_2(data_1);
    Display.register__Lorg_eclipse_swt_widgets_Display_2(this);
    if (Default === null)
      Default = this;
    return;
  }
  public function createDisplay__Lorg_eclipse_swt_graphics_DeviceData_2(data_1: DeviceData): void {
    var app: Application = Application(Application.application);
    root = new mx.containers.Canvas();
    root.percentHeight = root.percentWidth = 100;
    app.setStyle("paddingLeft", 0);
    app.setStyle("paddingTop", 0);
    app.setStyle("paddingRight", 0);
    app.setStyle("paddingBottom", 0);
    root.addEventListener(flash.events.Event.ADDED_TO_STAGE, this.handleAddedToStageFunction__());
    app.addChild(root);
    return;
  }
  public static function deregister__Lorg_eclipse_swt_widgets_Display_2(display: Display): void {
    {
      for (var i: int = 0; i < Displays.length; i++) {
        if (display === Displays[i])
          Displays[i] = null;
      }
    }
    return;
  }
  public override function destroy__(): void {
    if (this === Default)
      Default = null;
    Display.deregister__Lorg_eclipse_swt_widgets_Display_2(this);
    this.destroyDisplay__();
    return;
  }
  public function destroyDisplay__(): void {
    var app: Application = Application(Application.application);
    app.removeChild(root);
    root = null;
    return;
  }
  public function dispatchEvents__(): void {
    if (this.runEvents__())
      this.callLater__();
    return;
  }
  public function dispathEventsFunction__(): Function {
    return dispatchEvents__;
  }
  public function disposeExec__Ljava_lang_Runnable_2(runnable: Runnable): void {
    this.checkDevice__();
    if (disposeList === null)
      disposeList = new JavaArray("[Ljava/lang/Runnable;").lengths(4);
    for (var i: int = 0; i < disposeList.length; i++) {
      if (disposeList[i] === null) {
        disposeList[i] = runnable;
        return;
      }
    }
    var newDisposeList: JavaArray = new JavaArray("[Ljava/lang/Runnable;").lengths(disposeList.length + 4);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(disposeList, 0, newDisposeList, 0, disposeList.length);
    newDisposeList[disposeList.length] = runnable;
    disposeList = newDisposeList;
    return;
  }
  public function error__I(code: int): void {
    SWT.error__I(code);
    return;
  }
  public function filterEvent__Lorg_eclipse_swt_widgets_Event_2(event: org.eclipse.swt.widgets.Event): Boolean {
    if (filterTable !== null)
      filterTable.sendEvent__Lorg_eclipse_swt_widgets_Event_2(event);
    return false;
  }
  public function filters__I(eventType: int): Boolean {
    if (filterTable === null)
      return false;
    return filterTable.hooks__I(eventType);
  }
  public function findControl__Lflash_display_DisplayObject_2Z(target: DisplayObject, check: Boolean): Control {
    if (target === null)
      return null;
    while (target !== null) {
      if (target is UIComponent) {
        var widget: Widget = this.getWidget__Lmx_core_UIComponent_2(UIComponent(target));
        if (widget !== null) {
          if (check && !widget.checkComponent__Lflash_display_DisplayObject_2(target))
            return null;
          if (widget is Control) {
            var control: Control = Control(widget);
            if (control.isEnabled__())
              return control;
          }
        }
      }
      target = target.parent;
    }
    return null;
  }
  public function findWidget__I(handle: int): Widget {
    this.checkDevice__();
    return null;
  }
  public function findWidget__II(handle: int, id: int): Widget {
    return null;
  }
  public function findWidget__Lorg_eclipse_swt_widgets_Widget_2I(widget: Widget, id: int): Widget {
    return null;
  }
  public static function findDisplay__Ljava_lang_Thread_2(thread: Thread): Display {
    {
      for (var i: int = 0; i < Displays.length; i++) {
        var display: Display = Displays[i];
        if (display !== null && display.thread === thread) {
          return display;
        }
      }
      return null;
    }
    return null;
  }
  public function getActiveShell__(): Shell {
    return null;
  }
  public function getCaretBlinkTime__(): int {
    return 400;
  }
  public function getClickCount__ILorg_eclipse_swt_widgets_Control_2III(type: int, control: Control, x: int, y: int, time: int): int {
    switch (type) {
      case 3 :
        var timeDelta: int = 500;
        var xInset: int = 2;
        var yInset: int = 2;
        var clickRect: Rectangle = new Rectangle(lastMouseDownX - xInset, lastMouseDownY - yInset, xInset + xInset, yInset + yInset);
        if (control === lastMouseDownControl && (time - lastMouseDownTime) <= timeDelta && clickRect.contains__II(x, y)) {
          clickCount++;
        } else {
          clickCount = 1;
        }
        lastMouseDownControl = control;
        lastMouseDownX = x;
        lastMouseDownY = y;
        lastMouseDownTime = time;
      case 4 :
        return clickCount;
    }
    return 0;
  }
  public override function getBounds__(): Rectangle {
    this.checkDevice__();
    var application: Application = Application(Application.application);
    return new Rectangle(0, 0, int(application.width), int(application.height));
  }
  public static function getCurrent__(): Display {
    return findDisplay__Ljava_lang_Thread_2(Thread.currentThread__());
  }
  public override function getClientArea__(): Rectangle {
    this.checkDevice__();
    return this.getBounds__();
  }
  public function getCursorBitmap__(): BitmapData {
    return currentCursor !== null ? currentCursor.bitmap : null;
  }
  public function getCursorControl__(): Control {
    this.checkDevice__();
    return null;
  }
  public function getCursorLocation__(): org.eclipse.swt.graphics.Point {
    this.checkDevice__();
    return new org.eclipse.swt.graphics.Point(int(root.mouseX), int(root.mouseY));
  }
  public function getCursorSizes__(): JavaArray {
    return null;
  }
  public static function getDefault__(): Display {
    {
      if (Default === null)
        Default = new Display(new Arguments(org.eclipse.swt.widgets.Display.Display__, []));
      return Default;
    }
    return null;
  }
  public function getData__(): Object {
    this.checkDevice__();
    return data;
  }
  public function getData__Ljava_lang_String_2(key: String): Object {
    this.checkDevice__();
    if (key === null)
      this.error__I(4);
    if (keys === null)
      return null;
    for (var i: int = 0; i < keys.length; i++) {
      if (Object(keys[i]).equals__Ljava_lang_Object_2(key))
        return values[i];
    }
    return null;
  }
  public function getDismissalAlignment__(): int {
    this.checkDevice__();
    return 131072;
  }
  public function getDoubleClickTime__(): int {
    return 400;
  }
  public function getFocusControl__(): Control {
    var app: Application = Application(Application.application);
    var focusManager: IFocusManager = app.focusManager;
    if (focusManager === null)
      return null;
    var focusComponent: IFocusManagerComponent = focusManager.getFocus();
    if (focusComponent !== null && focusComponent is UIComponent) {
      return Control(this.getWidget__Lmx_core_UIComponent_2(UIComponent(focusComponent)));
    }
    return null;
  }
  public function getHighContrast__(): Boolean {
    return false;
  }
  public function getIconDepth__(): int {
    return 0;
  }
  public function getIconSizes__(): JavaArray {
    return null;
  }
  public function getLastEventTime__(): int {
    return 0;
  }
  public function getMessageCount__(): int {
    return synchronizer.getMessageCount__();
  }
  public function getMonitors__(): JavaArray {
    return null;
  }
  public function getPrimaryMonitor__(): Monitor {
    return null;
  }
  public function getShells__(): JavaArray {
    var count: int = 0;
    var result: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/Shell;").lengths(root.numChildren);
    for (var i: int = 0; i < result.length; i++) {
      var object: DisplayObject = root.getChildAt(i);
      if (object is UIComponent) {
        var widget: Widget = this.getWidget__Lmx_core_UIComponent_2(UIComponent(object));
        if (widget is Shell) {
          result[count++] = Shell(widget);
        }
      }
    }
    if (count != result.length) {
      var temp: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/Shell;").lengths(count);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(result, 0, temp, 0, count);
      result = temp;
    }
    return result;
  }
  public function getSynchronizer__(): Synchronizer {
    this.checkDevice__();
    return synchronizer;
  }
  public function getSyncThread__(): Thread {
    {
      if (this.isDisposed__())
        this.error__I(45);
      return synchronizer.syncThread;
    }
    return null;
  }
  public override function getSystemColor__I(id: int): Color {
    this.checkDevice__();
    var rgb: int = 0x000000;
    switch (id) {
      case 28 :
        rgb = 0x000000;
        break;
      case 29 :
        rgb = 0xFFFFE1;
        break;
      case 30 :
        rgb = 0xFFFFFF;
        break;
      case 31 :
        rgb = 0x0054e3;
        break;
      case 32 :
        rgb = 0x3D95FF;
        break;
      case 33 :
        rgb = 0xD8E4F8;
        break;
      case 34 :
        rgb = 0x7A96DF;
        break;
      case 35 :
        rgb = 0x9DB9EB;
        break;
      case 17 :
        rgb = 0x000000;
        break;
      case 18 :
        rgb = 0x909090;
        break;
      case 19 :
        rgb = 0xC0C0C0;
        break;
      case 20 :
        rgb = 0xFFFFFF;
        break;
      case 22 :
        rgb = 0xFFFFFF;
        break;
      case 21 :
        rgb = 0x000000;
        break;
      case 23 :
      case 24 :
        rgb = 0x000000;
        break;
      case 25 :
        rgb = 0xFFFFFF;
        break;
      case 27 :
        rgb = 0xFFFFFF;
        break;
      case 26 :
        rgb = 0x000000;
        break;
      default :
        return super.getSystemColor__I(id);
    }
    return Color.flex_new__Lorg_eclipse_swt_graphics_Device_2I(this, rgb);
  }
  public function getSystemCursor__I(id: int): Cursor {
    this.checkDevice__();
    if (!(0 <= id && id < cursors.length))
      return null;
    if (cursors[id] === null) {
      cursors[id] = new Cursor(new Arguments(org.eclipse.swt.graphics.Cursor.Cursor__Lorg_eclipse_swt_graphics_Device_2I, [this, id]));
    }
    return cursors[id];
  }
  public function getSystemImage__I(id: int): Image {
    return null;
  }
  public function getSystemTray__(): Tray {
    this.checkDevice__();
    return null;
  }
  public function getThread__(): Thread {
    {
      if (this.isDisposed__())
        this.error__I(45);
      return thread;
    }
    return null;
  }
  public function getWidget__Lmx_core_UIComponent_2(component: UIComponent): Widget {
    if (component === null)
      return null;
    return Widget(component.getStyle("SWT_OBJECT_STYLE"));
  }
  public function handleAddedToStage__Lflash_events_Event_2(event: flash.events.Event): void {
    var stage: InteractiveObject = root.stage;
    stage.addEventListener(flash.events.MouseEvent.MOUSE_DOWN, this.handleMouseDownFunction__());
    stage.addEventListener(flash.events.MouseEvent.MOUSE_UP, this.handleMouseUpFunction__());
    stage.addEventListener(flash.events.MouseEvent.MOUSE_MOVE, this.handleMouseMoveFunction__());
    stage.addEventListener(flash.events.MouseEvent.MOUSE_OVER, this.handleMouseOverFunction__());
    stage.addEventListener(flash.events.MouseEvent.MOUSE_OUT, this.handleMouseOutFunction__());
    stage.addEventListener(flash.events.KeyboardEvent.KEY_DOWN, this.handleKeyDownFunction__(), true);
    stage.addEventListener(flash.events.KeyboardEvent.KEY_UP, this.handleKeyUpFunction__(), true);
    stage.addEventListener(flash.events.FocusEvent.FOCUS_IN, this.handleFocusInFunction__(), true);
    stage.addEventListener(flash.events.FocusEvent.FOCUS_OUT, this.handleFocusOutFunction__(), true);
  }
  public function handleAddedToStageFunction__(): Function {
    return handleAddedToStage__Lflash_events_Event_2;
  }
  public function handleFocusIn__Lflash_events_FocusEvent_2(event: FocusEvent): void {
    var control: Control = this.findControl__Lflash_display_DisplayObject_2Z(DisplayObject(event.target), false);
    if (control === null)
      return;
    control.sendFocusEvent__I(15);
  }
  public function handleFocusInFunction__(): Function {
    return handleFocusIn__Lflash_events_FocusEvent_2;
  }
  public function handleFocusOut__Lflash_events_FocusEvent_2(event: FocusEvent): void {
    var control: Control = this.findControl__Lflash_display_DisplayObject_2Z(DisplayObject(event.target), false);
    if (control === null)
      return;
    control.sendFocusEvent__I(16);
  }
  public function handleFocusOutFunction__(): Function {
    return handleFocusOut__Lflash_events_FocusEvent_2;
  }
  public function handleKeyDown__Lflash_events_KeyboardEvent_2(event: KeyboardEvent): void {
    var control: Control = this.findControl__Lflash_display_DisplayObject_2Z(DisplayObject(event.target), false);
    if (control === null)
      return;
    if (!control.sendKeyEvent__ILflash_events_KeyboardEvent_2(1, event)) {
      event.stopPropagation();
    }
    return;
  }
  public function handleKeyDownFunction__(): Function {
    return handleKeyDown__Lflash_events_KeyboardEvent_2;
  }
  public function handleKeyUp__Lflash_events_KeyboardEvent_2(event: KeyboardEvent): void {
    var control: Control = this.findControl__Lflash_display_DisplayObject_2Z(DisplayObject(event.target), false);
    if (control === null)
      return;
    if (!control.sendKeyEvent__ILflash_events_KeyboardEvent_2(2, event)) {
      event.stopPropagation();
    }
    return;
  }
  public function handleKeyUpFunction__(): Function {
    return handleKeyUp__Lflash_events_KeyboardEvent_2;
  }
  public function handleMouseDown__Lflash_events_MouseEvent_2(event: MouseEvent): void {
    var control: Control = grabControl = this.findControl__Lflash_display_DisplayObject_2Z(DisplayObject(event.target), true);
    if (control === null)
      return;
    control.sendMouseEvent__ILflash_events_MouseEvent_2Z(3, event, false);
  }
  public function handleMouseDownFunction__(): Function {
    return handleMouseDown__Lflash_events_MouseEvent_2;
  }
  public function handleMouseMove__Lflash_events_MouseEvent_2(event: MouseEvent): void {
    var control: Control = grabControl !== null ? grabControl : this.findControl__Lflash_display_DisplayObject_2Z(DisplayObject(event.target), true);
    if (control === null)
      return;
    control.sendMouseEvent__ILflash_events_MouseEvent_2Z(5, event, false);
  }
  public function handleMouseMoveFunction__(): Function {
    return handleMouseMove__Lflash_events_MouseEvent_2;
  }
  public function handleMouseOver__Lflash_events_MouseEvent_2(event: MouseEvent): void {
    if (grabControl !== null) {
      if (event.relatedObject === null) {
        this.changeCursor__Lorg_eclipse_swt_graphics_Cursor_2(grabControl.findCursor__());
      }
      return;
    }
    var target: DisplayObject = DisplayObject(event.target);
    if (target is DisplayObjectContainer) {
      var container: DisplayObjectContainer = DisplayObjectContainer(target);
      var relatedObject: InteractiveObject = event.relatedObject;
      if (relatedObject !== null && relatedObject !== container && container.contains(relatedObject)) {
        return;
      }
    }
    var control: Control = this.findControl__Lflash_display_DisplayObject_2Z(target, true);
    if (control === null)
      return;
    control.sendMouseEvent__ILflash_events_MouseEvent_2Z(6, event, true);
    if (control.isDisposed__())
      return;
    this.changeCursor__Lorg_eclipse_swt_graphics_Cursor_2(control.findCursor__());
  }
  public function handleMouseOverFunction__(): Function {
    return handleMouseOver__Lflash_events_MouseEvent_2;
  }
  public function handleMouseOut__Lflash_events_MouseEvent_2(event: MouseEvent): void {
    if (grabControl !== null) {
      if (event.relatedObject === null) {
        this.changeCursor__Lorg_eclipse_swt_graphics_Cursor_2(null);
      }
      return;
    }
    var target: DisplayObject = DisplayObject(event.target);
    if (target is DisplayObjectContainer) {
      var container: DisplayObjectContainer = DisplayObjectContainer(target);
      var relatedObject: InteractiveObject = event.relatedObject;
      if (relatedObject !== null && relatedObject !== container && container.contains(relatedObject)) {
        return;
      }
    }
    var control: Control = this.findControl__Lflash_display_DisplayObject_2Z(target, true);
    this.changeCursor__Lorg_eclipse_swt_graphics_Cursor_2(null);
    if (control === null)
      return;
    control.sendMouseEvent__ILflash_events_MouseEvent_2Z(7, event, true);
  }
  public function handleMouseOutFunction__(): Function {
    return handleMouseOut__Lflash_events_MouseEvent_2;
  }
  public function handleMouseUp__Lflash_events_MouseEvent_2(event: MouseEvent): void {
    var control: Control = grabControl !== null ? grabControl : this.findControl__Lflash_display_DisplayObject_2Z(DisplayObject(event.target), true);
    grabControl = null;
    if (control === null)
      return;
    control.sendMouseEvent__ILflash_events_MouseEvent_2Z(4, event, false);
  }
  public function handleMouseUpFunction__(): Function {
    return handleMouseUp__Lflash_events_MouseEvent_2;
  }
  public override function init__(): void {
  }
  public override function internal_new_GC__Lorg_eclipse_swt_graphics_GCData_2(data_1: GCData): int {
    return 0;
  }
  public override function internal_dispose_GC__ILorg_eclipse_swt_graphics_GCData_2(hDC: int, data_1: GCData): void {
  }
  public function isValidThread__(): Boolean {
    return thread === Thread.currentThread__();
  }
  public function map__Lorg_eclipse_swt_widgets_Control_2Lorg_eclipse_swt_widgets_Control_2Lorg_eclipse_swt_graphics_Point_2(from: Control, to_1: Control, point: org.eclipse.swt.graphics.Point): org.eclipse.swt.graphics.Point {
    this.checkDevice__();
    if (point === null)
      this.error__I(4);
    return this.map__Lorg_eclipse_swt_widgets_Control_2Lorg_eclipse_swt_widgets_Control_2II(from, to_1, point.x, point.y);
  }
  public function map__Lorg_eclipse_swt_widgets_Control_2Lorg_eclipse_swt_widgets_Control_2II(from: Control, to_1: Control, x: int, y: int): org.eclipse.swt.graphics.Point {
    this.checkDevice__();
    if (from !== null && from.isDisposed__())
      this.error__I(5);
    if (to_1 !== null && to_1.isDisposed__())
      this.error__I(5);
    if (from === to_1)
      return new org.eclipse.swt.graphics.Point(x, y);
    var point: flash.geom.Point = new flash.geom.Point(x, y);
    if (from !== null) {
      point = from.object.contentToGlobal(point);
    }
    if (to_1 !== null) {
      point = to_1.object.globalToContent(point);
    }
    return new org.eclipse.swt.graphics.Point(int(point.x), int(point.y));
  }
  public function map__Lorg_eclipse_swt_widgets_Control_2Lorg_eclipse_swt_widgets_Control_2Lorg_eclipse_swt_graphics_Rectangle_2(from: Control, to_1: Control, rectangle: Rectangle): Rectangle {
    this.checkDevice__();
    if (rectangle === null)
      this.error__I(4);
    return this.map__Lorg_eclipse_swt_widgets_Control_2Lorg_eclipse_swt_widgets_Control_2IIII(from, to_1, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
  }
  public function map__Lorg_eclipse_swt_widgets_Control_2Lorg_eclipse_swt_widgets_Control_2IIII(from: Control, to_1: Control, x: int, y: int, width: int, height: int): Rectangle {
    this.checkDevice__();
    if (from !== null && from.isDisposed__())
      this.error__I(5);
    if (to_1 !== null && to_1.isDisposed__())
      this.error__I(5);
    if (from === to_1)
      return new Rectangle(x, y, width, height);
    var point: flash.geom.Point = new flash.geom.Point(x, y);
    if (from !== null) {
      point = from.object.contentToGlobal(point);
    }
    if (to_1 !== null) {
      point = to_1.object.globalToContent(point);
    }
    return new Rectangle(int(point.x), int(point.y), width, height);
  }
  public function post__Lorg_eclipse_swt_widgets_Event_2(event: org.eclipse.swt.widgets.Event): Boolean {
    return false;
  }
  public function postEvent__Lorg_eclipse_swt_widgets_Event_2(event: org.eclipse.swt.widgets.Event): void {
    if (eventQueue === null)
      eventQueue = new JavaArray("[Lorg/eclipse/swt/widgets/Event;").lengths(4);
    var index: int = 0;
    var length: int = eventQueue.length;
    while (index < length) {
      if (eventQueue[index] === null)
        break;
      index++;
    }
    if (index == length) {
      var newQueue: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/Event;").lengths(length + 4);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(eventQueue, 0, newQueue, 0, length);
      eventQueue = newQueue;
    }
    eventQueue[index] = event;
    if (index == 0)
      this.callLater__();
    return;
  }
  public function readAndDispatch__(): Boolean {
    this.checkDevice__();
    return false;
  }
  public static function register__Lorg_eclipse_swt_widgets_Display_2(display: Display): void {
    {
      for (var i: int = 0; i < Displays.length; i++) {
        if (Displays[i] === null) {
          Displays[i] = display;
          return;
        }
      }
      var newDisplays: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/Display;").lengths(Displays.length + 4);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(Displays, 0, newDisplays, 0, Displays.length);
      newDisplays[Displays.length] = display;
      Displays = newDisplays;
    }
    return;
  }
  public override function release__(): void {
    this.sendEvent__ILorg_eclipse_swt_widgets_Event_2(12, new org.eclipse.swt.widgets.Event());
    var shells: JavaArray = this.getShells__();
    for (var i: int = 0; i < shells.length; i++) {
      var shell: Shell = shells[i];
      if (!shell.isDisposed__())
        shell.dispose__();
    }
    if (tray !== null)
      tray.dispose__();
    tray = null;
    if (disposeList !== null) {
      for (var i_1: int = 0; i_1 < disposeList.length; i_1++) {
        if (disposeList[i_1] !== null)
          disposeList[i_1].run__();
      }
    }
    disposeList = null;
    synchronizer.releaseSynchronizer__();
    synchronizer = null;
    this.releaseDisplay__();
    super.release__();
    return;
  }
  public function releaseDisplay__(): void {
    currentCaret = null;
    if (caretTimer !== null)
      caretTimer.stop();
    caretTimer = null;
    for (var i: int = 0; i < cursors.length; i++) {
      if (cursors[i] !== null)
        cursors[i].dispose__();
    }
    cursors = null;
    if (timerIds !== null) {
      for (var i_1: int = 0; i_1 < timerIds.length; i_1++) {
        timerIds[i_1].stop();
      }
    }
    timerIds = null;
    timerList = null;
    lastMouseDownControl = null;
    grabControl = null;
    return;
  }
  public function removeFilter__ILorg_eclipse_swt_widgets_Listener_2(eventType: int, listener: Listener): void {
    this.checkDevice__();
    if (listener === null)
      this.error__I(4);
    if (filterTable === null)
      return;
    filterTable.unhook__ILorg_eclipse_swt_widgets_Listener_2(eventType, listener);
    if (filterTable.size__() == 0)
      filterTable = null;
  }
  public function removeListener__ILorg_eclipse_swt_widgets_Listener_2(eventType: int, listener: Listener): void {
    this.checkDevice__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_widgets_Listener_2(eventType, listener);
  }
  public function removeWidget__Lmx_core_UIComponent_2(component: UIComponent): Widget {
    if (component === null)
      return null;
    var result: Object = component.getStyle("SWT_OBJECT_STYLE");
    component.clearStyle("SWT_OBJECT_STYLE");
    return Widget(result);
  }
  public function runAsyncMessages__Z(all: Boolean): Boolean {
    return synchronizer.runAsyncMessages__Z(all);
  }
  public function runDeferredEvents__(): Boolean {
    if (eventQueue === null)
      return false;
    while (eventQueue !== null) {
      var event: org.eclipse.swt.widgets.Event = eventQueue[0];
      if (event === null)
        break;
      var length: int = eventQueue.length;
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(eventQueue, 1, eventQueue, 0, --length);
      eventQueue[length] = null;
      var widget: Widget = event.widget;
      if (widget !== null && !widget.isDisposed__()) {
        var item: Widget = event.item;
        if (item === null || !item.isDisposed__()) {
          widget.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(event.type, event);
        }
      }
    }
    eventQueue = null;
    return true;
  }
  public function runEvents__(): Boolean {
    if (this.runDeferredEvents__()) {
      return true;
    }
    return this.runAsyncMessages__Z(false);
  }
  public function sendEvent__ILorg_eclipse_swt_widgets_Event_2(eventType: int, event: org.eclipse.swt.widgets.Event): void {
    if (eventTable === null && filterTable === null) {
      return;
    }
    if (event === null)
      event = new org.eclipse.swt.widgets.Event();
    event.display = this;
    event.type = eventType;
    if (event.time == 0)
      event.time = this.getLastEventTime__();
    if (!this.filterEvent__Lorg_eclipse_swt_widgets_Event_2(event)) {
      if (eventTable !== null)
        eventTable.sendEvent__Lorg_eclipse_swt_widgets_Event_2(event);
    }
    return;
  }
  public function setCurrentCaret__Lorg_eclipse_swt_widgets_Caret_2(caret: Caret): void {
    currentCaret = caret;
    if (caretTimer !== null)
      caretTimer.stop();
    caretTimer = null;
    if (currentCaret !== null) {
      var blinkRate: int = currentCaret.blinkRate;
      if (blinkRate != 0) {
        caretTimer = new Timer(blinkRate, 0);
        caretTimer.start();
        caretTimer.addEventListener(TimerEvent.TIMER, this.caretTimerHandlerFunction__());
      }
    }
    return;
  }
  public function setCursorLocation__II(x: int, y: int): void {
  }
  public function setCursorLocation__Lorg_eclipse_swt_graphics_Point_2(point: org.eclipse.swt.graphics.Point): void {
    this.checkDevice__();
    if (point === null)
      this.error__I(4);
    this.setCursorLocation__II(point.x, point.y);
    return;
  }
  public function setData__Ljava_lang_Object_2(data_1: Object): void {
    this.checkDevice__();
    this.data = data_1;
    return;
  }
  public function setData__Ljava_lang_String_2Ljava_lang_Object_2(key: String, value: Object): void {
    this.checkDevice__();
    if (key === null)
      this.error__I(4);
    if (value === null) {
      if (keys === null)
        return;
      var index: int = 0;
      while (index < keys.length && !Object(keys[index]).equals__Ljava_lang_Object_2(key))
        index++;
      if (index == keys.length)
        return;
      if (keys.length == 1) {
        keys = null;
        values = null;
      } else {
        var newKeys: JavaArray = new JavaArray("[Ljava/lang/String;").lengths(keys.length - 1);
        var newValues: JavaArray = new JavaArray("[Ljava/lang/Object;").lengths(values.length - 1);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(keys, 0, newKeys, 0, index);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(keys, index + 1, newKeys, index, newKeys.length - index);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(values, 0, newValues, 0, index);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(values, index + 1, newValues, index, newValues.length - index);
        keys = newKeys;
        values = newValues;
      }
      return;
    }
    if (keys === null) {
      keys = new JavaArray("[Ljava/lang/String;").values(key);
      values = new JavaArray("[Ljava/lang/Object;").values(value);
      return;
    }
    for (var i: int = 0; i < keys.length; i++) {
      if (Object(keys[i]).equals__Ljava_lang_Object_2(key)) {
        values[i] = value;
        return;
      }
    }
    var newKeys_1: JavaArray = new JavaArray("[Ljava/lang/String;").lengths(keys.length + 1);
    var newValues_1: JavaArray = new JavaArray("[Ljava/lang/Object;").lengths(values.length + 1);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(keys, 0, newKeys_1, 0, keys.length);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(values, 0, newValues_1, 0, values.length);
    newKeys_1[keys.length] = key;
    newValues_1[values.length] = value;
    keys = newKeys_1;
    values = newValues_1;
    return;
  }
  public static function setAppName__Ljava_lang_String_2(name: String): void {
  }
  public function setSynchronizer__Lorg_eclipse_swt_widgets_Synchronizer_2(synchronizer_1: Synchronizer): void {
    this.checkDevice__();
    if (synchronizer_1 === null)
      this.error__I(4);
    if (synchronizer_1 === this.synchronizer)
      return;
    var oldSynchronizer: Synchronizer;
    {
      oldSynchronizer = this.synchronizer;
      this.synchronizer = synchronizer_1;
    }
    if (oldSynchronizer !== null) {
      oldSynchronizer.runAsyncMessages__Z(true);
    }
    return;
  }
  public function sleep__(): Boolean {
    this.checkDevice__();
    if (this.getMessageCount__() != 0)
      return true;
    return true;
  }
  public function syncExec__Ljava_lang_Runnable_2(runnable: Runnable): void {
    var synchronizer_1: Synchronizer;
    {
      if (this.isDisposed__())
        this.error__I(45);
      synchronizer_1 = this.synchronizer;
    }
    synchronizer_1.syncExec__Ljava_lang_Runnable_2(runnable);
    return;
  }
  public function timerExec__ILjava_lang_Runnable_2(milliseconds: int, runnable: Runnable): void {
    this.checkDevice__();
    if (runnable === null)
      this.error__I(4);
    if (timerList === null)
      timerList = new JavaArray("[Ljava/lang/Runnable;").lengths(4);
    if (timerIds === null)
      timerIds = new JavaArray("[Lintrinsic/flash/utils/Timer;").lengths(4);
    var index: int = 0;
    while (index < timerList.length) {
      if (timerList[index] === runnable)
        break;
      index++;
    }
    var timerId: Timer = null;
    if (index != timerList.length) {
      timerId = timerIds[index];
      if (milliseconds < 0) {
        timerId.stop();
        timerList[index] = null;
        timerIds[index] = null;
        return;
      }
    } else {
      if (milliseconds < 0)
        return;
      index = 0;
      while (index < timerList.length) {
        if (timerList[index] === null)
          break;
        index++;
      }
      if (index == timerList.length) {
        var newTimerList: JavaArray = new JavaArray("[Ljava/lang/Runnable;").lengths(timerList.length + 4);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(timerList, 0, newTimerList, 0, timerList.length);
        timerList = newTimerList;
        var newTimerIds: JavaArray = new JavaArray("[Lintrinsic/flash/utils/Timer;").lengths(timerIds.length + 4);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(timerIds, 0, newTimerIds, 0, timerIds.length);
        timerIds = newTimerIds;
      }
    }
    var newTimerID: Timer = new Timer(milliseconds, 1);
    if (newTimerID !== null) {
      newTimerID.start();
      newTimerID.addEventListener(TimerEvent.TIMER, this.timerHandlerFunction__());
      timerList[index] = runnable;
      timerIds[index] = newTimerID;
    }
    return;
  }
  public function timerHandler__Lflash_events_TimerEvent_2(event: TimerEvent): void {
    if (timerList !== null && timerIds !== null) {
      var index: int = 0;
      while (index < timerIds.length) {
        if (timerIds[index] === event.target) {
          timerIds[index] = null;
          var runnable: Runnable = timerList[index];
          timerList[index] = null;
          if (runnable !== null)
            runnable.run__();
          return;
        }
        index++;
      }
    }
    return;
  }
  public function timerHandlerFunction__(): Function {
    return timerHandler__Lflash_events_TimerEvent_2;
  }
  public function update__(): void {
  }
  public function wake__(): void {
    {
      if (this.isDisposed__())
        this.error__I(45);
      if (thread === Thread.currentThread__())
        return;
      this.wakeThread__();
    }
    return;
  }
  public function wakeThread__(): void {
  }
  public function Display(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is DeviceData) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        args1 = [null];
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.swt.graphics.Device.Device__Lorg_eclipse_swt_graphics_DeviceData_2, [args1[0]]);
        break;
      case 1:
        var args1: Array = [args[0]];
        superArgs = new Arguments(org.eclipse.swt.graphics.Device.Device__Lorg_eclipse_swt_graphics_DeviceData_2, [args1[0]]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        Display__Lorg_eclipse_swt_graphics_DeviceData_2(args1[0]);
        Display__();
        break;
      case 1:
        Display__Lorg_eclipse_swt_graphics_DeviceData_2(args1[0]);
        break;
    }
  }
  public static const Display__ : int = 0;
  public static const Display__Lorg_eclipse_swt_graphics_DeviceData_2 : int = 1;
}
}
