package org.eclipse.swt.widgets {
import org.eclipse.swt.*;
import org.eclipse.swt.internal.SWTEventListener;
import java.lang.System;
import org.eclipse.swt.SWT;
import java.lang.JavaArray;
dynamic public class EventTable {
  internal var types: JavaArray;
  internal var listeners: JavaArray;
  internal var level: int;
  public static const GROW_SIZE: int = 4;
  public function getListeners__I(eventType: int): JavaArray {
    if (types === null)
      return new JavaArray("[Lorg/eclipse/swt/widgets/Listener;").lengths(0);
    var count: int = 0;
    for (var i: int = 0; i < types.length; i++) {
      if (types[i] == eventType)
        count++;
    }
    if (count == 0)
      return new JavaArray("[Lorg/eclipse/swt/widgets/Listener;").lengths(0);
    var result: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/Listener;").lengths(count);
    count = 0;
    for (var i_1: int = 0; i_1 < types.length; i_1++) {
      if (types[i_1] == eventType) {
        result[count++] = listeners[i_1];
      }
    }
    return result;
  }
  public function hook__ILorg_eclipse_swt_widgets_Listener_2(eventType: int, listener: Listener): void {
    if (types === null)
      types = new JavaArray("[I").lengths(4);
    if (listeners === null)
      listeners = new JavaArray("[Lorg/eclipse/swt/widgets/Listener;").lengths(4);
    var length: int = types.length;
    var index: int = length - 1;
    while (index >= 0) {
      if (types[index] != 0)
        break;
      --index;
    }
    index++;
    if (index == length) {
      var newTypes: JavaArray = new JavaArray("[I").lengths(length + 4);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(types, 0, newTypes, 0, length);
      types = newTypes;
      var newListeners: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/Listener;").lengths(length + 4);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(listeners, 0, newListeners, 0, length);
      listeners = newListeners;
    }
    types[index] = eventType;
    listeners[index] = listener;
    return;
  }
  public function hooks__I(eventType: int): Boolean {
    if (types === null)
      return false;
    for (var i: int = 0; i < types.length; i++) {
      if (types[i] == eventType)
        return true;
    }
    return false;
  }
  public function sendEvent__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    if (types === null)
      return;
    level += level >= 0 ? 1 : -1;
    try {
      for (var i: int = 0; i < types.length; i++) {
        if (event.type == 0)
          return;
        if (types[i] == event.type) {
          var listener: Listener = listeners[i];
          if (listener !== null)
            listener.handleEvent__Lorg_eclipse_swt_widgets_Event_2(event);
        }
      }
    } finally {
      var compact: Boolean = level < 0;
      level -= level >= 0 ? 1 : -1;
      if (compact && level == 0) {
        var index: int = 0;
        for (var i_1: int = 0; i_1 < types.length; i_1++) {
          if (types[i_1] != 0) {
            types[index] = types[i_1];
            listeners[index] = listeners[i_1];
            index++;
          }
        }
        for (var i_2: int = index; i_2 < types.length; i_2++) {
          types[i_2] = 0;
          listeners[i_2] = null;
        }
      }
    }
    return;
  }
  public function size__(): int {
    if (types === null)
      return 0;
    var count: int = 0;
    for (var i: int = 0; i < types.length; i++) {
      if (types[i] != 0)
        count++;
    }
    return count;
  }
  public function remove__I(index: int): void {
    if (level == 0) {
      var end: int = types.length - 1;
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(types, index + 1, types, index, end - index);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(listeners, index + 1, listeners, index, end - index);
      index = end;
    } else {
      if (level > 0)
        level = -level;
    }
    types[index] = 0;
    listeners[index] = null;
    return;
  }
  public function unhook__ILorg_eclipse_swt_widgets_Listener_2(eventType: int, listener: Listener): void {
    if (types === null)
      return;
    for (var i: int = 0; i < types.length; i++) {
      if (types[i] == eventType && listeners[i] === listener) {
        this.remove__I(i);
        return;
      }
    }
    return;
  }
  public function unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(eventType: int, listener: SWTEventListener): void {
    if (types === null)
      return;
    for (var i: int = 0; i < types.length; i++) {
      if (types[i] == eventType) {
        if (listeners[i] is TypedListener) {
          var typedListener: TypedListener = TypedListener(listeners[i]);
          if (typedListener.getEventListener__() === listener) {
            this.remove__I(i);
            return;
          }
        }
      }
    }
    return;
  }
}
}
