package org.eclipse.swt.widgets {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.GC;
import java.lang.Math__;
import org.eclipse.swt.graphics.Rectangle;
import java.lang.System;
import org.eclipse.swt.graphics.FontMetrics;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class ExpandBar extends Composite {
  internal var items: JavaArray;
  internal var itemCount: int;
  internal var focusItem: ExpandItem;
  internal var spacing: int;
  internal var yCurrentScroll: int;
  internal var font_org_eclipse_swt_widgets_ExpandBar: Font;
  internal var foreground_org_eclipse_swt_widgets_ExpandBar: Color;
  internal var listener: Listener;
  internal var inDispose: Boolean;
  public function ExpandBar(parent: Composite, style: int) {
    super(new Arguments(org.eclipse.swt.widgets.Composite.Composite__Lorg_eclipse_swt_widgets_Composite_2I, [parent, ExpandBar.checkStyle__I(style)]));
    items = new JavaArray("[Lorg/eclipse/swt/widgets/ExpandItem;").lengths(4);
    listener = new org.eclipse.swt.widgets.ExpandBar$1(this);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(12, listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(3, listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(4, listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(9, listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(11, listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(1, listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(15, listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(16, listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(31, listener);
    var verticalBar: ScrollBar = this.getVerticalBar__();
    if (verticalBar !== null) {
      verticalBar.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, new org.eclipse.swt.widgets.ExpandBar$2(this));
    }
    return;
  }
  public function addExpandListener__Lorg_eclipse_swt_events_ExpandListener_2(listener_1: ExpandListener): void {
    this.checkWidget__();
    if (listener_1 === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener_1);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(17, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(18, typedListener);
    return;
  }
  public static function checkStyle__I(style: int): int {
    return style & ~256;
  }
  public override function checkSubclass__(): void {
    if (!this.isValidSubclass__())
      this.error__I(43);
  }
  public override function computeSize__IIZ(wHint: int, hHint: int, changed: Boolean): Point {
    this.checkWidget__();
    var height_1: int = 0;
    var width_1: int = 0;
    if (wHint == -1 || hHint == -1) {
      if (itemCount > 0) {
        height_1 += spacing;
        var gc: GC = new GC(new Arguments(org.eclipse.swt.graphics.GC.GC__Lorg_eclipse_swt_graphics_Drawable_2, [this]));
        for (var i: int = 0; i < itemCount; i++) {
          var item: ExpandItem = items[i];
          height_1 += item.getHeaderHeight__();
          if (item.expanded)
            height_1 += item.height;
          height_1 += spacing;
          width_1 = Math__.max__II(width_1, item.getPreferredWidth__Lorg_eclipse_swt_graphics_GC_2(gc));
        }
        gc.dispose__();
      }
    }
    if (width_1 == 0)
      width_1 = 64;
    if (height_1 == 0)
      height_1 = 64;
    if (wHint != -1)
      width_1 = wHint;
    if (hHint != -1)
      height_1 = hHint;
    var trim: Rectangle = this.computeTrim__IIII(0, 0, width_1, height_1);
    return new Point(trim.width, trim.height);
  }
  public function createItem__Lorg_eclipse_swt_widgets_ExpandItem_2II(item: ExpandItem, style_1: int, index: int): void {
    if (!(0 <= index && index <= itemCount))
      this.error__I(6);
    if (itemCount == items.length) {
      var newItems: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/ExpandItem;").lengths(itemCount + 4);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(items, 0, newItems, 0, items.length);
      items = newItems;
    }
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(items, index, items, index + 1, itemCount - index);
    items[index] = item;
    itemCount++;
    if (focusItem === null)
      focusItem = item;
    item.width = Math__.max__II(0, this.getClientArea__().width - spacing * 2);
    this.layoutItems__IZ(index, true);
    return;
  }
  public function destroyItem__Lorg_eclipse_swt_widgets_ExpandItem_2(item: ExpandItem): void {
    if (inDispose)
      return;
    var index: int = 0;
    while (index < itemCount) {
      if (items[index] === item)
        break;
      index++;
    }
    if (index == itemCount)
      return;
    if (item === focusItem) {
      var focusIndex: int = index > 0 ? index - 1 : 1;
      if (focusIndex < itemCount) {
        focusItem = items[focusIndex];
        focusItem.redraw__();
      } else {
        focusItem = null;
      }
    }
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(items, index + 1, items, index, --itemCount - index);
    items[itemCount] = null;
    item.redraw__();
    this.layoutItems__IZ(index, true);
    return;
  }
  public function getBandHeight__(): int {
    if (font_org_eclipse_swt_widgets_ExpandBar === null)
      return 24;
    var gc: GC = new GC(new Arguments(org.eclipse.swt.graphics.GC.GC__Lorg_eclipse_swt_graphics_Drawable_2, [this]));
    var metrics: FontMetrics = gc.getFontMetrics__();
    gc.dispose__();
    return Math__.max__II(24, metrics.getHeight__());
  }
  public override function getForeground__(): Color {
    this.checkWidget__();
    if (foreground_org_eclipse_swt_widgets_ExpandBar === null) {
      var display_1: Display = this.getDisplay__();
      return display_1.getSystemColor__I(30);
    }
    return foreground_org_eclipse_swt_widgets_ExpandBar;
  }
  public function getItem__I(index: int): ExpandItem {
    this.checkWidget__();
    if (!(0 <= index && index < itemCount))
      this.error__I(6);
    return items[index];
  }
  public function getItemCount__(): int {
    this.checkWidget__();
    return itemCount;
  }
  public function getItems__(): JavaArray {
    this.checkWidget__();
    var result: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/ExpandItem;").lengths(itemCount);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(items, 0, result, 0, itemCount);
    return result;
  }
  public function getSpacing__(): int {
    this.checkWidget__();
    return spacing;
  }
  public function indexOf__Lorg_eclipse_swt_widgets_ExpandItem_2(item: ExpandItem): int {
    this.checkWidget__();
    if (item === null)
      this.error__I(4);
    for (var i: int = 0; i < itemCount; i++) {
      if (items[i] === item)
        return i;
    }
    return -1;
  }
  public function layoutItems__IZ(index: int, setScrollbar: Boolean): void {
    if (index < itemCount) {
      var y_1: int = spacing - yCurrentScroll;
      for (var i: int = 0; i < index; i++) {
        var item: ExpandItem = items[i];
        if (item.expanded)
          y_1 += item.height;
        y_1 += item.getHeaderHeight__() + spacing;
      }
      for (var i_1: int = index; i_1 < itemCount; i_1++) {
        var item_1: ExpandItem = items[i_1];
        item_1.setBounds__IIIIZZ(spacing, y_1, 0, 0, true, false);
        if (item_1.expanded)
          y_1 += item_1.height;
        y_1 += item_1.getHeaderHeight__() + spacing;
      }
    }
    if (setScrollbar)
      this.setScrollbar__();
    return;
  }
  public function removeExpandListener__Lorg_eclipse_swt_events_ExpandListener_2(listener_1: ExpandListener): void {
    this.checkWidget__();
    if (listener_1 === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(17, listener_1);
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(18, listener_1);
  }
  public override function setFont__Lorg_eclipse_swt_graphics_Font_2(font_1: Font): void {
    super.setFont__Lorg_eclipse_swt_graphics_Font_2(font_1);
    this.font_org_eclipse_swt_widgets_ExpandBar = font_1;
    this.layoutItems__IZ(0, true);
  }
  public override function setForeground__Lorg_eclipse_swt_graphics_Color_2(color: Color): void {
    super.setForeground__Lorg_eclipse_swt_graphics_Color_2(color);
    foreground_org_eclipse_swt_widgets_ExpandBar = color;
  }
  public function setScrollbar__(): void {
    if (itemCount == 0)
      return;
    var verticalBar_1: ScrollBar = this.getVerticalBar__();
    if (verticalBar_1 === null)
      return;
    var height_1: int = this.getClientArea__().height;
    var item: ExpandItem = items[itemCount - 1];
    var maxHeight: int = item.y + this.getBandHeight__() + spacing;
    if (item.expanded)
      maxHeight += item.height;
    if (yCurrentScroll > 0 && height_1 > maxHeight) {
      yCurrentScroll = Math__.max__II(0, yCurrentScroll + maxHeight - height_1);
      this.layoutItems__IZ(0, false);
    }
    maxHeight += yCurrentScroll;
    var selection: int = Math__.min__II(yCurrentScroll, maxHeight);
    var increment: int = verticalBar_1.getIncrement__();
    var pageIncrement: int = verticalBar_1.getPageIncrement__();
    verticalBar_1.setValues__IIIIII(selection, 0, maxHeight, height_1, increment, pageIncrement);
    verticalBar_1.setVisible__Z(maxHeight > height_1);
    return;
  }
  public function setSpacing__I(spacing_1: int): void {
    this.checkWidget__();
    if (spacing_1 < 0)
      return;
    if (spacing_1 == this.spacing)
      return;
    this.spacing = spacing_1;
    var width_1: int = Math__.max__II(0, this.getClientArea__().width - spacing_1 * 2);
    for (var i: int = 0; i < itemCount; i++) {
      var item: ExpandItem = items[i];
      if (item.width != width_1)
        item.setBounds__IIIIZZ(0, 0, width_1, item.height, false, true);
    }
    this.layoutItems__IZ(0, true);
    this.redraw__();
    return;
  }
  public function showItem__Lorg_eclipse_swt_widgets_ExpandItem_2(item: ExpandItem): void {
    var control: Control = item.control;
    if (control !== null && !control.isDisposed__()) {
      control.setVisible__Z(item.expanded);
    }
    item.redraw__();
    var index: int = this.indexOf__Lorg_eclipse_swt_widgets_ExpandItem_2(item);
    this.layoutItems__IZ(index + 1, true);
    return;
  }
  public function onDispose__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    this.removeListener__ILorg_eclipse_swt_widgets_Listener_2(12, listener);
    this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(12, event);
    event.type = 0;
    inDispose = true;
    for (var i: int = 0; i < itemCount; i++) {
      items[i].dispose__();
    }
    items = null;
    font_org_eclipse_swt_widgets_ExpandBar = null;
    foreground_org_eclipse_swt_widgets_ExpandBar = null;
    focusItem = null;
    return;
  }
  public function onFocus__(): void {
    if (focusItem !== null)
      focusItem.redraw__();
    return;
  }
  public function onKeyDown__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    if (focusItem === null)
      return;
    switch (event.keyCode) {
      case 13 :
      case 32 :
        var ev: Event = new Event();
        ev.item = focusItem;
        this.sendEvent__ILorg_eclipse_swt_widgets_Event_2(focusItem.expanded ? 18 : 17, ev);
        focusItem.expanded = !focusItem.expanded;
        this.showItem__Lorg_eclipse_swt_widgets_ExpandItem_2(focusItem);
        break;
      case 16777217 :
        {
          var focusIndex: int = this.indexOf__Lorg_eclipse_swt_widgets_ExpandItem_2(focusItem);
          if (focusIndex > 0) {
            focusItem.redraw__();
            focusItem = items[focusIndex - 1];
            focusItem.redraw__();
          }
          break;
        }
      case 16777218 :
        {
          var focusIndex_1: int = this.indexOf__Lorg_eclipse_swt_widgets_ExpandItem_2(focusItem);
          if (focusIndex_1 < itemCount - 1) {
            focusItem.redraw__();
            focusItem = items[focusIndex_1 + 1];
            focusItem.redraw__();
          }
          break;
        }
    }
    return;
  }
  public function onMouseDown__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    if (event.button != 1)
      return;
    var x_1: int = event.x;
    var y_1: int = event.y;
    for (var i: int = 0; i < itemCount; i++) {
      var item: ExpandItem = items[i];
      var hover: Boolean = item.x <= x_1 && x_1 < (item.x + item.width) && item.y <= y_1 && y_1 < (item.y + this.getBandHeight__());
      if (hover && item !== focusItem) {
        focusItem.redraw__();
        focusItem = item;
        focusItem.redraw__();
        this.forceFocus__();
        break;
      }
    }
    return;
  }
  public function onMouseUp__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    if (event.button != 1)
      return;
    if (focusItem === null)
      return;
    var x_1: int = event.x;
    var y_1: int = event.y;
    var hover: Boolean = focusItem.x <= x_1 && x_1 < (focusItem.x + focusItem.width) && focusItem.y <= y_1 && y_1 < (focusItem.y + this.getBandHeight__());
    if (hover) {
      var ev: Event = new Event();
      ev.item = focusItem;
      this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(focusItem.expanded ? 18 : 17, ev);
      focusItem.expanded = !focusItem.expanded;
      this.showItem__Lorg_eclipse_swt_widgets_ExpandItem_2(focusItem);
    }
    return;
  }
  public function onPaint__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    var hasFocus: Boolean = this.isFocusControl__();
    for (var i: int = 0; i < itemCount; i++) {
      var item: ExpandItem = items[i];
      item.drawItem__Lorg_eclipse_swt_graphics_GC_2Z(event.gc, hasFocus && item === focusItem);
    }
    return;
  }
  public function onResize__(): void {
    var rect: Rectangle = this.getClientArea__();
    var width_1: int = Math__.max__II(0, rect.width - spacing * 2);
    for (var i: int = 0; i < itemCount; i++) {
      var item: ExpandItem = items[i];
      item.setBounds__IIIIZZ(0, 0, width_1, item.height, false, true);
    }
    this.setScrollbar__();
    return;
  }
  public function onScroll__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    var verticalBar_1: ScrollBar = this.getVerticalBar__();
    if (verticalBar_1 !== null) {
      yCurrentScroll = verticalBar_1.getSelection__();
      this.layoutItems__IZ(0, false);
    }
    return;
  }
  public function onTraverse__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    switch (event.detail) {
      case 16 :
      case 8 :
        event.doit = true;
        break;
    }
    return;
  }
}
}
