package org.eclipse.swt.widgets {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import java.lang.Math__;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class ExpandItem extends Item {
  internal var parent: ExpandBar;
  internal var control: Control;
  internal var expanded: Boolean;
  internal var x: int;
  internal var y: int;
  internal var width: int;
  internal var height: int;
  internal var imageHeight: int;
  internal var imageWidth: int;
  public static const TEXT_INSET: int = 6;
  public static const BORDER: int = 1;
  public static const CHEVRON_SIZE: int = 24;
  public function ExpandItem__Lorg_eclipse_swt_widgets_ExpandBar_2I(parent: ExpandBar, style: int): Object {
    return this;
  }
  public function ExpandItem__Lorg_eclipse_swt_widgets_ExpandBar_2II(parent: ExpandBar, style: int, index: int): Object {
    this.parent = parent;
    parent.createItem__Lorg_eclipse_swt_widgets_ExpandItem_2II(this, style, index);
    return this;
  }
  public static function checkNull__Lorg_eclipse_swt_widgets_ExpandBar_2(control: ExpandBar): ExpandBar {
    if (control === null)
      SWT.error__I(4);
    return control;
  }
  public override function dispose__(): void {
    if (this.isDisposed__())
      return;
    parent.destroyItem__Lorg_eclipse_swt_widgets_ExpandItem_2(this);
    super.dispose__();
    parent = null;
    control = null;
  }
  public function drawChevron__Lorg_eclipse_swt_graphics_GC_2II(gc: GC, x_1: int, y_1: int): void {
    var polyline1: JavaArray;
    var polyline2: JavaArray;
    if (expanded) {
      var px: int = x_1 + 4 + 5;
      var py: int = y_1 + 4 + 7;
      polyline1 = new JavaArray("[I").values(px, py, px + 1, py, px + 1, py - 1, px + 2, py - 1, px + 2, py - 2, px + 3, py - 2, px + 3, py - 3, px + 3, py - 2, px + 4, py - 2, px + 4, py - 1, px + 5, py - 1, px + 5, py, px + 6, py);
      py += 4;
      polyline2 = new JavaArray("[I").values(px, py, px + 1, py, px + 1, py - 1, px + 2, py - 1, px + 2, py - 2, px + 3, py - 2, px + 3, py - 3, px + 3, py - 2, px + 4, py - 2, px + 4, py - 1, px + 5, py - 1, px + 5, py, px + 6, py);
    } else {
      var px_1: int = x_1 + 4 + 5;
      var py_1: int = y_1 + 4 + 4;
      polyline1 = new JavaArray("[I").values(px_1, py_1, px_1 + 1, py_1, px_1 + 1, py_1 + 1, px_1 + 2, py_1 + 1, px_1 + 2, py_1 + 2, px_1 + 3, py_1 + 2, px_1 + 3, py_1 + 3, px_1 + 3, py_1 + 2, px_1 + 4, py_1 + 2, px_1 + 4, py_1 + 1, px_1 + 5, py_1 + 1, px_1 + 5, py_1, px_1 + 6, py_1);
      py_1 += 4;
      polyline2 = new JavaArray("[I").values(px_1, py_1, px_1 + 1, py_1, px_1 + 1, py_1 + 1, px_1 + 2, py_1 + 1, px_1 + 2, py_1 + 2, px_1 + 3, py_1 + 2, px_1 + 3, py_1 + 3, px_1 + 3, py_1 + 2, px_1 + 4, py_1 + 2, px_1 + 4, py_1 + 1, px_1 + 5, py_1 + 1, px_1 + 5, py_1, px_1 + 6, py_1);
    }
    gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(display.getSystemColor__I(30));
    gc.drawPolyline___3I(polyline1);
    gc.drawPolyline___3I(polyline2);
    return;
  }
  public function drawItem__Lorg_eclipse_swt_graphics_GC_2Z(gc: GC, drawFocus: Boolean): void {
    var headerHeight: int = parent.getBandHeight__();
    var display_1: Display = this.getDisplay__();
    gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(display_1.getSystemColor__I(31));
    gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(display_1.getSystemColor__I(32));
    gc.fillGradientRectangle__IIIIZ(x, y, width, headerHeight, true);
    if (expanded) {
      gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(display_1.getSystemColor__I(32));
      gc.drawLine__IIII(x, y + headerHeight, x, y + headerHeight + height - 1);
      gc.drawLine__IIII(x, y + headerHeight + height - 1, x + width - 1, y + headerHeight + height - 1);
      gc.drawLine__IIII(x + width - 1, y + headerHeight + height - 1, x + width - 1, y + headerHeight);
    }
    var drawX: int = x;
    if (image !== null) {
      drawX += 6;
      if (imageHeight > headerHeight) {
        gc.drawImage__Lorg_eclipse_swt_graphics_Image_2II(image, drawX, y + headerHeight - imageHeight);
      } else {
        gc.drawImage__Lorg_eclipse_swt_graphics_Image_2II(image, drawX, y + int((headerHeight - imageHeight) / 2));
      }
      drawX += imageWidth;
    }
    if (Object(text).length__() > 0) {
      drawX += 6;
      var size: Point = gc.stringExtent__Ljava_lang_String_2(text);
      gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(parent.getForeground__());
      gc.drawString__Ljava_lang_String_2IIZ(text, drawX, y + int((headerHeight - size.y) / 2), true);
    }
    var chevronSize: int = 24;
    this.drawChevron__Lorg_eclipse_swt_graphics_GC_2II(gc, x + width - chevronSize, y + int((headerHeight - chevronSize) / 2));
    if (drawFocus) {
      gc.drawFocus__IIII(x + 1, y + 1, width - 2, headerHeight - 2);
    }
    return;
  }
  public function getControl__(): Control {
    this.checkWidget__();
    return control;
  }
  public function getExpanded__(): Boolean {
    this.checkWidget__();
    return expanded;
  }
  public function getHeaderHeight__(): int {
    this.checkWidget__();
    return Math__.max__II(parent.getBandHeight__(), imageHeight);
  }
  public function getHeight__(): int {
    this.checkWidget__();
    return height;
  }
  public function getParent__(): ExpandBar {
    this.checkWidget__();
    return parent;
  }
  public function getPreferredWidth__Lorg_eclipse_swt_graphics_GC_2(gc: GC): int {
    var width_1: int = 6 * 2 + 24;
    if (image !== null) {
      width_1 += 6 + imageWidth;
    }
    if (Object(text).length__() > 0) {
      width_1 += gc.stringExtent__Ljava_lang_String_2(text).x;
    }
    return width_1;
  }
  public function redraw__(): void {
    var headerHeight: int = parent.getBandHeight__();
    if (imageHeight > headerHeight) {
      parent.redraw__IIIIZ(x + 6, y + headerHeight - imageHeight, imageWidth, imageHeight, false);
    }
    parent.redraw__IIIIZ(x, y, width, headerHeight + height, false);
    return;
  }
  public function setBounds__IIIIZZ(x_1: int, y_1: int, width_1: int, height_1: int, move: Boolean, size: Boolean): void {
    this.redraw__();
    var headerHeight: int = parent.getBandHeight__();
    if (move) {
      if (imageHeight > headerHeight) {
        y_1 += (imageHeight - headerHeight);
      }
      this.x = x_1;
      this.y = y_1;
      this.redraw__();
    }
    if (size) {
      this.width = width_1;
      this.height = height_1;
      this.redraw__();
    }
    if (control !== null && !control.isDisposed__()) {
      if (move)
        control.setLocation__II(x_1 + 1, y_1 + headerHeight);
      if (size)
        control.setSize__II(Math__.max__II(0, width_1 - 2 * 1), Math__.max__II(0, height_1 - 1));
    }
    return;
  }
  public function setControl__Lorg_eclipse_swt_widgets_Control_2(control_1: Control): void {
    this.checkWidget__();
    if (control_1 !== null) {
      if (control_1.isDisposed__())
        this.error__I(5);
      if (control_1.parent !== parent)
        this.error__I(32);
    }
    this.control = control_1;
    if (control_1 !== null) {
      control_1.setVisible__Z(expanded);
      var headerHeight: int = parent.getBandHeight__();
      control_1.setBounds__IIII(x + 1, y + headerHeight, Math__.max__II(0, width - 2 * 1), Math__.max__II(0, height - 1));
    }
    return;
  }
  public function setExpanded__Z(expanded_1: Boolean): void {
    this.checkWidget__();
    this.expanded = expanded_1;
    parent.showItem__Lorg_eclipse_swt_widgets_ExpandItem_2(this);
    return;
  }
  public override function setImage__Lorg_eclipse_swt_graphics_Image_2(image_1: Image): void {
    super.setImage__Lorg_eclipse_swt_graphics_Image_2(image_1);
    var oldImageHeight: int = imageHeight;
    if (image_1 !== null) {
      var bounds: Rectangle = image_1.getBounds__();
      imageHeight = bounds.height;
      imageWidth = bounds.width;
    } else {
      imageHeight = imageWidth = 0;
    }
    if (oldImageHeight != imageHeight) {
      parent.layoutItems__IZ(parent.indexOf__Lorg_eclipse_swt_widgets_ExpandItem_2(this), true);
    } else {
      this.redraw__();
    }
    return;
  }
  public function setHeight__I(height_1: int): void {
    this.checkWidget__();
    if (height_1 < 0)
      return;
    this.setBounds__IIIIZZ(0, 0, width, height_1, false, true);
    if (expanded)
      parent.layoutItems__IZ(parent.indexOf__Lorg_eclipse_swt_widgets_ExpandItem_2(this) + 1, true);
  }
  public override function setText__Ljava_lang_String_2(string: String): void {
    super.setText__Ljava_lang_String_2(string);
    this.redraw__();
  }
  public function ExpandItem(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 2 && vargs[0] is ExpandBar && vargs[1] is int) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 3 && vargs[0] is ExpandBar && vargs[1] is int && vargs[2] is int) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0], args[1]];
        args1 = [args0[0], args0[1], ExpandItem.checkNull__Lorg_eclipse_swt_widgets_ExpandBar_2(args0[0]).getItemCount__()];
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.swt.widgets.Item.Item__Lorg_eclipse_swt_widgets_Widget_2I, [args1[0], args1[1]]);
        break;
      case 1:
        var args1: Array = [args[0], args[1], args[2]];
        superArgs = new Arguments(org.eclipse.swt.widgets.Item.Item__Lorg_eclipse_swt_widgets_Widget_2I, [args1[0], args1[1]]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        ExpandItem__Lorg_eclipse_swt_widgets_ExpandBar_2II(args1[0], args1[1], args1[2]);
        ExpandItem__Lorg_eclipse_swt_widgets_ExpandBar_2I(args0[0], args0[1]);
        break;
      case 1:
        ExpandItem__Lorg_eclipse_swt_widgets_ExpandBar_2II(args1[0], args1[1], args1[2]);
        break;
    }
  }
  public static const ExpandItem__Lorg_eclipse_swt_widgets_ExpandBar_2I : int = 0;
  public static const ExpandItem__Lorg_eclipse_swt_widgets_ExpandBar_2II : int = 1;
}
}
