package org.eclipse.swt.widgets {
import mx.containers.VBox;
import mx.controls.Label;
import mx.core.Container;
import mx.core.EdgeMetrics;
import mx.core.ScrollPolicy;
import mx.core.UIComponent;
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.SWT;
import java.lang.Math__;
import mx.containers.Canvas;
import java.lang.Arguments;
dynamic public class Group extends Composite {
  internal var text: String = "";
  internal var boxComponent: VBox;
  internal var labelComponent: mx.controls.Label;
  public static const INDENT: int = 5;
  public function Group(parent: Composite, style: int) {
    super(new Arguments(org.eclipse.swt.widgets.Composite.Composite__Lorg_eclipse_swt_widgets_Composite_2I, [parent, Group.checkStyle__I(style)]));
    return;
  }
  public static function checkStyle__I(style: int): int {
    style |= 524288;
    return style & ~(256 | 512);
  }
  public override function checkSubclass__(): void {
    if (!this.isValidSubclass__())
      this.error__I(43);
  }
  public override function computeSize__IIZ(wHint: int, hHint: int, changed: Boolean): Point {
    var size: Point = super.computeSize__IIZ(wHint, hHint, changed);
    if (labelComponent.visible) {
      size.x = Math__.max__II(size.x, int(labelComponent.width) + 5 * 2);
    }
    return size;
  }
  public override function computeTrim__IIII(x_1: int, y_1: int, width_1: int, height_1: int): Rectangle {
    var trim: Rectangle = super.computeTrim__IIII(x_1, y_1, width_1, height_1);
    trim.y -= labelComponent.measuredHeight;
    trim.height += labelComponent.measuredHeight;
    trim.width = Math__.max__II(trim.width, int(labelComponent.width) + 5 * 2);
    return trim;
  }
  public override function createHandle__(): void {
    var boxWidget: VBox = new VBox();
    boxWidget.horizontalScrollPolicy = boxWidget.verticalScrollPolicy = ScrollPolicy.OFF;
    boxWidget.setStyle("verticalGap", 0);
    var labelWidget: mx.controls.Label = new mx.controls.Label();
    labelWidget.setStyle("paddingLeft", 5);
    labelWidget.setStyle("fontWeight", "bold");
    labelWidget.visible = false;
    labelWidget.includeInLayout = false;
    var widget: mx.containers.Canvas = new mx.containers.Canvas();
    widget.horizontalScrollPolicy = widget.verticalScrollPolicy = ScrollPolicy.OFF;
    widget.percentWidth = widget.percentHeight = 100;
    widget.setStyle("borderStyle", "solid");
    boxWidget.addChild(labelWidget);
    boxWidget.addChild(widget);
    boxComponent = boxWidget;
    labelComponent = labelWidget;
    object = widget;
  }
  public override function getClientArea__(): Rectangle {
    this.checkWidget__();
    var width_1: Number = boxComponent.width;
    var height_1: Number = boxComponent.height;
    var view: EdgeMetrics = (Container(object)).viewMetrics;
    width_1 -= (view.left + view.right);
    height_1 -= (view.top + view.bottom);
    if (labelComponent.visible) {
      height_1 -= labelComponent.measuredHeight;
    }
    return new Rectangle(0, 0, int(width_1), int(height_1));
  }
  public override function getNameText__(): String {
    return this.getText__();
  }
  public function getText__(): String {
    this.checkWidget__();
    return text;
  }
  public override function releaseWidget__(): void {
    super.releaseWidget__();
    text = null;
  }
  public function setText__Ljava_lang_String_2(string: String): void {
    this.checkWidget__();
    if (string === null)
      this.error__I(4);
    text = string;
    labelComponent.text = string;
    var visible: Boolean = Object(text).length__() > 0;
    labelComponent.visible = visible;
    labelComponent.includeInLayout = visible;
  }
  public override function topComponent__(): UIComponent {
    return boxComponent;
  }
}
}
