package org.eclipse.swt.widgets {
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.graphics.TextStyle;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class IME extends Widget {
  internal var parent: Canvas;
  internal var caretOffset: int;
  internal var startOffset: int;
  internal var commitCount: int;
  internal var text: String;
  internal var ranges: JavaArray;
  internal var styles: JavaArray;
  public function IME__(): Object {
    return this;
  }
  public function IME__Lorg_eclipse_swt_widgets_Canvas_2I(parent: Canvas, style: int): Object {
    this.parent = parent;
    this.createWidget__();
    return this;
  }
  public override function createWidget__(): void {
    text = "";
    startOffset = -1;
    if (parent.getIME__() === null) {
      parent.setIME__Lorg_eclipse_swt_widgets_IME_2(this);
    }
    return;
  }
  public function getCaretOffset__(): int {
    this.checkWidget__();
    return startOffset + caretOffset;
  }
  public function getCommitCount__(): int {
    this.checkWidget__();
    return commitCount;
  }
  public function getCompositionOffset__(): int {
    this.checkWidget__();
    return startOffset;
  }
  public function getRanges__(): JavaArray {
    this.checkWidget__();
    return ranges !== null ? ranges : new JavaArray("[I").lengths(0);
  }
  public function getStyles__(): JavaArray {
    this.checkWidget__();
    return styles !== null ? styles : new JavaArray("[Lorg/eclipse/swt/graphics/TextStyle;").lengths(0);
  }
  public function getText__(): String {
    this.checkWidget__();
    return text;
  }
  public function getWideCaret__(): Boolean {
    return false;
  }
  public override function releaseParent__(): void {
    super.releaseParent__();
    if (this === parent.getIME__())
      parent.setIME__Lorg_eclipse_swt_widgets_IME_2(null);
  }
  public override function releaseWidget__(): void {
    super.releaseWidget__();
    parent = null;
    text = null;
    styles = null;
    ranges = null;
  }
  public function setCompositionOffset__I(offset: int): void {
    this.checkWidget__();
    if (offset < 0)
      return;
    if (startOffset != -1) {
      startOffset = offset;
    }
    return;
  }
  public function IME(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 2 && vargs[0] is Canvas && vargs[1] is int) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.swt.widgets.Widget.Widget__, []);
        break;
      case 1:
        var args1: Array = [args[0], args[1]];
        superArgs = new Arguments(org.eclipse.swt.widgets.Widget.Widget__Lorg_eclipse_swt_widgets_Widget_2I, [args1[0], args1[1]]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        IME__();
        break;
      case 1:
        IME__Lorg_eclipse_swt_widgets_Canvas_2I(args1[0], args1[1]);
        break;
    }
  }
  public static const IME__ : int = 0;
  public static const IME__Lorg_eclipse_swt_widgets_Canvas_2I : int = 1;
}
}
