package org.eclipse.swt.widgets {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.Point;
import flash.display.Bitmap;
import flash.events.IEventDispatcher;
import mx.core.*;
import mx.controls.*;
import mx.containers.*;
import org.eclipse.swt.graphics.Image;
import mx.core.UIComponent;
import org.eclipse.swt.SWT;
import mx.controls.VRule;
import mx.controls.HRule;
import mx.containers.HBox;
import mx.controls.Label;
import mx.controls.Image;
import mx.core.ScrollPolicy;
import flash.events.Event;
import java.lang.Arguments;
dynamic public class Label extends Control {
  internal var text: String = "";
  internal var image: org.eclipse.swt.graphics.Image;
  internal var labelObject: UIComponent;
  internal var imageObject: UIComponent;
  public function Label(parent: Composite, style: int) {
    super(new Arguments(org.eclipse.swt.widgets.Control.Control__Lorg_eclipse_swt_widgets_Composite_2I, [parent, org.eclipse.swt.widgets.Label.checkStyle__I(style)]));
    return;
  }
  public override function computeSize__IIZ(wHint: int, hHint: int, changed: Boolean): Point {
    this.checkWidget__();
    if ((style & 2) != 0) {
      return this.computeNativeSize__Lmx_core_UIComponent_2IIZ(object, wHint, hHint, changed);
    }
    var widget: UIComponent = labelObject.includeInLayout ? labelObject : imageObject;
    widget.validateProperties();
    widget.validateSize();
    var width_1: int = wHint == -1 ? int(widget.measuredWidth) : wHint;
    var height_1: int = hHint == -1 ? int(widget.measuredHeight) : hHint;
    return new Point(width_1, height_1);
  }
  public override function createHandle__(): void {
    if ((style & 2) != 0) {
      if ((style & 512) != 0) {
        object = new VRule();
      } else {
        object = new HRule();
      }
    } else {
      var widget: HBox = new HBox();
      var labelWidget: mx.controls.Label = new mx.controls.Label();
      labelWidget.percentHeight = labelWidget.percentWidth = 100;
      labelObject = labelWidget;
      var imageWidget: mx.controls.Image = new mx.controls.Image();
      imageWidget.scaleContent = false;
      imageWidget.visible = false;
      imageWidget.includeInLayout = false;
      imageWidget.percentHeight = imageWidget.percentWidth = 100;
      imageObject = imageWidget;
      widget.horizontalScrollPolicy = ScrollPolicy.OFF;
      widget.verticalScrollPolicy = ScrollPolicy.OFF;
      widget.addChild(imageObject);
      widget.addChild(labelObject);
      object = widget;
      this.setAlignment__I(style);
    }
    return;
  }
  public function getAlignment__(): int {
    this.checkWidget__();
    if ((style & 2) != 0)
      return 0;
    if ((style & 16384) != 0)
      return 16384;
    if ((style & 16777216) != 0)
      return 16777216;
    if ((style & 131072) != 0)
      return 131072;
    return 16384;
  }
  public function getImage__(): org.eclipse.swt.graphics.Image {
    this.checkWidget__();
    return image;
  }
  public override function getNameText__(): String {
    return this.getText__();
  }
  public function getText__(): String {
    this.checkWidget__();
    return text;
  }
  public function setAlignment__I(alignment: int): void {
    this.checkWidget__();
    if ((style & 2) != 0)
      return;
    if ((alignment & (16384 | 131072 | 16777216)) == 0)
      return;
    style &= ~(16384 | 131072 | 16777216);
    style |= alignment & (16384 | 131072 | 16777216);
    imageObject.setStyle("verticalAlign", "middle");
    if ((alignment & 131072) != 0) {
      labelObject.setStyle("textAlign", "right");
      imageObject.setStyle("horizontalAlign", "right");
    } else if ((alignment & 16777216) != 0) {
      labelObject.setStyle("textAlign", "center");
      imageObject.setStyle("horizontalAlign", "center");
    } else {
      labelObject.setStyle("textAlign", "left");
      imageObject.setStyle("horizontalAlign", "left");
    }
    return;
  }
  public function setImage__Lorg_eclipse_swt_graphics_Image_2(image_1: org.eclipse.swt.graphics.Image): void {
    this.checkWidget__();
    if (image_1 !== null && image_1.isDisposed__())
      this.error__I(5);
    if ((style & 2) != 0)
      return;
    var oldImage: org.eclipse.swt.graphics.Image = this.image;
    if (oldImage === image_1)
      return;
    this.image = image_1;
    if (image_1 !== null) {
      if (image_1.object !== null) {
        (mx.controls.Image(imageObject)).source = new Bitmap(image_1.object);
      } else {
        image_1.listener.addEventListener(flash.events.Event.COMPLETE, this.completeHandlerFunction__());
      }
    } else {
      (mx.controls.Image(imageObject)).source = null;
    }
    labelObject.visible = image_1 === null;
    imageObject.visible = image_1 !== null;
    labelObject.includeInLayout = image_1 === null;
    imageObject.includeInLayout = image_1 !== null;
    return;
  }
  public static function checkStyle__I(style: int): int {
    style |= 524288;
    if ((style & 2) != 0) {
      style = Widget.checkBits__IIIIIII(style, 512, 256, 0, 0, 0, 0);
      return Widget.checkBits__IIIIIII(style, 8, 4, 32, 0, 0, 0);
    }
    return Widget.checkBits__IIIIIII(style, 16384, 16777216, 131072, 0, 0, 0);
  }
  public function completeHandler__Lflash_events_Event_2(event: flash.events.Event): void {
    if (image !== null)
      (mx.controls.Image(imageObject)).source = new Bitmap(image.object);
    (IEventDispatcher(event.target)).removeEventListener(flash.events.Event.COMPLETE, this.completeHandlerFunction__());
  }
  public function completeHandlerFunction__(): Function {
    return completeHandler__Lflash_events_Event_2;
  }
  public function setText__Ljava_lang_String_2(string: String): void {
    this.checkWidget__();
    if (string === null)
      this.error__I(4);
    if ((style & 2) != 0)
      return;
    text = string;
    (mx.controls.Label(labelObject)).text = this.fixMnemonic__Ljava_lang_String_2(string);
    labelObject.visible = true;
    imageObject.visible = false;
    labelObject.includeInLayout = true;
    imageObject.includeInLayout = false;
  }
}
}
