package org.eclipse.swt.widgets {
import org.eclipse.swt.*;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.SWT;
import mx.controls.Text;
import flash.events.TextEvent;
import java.lang.StringBuffer;
import java.lang.Character;
import java.lang.System;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class Link extends Control {
  internal var offsets: JavaArray;
  internal var ids: JavaArray;
  internal var mnemonics: JavaArray;
  internal var text: String = "";
  public function Link(parent: Composite, style: int) {
    super(new Arguments(org.eclipse.swt.widgets.Control.Control__Lorg_eclipse_swt_widgets_Composite_2I, [parent, style]));
    return;
  }
  public function addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener: SelectionListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(14, typedListener);
    return;
  }
  public override function createHandle__(): void {
    var widget: mx.controls.Text = new mx.controls.Text();
    object = widget;
    return;
  }
  public function getText__(): String {
    this.checkWidget__();
    return text;
  }
  public override function hookEvents__(): void {
    super.hookEvents__();
    object.addEventListener(flash.events.TextEvent.LINK, this.linkHandlerFunction__());
  }
  public function linkHandler__Lflash_events_TextEvent_2(event: TextEvent): void {
    this.sendSelection__Ljava_lang_String_2(event.text);
  }
  public function linkHandlerFunction__(): Function {
    return linkHandler__Lflash_events_TextEvent_2;
  }
  public function parse__Ljava_lang_String_2(string: String): String {
    var length: int = Object(string).length__();
    offsets = new JavaArray("[Lorg/eclipse/swt/graphics/Point;").lengths(int(length / 4));
    ids = new JavaArray("[Ljava/lang/String;").lengths(int(length / 4));
    mnemonics = new JavaArray("[I").lengths(int(length / 4) + 1);
    var result: StringBuffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__, []));
    var buffer: JavaArray = new JavaArray("[C").lengths(length);
    Object(string).getChars__II_3CI(0, Object(string).length__(), buffer, 0);
    var index: int = 0;
    var state_1: int = 0;
    var linkIndex: int = 0;
    var start: int = 0;
    var tagStart: int = 0;
    var linkStart: int = 0;
    var endtagStart: int = 0;
    var refStart: int = 0;
    while (index < length) {
      var c: uint = Character.toLowerCase__C(buffer[index]);
      switch (state_1) {
        case 0 :
          if (c == 60) {
            tagStart = index;
            state_1++;
          }
          break;
        case 1 :
          if (c == 97)
            state_1++;
          break;
        case 2 :
          switch (c) {
            case 104 :
              state_1 = 7;
              break;
            case 62 :
              linkStart = index + 1;
              state_1++;
              break;
            default :
              if (Character.isWhitespace__C(c))
                break;
              else
                state_1 = 13;
          }
          break;
        case 3 :
          if (c == 60) {
            endtagStart = index;
            state_1++;
          }
          break;
        case 4 :
          state_1 = c == 47 ? state_1 + 1 : 3;
          break;
        case 5 :
          state_1 = c == 97 ? state_1 + 1 : 3;
          break;
        case 6 :
          if (c == 62) {
            mnemonics[linkIndex] = this.parseMnemonics___3CIILjava_lang_StringBuffer_2(buffer, start, tagStart, result);
            var offset: int = result.length__();
            this.parseMnemonics___3CIILjava_lang_StringBuffer_2(buffer, linkStart, endtagStart, result);
            offsets[linkIndex] = new Point(offset, result.length__() - 1);
            if (ids[linkIndex] === null) {
              ids[linkIndex] = Object(String).__init___3CII(buffer, linkStart, endtagStart - linkStart);
            }
            linkIndex++;
            start = tagStart = linkStart = endtagStart = refStart = index + 1;
            state_1 = 0;
          } else {
            state_1 = 3;
          }
          break;
        case 7 :
          state_1 = c == 114 ? state_1 + 1 : 0;
          break;
        case 8 :
          state_1 = c == 101 ? state_1 + 1 : 0;
          break;
        case 9 :
          state_1 = c == 102 ? state_1 + 1 : 0;
          break;
        case 10 :
          state_1 = c == 61 ? state_1 + 1 : 0;
          break;
        case 11 :
          if (c == 34) {
            state_1++;
            refStart = index + 1;
          } else {
            state_1 = 0;
          }
          break;
        case 12 :
          if (c == 34) {
            ids[linkIndex] = Object(String).__init___3CII(buffer, refStart, index - refStart);
            state_1 = 2;
          }
          break;
        case 13 :
          if (Character.isWhitespace__C(c)) {
            state_1 = 0;
          } else if (c == 61) {
            state_1++;
          }
          break;
        case 14 :
          state_1 = c == 34 ? state_1 + 1 : 0;
          break;
        case 15 :
          if (c == 34)
            state_1 = 2;
          break;
        default :
          state_1 = 0;
          break;
      }
      index++;
    }
    if (start < length) {
      var tmp: int = this.parseMnemonics___3CIILjava_lang_StringBuffer_2(buffer, start, tagStart, result);
      var mnemonic: int = this.parseMnemonics___3CIILjava_lang_StringBuffer_2(buffer, linkStart, index, result);
      if (mnemonic == -1)
        mnemonic = tmp;
      mnemonics[linkIndex] = mnemonic;
    } else {
      mnemonics[linkIndex] = -1;
    }
    if (offsets.length != linkIndex) {
      var newOffsets: JavaArray = new JavaArray("[Lorg/eclipse/swt/graphics/Point;").lengths(linkIndex);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(offsets, 0, newOffsets, 0, linkIndex);
      offsets = newOffsets;
      var newIDs: JavaArray = new JavaArray("[Ljava/lang/String;").lengths(linkIndex);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(ids, 0, newIDs, 0, linkIndex);
      ids = newIDs;
      var newMnemonics: JavaArray = new JavaArray("[I").lengths(linkIndex + 1);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(mnemonics, 0, newMnemonics, 0, linkIndex + 1);
      mnemonics = newMnemonics;
    }
    return result.toString__();
  }
  public function parseMnemonics___3CIILjava_lang_StringBuffer_2(buffer: JavaArray, start: int, end: int, result: StringBuffer): int {
    var mnemonic: int = -1;
    var index: int = start;
    while (index < end) {
      if (buffer[index] == 38) {
        if (index + 1 < end && buffer[index + 1] == 38) {
          result.append__C(buffer[index]);
          index++;
        } else {
          mnemonic = result.length__();
        }
      } else {
        result.append__C(buffer[index]);
      }
      index++;
    }
    return mnemonic;
  }
  public override function releaseWidget__(): void {
    super.releaseWidget__();
    text = null;
  }
  public function removeSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener: SelectionListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(13, listener);
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(14, listener);
  }
  public function sendSelection__Ljava_lang_String_2(string: String): void {
    var event: Event = new Event();
    event.text = string;
    this.postEvent__ILorg_eclipse_swt_widgets_Event_2(13, event);
  }
  public function setText__Ljava_lang_String_2(string: String): void {
    this.checkWidget__();
    if (string === null)
      this.error__I(4);
    text = string;
    var parsedText: String = this.parse__Ljava_lang_String_2(string);
    var buffer: StringBuffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__, []));
    var start: int = 0;
    for (var i: int = 0; i < offsets.length; i++) {
      var pt: Point = offsets[i];
      buffer.append__Ljava_lang_String_2(Object(parsedText).substring__II(start, pt.x));
      buffer.append__Ljava_lang_String_2("<A HREF=\"event:");
      buffer.append__Ljava_lang_String_2(ids[i]);
      buffer.append__Ljava_lang_String_2("\"><FONT color=\"#0000FF\"><u>");
      buffer.append__Ljava_lang_String_2(Object(parsedText).substring__II(pt.x, pt.y + 1));
      buffer.append__Ljava_lang_String_2("</u></FONT></A>");
      start = pt.y + 1;
    }
    if (start < Object(parsedText).length__()) {
      buffer.append__Ljava_lang_String_2(Object(parsedText).substring__I(start));
    }
    var widget: mx.controls.Text = mx.controls.Text(object);
    widget.htmlText = buffer.toString__();
    return;
  }
}
}
