package org.eclipse.swt.widgets {
import mx.collections.ArrayCollection;
import mx.controls.listClasses.*;
import mx.core.EdgeMetrics;
import mx.core.ScrollControlBase;
import mx.events.ListEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.events.SelectionListener;
import mx.controls.List;
import mx.controls.listClasses.ListBase;
import java.lang.System;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class List extends Scrollable {
  internal var dataProvider: ArrayCollection;
  public function List(parent: Composite, style: int) {
    super(new Arguments(org.eclipse.swt.widgets.Scrollable.Scrollable__Lorg_eclipse_swt_widgets_Composite_2I, [parent, org.eclipse.swt.widgets.List.checkStyle__I(style)]));
    return;
  }
  public function add__Ljava_lang_String_2(string: String): void {
    this.checkWidget__();
    if (string === null)
      this.error__I(4);
    dataProvider.addItem(string);
    return;
  }
  public function add__Ljava_lang_String_2I(string: String, index: int): void {
    this.checkWidget__();
    if (string === null)
      this.error__I(4);
    dataProvider.addItemAt(string, index);
    return;
  }
  public function addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener: SelectionListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(14, typedListener);
    return;
  }
  public function changeHandler__Lmx_events_ListEvent_2(event: ListEvent): void {
    this.postEvent__I(13);
    return;
  }
  public function changeHandlerFunction__(): Function {
    return changeHandler__Lmx_events_ListEvent_2;
  }
  public override function createHandle__(): void {
    var widget: mx.controls.List = new mx.controls.List();
    if ((style & 2) != 0)
      widget.allowMultipleSelection = true;
    widget.dataProvider = dataProvider = new ArrayCollection();
    object = widget;
    return;
  }
  public static function checkStyle__I(style: int): int {
    style |= 256 | 512;
    return Widget.checkBits__IIIIIII(style, 4, 2, 0, 0, 0, 0);
  }
  public override function computeTrim__IIII(x_1: int, y_1: int, width_1: int, height_1: int): Rectangle {
    this.checkWidget__();
    var widget: ScrollControlBase = ScrollControlBase(object);
    var view: EdgeMetrics = widget.viewMetrics;
    x_1 -= view.left;
    y_1 -= view.top;
    width_1 += (view.left + view.right);
    height_1 += (view.top + view.bottom);
    return new Rectangle(x_1, y_1, width_1, height_1);
  }
  public function deselect___3I(indices: JavaArray): void {
    this.checkWidget__();
  }
  public function deselect__I(index: int): void {
  }
  public function deselect__II(start: int, end: int): void {
  }
  public function deselectAll__(): void {
    this.checkWidget__();
    (ListBase(object)).selectedIndices = new Array();
  }
  public function getFocusIndex__(): int {
    return 0;
  }
  public function getItem__I(index: int): String {
    this.checkWidget__();
    var count: int = dataProvider.length;
    if (!(0 <= index && index < count))
      this.error__I(6);
    return String(dataProvider.getItemAt(index));
  }
  public function getItemCount__(): int {
    this.checkWidget__();
    return dataProvider.length;
  }
  public function getItemHeight__(): int {
    return int((ListBase(object)).rowHeight);
  }
  public function getItems__(): JavaArray {
    this.checkWidget__();
    var result: JavaArray = new JavaArray("[Ljava/lang/String;").lengths(dataProvider.length);
    for (var i: int = 0; i < result.length; i++) {
      result[i] = String(dataProvider.getItemAt(i));
    }
    return result;
  }
  public function getSelection__(): JavaArray {
    this.checkWidget__();
    var array: Array = (ListBase(object)).selectedIndices;
    var result: JavaArray = new JavaArray("[Ljava/lang/String;").lengths(array.length);
    for (var i: int = 0; i < result.length; i++) {
      result[i] = String(dataProvider.getItemAt(this.arrayGetInt__LArray_2I(array, i)));
    }
    return result;
  }
  public function getSelectionCount__(): int {
    this.checkWidget__();
    return (ListBase(object)).selectedIndices.length;
  }
  public function getSelectionIndex__(): int {
    this.checkWidget__();
    return (ListBase(object)).selectedIndex;
  }
  public function getSelectionIndices__(): JavaArray {
    this.checkWidget__();
    var array: Array = (ListBase(object)).selectedIndices;
    var result: JavaArray = new JavaArray("[I").lengths(array.length);
    for (var i: int = 0; i < result.length; i++) {
      result[i] = this.arrayGetInt__LArray_2I(array, i);
    }
    return result;
  }
  public function getTopIndex__(): int {
    return 0;
  }
  public function indexOf__Ljava_lang_String_2(string: String): int {
    this.checkWidget__();
    if (string === null)
      this.error__I(4);
    return dataProvider.getItemIndex(string);
  }
  public function indexOf__Ljava_lang_String_2I(string: String, start: int): int {
    this.checkWidget__();
    if (string === null)
      this.error__I(4);
    return dataProvider.toArray().indexOf(string, start);
  }
  public function isSelected__I(index: int): Boolean {
    this.checkWidget__();
    var array: Array = (ListBase(object)).selectedIndices;
    for (var i: int = 0; i < array.length; i++) {
      if (this.arrayGetInt__LArray_2I(array, i) == index) {
        return true;
      }
    }
    return false;
  }
  public override function hookEvents__(): void {
    super.hookEvents__();
    object.addEventListener(ListEvent.CHANGE, this.changeHandlerFunction__());
  }
  public override function releaseWidget__(): void {
    super.releaseWidget__();
    dataProvider = null;
  }
  public function remove___3I(indices: JavaArray): void {
    if (indices === null)
      this.error__I(4);
    if (indices.length == 0)
      return;
    var newIndices: JavaArray = new JavaArray("[I").lengths(indices.length);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(indices, 0, newIndices, 0, indices.length);
    this.sort___3I(newIndices);
    var start: int = newIndices[newIndices.length - 1];
    var end: int = newIndices[0];
    var count: int = this.getItemCount__();
    if (!(0 <= start && start <= end && end < count)) {
      this.error__I(6);
    }
    dataProvider.disableAutoUpdate();
    var last: int = -1;
    for (var i: int = 0; i < newIndices.length; i++) {
      var index: int = newIndices[i];
      if (index != last) {
        dataProvider.removeItemAt(index);
        last = index;
      }
    }
    dataProvider.enableAutoUpdate();
    return;
  }
  public function remove__I(index: int): void {
    this.checkWidget__();
    var count: int = dataProvider.length;
    if (!(0 <= index && index < count))
      this.error__I(6);
    dataProvider.removeItemAt(index);
    return;
  }
  public function remove__II(start: int, end: int): void {
    var count: int = dataProvider.length;
    if (!(0 <= start && start <= end && end < count)) {
      this.error__I(6);
    }
    dataProvider.disableAutoUpdate();
    for (var index: int = end; index >= start; index--) {
      dataProvider.removeItemAt(index);
    }
    dataProvider.enableAutoUpdate();
    return;
  }
  public function remove__Ljava_lang_String_2(string: String): void {
    this.checkWidget__();
    if (string === null)
      this.error__I(4);
    var index: int = dataProvider.getItemIndex(string);
    if (index == -1)
      this.error__I(5);
    dataProvider.removeItemAt(index);
    return;
  }
  public function removeAll__(): void {
    this.checkWidget__();
    dataProvider.removeAll();
    return;
  }
  public function removeSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener: SelectionListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(13, listener);
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(14, listener);
  }
  public function select___3I(indices: JavaArray): void {
  }
  public function select__I(index: int): void {
  }
  public function select__II(start: int, end: int): void {
  }
  public function selectAll__(): void {
  }
  public function setItem__ILjava_lang_String_2(index: int, string: String): void {
    this.checkWidget__();
    if (string === null)
      this.error__I(4);
    var count: int = dataProvider.length;
    if (!(0 <= index && index < count))
      this.error__I(6);
    dataProvider.setItemAt(string, index);
  }
  public function setItems___3Ljava_lang_String_2(items: JavaArray): void {
    this.checkWidget__();
    if (items === null)
      this.error__I(4);
    for (var i: int = 0; i < items.length; i++) {
      if (items[i] === null)
        this.error__I(5);
    }
    dataProvider.disableAutoUpdate();
    dataProvider.removeAll();
    for (var i_1: int = 0; i_1 < items.length; i_1++) {
      dataProvider.addItem(items[i_1]);
    }
    dataProvider.enableAutoUpdate();
    return;
  }
  public function setSelection___3I(indices: JavaArray): void {
  }
  public function setSelection___3Ljava_lang_String_2(items: JavaArray): void {
  }
  public function setSelection__I(index: int): void {
  }
  public function setSelection__II(start: int, end: int): void {
  }
  public function setTopIndex__I(index: int): void {
  }
  public function showSelection__(): void {
  }
}
}
