package org.eclipse.swt.widgets {
import mx.collections.ArrayCollection;
import mx.controls.MenuBar;
import mx.core.Container;
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.internal.flex.SWTMenu;
import org.eclipse.swt.internal.flex.SWTMenuDataDescriptor;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.SWT;
import mx.controls.Menu;
import org.eclipse.swt.graphics.Point;
import mx.events.MenuEvent;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class Menu extends Widget {
  internal var parent: Decorations;
  internal var cascade: MenuItem;
  internal var x: int;
  internal var y: int;
  internal var hasLocation: Boolean;
  public var items: ArrayCollection;
  public function Menu__Lorg_eclipse_swt_widgets_Control_2(parent: Control): Object {
    return this;
  }
  public function Menu__Lorg_eclipse_swt_widgets_Decorations_2I(parent: Decorations, style: int): Object {
    this.parent = parent;
    this.createWidget__();
    return this;
  }
  public function Menu__Lorg_eclipse_swt_widgets_Menu_2(parentMenu: org.eclipse.swt.widgets.Menu): Object {
    return this;
  }
  public function Menu__Lorg_eclipse_swt_widgets_MenuItem_2(parentItem: MenuItem): Object {
    return this;
  }
  public function addHelpListener__Lorg_eclipse_swt_events_HelpListener_2(listener: HelpListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(28, typedListener);
    return;
  }
  public function addMenuListener__Lorg_eclipse_swt_events_MenuListener_2(listener: MenuListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(23, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(22, typedListener);
    return;
  }
  public static function checkNull__Lorg_eclipse_swt_widgets_Control_2(control: Control): Control {
    if (control === null)
      SWT.error__I(4);
    return control;
  }
  public static function checkNull__Lorg_eclipse_swt_widgets_Menu_2(menu: org.eclipse.swt.widgets.Menu): org.eclipse.swt.widgets.Menu {
    if (menu === null)
      SWT.error__I(4);
    return menu;
  }
  public static function checkNull__Lorg_eclipse_swt_widgets_MenuItem_2(item: MenuItem): MenuItem {
    if (item === null)
      SWT.error__I(4);
    return item;
  }
  public static function checkStyle__I(style: int): int {
    return Widget.checkBits__IIIIIII(style, 8, 2, 4, 0, 0, 0);
  }
  public override function createHandle__(): void {
    if ((style & 2) != 0) {
      var menu: MenuBar = new MenuBar();
      menu.dataProvider = items = new ArrayCollection();
      menu.dataDescriptor = new SWTMenuDataDescriptor();
      menu.labelFunction = this.getLabelFunction__();
      menu.percentWidth = 100;
      object = menu;
    } else {
      items = new ArrayCollection();
      var menu_1: mx.controls.Menu = new SWTMenu();
      mx.controls.Menu.popUpMenu(menu_1, parent.object, items);
      menu_1.dataDescriptor = new SWTMenuDataDescriptor();
      menu_1.labelFunction = this.getLabelFunction__();
      menu_1.iconFunction = this.getIconFunction__();
      object = menu_1;
    }
    return;
  }
  public function createItem__Lorg_eclipse_swt_widgets_MenuItem_2I(item: MenuItem, index: int): void {
    var itemCount: int = items.length;
    if (!(0 <= index && index <= itemCount))
      this.error__I(6);
    item.createWidget__();
    items.addItemAt(item, index);
    return;
  }
  public function getDefaultItem__(): MenuItem {
    this.checkWidget__();
    return null;
  }
  public function getEnabled__(): Boolean {
    this.checkWidget__();
    return object.enabled;
  }
  public function getItem__I(index: int): MenuItem {
    this.checkWidget__();
    var itemCount: int = items.length;
    if (!(0 <= index && index < itemCount))
      this.error__I(6);
    return MenuItem(items.getItemAt(index));
  }
  public function getItemCount__(): int {
    this.checkWidget__();
    return items.length;
  }
  public function getItems__(): JavaArray {
    this.checkWidget__();
    var result: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/MenuItem;").lengths(items.length);
    for (var i: int = 0; i < result.length; i++) {
      result[i] = MenuItem(items.getItemAt(i));
    }
    return result;
  }
  public function getParent__(): Decorations {
    this.checkWidget__();
    return parent;
  }
  public function getParentItem__(): MenuItem {
    this.checkWidget__();
    return cascade;
  }
  public function getParentMenu__(): org.eclipse.swt.widgets.Menu {
    this.checkWidget__();
    if (cascade !== null)
      return cascade.parent;
    return null;
  }
  public function getShell__(): Shell {
    this.checkWidget__();
    return parent.getShell__();
  }
  public function getVisible__(): Boolean {
    this.checkWidget__();
    return object.visible;
  }
  public function indexOf__Lorg_eclipse_swt_widgets_MenuItem_2(item: MenuItem): int {
    this.checkWidget__();
    return items.getItemIndex(item);
  }
  public function invalidateItem__Lorg_eclipse_swt_widgets_MenuItem_2(item: MenuItem): void {
    items.itemUpdated(item);
  }
  public function isEnabled__(): Boolean {
    this.checkWidget__();
    var parentMenu: org.eclipse.swt.widgets.Menu = this.getParentMenu__();
    if (parentMenu === null) {
      return this.getEnabled__() && parent.isEnabled__();
    }
    return this.getEnabled__() && parentMenu.isEnabled__();
  }
  public function isVisible__(): Boolean {
    this.checkWidget__();
    return this.getVisible__();
  }
  public function labelFunction__Lorg_eclipse_swt_widgets_MenuItem_2(item: MenuItem): String {
    return item.getText__();
  }
  public function getLabelFunction__(): Function {
    return labelFunction__Lorg_eclipse_swt_widgets_MenuItem_2;
  }
  public function iconFunction__Ljava_lang_Object_2(object_1: Object): String {
    return null;
  }
  public function getIconFunction__(): Function {
    return iconFunction__Ljava_lang_Object_2;
  }
  public function removeHelpListener__Lorg_eclipse_swt_events_HelpListener_2(listener: HelpListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(28, listener);
  }
  public function removeMenuListener__Lorg_eclipse_swt_events_MenuListener_2(listener: MenuListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(23, listener);
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(22, listener);
  }
  public function setDefaultItem__Lorg_eclipse_swt_widgets_MenuItem_2(item: MenuItem): void {
    this.checkWidget__();
  }
  public function setEnabled__Z(enabled: Boolean): void {
    this.checkWidget__();
    object.enabled = enabled;
  }
  public function setLocation__II(x_1: int, y_1: int): void {
    this.checkWidget__();
    if ((style & (2 | 4)) != 0)
      return;
    this.x = x_1;
    this.y = y_1;
    hasLocation = true;
  }
  public function setLocation__Lorg_eclipse_swt_graphics_Point_2(location: Point): void {
    this.checkWidget__();
    if (location === null)
      SWT.error__I(4);
    this.setLocation__II(location.x, location.y);
  }
  public function setVisible__Z(visible: Boolean): void {
    this.checkWidget__();
    if ((style & (2 | 4)) != 0)
      return;
    var nX: int = x;
    var nY: int = y;
    if (!hasLocation) {
      var root: Container = display.root;
      nX = int(root.mouseX);
      nY = int(root.mouseY);
    }
    (SWTMenu(object)).show(nX, nY);
    return;
  }
  public function itemClickHandler__Lmx_events_MenuEvent_2(event: MenuEvent): void {
    (MenuItem(event.item)).sendEvent__I(13);
    return;
  }
  public function menuShowHandler__Lmx_events_MenuEvent_2(event: MenuEvent): void {
    if ((style & 2) != 0)
      (MenuItem(items.getItemAt(event.menuBar.selectedIndex))).menu.sendEvent__I(22);
    return;
  }
  public function itemClickHandlerFunction__(): Function {
    return itemClickHandler__Lmx_events_MenuEvent_2;
  }
  public function menuShowHandlerFunction__(): Function {
    return menuShowHandler__Lmx_events_MenuEvent_2;
  }
  public override function hookEvents__(): void {
    super.hookEvents__();
    object.addEventListener(mx.events.MenuEvent.ITEM_CLICK, this.itemClickHandlerFunction__());
    object.addEventListener(mx.events.MenuEvent.MENU_SHOW, this.menuShowHandlerFunction__());
    return;
  }
  public function Menu(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 1 && vargs[0] is Control) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 2 && vargs[0] is Decorations && vargs[1] is int) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 1 && vargs[0] is org.eclipse.swt.widgets.Menu) {
        args = vargs;
        id = 2;
      } else if (vargs.length == 1 && vargs[0] is MenuItem) {
        args = vargs;
        id = 3;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0]];
        args1 = [org.eclipse.swt.widgets.Menu.checkNull__Lorg_eclipse_swt_widgets_Control_2(args0[0]).menuShell__(), 8];
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.swt.widgets.Widget.Widget__Lorg_eclipse_swt_widgets_Widget_2I, [args1[0], org.eclipse.swt.widgets.Menu.checkStyle__I(args1[1])]);
        break;
      case 1:
        var args1: Array = [args[0], args[1]];
        superArgs = new Arguments(org.eclipse.swt.widgets.Widget.Widget__Lorg_eclipse_swt_widgets_Widget_2I, [args1[0], org.eclipse.swt.widgets.Menu.checkStyle__I(args1[1])]);
        break;
      case 2:
        var args2: Array = [args[0]];
        args1 = [org.eclipse.swt.widgets.Menu.checkNull__Lorg_eclipse_swt_widgets_Menu_2(args2[0]).parent, 4];
        superArgs = new Arguments(org.eclipse.swt.widgets.Widget.Widget__Lorg_eclipse_swt_widgets_Widget_2I, [args1[0], org.eclipse.swt.widgets.Menu.checkStyle__I(args1[1])]);
        break;
      case 3:
        var args3: Array = [args[0]];
        args2 = [org.eclipse.swt.widgets.Menu.checkNull__Lorg_eclipse_swt_widgets_MenuItem_2(args3[0]).parent];
        args1 = [org.eclipse.swt.widgets.Menu.checkNull__Lorg_eclipse_swt_widgets_Menu_2(args2[0]).parent, 4];
        superArgs = new Arguments(org.eclipse.swt.widgets.Widget.Widget__Lorg_eclipse_swt_widgets_Widget_2I, [args1[0], org.eclipse.swt.widgets.Menu.checkStyle__I(args1[1])]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        Menu__Lorg_eclipse_swt_widgets_Decorations_2I(args1[0], args1[1]);
        Menu__Lorg_eclipse_swt_widgets_Control_2(args0[0]);
        break;
      case 1:
        Menu__Lorg_eclipse_swt_widgets_Decorations_2I(args1[0], args1[1]);
        break;
      case 2:
        Menu__Lorg_eclipse_swt_widgets_Decorations_2I(args1[0], args1[1]);
        Menu__Lorg_eclipse_swt_widgets_Menu_2(args2[0]);
        break;
      case 3:
        Menu__Lorg_eclipse_swt_widgets_Decorations_2I(args1[0], args1[1]);
        Menu__Lorg_eclipse_swt_widgets_Menu_2(args2[0]);
        Menu__Lorg_eclipse_swt_widgets_MenuItem_2(args3[0]);
        break;
    }
  }
  public static const Menu__Lorg_eclipse_swt_widgets_Control_2 : int = 0;
  public static const Menu__Lorg_eclipse_swt_widgets_Decorations_2I : int = 1;
  public static const Menu__Lorg_eclipse_swt_widgets_Menu_2 : int = 2;
  public static const Menu__Lorg_eclipse_swt_widgets_MenuItem_2 : int = 3;
}
}
