package org.eclipse.swt.widgets {
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import java.lang.Arguments;
dynamic public class MenuItem extends Item {
  internal var parent: Menu;
  internal var menu: Menu;
  internal var enabled: Boolean;
  internal var selected: Boolean;
  public function MenuItem__Lorg_eclipse_swt_widgets_Menu_2I(parent: Menu, style: int): Object {
    this.parent = parent;
    parent.createItem__Lorg_eclipse_swt_widgets_MenuItem_2I(this, parent.getItemCount__());
    return this;
  }
  public function MenuItem__Lorg_eclipse_swt_widgets_Menu_2II(parent: Menu, style: int, index: int): Object {
    this.parent = parent;
    parent.createItem__Lorg_eclipse_swt_widgets_MenuItem_2I(this, index);
    return this;
  }
  public function addArmListener__Lorg_eclipse_swt_events_ArmListener_2(listener: ArmListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(30, typedListener);
    return;
  }
  public function addHelpListener__Lorg_eclipse_swt_events_HelpListener_2(listener: HelpListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(28, typedListener);
    return;
  }
  public function addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener: SelectionListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(14, typedListener);
    return;
  }
  public override function checkSubclass__(): void {
  }
  public override function createWidget__(): void {
    super.createWidget__();
    enabled = true;
    return;
  }
  public static function checkStyle__I(style: int): int {
    return Widget.checkBits__IIIIIII(style, 8, 32, 16, 2, 64, 0);
  }
  public function getAccelerator__(): int {
    this.checkWidget__();
    return 0;
  }
  public function getEnabled__(): Boolean {
    return enabled;
  }
  public function getMenu__(): Menu {
    this.checkWidget__();
    return menu;
  }
  public function getParent__(): Menu {
    this.checkWidget__();
    return parent;
  }
  public function getSelection__(): Boolean {
    this.checkWidget__();
    return selected;
  }
  public function isEnabled__(): Boolean {
    this.checkWidget__();
    return this.getEnabled__() && parent.isEnabled__();
  }
  public function removeArmListener__Lorg_eclipse_swt_events_ArmListener_2(listener: ArmListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(30, listener);
  }
  public function removeHelpListener__Lorg_eclipse_swt_events_HelpListener_2(listener: HelpListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(28, listener);
  }
  public function removeSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener: SelectionListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(13, listener);
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(14, listener);
  }
  public function setAccelerator__I(accelerator: int): void {
    this.checkWidget__();
  }
  public function setEnabled__Z(enabled_1: Boolean): void {
    this.checkWidget__();
    if (this.enabled == enabled_1)
      return;
    this.enabled = enabled_1;
    parent.invalidateItem__Lorg_eclipse_swt_widgets_MenuItem_2(this);
  }
  public override function setImage__Lorg_eclipse_swt_graphics_Image_2(image_1: Image): void {
    this.checkWidget__();
    if ((style & 2) != 0)
      return;
    super.setImage__Lorg_eclipse_swt_graphics_Image_2(image_1);
  }
  public function setMenu__Lorg_eclipse_swt_widgets_Menu_2(menu_1: Menu): void {
    this.checkWidget__();
    if ((style & 64) == 0) {
      this.error__I(27);
    }
    if (menu_1 !== null) {
      if (menu_1.isDisposed__())
        this.error__I(5);
      if ((menu_1.style & 4) == 0) {
        this.error__I(21);
      }
      if (menu_1.parent !== parent.parent) {
        this.error__I(32);
      }
    }
    var oldMenu: Menu = this.menu;
    if (oldMenu === menu_1)
      return;
    if (oldMenu !== null)
      oldMenu.cascade = null;
    this.menu = menu_1;
    var index: int = parent.indexOf__Lorg_eclipse_swt_widgets_MenuItem_2(this);
    if (index == -1)
      return;
    if (menu_1 !== null) {
      menu_1.cascade = this;
    }
    return;
  }
  public function setSelection__Z(selected_1: Boolean): void {
    this.checkWidget__();
    if ((style & (32 | 16)) == 0)
      return;
    this.selected = selected_1;
    parent.invalidateItem__Lorg_eclipse_swt_widgets_MenuItem_2(this);
  }
  public override function setText__Ljava_lang_String_2(string: String): void {
    this.checkWidget__();
    if (string === null)
      this.error__I(4);
    if ((style & 2) != 0)
      return;
    if (Object(text).equals__Ljava_lang_Object_2(string))
      return;
    super.setText__Ljava_lang_String_2(string);
  }
  public function MenuItem(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 2 && vargs[0] is Menu && vargs[1] is int) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 3 && vargs[0] is Menu && vargs[1] is int && vargs[2] is int) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0], args[1]];
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.swt.widgets.Item.Item__Lorg_eclipse_swt_widgets_Widget_2I, [args0[0], MenuItem.checkStyle__I(args0[1])]);
        break;
      case 1:
        var args1: Array = [args[0], args[1], args[2]];
        superArgs = new Arguments(org.eclipse.swt.widgets.Item.Item__Lorg_eclipse_swt_widgets_Widget_2I, [args1[0], MenuItem.checkStyle__I(args1[1])]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        MenuItem__Lorg_eclipse_swt_widgets_Menu_2I(args0[0], args0[1]);
        break;
      case 1:
        MenuItem__Lorg_eclipse_swt_widgets_Menu_2II(args1[0], args1[1], args1[2]);
        break;
    }
  }
  public static const MenuItem__Lorg_eclipse_swt_widgets_Menu_2I : int = 0;
  public static const MenuItem__Lorg_eclipse_swt_widgets_Menu_2II : int = 1;
}
}
