package org.eclipse.swt.widgets {
import flash.display.DisplayObjectContainer;
import flash.display.Sprite;
import mx.controls.Alert;
import org.eclipse.swt.SWT;
import mx.events.CloseEvent;
import java.lang.System;
import java.lang.Arguments;
dynamic public class MessageBox extends Dialog {
  internal var message: String = "";
  public function MessageBox__Lorg_eclipse_swt_widgets_Shell_2(parent: Shell): Object {
    return this;
  }
  public function MessageBox__Lorg_eclipse_swt_widgets_Shell_2I(parent: Shell, style: int): Object {
    this.checkSubclass__();
    return this;
  }
  public static function checkStyle__I(style: int): int {
    if ((style & (32768 | 65536 | 131072)) == 0)
      style |= 65536;
    var mask: int = (64 | 128 | 32 | 256 | 512 | 1024 | 2048);
    var bits: int = style & mask;
    if (bits == 32 || bits == 256 || bits == (32 | 256))
      return style;
    if (bits == 64 || bits == 128 || bits == (64 | 128) || bits == (64 | 128 | 256))
      return style;
    if (bits == (1024 | 256) || bits == (512 | 1024 | 2048))
      return style;
    style = (style & ~mask) | 32;
    return style;
  }
  public function handleClose__Lmx_events_CloseEvent_2(event: CloseEvent): void {
    var result: int = 0;
    var mask: int = (64 | 128 | 32 | 256 | 512 | 1024 | 2048);
    var bits: int = style & mask;
    switch (event.detail) {
      case Alert.OK :
        result = (bits & 1024) != 0 ? result = 1024 : 32;
        break;
      case Alert.CANCEL :
        result = (bits & 2048) != 0 ? result = 2048 : 256;
        break;
      case Alert.YES :
        result = 64;
        break;
      case Alert.NO :
        result = (bits & 512) != 0 ? 512 : 128;
        break;
    }
    System.out.println__I(result);
  }
  public function handleCloseFunction__(): Function {
    return handleClose__Lmx_events_CloseEvent_2;
  }
  public function getMessage__(): String {
    return message;
  }
  public function open__(): int {
    var text: String = message !== null ? message : "";
    var title_1: String = this.title !== null ? this.title : "";
    var mask: int = (64 | 128 | 32 | 256 | 512 | 1024 | 2048);
    var flags: int = 0;
    var defaultButtonFlag: int = 0;
    var okLabel: String = null;
    var noLabel: String = null;
    var cancelLabel: String = null;
    var bits: int = style & mask;
    switch (bits) {
      case 32 :
        flags = Alert.OK;
        defaultButtonFlag = Alert.OK;
        break;
      case 256 :
        flags = Alert.CANCEL;
        defaultButtonFlag = Alert.CANCEL;
        break;
      case 32 | 256 :
        flags = Alert.OK | Alert.CANCEL;
        defaultButtonFlag = Alert.OK;
        break;
      case 64 :
        flags = Alert.YES;
        defaultButtonFlag = Alert.YES;
        break;
      case 128 :
        flags = Alert.NO;
        defaultButtonFlag = Alert.NO;
        break;
      case 64 | 128 :
        flags = Alert.YES | Alert.NO;
        defaultButtonFlag = Alert.YES;
        break;
      case 64 | 128 | 256 :
        flags = Alert.YES | Alert.NO | Alert.CANCEL;
        defaultButtonFlag = Alert.YES;
        break;
      case 1024 | 256 :
        flags = Alert.OK | Alert.CANCEL;
        defaultButtonFlag = Alert.OK;
        okLabel = SWT.getMessage__Ljava_lang_String_2("SWT_Retry");
        break;
      case 512 | 1024 | 2048 :
        flags = Alert.OK | Alert.NO | Alert.CANCEL;
        defaultButtonFlag = Alert.OK;
        okLabel = SWT.getMessage__Ljava_lang_String_2("SWT_Retry");
        noLabel = SWT.getMessage__Ljava_lang_String_2("SWT_Abort");
        cancelLabel = SWT.getMessage__Ljava_lang_String_2("SWT_Ignore");
        break;
    }
    Alert.okLabel = okLabel;
    Alert.noLabel = noLabel;
    Alert.cancelLabel = cancelLabel;
    var sprite: DisplayObjectContainer = parent !== null ? parent.parentingComponent__() : null;
    Alert.show(text, title_1, flags, Sprite(sprite), this.handleCloseFunction__(), null, defaultButtonFlag);
    return 0;
  }
  public function setMessage__Ljava_lang_String_2(string: String): void {
    if (string === null)
      this.error__I(4);
    message = string;
  }
  public function MessageBox(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 1 && vargs[0] is Shell) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 2 && vargs[0] is Shell && vargs[1] is int) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0]];
        args1 = [args0[0], 32 | 2 | 65536];
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.swt.widgets.Dialog.Dialog__Lorg_eclipse_swt_widgets_Shell_2I, [args1[0], MessageBox.checkStyle__I(args1[1])]);
        break;
      case 1:
        var args1: Array = [args[0], args[1]];
        superArgs = new Arguments(org.eclipse.swt.widgets.Dialog.Dialog__Lorg_eclipse_swt_widgets_Shell_2I, [args1[0], MessageBox.checkStyle__I(args1[1])]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        MessageBox__Lorg_eclipse_swt_widgets_Shell_2I(args1[0], args1[1]);
        MessageBox__Lorg_eclipse_swt_widgets_Shell_2(args0[0]);
        break;
      case 1:
        MessageBox__Lorg_eclipse_swt_widgets_Shell_2I(args1[0], args1[1]);
        break;
    }
  }
  public static const MessageBox__Lorg_eclipse_swt_widgets_Shell_2 : int = 0;
  public static const MessageBox__Lorg_eclipse_swt_widgets_Shell_2I : int = 1;
}
}
