package org.eclipse.swt.widgets {
import mx.core.UIComponent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.events.SelectionListener;
import mx.containers.Canvas;
import java.lang.Math__;
import java.lang.Arguments;
dynamic public class Sash extends Control {
  internal var lastX: int;
  internal var lastY: int;
  internal var startX: int;
  internal var startY: int;
  internal var sizeCursor: Cursor;
  internal var dragging: Boolean;
  public static const INCREMENT: int = 1;
  public static const PAGE_INCREMENT: int = 9;
  public function Sash(parent: Composite, style: int) {
    super(new Arguments(org.eclipse.swt.widgets.Control.Control__Lorg_eclipse_swt_widgets_Composite_2I, [parent, Sash.checkStyle__I(style)]));
    var cursorStyle: int = (style & 512) != 0 ? 9 : 7;
    sizeCursor = display.getSystemCursor__I(cursorStyle);
    return;
  }
  public function addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener: SelectionListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(14, typedListener);
    return;
  }
  public static function checkStyle__I(style: int): int {
    style |= 65536;
    return Widget.checkBits__IIIIIII(style, 256, 512, 0, 0, 0, 0);
  }
  public override function computeSize__IIZ(wHint: int, hHint: int, changed: Boolean): Point {
    this.checkWidget__();
    var width_1: int = 0;
    var height_1: int = 0;
    if ((style & 256) != 0) {
      width_1 += 64;
      height_1 += 5;
    } else {
      width_1 += 5;
      height_1 += 64;
    }
    if (wHint != -1)
      width_1 = wHint;
    if (hHint != -1)
      height_1 = hHint;
    return new Point(width_1, height_1);
  }
  public override function createHandle__(): void {
    var widget: mx.containers.Canvas = new mx.containers.Canvas();
    widget.setStyle("backgroundColor", 0xFFFFFF);
    object = widget;
  }
  public override function sendFocusEvent__I(type: int): Boolean {
    var result: Boolean = super.sendFocusEvent__I(type);
    if (!this.isDisposed__())
      return false;
    if (type == 15) {
      var location: Point = this.getLocation__();
      lastX = location.x;
      lastY = location.y;
    }
    return result;
  }
  public override function sendKeyEvent__ILorg_eclipse_swt_widgets_Event_2(type: int, keyEvent: Event): Boolean {
    var result: Boolean = super.sendKeyEvent__ILorg_eclipse_swt_widgets_Event_2(type, keyEvent);
    if (this.isDisposed__())
      return false;
    if (!result)
      return result;
    if (type != 1)
      return result;
    switch (keyEvent.keyCode) {
      case 128 :
      case 16384 :
      case 1024 :
      case 131072 :
        {
          var xChange: int = 0;
          var yChange: int = 0;
          var stepSize: int = 9;
          if ((keyEvent.stateMask & 262144) != 0)
            stepSize = 1;
          if ((style & 512) != 0) {
            if (keyEvent.keyCode == 128 || keyEvent.keyCode == 1024)
              break;
            xChange = 16384 == 123 ? -stepSize : stepSize;
          } else {
            if (keyEvent.keyCode == 16384 || keyEvent.keyCode == 131072)
              break;
            yChange = 128 == 126 ? -stepSize : stepSize;
          }
          var bounds: Rectangle = this.getBounds__();
          var width_1: int = bounds.width;
          var height_1: int = bounds.height;
          var parentBounds: Rectangle = parent.getBounds__();
          var parentWidth: int = parentBounds.width;
          var parentHeight: int = parentBounds.height;
          var newX: int = lastX;
          var newY: int = lastY;
          if ((style & 512) != 0) {
            newX = Math__.min__II(Math__.max__II(0, lastX + xChange), parentWidth - width_1);
          } else {
            newY = Math__.min__II(Math__.max__II(0, lastY + yChange), parentHeight - height_1);
          }
          if (newX == lastX && newY == lastY)
            return result;
          var event: Event = new Event();
          event.x = newX;
          event.y = newY;
          event.width = width_1;
          event.height = height_1;
          this.sendEvent__ILorg_eclipse_swt_widgets_Event_2(13, event);
          if (this.isDisposed__())
            break;
          if (event.doit) {
            this.setBounds__IIII(event.x, event.y, width_1, height_1);
            if (this.isDisposed__())
              break;
            lastX = event.x;
            lastY = event.y;
            if (this.isDisposed__())
              return result;
            var cursorX: int = event.x;
            var cursorY: int = event.y;
            if ((style & 512) != 0) {
              cursorY += int(height_1 / 2);
            } else {
              cursorX += int(width_1 / 2);
            }
            display.setCursorLocation__Lorg_eclipse_swt_graphics_Point_2(parent.toDisplay__II(cursorX, cursorY));
          }
          break;
        }
    }
    return result;
  }
  public override function sendMouseEvent__ILorg_eclipse_swt_widgets_Event_2Z(type: int, mouseEvent: Event, send: Boolean): Boolean {
    var result: Boolean = super.sendMouseEvent__ILorg_eclipse_swt_widgets_Event_2Z(type, mouseEvent, send);
    var x_1: int = mouseEvent.x;
    var y_1: int = mouseEvent.y;
    var controlX: int = int(object.x);
    var controlY: int = int(object.y);
    var width_1: int = int(object.width);
    var height_1: int = int(object.height);
    var parentComponent: UIComponent = parent.topComponent__();
    var parentWidth: int = int(parentComponent.width);
    var parentHeight: int = int(parentComponent.height);
    switch (type) {
      case 3 :
        if (mouseEvent.button != 1 || mouseEvent.count != 1)
          break;
        startX = x_1;
        startY = y_1;
        var event: Event = new Event();
        event.x = controlX;
        event.y = controlY;
        event.width = width_1;
        event.height = height_1;
        this.sendEvent__ILorg_eclipse_swt_widgets_Event_2(13, event);
        if (this.isDisposed__())
          return result;
        if (event.doit) {
          lastX = event.x;
          lastY = event.y;
          dragging = true;
          this.setBounds__IIII(event.x, event.y, width_1, height_1);
        }
        break;
      case 4 :
        if (!dragging)
          break;
        dragging = false;
        event = new Event();
        event.x = lastX;
        event.y = lastY;
        event.width = width_1;
        event.height = height_1;
        this.sendEvent__ILorg_eclipse_swt_widgets_Event_2(13, event);
        if (this.isDisposed__())
          return result;
        if (event.doit) {
          this.setBounds__IIII(event.x, event.y, width_1, height_1);
        }
        break;
      case 5 :
        if (!dragging)
          break;
        var newX: int = lastX;
        var newY: int = lastY;
        if ((style & 512) != 0) {
          newX = Math__.min__II(Math__.max__II(0, x_1 + controlX - startX), parentWidth - width_1);
        } else {
          newY = Math__.min__II(Math__.max__II(0, y_1 + controlY - startY), parentHeight - height_1);
        }
        if (newX == lastX && newY == lastY)
          return result;
        event = new Event();
        event.x = newX;
        event.y = newY;
        event.width = width_1;
        event.height = height_1;
        this.sendEvent__ILorg_eclipse_swt_widgets_Event_2(13, event);
        if (this.isDisposed__())
          return result;
        if (event.doit) {
          lastX = event.x;
          lastY = event.y;
          this.setBounds__IIII(event.x, event.y, width_1, height_1);
        }
        break;
    }
    return result;
  }
  public override function findCursor__(): Cursor {
    var cursor_1: Cursor = super.findCursor__();
    if (cursor_1 !== null)
      return cursor_1;
    return sizeCursor;
  }
  public override function hooksMouse__I(type: int): Boolean {
    switch (type) {
      case 3 :
      case 4 :
      case 5 :
        return true;
    }
    return super.hooksMouse__I(type);
  }
  public override function releaseWidget__(): void {
    super.releaseWidget__();
    sizeCursor = null;
  }
  public function removeSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener: SelectionListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(13, listener);
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(14, listener);
  }
}
}
