package org.eclipse.swt.widgets {
import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import mx.events.*;
import mx.controls.*;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.SWT;
import mx.controls.sliderClasses.Slider;
import mx.controls.HSlider;
import mx.controls.VSlider;
import mx.events.SliderEvent;
import java.lang.Arguments;
dynamic public class Scale extends Control {
  internal var minimum: int;
  internal var maximum: int;
  internal var selection: int;
  internal var increment: int;
  internal var pageIncrement: int;
  public function Scale(parent: Composite, style: int) {
    super(new Arguments(org.eclipse.swt.widgets.Control.Control__Lorg_eclipse_swt_widgets_Composite_2I, [parent, Scale.checkStyle__I(style)]));
    return;
  }
  public function addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener: SelectionListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(14, typedListener);
    return;
  }
  public static function checkStyle__I(style: int): int {
    return Widget.checkBits__IIIIIII(style, 256, 512, 0, 0, 0, 0);
  }
  public override function createHandle__(): void {
    var widget: mx.controls.sliderClasses.Slider;
    if ((style & 256) != 0) {
      widget = new HSlider();
    } else {
      widget = new VSlider();
    }
    widget.liveDragging = true;
    widget.allowTrackClick = true;
    object = widget;
    return;
  }
  public override function createWidget__(): void {
    super.createWidget__();
    this.setValues__IIIII(0, 0, 100, 1, 10);
    return;
  }
  public function getIncrement__(): int {
    this.checkWidget__();
    return increment;
  }
  public function getMaximum__(): int {
    this.checkWidget__();
    return maximum;
  }
  public function getMinimum__(): int {
    this.checkWidget__();
    return minimum;
  }
  public function getPageIncrement__(): int {
    this.checkWidget__();
    return pageIncrement;
  }
  public function getSelection__(): int {
    this.checkWidget__();
    return selection;
  }
  public override function hookEvents__(): void {
    super.hookEvents__();
    object.addEventListener(SliderEvent.CHANGE, this.sliderHandlerFunction__());
  }
  public function removeSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener: SelectionListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(13, listener);
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(14, listener);
  }
  public function sendSelection__I(selection_1: int): void {
    this.selection = selection_1;
    this.sendEvent__I(13);
  }
  public function setIncrement__I(value: int): void {
    this.setValues__IIIII(selection, minimum, maximum, value, pageIncrement);
  }
  public function setMaximum__I(value: int): void {
    this.setValues__IIIII(selection, minimum, value, increment, pageIncrement);
  }
  public function setMinimum__I(value: int): void {
    this.setValues__IIIII(selection, value, maximum, increment, pageIncrement);
  }
  public function setPageIncrement__I(value: int): void {
    this.setValues__IIIII(selection, minimum, maximum, increment, value);
  }
  public function setSelection__I(value: int): void {
    this.setValues__IIIII(value, minimum, maximum, increment, pageIncrement);
  }
  public function setValues__IIIII(selection_1: int, minimum_1: int, maximum_1: int, increment_1: int, pageIncrement_1: int): void {
    this.checkWidget__();
    this.selection = selection_1;
    this.minimum = minimum_1;
    this.maximum = maximum_1;
    this.increment = increment_1;
    this.pageIncrement = pageIncrement_1;
    var widget: mx.controls.sliderClasses.Slider = mx.controls.sliderClasses.Slider(object);
    widget.minimum = minimum_1;
    widget.maximum = maximum_1;
    widget.value = selection_1;
    widget.snapInterval = increment_1;
    widget.tickInterval = pageIncrement_1;
  }
  public function sliderHandler__Lmx_events_SliderEvent_2(event: SliderEvent): void {
    this.sendSelection__I(int(event.value));
  }
  public function sliderHandlerFunction__(): Function {
    return sliderHandler__Lmx_events_SliderEvent_2;
  }
}
}
