package org.eclipse.swt.widgets {
import flash.display.DisplayObject;
import mx.controls.HScrollBar;
import mx.controls.VScrollBar;
import mx.core.ScrollControlBase;
import mx.events.ScrollEvent;
import mx.events.ScrollEventDetail;
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.SWT;
import mx.controls.scrollClasses.ScrollBar;
import org.eclipse.swt.graphics.Point;
import java.lang.Math__;
import java.lang.Arguments;
dynamic public class ScrollBar extends Widget {
  internal var parent: Scrollable;
  internal var minimum: int;
  internal var maximum: int;
  internal var selection: int;
  internal var thumb: int;
  internal var increment: int;
  internal var pageIncrement: int;
  function ScrollBar(parent: Scrollable, style: int) {
    super(new Arguments(org.eclipse.swt.widgets.Widget.Widget__Lorg_eclipse_swt_widgets_Widget_2I, [parent, org.eclipse.swt.widgets.ScrollBar.checkStyle__I(style)]));
    this.parent = parent;
    this.createWidget__();
    return;
  }
  public function addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener: SelectionListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(14, typedListener);
    return;
  }
  public static function checkStyle__I(style: int): int {
    return Widget.checkBits__IIIIIII(style, 256, 512, 0, 0, 0, 0);
  }
  public function getBar__(): mx.controls.scrollClasses.ScrollBar {
    var widget: ScrollControlBase = ScrollControlBase(parent.object);
    if ((style & 256) != 0) {
      for (var i: int = 0; i < widget.numChildren; i++) {
        var child: DisplayObject = widget.getChildAt(i);
        if (child is HScrollBar) {
          return HScrollBar(child);
        }
      }
    } else {
      for (var i_1: int = 0; i_1 < widget.numChildren; i_1++) {
        var child_1: DisplayObject = widget.getChildAt(i_1);
        if (child_1 is VScrollBar) {
          return VScrollBar(child_1);
        }
      }
    }
    return null;
  }
  public function getEnabled__(): Boolean {
    this.checkWidget__();
    return (state & 32) == 0;
  }
  public function getIncrement__(): int {
    this.checkWidget__();
    var bar: mx.controls.scrollClasses.ScrollBar = this.getBar__();
    if (bar !== null)
      return int(bar.lineScrollSize);
    return increment;
  }
  public function getMaximum__(): int {
    this.checkWidget__();
    var bar: mx.controls.scrollClasses.ScrollBar = this.getBar__();
    if (bar !== null)
      return int((bar.maxScrollPosition + bar.pageSize));
    return maximum + thumb;
  }
  public function getMinimum__(): int {
    this.checkWidget__();
    var bar: mx.controls.scrollClasses.ScrollBar = this.getBar__();
    if (bar !== null)
      return int(bar.minScrollPosition);
    return minimum;
  }
  public function getPageIncrement__(): int {
    this.checkWidget__();
    var bar: mx.controls.scrollClasses.ScrollBar = this.getBar__();
    if (bar !== null)
      return int(bar.pageScrollSize);
    return pageIncrement;
  }
  public function getParent__(): Scrollable {
    this.checkWidget__();
    return parent;
  }
  public function getSelection__(): int {
    this.checkWidget__();
    var bar: mx.controls.scrollClasses.ScrollBar = this.getBar__();
    if (bar !== null)
      return int(bar.scrollPosition);
    return selection;
  }
  public function getSize__(): Point {
    this.checkWidget__();
    var bar: mx.controls.scrollClasses.ScrollBar = this.getBar__();
    if (bar !== null)
      return new Point(Math__.max__II(0, int(bar.width)), Math__.max__II(0, int(bar.height)));
    var thickness: int = int(mx.controls.scrollClasses.ScrollBar.THICKNESS);
    return new Point(thickness, thickness);
  }
  public function getThumb__(): int {
    this.checkWidget__();
    var bar: mx.controls.scrollClasses.ScrollBar = this.getBar__();
    if (bar !== null)
      return int(bar.pageSize);
    return thumb;
  }
  public function getVisible__(): Boolean {
    this.checkWidget__();
    return (state & 64) == 0;
  }
  public function isEnabled__(): Boolean {
    this.checkWidget__();
    return this.getEnabled__() && parent.isEnabled__();
  }
  public function isVisible__(): Boolean {
    this.checkWidget__();
    return this.getVisible__() && parent.isVisible__();
  }
  public override function releaseHandle__(): void {
    super.releaseHandle__();
    object = null;
    parent = null;
  }
  public override function releaseParent__(): void {
    super.releaseParent__();
    if (parent.horizontalBar === this)
      parent.horizontalBar = null;
    if (parent.verticalBar === this)
      parent.verticalBar = null;
  }
  public function removeSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener: SelectionListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(13, listener);
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(14, listener);
  }
  public function scrollHandler__Lmx_events_ScrollEvent_2(event: ScrollEvent): void {
    var detail: int = 0;
    if (event.detail === ScrollEventDetail.LINE_UP) {
      detail = 16777217;
    } else if (event.detail === ScrollEventDetail.LINE_DOWN) {
      detail = 16777218;
    } else if (event.detail === ScrollEventDetail.LINE_LEFT) {
      detail = 16777218;
    } else if (event.detail === ScrollEventDetail.LINE_RIGHT) {
      detail = 16777217;
    } else if (event.detail === ScrollEventDetail.PAGE_UP) {
      detail = 16777221;
    } else if (event.detail === ScrollEventDetail.PAGE_DOWN) {
      detail = 16777222;
    } else if (event.detail === ScrollEventDetail.PAGE_LEFT) {
      detail = 16777222;
    } else if (event.detail === ScrollEventDetail.PAGE_RIGHT) {
      detail = 16777221;
    } else if (event.detail === ScrollEventDetail.THUMB_TRACK) {
      detail = 1;
    } else if (event.detail === ScrollEventDetail.THUMB_POSITION) {
      detail = 0;
    } else if (event.detail === ScrollEventDetail.AT_TOP) {
      detail = 16777223;
    } else if (event.detail === ScrollEventDetail.AT_BOTTOM) {
      detail = 16777224;
    } else if (event.detail === ScrollEventDetail.AT_LEFT) {
      detail = 16777223;
    } else if (event.detail === ScrollEventDetail.AT_RIGHT) {
      detail = 16777224;
    }
    this.sendSelection__II(detail, int(event.position));
    return;
  }
  public function sendSelection__II(detail: int, selection_1: int): void {
    this.selection = selection_1;
    var event: Event = new Event();
    event.detail = detail;
    this.sendEvent__ILorg_eclipse_swt_widgets_Event_2(13, event);
    return;
  }
  public function setEnabled__Z(enabled: Boolean): void {
    this.checkWidget__();
    if (((state & 32) == 0) == enabled)
      return;
    state = enabled ? state & ~32 : state | 32;
    object.enabled = enabled;
  }
  public function setIncrement__I(value: int): void {
    this.checkWidget__();
    if (value < 1)
      return;
    increment = value;
    var bar: mx.controls.scrollClasses.ScrollBar = this.getBar__();
    if (bar !== null) {
      bar.lineScrollSize = value;
    }
    return;
  }
  public function setMaximum__I(value: int): void {
    this.checkWidget__();
    if (value < 0)
      return;
    if (value <= minimum)
      return;
    if (value - minimum < thumb) {
      thumb = value - minimum;
    }
    maximum = value - thumb;
    var bar: mx.controls.scrollClasses.ScrollBar = this.getBar__();
    if (bar !== null) {
      bar.setScrollProperties(thumb, minimum, maximum, pageIncrement);
    }
    return;
  }
  public function setMinimum__I(value: int): void {
    this.checkWidget__();
    if (value < 0)
      return;
    if (value >= maximum + thumb)
      return;
    if (maximum + thumb - value < thumb) {
      thumb = maximum + thumb - value;
    }
    minimum = value;
    var bar: mx.controls.scrollClasses.ScrollBar = this.getBar__();
    if (bar !== null) {
      bar.setScrollProperties(thumb, minimum, maximum, pageIncrement);
    }
    return;
  }
  public function setPageIncrement__I(value: int): void {
    this.checkWidget__();
    if (value < 1)
      return;
    pageIncrement = value;
    var bar: mx.controls.scrollClasses.ScrollBar = this.getBar__();
    if (bar !== null) {
      bar.setScrollProperties(thumb, minimum, maximum, pageIncrement);
    }
    return;
  }
  public function setSelection__I(value: int): void {
    this.checkWidget__();
    if (value < minimum || value > maximum)
      return;
    selection = value;
    var bar: mx.controls.scrollClasses.ScrollBar = this.getBar__();
    if (bar !== null) {
      bar.scrollPosition = value;
    }
    return;
  }
  public function setThumb__I(value: int): void {
    this.checkWidget__();
    if (value < 1)
      return;
    value = Math__.min__II(value, maximum + thumb - minimum);
    maximum = maximum + thumb - value;
    thumb = value;
    var bar: mx.controls.scrollClasses.ScrollBar = this.getBar__();
    if (bar !== null) {
      bar.setScrollProperties(thumb, minimum, maximum, pageIncrement);
    }
    return;
  }
  public function setValues__IIIIII(selection_1: int, minimum_1: int, maximum_1: int, thumb_1: int, increment_1: int, pageIncrement_1: int): void {
    this.checkWidget__();
    if (minimum_1 < 0)
      return;
    if (maximum_1 < 0)
      return;
    if (thumb_1 < 1)
      return;
    if (increment_1 < 1)
      return;
    if (pageIncrement_1 < 1)
      return;
    thumb_1 = Math__.min__II(thumb_1, maximum_1 - minimum_1);
    this.minimum = minimum_1;
    this.maximum = maximum_1 - thumb_1;
    this.thumb = thumb_1;
    this.selection = selection_1;
    this.increment = increment_1;
    this.pageIncrement = pageIncrement_1;
    var bar: mx.controls.scrollClasses.ScrollBar = this.getBar__();
    if (bar !== null) {
      bar.setScrollProperties(this.thumb, this.minimum, this.maximum, this.pageIncrement);
      bar.lineScrollSize = increment_1;
      bar.scrollPosition = selection_1;
    }
    return;
  }
  public function setVisible__Z(visible: Boolean): void {
    this.checkWidget__();
    if (((state & 64) == 0) == visible)
      return;
    if (visible) {
      this.sendEvent__I(22);
      if (this.isDisposed__())
        return;
    }
    state = visible ? state & ~64 : state | 64;
    var bar: mx.controls.scrollClasses.ScrollBar = this.getBar__();
    if (bar !== null)
      bar.visible = visible;
    parent.object.invalidateDisplayList();
    if (!visible) {
      this.sendEvent__I(23);
      if (this.isDisposed__())
        return;
    }
    return;
  }
}
}
